% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split.R
\name{vec_split}
\alias{vec_split}
\title{Split a vector into groups}
\usage{
vec_split(x, by)
}
\arguments{
\item{x}{Vector to divide into groups.}

\item{by}{Vector whose unique values defines the groups.}
}
\value{
A data frame with two columns and size equal to
\code{vec_size(vec_unique(by))}. The \code{key} column has the same type as
\code{by}, and the \code{val} column is a list containing elements of type
\code{vec_ptype(x)}.

Note for complex types, the default \code{data.frame} print method will be
suboptimal, and you will want to coerce into a tibble to better
understand the output.
}
\description{
This is a generalisation of \code{\link[=split]{split()}} that can split by any type of vector,
not just factors. Instead of returning the keys in the character names,
the are returned in a separate parallel vector.
}
\section{Dependencies}{

\itemize{
\item \code{\link[=vec_group_loc]{vec_group_loc()}}
\item \code{\link[=vec_chop]{vec_chop()}}
}
}

\examples{
vec_split(mtcars$cyl, mtcars$vs)
vec_split(mtcars$cyl, mtcars[c("vs", "am")])

if (require("tibble")) {
  as_tibble(vec_split(mtcars$cyl, mtcars[c("vs", "am")]))
  as_tibble(vec_split(mtcars, mtcars[c("vs", "am")]))
}
}
