% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/union.R
\name{new_union}
\alias{new_union}
\title{Define a class union}
\usage{
new_union(...)
}
\arguments{
\item{...}{The classes to include in the union. See \code{\link[=as_class]{as_class()}} for
details.}
}
\value{
An S7 union, i.e. a list with class \code{S7_union}.
}
\description{
A class union represents a list of possible classes. You can create it
with \code{new_union(a, b, c)} or \code{a | b | c}. Unions can be used in two
places:
\itemize{
\item To allow a property to be one of a set of classes,
\code{new_property(class_integer | Range)}. The default \code{default} value for the
property will be the constructor of the first object in the union.
This means if you want to create an "optional" property (i.e. one that
can be \code{NULL} or of a specified type), you'll need to write (e.g.)
\code{NULL | class_integer}.
\item As a convenient short-hand to define methods for multiple classes.
\code{method(foo, X | Y) <- f} is short-hand for
\verb{method(foo, X) <- f; method(foo, Y) <- foo}
}

S7 includes built-in unions for "numeric" (integer and double vectors),
"atomic" (logical, numeric, complex, character, and raw vectors) and
"vector" (atomic vectors, lists, and expressions).
}
\examples{
logical_or_character <- new_union(class_logical, class_character)
logical_or_character
# or with shortcut syntax
logical_or_character <- class_logical | class_character

Foo <- new_class("Foo", properties = list(x = logical_or_character))
Foo(x = TRUE)
Foo(x = letters[1:5])
try(Foo(1:3))

bar <- new_generic("bar", "x")
# Use built-in union
method(bar, class_atomic) <- function(x) "Hi!"
bar
bar(TRUE)
bar(letters)
try(bar(NULL))
}
