"""QGIS Unit tests for QgsCoordinateReferenceSystem.

Note that most of the tests for this class are in the c++ test file!

.. note:: This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
"""

__author__ = "(C) 2022 by Nyall Dawson"
__date__ = "06/04/2022"
__copyright__ = "Copyright 2022, The QGIS Project"


from qgis.core import Qgis, QgsCoordinateReferenceSystem
import unittest
from qgis.testing import start_app, QgisTestCase

start_app()


class TestQgsCoordinateReferenceSystem(QgisTestCase):

    def test_axis_order(self):
        """
        Test QgsCoordinateReferenceSystem.axisOrdering() (including the Python MethodCode associated with this)
        """
        self.assertEqual(QgsCoordinateReferenceSystem().axisOrdering(), [])
        self.assertEqual(
            QgsCoordinateReferenceSystem("EPSG:4326").axisOrdering(),
            [Qgis.CrsAxisDirection.North, Qgis.CrsAxisDirection.East],
        )
        self.assertEqual(
            QgsCoordinateReferenceSystem("EPSG:3111").axisOrdering(),
            [Qgis.CrsAxisDirection.East, Qgis.CrsAxisDirection.North],
        )

    def test_geocentric_to_geographic_crs(self):
        res = QgsCoordinateReferenceSystem("EPSG:4978").toGeographicCrs()
        self.assertTrue(res.isValid())
        self.assertEqual(res.type(), Qgis.CrsType.Geographic2d)
        self.assertEqual(res.mapUnits(), Qgis.DistanceUnit.Degrees)
        self.assertEqual(res.ellipsoidAcronym(), "EPSG:7030")
        self.assertEqual(
            res.axisOrdering(),
            [Qgis.CrsAxisDirection.East, Qgis.CrsAxisDirection.North],
        )

        res = QgsCoordinateReferenceSystem("IGNF:ATI").toGeographicCrs()
        self.assertTrue(res.isValid())
        self.assertEqual(res.type(), Qgis.CrsType.Geographic2d)
        self.assertEqual(res.mapUnits(), Qgis.DistanceUnit.Degrees)
        self.assertEqual(res.ellipsoidAcronym(), "EPSG:7027")
        self.assertEqual(
            res.axisOrdering(),
            [Qgis.CrsAxisDirection.East, Qgis.CrsAxisDirection.North],
        )


if __name__ == "__main__":
    unittest.main()
