# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.mysqlflexibleservers.aio import MySQLManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestMySQLManagementServersOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(MySQLManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_servers_list(self, resource_group):
        response = self.client.servers.list(
            api_version="2025-06-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_servers_list_by_resource_group(self, resource_group):
        response = self.client.servers.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2025-06-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_servers_get(self, resource_group):
        response = await self.client.servers.get(
            resource_group_name=resource_group.name,
            server_name="str",
            api_version="2025-06-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_servers_begin_create(self, resource_group):
        response = await (
            await self.client.servers.begin_create(
                resource_group_name=resource_group.name,
                server_name="str",
                parameters={
                    "location": "str",
                    "administratorLogin": "str",
                    "administratorLoginPassword": "str",
                    "availabilityZone": "str",
                    "backup": {
                        "backupIntervalHours": 0,
                        "backupRetentionDays": 0,
                        "earliestRestoreDate": "2020-02-20 00:00:00",
                        "geoRedundantBackup": "str",
                    },
                    "createMode": "str",
                    "dataEncryption": {
                        "geoBackupKeyURI": "str",
                        "geoBackupUserAssignedIdentityId": "str",
                        "primaryKeyURI": "str",
                        "primaryUserAssignedIdentityId": "str",
                        "type": "str",
                    },
                    "databasePort": 0,
                    "fullVersion": "str",
                    "fullyQualifiedDomainName": "str",
                    "highAvailability": {
                        "mode": "str",
                        "replicationMode": "str",
                        "standbyAvailabilityZone": "str",
                        "state": "str",
                    },
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "importSourceProperties": {
                        "dataDirPath": "str",
                        "sasToken": "str",
                        "storageType": "str",
                        "storageUrl": "str",
                    },
                    "lowerCaseTableNames": 0,
                    "maintenancePolicy": {"patchStrategy": "str"},
                    "maintenanceWindow": {
                        "batchOfMaintenance": "str",
                        "customWindow": "str",
                        "dayOfWeek": 0,
                        "startHour": 0,
                        "startMinute": 0,
                    },
                    "name": "str",
                    "network": {
                        "delegatedSubnetResourceId": "str",
                        "privateDnsZoneResourceId": "str",
                        "publicNetworkAccess": "str",
                    },
                    "privateEndpointConnections": [
                        {
                            "groupIds": ["str"],
                            "id": "str",
                            "name": "str",
                            "privateEndpoint": {"id": "str"},
                            "privateLinkServiceConnectionState": {
                                "actionsRequired": "str",
                                "description": "str",
                                "status": "str",
                            },
                            "provisioningState": "str",
                            "systemData": {
                                "createdAt": "2020-02-20 00:00:00",
                                "createdBy": "str",
                                "createdByType": "str",
                                "lastModifiedAt": "2020-02-20 00:00:00",
                                "lastModifiedBy": "str",
                                "lastModifiedByType": "str",
                            },
                            "type": "str",
                        }
                    ],
                    "replicaCapacity": 0,
                    "replicationRole": "str",
                    "restorePointInTime": "2020-02-20 00:00:00",
                    "sku": {"name": "str", "tier": "str"},
                    "sourceServerResourceId": "str",
                    "state": "str",
                    "storage": {
                        "autoGrow": "str",
                        "autoIoScaling": "str",
                        "iops": 0,
                        "logOnDisk": "str",
                        "storageRedundancy": "LocalRedundancy",
                        "storageSizeGB": 0,
                        "storageSku": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                    "version": "str",
                },
                api_version="2025-06-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_servers_begin_update(self, resource_group):
        response = await (
            await self.client.servers.begin_update(
                resource_group_name=resource_group.name,
                server_name="str",
                parameters={
                    "administratorLoginPassword": "str",
                    "backup": {
                        "backupIntervalHours": 0,
                        "backupRetentionDays": 0,
                        "earliestRestoreDate": "2020-02-20 00:00:00",
                        "geoRedundantBackup": "str",
                    },
                    "dataEncryption": {
                        "geoBackupKeyURI": "str",
                        "geoBackupUserAssignedIdentityId": "str",
                        "primaryKeyURI": "str",
                        "primaryUserAssignedIdentityId": "str",
                        "type": "str",
                    },
                    "highAvailability": {
                        "mode": "str",
                        "replicationMode": "str",
                        "standbyAvailabilityZone": "str",
                        "state": "str",
                    },
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "maintenancePolicy": {"patchStrategy": "str"},
                    "maintenanceWindow": {
                        "batchOfMaintenance": "str",
                        "customWindow": "str",
                        "dayOfWeek": 0,
                        "startHour": 0,
                        "startMinute": 0,
                    },
                    "network": {
                        "delegatedSubnetResourceId": "str",
                        "privateDnsZoneResourceId": "str",
                        "publicNetworkAccess": "str",
                    },
                    "replicationRole": "str",
                    "sku": {"name": "str", "tier": "str"},
                    "storage": {
                        "autoGrow": "str",
                        "autoIoScaling": "str",
                        "iops": 0,
                        "logOnDisk": "str",
                        "storageRedundancy": "LocalRedundancy",
                        "storageSizeGB": 0,
                        "storageSku": "str",
                    },
                    "tags": {"str": "str"},
                    "version": "str",
                },
                api_version="2025-06-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_servers_begin_delete(self, resource_group):
        response = await (
            await self.client.servers.begin_delete(
                resource_group_name=resource_group.name,
                server_name="str",
                api_version="2025-06-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_servers_begin_detach_v_net(self, resource_group):
        response = await (
            await self.client.servers.begin_detach_v_net(
                resource_group_name=resource_group.name,
                server_name="str",
                parameters={"publicNetworkAccess": "str"},
                api_version="2025-06-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_servers_begin_failover(self, resource_group):
        response = await (
            await self.client.servers.begin_failover(
                resource_group_name=resource_group.name,
                server_name="str",
                api_version="2025-06-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_servers_begin_reset_gtid(self, resource_group):
        response = await (
            await self.client.servers.begin_reset_gtid(
                resource_group_name=resource_group.name,
                server_name="str",
                parameters={"gtidSet": "str"},
                api_version="2025-06-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_servers_begin_restart(self, resource_group):
        response = await (
            await self.client.servers.begin_restart(
                resource_group_name=resource_group.name,
                server_name="str",
                parameters={"maxFailoverSeconds": 0, "restartWithFailover": "str"},
                api_version="2025-06-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_servers_begin_start(self, resource_group):
        response = await (
            await self.client.servers.begin_start(
                resource_group_name=resource_group.name,
                server_name="str",
                api_version="2025-06-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_servers_begin_stop(self, resource_group):
        response = await (
            await self.client.servers.begin_stop(
                resource_group_name=resource_group.name,
                server_name="str",
                api_version="2025-06-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_servers_validate_estimate_high_availability(self, resource_group):
        response = await self.client.servers.validate_estimate_high_availability(
            resource_group_name=resource_group.name,
            server_name="str",
            parameters={
                "estimatedDowntime": 0,
                "expectedStandbyAvailabilityZone": "str",
                "scheduledStandbyAvailabilityZone": "str",
            },
            api_version="2025-06-01-preview",
        )

        # please add some check logic here by yourself
        # ...
