from __future__ import absolute_import, division, print_function
from gltbx.images import img_data

align_a_img = img_data(width=32, height=32, mask=-1, encoded_data = """\
fafafaeaeaeaebebebedededededededededededededededededededededededededededededed\
ededededededededededededededededededededededededededededededededededededededed\
edededededededededebebebeaeaeaf8f8f8e6e6e6d1d1d1dbdbdbd0d0d0cfcfcfcfcfcfcfcfcf\
cfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcf\
cfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfd0d0d0dbdbdbd2d2d2e3e3e3e7e7e7\
e5e5e59f9f9f1e1e1e141414141414141414141414141414141414141414141414141414141414\
141414141414141414141414141414141414141414141414141414141414141414141414141414\
1414141515159a9a9ae7e7e7e4e4e4e7e7e7e6e6e67a7a7a0b0b0b828282878787868686868686\
868686868686868686868686868686868686868686868686868686868686868686868686868686\
8686868d8d8d898989868686868686868686868686888888c9c9c9e1e1e1e4e4e4e7e7e7e6e6e6\
7b7b7b1b1b1be9e9e9f0f0f0efefefefefefefefefefefefefefefefefefefefefefefefefefef\
efefefefefefefefefefefefefefeff0f0f0f0f0f0b4b4b4d1d1d1f2f2f2efefefefefefefefef\
efefefeaeaeadededee4e4e4e7e7e7e6e6e67b7b7b1a1a1ae0e0e0e7e7e7e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7e7e7e7\
262626848484efefefe6e6e6e6e6e6e6e6e6e6e6e6e7e7e7dededee4e4e4e7e7e7e6e6e67b7b7b\
1a1a1ae0e0e0e7e7e7e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7e7e7e72c2c2c8a8a8af7f7f7e8e8e8edededeaeaeae6e6e6\
e7e7e7dededee4e4e4e7e7e7e6e6e67b7b7b1a1a1ae0e0e0e7e7e7e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7e7e7e72f2f2f\
727272646464313131525252c5c5c5ebebebe7e7e7dededee4e4e4e7e7e7e6e6e67b7b7b1a1a1a\
e0e0e0e7e7e7e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e7e7e7e7e7e73434340d0d0d6767679c9c9c3d3d3d1d1d1dd6d6d6e9e9e9\
dededee4e4e4e7e7e7e6e6e67b7b7b1a1a1ae0e0e0e7e7e7e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7e7e7e72c2c2c5a5a5a\
f4f4f4f2f2f2d7d7d70e0e0e8e8e8eefefefdededee4e4e4e7e7e7e6e6e67b7b7b1a1a1ae0e0e0\
e7e7e7e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e7e7e7e7e7e72d2d2d929292efefefe6e6e6ececec3636366a6a6af1f1f1dedede\
e4e4e4e7e7e7e6e6e67b7b7b1a1a1ae0e0e0e7e7e7e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7e7e7e72c2c2c8e8e8eefefef\
e6e6e6ebebeb333333707070f1f1f1dededee4e4e4e7e7e7e6e6e67b7b7b1a1a1ae0e0e0e7e7e7\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e7e7e7e7e7e72c2c2c565656f5f5f5f2f2f2d4d4d40f0f0fa3a3a3eeeeeedededee4e4e4\
e7e7e7e6e6e67b7b7b1a1a1ae0e0e0e7e7e7e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7e7e7e72c2c2c0e0e0e6c6c6c9b9b9b\
383838373737e3e3e3e8e8e8dededee4e4e4e7e7e7e6e6e67b7b7b1a1a1ae0e0e0e7e7e7e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e7e7e7e7e7e7828282a2a2a25c5c5c353535606060d4d4d4eaeaeae7e7e7dededee4e4e4e7e7e7\
e6e6e67b7b7b1a1a1ae0e0e0e7e7e7e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6eeeeeeecececeeeeeee9e9e9eeeeee\
e9e9e9e6e6e6e7e7e7dededee4e4e4e7e7e7e6e6e67b7b7b1a1a1ae0e0e0e7e7e7e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7dededee4e4e4e7e7e7e6e6e6\
7b7b7b1a1a1ae0e0e0e7e7e7e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e7e7e7dededee4e4e4e7e7e7e6e6e67b7b7b1a1a1ae0e0e0e7e7e7e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7dededee4e4e4e7e7e7e6e6e67b7b7b\
1a1a1ae0e0e0e7e7e7e6e6e6e7e7e7ebebebececece9e9e9e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e7e7e7dededee4e4e4e7e7e7e6e6e67b7b7b1a1a1ae0e0e0e7e7e7e9e9e9e5e5e5b8b8b8acacac\
d3d3d3ececece6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7dededee4e4e4e7e7e7e6e6e67b7b7b1a1a1a\
e0e0e0eaeaead6d6d6414141191919232323191919a2a2a2ececece6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7\
dededee4e4e4e7e7e7e6e6e67b7b7b1a1a1ae0e0e0eeeeee565656282828d2d2d2e7e7e7656565\
1a1a1ae1e1e1e7e7e7e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7dededee4e4e4e7e7e7e6e6e67b7b7b1a1a1ae2e2e2\
d9d9d90f0f0f919191f2f2f2eaeaead6d6d6949494dededee7e7e7e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7dedede\
e4e4e4e7e7e7e6e6e67b7b7b1a1a1ae4e4e4c8c8c8070707b1b1b1ececece5e5e5ebebebf7f7f7\
e7e7e7e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7dededee4e4e4e7e7e7e6e6e67b7b7b1a1a1ae3e3e3d0d0d0\
090909a6a6a6efefefe9e9e9d4d4d48f8f8fdededee7e7e7e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7dededee4e4e4\
e7e7e7e6e6e67b7b7b1a1a1ae0e0e0eaeaea3939394a4a4aebebebf0f0f0636363212121e4e4e4\
e7e7e7e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e7e7e7dededee4e4e4e7e7e7e6e6e67b7b7b1a1a1ae0e0e0ecececc0c0c0\
2121212e2e2e363636191919abababececece6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7dededee4e4e4e7e7e7\
e6e6e67a7a7a181818e0e0e0e7e7e7ebebebd6d6d69b9b9b989898cfcfcfececece6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e7e7e7dededee4e4e4e7e7e7e6e6e6858585252525e3e3e3e7e7e7e6e6e6e9e9e9\
eeeeeeeeeeeee9e9e9e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7dededee4e4e4e6e6e6d7d7d7\
d4d4d4c2c2c2e1e1e1e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0\
e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0\
e0e0e0e1e1e1d8d8d8e2e2e2f5f5f5dededee2e2e2e4e4e4e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0\
e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0\
e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e1e1e1dededef2f2f2\
""")

align_b_img = img_data(width=32, height=32, mask=-1, encoded_data = """\
fafafaebebebebebebedededededededededededededededededededededededededededededed\
ededededededededededededededededededededededededededededededededededededededed\
edededededededededecececeaeaeaf8f8f8e8e8e8d0d0d0dcdcdcd1d1d1cfcfcfcfcfcfcfcfcf\
cfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcf\
cfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfd0d0d0dbdbdbd3d3d3e0e0e0e9e9e9\
e2e2e2b9b9b9222222151515141414141414141414141414141414141414141414141414141414\
141414141414141414141414141414141414141414141414141414141414141414141414141414\
1414141616169d9d9de8e8e8e2e2e2e9e9e9e3e3e39e9e9e010101777777888888868686868686\
868686868686868686868686868686868686868686868686868686868686868686868686868686\
868686868686868686868686868686868686858585878787cacacae2e2e2e2e2e2e9e9e9e3e3e3\
9f9f9f090909d6d6d6f3f3f3efefefefefefefefefefefefefefefefefefefefefefefefefefef\
efefefefefefefefefefefefefefefefefefefefefefefefefefefefefefefefefefefefefefef\
efefefeaeaeadfdfdfe2e2e2e9e9e9e3e3e39f9f9f090909cececee9e9e9e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7e6e6e6e6e6e6e7e7e7dfdfdfe2e2e2e9e9e9e3e3e39f9f9f\
090909cececee9e9e9e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7eeeeeee9e9e9e8e8e8eeeeeee8e8e8\
e7e7e7dfdfdfe2e2e2e9e9e9e3e3e39f9f9f090909cececee9e9e9e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7\
e8e8e88a8a8a3535352f2f2f6e6e6edededee9e9e9dfdfdfe2e2e2e9e9e9e3e3e39f9f9f090909\
cececee9e9e9e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6eeeeee7d7d7d0f0f0f8888889797971717175f5f5feeeeee\
dfdfdfe2e2e2e9e9e9e3e3e39f9f9f090909cececee9e9e9e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e8e8e8dadada121212\
848484f7f7f7f5f5f5a0a0a04b4b4be4e4e4e0e0e0e2e2e2e9e9e9e3e3e39f9f9f090909cecece\
e9e9e9e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6ebebebbcbcbc060606bdbdbdebebebe6e6e6e9e9e9e8e8e8e7e7e7dfdfdf\
e2e2e2e9e9e9e3e3e39f9f9f090909cececee9e9e9e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6ebebebb8b8b8070707c3c3c3\
eaeaeae7e7e7e4e4e4d7d7d7e6e6e6dfdfdfe2e2e2e9e9e9e3e3e39f9f9f090909cececee9e9e9\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e8e8e8d4d4d40e0e0e959595f7f7f7f6f6f6868686393939e6e6e6dfdfdfe2e2e2\
e9e9e9e3e3e39f9f9f090909cececee9e9e9e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6ededed7171711515158f8f8f\
8989890e0e0e838383eeeeeedfdfdfe2e2e2e9e9e9e3e3e39f9f9f090909cececee9e9e9e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e7e7e7e6e6e68484843b3b3b3f3f3f8f8f8fe8e8e8e7e7e7dfdfdfe2e2e2e9e9e9\
e3e3e39f9f9f090909cececee9e9e9e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7eeeeeeebebebececec\
eeeeeee7e7e7e7e7e7dfdfdfe2e2e2e9e9e9e3e3e39f9f9f090909cececee9e9e9e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7dfdfdfe2e2e2e9e9e9e3e3e3\
9f9f9f090909cececee9e9e9e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e7e7e7dfdfdfe2e2e2e9e9e9e3e3e39f9f9f090909cececee9e9e9e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7dfdfdfe2e2e2e9e9e9e3e3e39f9f9f\
090909cececee9e9e9e6e6e6e7e7e7e9e9e9e9e9e9e7e7e7e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e7e7e7dfdfdfe2e2e2e9e9e9e3e3e39f9f9f090909cececee9e9e9ebebebe5e5e5cbcbcbcdcdcd\
e6e6e6ebebebe6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7dfdfdfe2e2e2e9e9e9e3e3e39f9f9f090909\
cececeeeeeeebbbbbb3535352222221f1f1f373737bfbfbfeaeaeae6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7\
dfdfdfe2e2e2e9e9e9e3e3e39f9f9f090909cfcfcfededed333333535353d9d9d9d4d4d43e3e3e\
494949eeeeeee6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7dfdfdfe2e2e2e9e9e9e3e3e39f9f9f090909cecece\
e7e7e7afafafdadadae3e3e3d7d7d7545454393939ebebebe6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7dfdfdf\
e2e2e2e9e9e9e3e3e39f9f9f090909cececeeeeeeeb4b4b44646462a2a2a2f2f2f1c1c1c404040\
ebebebe6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7dfdfdfe2e2e2e9e9e9e3e3e39f9f9f090909d2d2d2cdcdcd\
0d0d0d6c6c6cc3c3c3e4e4e4717171393939ebebebe6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7dfdfdfe2e2e2\
e9e9e9e3e3e39f9f9f090909d5d5d5b0b0b0030303d0d0d0fafafae4e4e43131313e3e3ef0f0f0\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e7e7e7dfdfdfe2e2e2e9e9e9e3e3e39f9f9f090909d0d0d0dbdbdb262626\
2e2e2e6363633b3b3b3e3e3e111111a1a1a1ececece6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7dfdfdfe2e2e2e9e9e9\
e3e3e39e9e9e070707cdcdcdedededcecece797979727272b7b7b7e1e1e18b8b8bb3b3b3eaeaea\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e7e7e7dfdfdfe2e2e2e9e9e9e3e3e3a7a7a7131313d3d3d3e9e9e9eaeaeaf0f0f0\
f0f0f0ebebebe8e8e8f0f0f0ebebebe6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7dfdfdfe2e2e2e8e8e8d6d6d6\
dadadabebebee0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0\
e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0\
e0e0e0e1e1e1d9d9d9e0e0e0f6f6f6dededee1e1e1e5e5e5e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0\
e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0\
e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e1e1e1dededef1f1f1\
""")

align_c_img = img_data(width=32, height=32, mask=-1, encoded_data = """\
f8f8f8eaeaeaebebebedededededededededededededededededededededededededededededed\
ededededededededededededededededededededededededededededededededededededededed\
edededededededededecececeaeaeaf7f7f7e4e4e4d2d2d2dcdcdcd1d1d1cfcfcfcfcfcfcfcfcf\
cfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcf\
cfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfcfd0d0d0dadadad4d4d4dededee5e5e5\
e5e5e5ababab1f1f1f151515141414141414141414141414141414141414141414141414141414\
141414141414141414141414141414141414141414141414141414141414141414141414141414\
141414151515919191eaeaeae0e0e0e5e5e5e7e7e78b8b8b0505057d7d7d878787868686868686\
868686868686868686868686868686868686868686868686868686868686868686868686868686\
868686868686868686868686868686868686868686878787c5c5c5e3e3e3e0e0e0e5e5e5e7e7e7\
8c8c8c111111e1e1e1f1f1f1efefefefefefefefefefefefefefefefefefefefefefefefefefef\
efefefefefefefefefefefefefefefefefefefefefefefefefefefefefefefefefefefefefefef\
efefefe9e9e9e0e0e0e0e0e0e5e5e5e7e7e78c8c8c101010d8d8d8e8e8e8e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e0e0e0e0e0e0e5e5e5e7e7e78c8c8c\
101010d8d8d8e8e8e8e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e9e9e9efefefe9e9e9eaeaeaefefefe7e7e7\
e6e6e6e0e0e0e0e0e0e5e5e5e7e7e78c8c8c101010d8d8d8e8e8e8e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e9e9e9\
d1d1d16464643535353a3a3a7a7a7adfdfdfe8e8e8e0e0e0e0e0e0e5e5e5e7e7e78c8c8c101010\
d8d8d8e8e8e8e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7e8e8e8373737373737a5a5a5919191141414747474efefef\
e0e0e0e0e0e0e5e5e5e7e7e78c8c8c101010d8d8d8e8e8e8e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7dedede707070\
d2d2d2fafafafafafa555555484848eeeeeee0e0e0e0e0e0e5e5e5e7e7e78c8c8c101010d8d8d8\
e8e8e8e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6ebebebd6d6d67d7d7d5050503d3d3d101010515151eeeeeee0e0e0\
e0e0e0e5e5e5e7e7e78c8c8c101010d8d8d8e8e8e8e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e9e9e9cecece1f1f1f414141\
898989b4b4b45353534b4b4beeeeeee0e0e0e0e0e0e5e5e5e7e7e78c8c8c101010d8d8d8e8e8e8\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6efefef9696960b0b0be2e2e2fafafaf6f6f63b3b3b4f4f4ff2f2f2e0e0e0e0e0e0\
e5e5e5e7e7e78c8c8c101010d8d8d8e8e8e8e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6ebebebb8b8b8060606717171a3a3a3\
5a5a5a1616162e2e2ecbcbcbe3e3e3e0e0e0e5e5e5e7e7e78c8c8c101010d8d8d8e8e8e8e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6eaeaea9696963737373d3d3d8a8a8abdbdbd4a4a4aa1a1a1e7e7e7e0e0e0e5e5e5\
e7e7e78c8c8c101010d8d8d8e8e8e8e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6ededede9e9e9eaeaeaeeeeee\
eaeaeaededede9e9e9e0e0e0e0e0e0e5e5e5e7e7e78c8c8c101010d8d8d8e8e8e8e7e7e7e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e0e0e0e0e0e0e5e5e5e7e7e7\
8c8c8c101010d8d8d8e8e8e8e2e2e2e4e4e4e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e0e0e0e0e0e0e5e5e5e7e7e78c8c8c101010d9d9d9e6e6e6444444a1a1a1ededed\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e0e0e0e0e0e0e5e5e5e7e7e78c8c8c\
101010d9d9d9e6e6e6202020919191f3f3f3eeeeeeebebebe6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e0e0e0e0e0e0e5e5e5e7e7e78c8c8c101010d9d9d9e6e6e6242424969696bfbfbf929292\
b6b6b6eaeaeae7e7e7e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e0e0e0e0e0e0e5e5e5e7e7e78c8c8c101010\
d9d9d9e6e6e62b2b2b3131312828283636360d0d0d6d6d6deaeaeae6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e0e0e0e0e0e0e5e5e5e7e7e78c8c8c101010d9d9d9e6e6e6262626323232d9d9d9f0f0f09c9c9c\
010101b7b7b7ebebebe6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e0e0e0e0e0e0e5e5e5e7e7e78c8c8c101010d9d9d9\
e6e6e6242424919191f1f1f1e7e7e7e6e6e6202020808080f0f0f0e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e0e0e0\
e0e0e0e5e5e5e7e7e78c8c8c101010d9d9d9e6e6e6262626a0a0a0eeeeeee6e6e6eaeaea303030\
747474f0f0f0e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e0e0e0e0e0e0e5e5e5e7e7e78c8c8c101010d9d9d9e6e6e6\
232323858585f3f3f3e9e9e9e2e2e2191919929292eeeeeee6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e0e0e0e0e0e0\
e5e5e5e7e7e78c8c8c101010d9d9d9e6e6e6252525252525cccccce7e7e7828282121212d2d2d2\
e9e9e9e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e0e0e0e0e0e0e5e5e5e7e7e78c8c8c101010d9d9d9e6e6e63c3c3c\
4e4e4e2525252626261919199e9e9eededede6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e0e0e0e0e0e0e5e5e5\
e7e7e78b8b8b0e0e0ed8d8d8e8e8e8d6d6d6e5e5e5c9c9c9afafafd1d1d1ececece6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e0e0e0e0e0e0e5e5e5e6e6e69595951b1b1bdcdcdce8e8e8e8e8e8e7e7e7\
eaeaeaececece9e9e9e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e0e0e0e0e0e0e3e3e3d8d8d8\
d7d7d7c0c0c0e1e1e1e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0\
e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0\
e0e0e0e0e0e0dadadadededef3f3f3dededee2e2e2e5e5e5e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0\
e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0\
e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0dededef0f0f0\
""")

centre_img = img_data(width=32, height=32, mask=-1, encoded_data = """\
f9f9f9e3e3e3e5e5e5e5e5e5e5e5e5e5e5e5e5e5e5e5e5e5e5e5e5e5e5e5e4e5e5e5e5e5e8e8e6\
ecebe8eeede9efeee9efeee9eeeee9ecece8e8e8e6e5e5e5e4e4e5e5e5e5e5e5e5e5e5e5e5e5e5\
e5e5e5e5e5e5e5e5e5e5e5e5e3e3e3f5f5f5ecececd1d1d1dedededededededededededededede\
dedededddddee0e0dfe6e6e2e1e1dfc5c6d3a1a3c28287b57177ad7076ad7f84b39b9fc0c0c1d0\
dededee7e7e2e1e0dfdddddededededededededededededededededfdfdfd5d5d5e3e3e3ededed\
dadadae8e8e8e7e7e7e7e7e7e7e7e7e7e7e7e8e7e7f0efebdbdce29093c03f479c0d188500027b\
00007800007800007800007800007b081383363e978387bad3d4def0f0ebefefefe9e9e9e6e6e6\
e7e7e7e7e7e7e8e8e8dededee5e5e5edededd9d9d9e7e7e7e6e6e6e6e6e6e6e6e6eaeae8e8e8e7\
9095c0222a8e00007900027b1a258b4951a06d74b08086b98187b97177b24f57a3212b8e00057c\
00007817208a7b81b58e8e8ed9d9d9eaeaeae6e6e6e6e6e6e7e7e7dddddde5e5e5edededd9d9d9\
e7e7e7e6e6e6e6e6e6ecece9d5d6df4c53a100017a00077d464d9ea3a7c8dadbe1edece9f0efea\
f0efeaf0efeaf0f0eaeeede9dfdfe3aeb1cd555ca609128303093d242321555555ddddddeaeaea\
e6e6e6e7e7e7dddddde5e5e5edededd9d9d9e7e7e7e6e6e6ecece9cbccda2b3492000078242c8f\
a5a8c9ebebe8eeeeeae8e8e7e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7efefebedecea\
5455643736354242422d2d2d535353dcdcdceaeaeae7e7e7dddddde5e5e5edededd9d9d9e7e7e7\
eaeae8d4d5de293391000078434b9dd5d6dfefefeae6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e8e8e8e8e8e87575754343414e4e4d4545454040402d2d2d535353d7d7d7\
e9e9e9dddddde5e5e5edededd9d9d9e8e8e8e7e7e6454f9f000078444d9ee1e2e4ebebe8e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e8e8e8e8e8e87979794a4a4a5a5a5a\
5252524c4c4c454545424242242422878787f0efefdddddde5e5e5edededd9d9d9f0f0eb888dbc\
000179273090d8d9e0ebebe8e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e4e4e4e7e7e7e8e8e8\
e7e7e7e8e8e87d7d7d5454546767675e5e5e5858585252524e4e4d3a3a38070939676eabefefeb\
dddddde5e5e5edededdcdcdbd6d7e019238a040b7eacafccefeeeae6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e8e8e8d8d8d76f6f6fddddddebebeb8080805d5d5d7474746b6b6b6565655e5e5e\
5a5a5a45454454555d121b850a1384c1c3d6e2e2dfe5e5e5ededede3e2de8388bb0000784f58a3\
edede9e6e6e6e8e7e7e9e9e8ebebe8ebebe8e9e9e8e7e7e6e5e5e6e1e2e45c5d5e7272727f7f7f\
6767677f7f7f7676767171716b6b6b676767505050656565e9e9e57178b40000776269ace6e5e1\
e5e5e5eeededd9d9d9313b9601087db2b5cff2f1ebe7e7e6dadbe1c8cad8b5b8d0a4a8c8979bc3\
8d92be858fc0848cbf5a576d797a787474748a8a8a8181817c7c7c7676767373735e5e5d5c5c61\
dededff3f2edcbcdda0b158417238acecfd7e7e7e6f1f1efb5b7c9040f82283392d1d3ddb1b4ce\
8e93be787eb56c74af6870ae6971ae6c74af717eb87d5c89a01f307c0c0f7f83839797978c8c8c\
8787878181817f7f7f6969683c3f547077ac8b91bfa8accad5d6df434d9e00037b9ea2c1ecece8\
f5f5f18a8eb600027b3641987c83b76870ad6e75b08086b8969ac2abaeccbcbfd3cbd2e0c399a3\
b0080ac30000a60000736c6c9b9d9d9292928c8c8c898989747473626265959abc868cbd7178b1\
6870ae797fb54851a00000796d73abefefeaf7f6f1676ea700017a3e479a7f86b8a6aac9cbcdda\
e1e1e4e9e9e7ebebe8ebebe9e8e5e4bc2f2ebe0000cf0000cc0000714e4ea3aaaa9b9b9b949494\
8181816a6a6addddddededebe3e3e5d1d2dcadb1cd848aba4d56a100037b4a539cedede9f6f6f1\
535a9d0000796e76b1e4e4e5ebebe8e9e9e7e7e7e6e6e6e6e6e6e6e7ebebdbbcbcb50202c90000\
db0000ed0000891a1a7165657c7d7d878e8e7f82826e6d6ddddddde9e9e9e6e6e6e9e9e7ebebe8\
e7e7e78b90bd00047b374193eaeae7f6f5f14f579c00027b3a4299c4c6d7efeeeaeeeeeae9e9e7\
e6e6e6e6e6e6e8ececd8b1b1b60000cc0000df0000f30000f30000ca0000a201017d0f0f785c5c\
5e61615c5c5ce0e0e0eae9e8edede9f0efead0d1dc4f56a200037b343e92eae9e7f6f6f15c63a2\
00057d00047c081383555ca5a1a5c7d2d2dde8e8e7efefeaf0f2ede8d6d2bd130fcb0000dc0000\
e90000ec0000e30000d50000c40300e5bfbbebeeead3d3cee3e3e1d7d8dfaaadcb6168ab121b87\
00027b00067d404997ecebe8f6f6f1767cad00037c232e9017238a00007800007a0f1a86363f98\
5e65aa8187b99da6cb96405a9c0216b10211bd010ebf010eb50211a10215952a44a0a3c7878cbd\
676eaf3d469b141f8800037b0000770e1a8629349200047c5960a3efeee9f3f3f09ea2bf00047c\
4851a0d7d8df8e92be4a51a019238a00097e00007800007700007900077f00067b020778050877\
06087703077800077a00087f00007a00007700007800067d141e8841499c8387b9d3d4dd676eae\
0000798389b6eeeee9efefeec9cad214218a0e1a86d3d4ddf2f2ececece9dadae0bbbdd3989cc3\
777db55c63a847509f38429a2e39962733932633932c3895364199444d9e5860a77279b39397c1\
b6b8d0d6d6dfebeae8f1f0ebe4e5e5242f90040e81b7b9cceaeae7ededede1e1dd555da7000078\
848abbf1efeae6e6e6e8e8e7ebebe8eeeeeaf0efeaefefeaecece9e9e8e7e5e5e6e3e3e4e2e3e4\
e5e5e5e8e8e7ecebe9efeeeaf0efeaefeeeaecece9e8e8e7e6e6e6eeeeeaa3a7c800047b364098\
dededee6e6e5ededede0e0dcb0b3cf02087d202b8edadbe1e9e9e7e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e7e7e6e7e7e6e7e7e6e7e7e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e7e7e7e7e7e73943990001799297c1e6e6e1e5e5e5edededdadad9ebebe94751a0000078\
6a71aff0efeae6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6f1f0eb888ebd00027a2c3693e1e2e4dfdede\
e5e5e5edededd9d9d9edeceac2c5d60f188503097e999ec4f1f0ebe6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6f0efea\
b3b6d00d1583040b7faaadcbeeeeeadddddde5e5e5edededd9d9d9e7e7e7efefea9197c100057d\
0b1383a1a5c8f1f0ebe7e7e7e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6f1f0ebb8bbd219218a000079747bb4eeeeeae7e7e7dddddde5e5e5\
edededd9d9d9e7e7e7e6e6e6eeede97980b600037c060f818388bae8e8e7edede9e7e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6ecebe9edede9989dc3111a86000079\
5e66aae9e9e7e7e7e7e7e7e7dddddde5e5e5edededd9d9d9e7e7e7e6e6e6e7e7e6edece98489ba\
050d8000007a40489cb1b4cee9e9e7f0f0eaecece9e9e9e7e8e8e7e8e8e7e9e8e7ebebe8f0efea\
ecece9bebfd45158a300057c00057c6b72b0e8e8e7e8e8e7e6e6e6e7e7e7dddddde5e5e5ededed\
d9d9d9e7e7e7e6e6e6e6e6e6e7e7e6efeeeaacb0cc2b339200007800097e3a43998388bab6b9d1\
d1d2dddbdce1dcdce2d3d4debcbed38c91be454d9e040f810000781d258b999ec4edece9e8e8e7\
e6e6e6e6e6e6e7e7e7dddddde5e5e5edededd9d9d9e7e7e7e6e6e6e6e6e6e6e6e6e6e6e6eeeeea\
dedee38388ba262f9000037b00007800077e0d19861a258c1b268c101c87000a7f00007800007a\
1c258c7479b3d5d6deefefeae7e7e7e6e6e6e6e6e6e6e6e6e7e7e7dddddde5e5e5ecececd3d3d3\
e1e1e1e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e2e2e1e9e9e4d8d9dda2a4c46369a8343d93182387\
0c18820b17811621862f38915b61a4989bc0d2d3dae9e9e4e3e3e1e0e0e0e0e0e0e0e0e0e0e0e0\
e0e0e0e1e1e1d7d7d7e3e3e3f8f8f8dfdfdfe0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0\
e0e0e0e2e2e1e8e7e4eaeae5e3e3e2d8d9ddd0d1d9cfd0d9d7d7dce2e2e1eae9e5e8e8e4e3e3e1\
e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e1e1e1dededef3f3f3\
""")

fit_img = img_data(width=32, height=32, mask=-1, encoded_data = """\
f6f6f6e5e5e5ededededededededededededededededededededededededededededededededed\
ededededededededededededededededededededededededededededededededededededededed\
edededededededededededede4e4e4f4f4f4e8e8e8c3c3c39090908a8a8a8a8a8a8a8a8a8a8a8a\
8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a\
8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a8a8b8b8b969696cececee3e3e3f1f1f1\
8282820000000c0c0c0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d\
0d0d0d0e0e0e0e0e0e0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d0d\
0e0e0e0a0a0a000000aaaaaaeaeaeaf1f1f17a7a7a131313cbcbcbd6d6d6d4d4d4d4d4d4d4d4d4\
d4d4d4d4d4d4d4d4d4d4d4d4d4d4d4d5d5d5d8dbdbd0d2d2d2d4d4d7dadad5d5d5d4d4d4d4d4d4\
d4d4d4d4d4d4d4d4d4d4d4d4d4d4d4d4d4d4d8d8d8b3b3b3040404a5a5a5eaeaeaf1f1f17a7a7a\
151515dededeeaeaeae8e8e8e8e8e8e8e8e8e8e8e8e8e8e8e8e8e8e9eaeaecf0f0e4e5e5c5a9a9\
a65656ab6060ccb5b5e6e9e8ecefefe9e9e9e8e8e8e8e8e8e8e8e8e8e8e8e8e8e8e8e8e8ededed\
c4c4c4050505a5a5a5eaeaeaf1f1f17a7a7a151515dcdcdce8e8e8e6e6e6e6e6e6e6e6e6e6e6e6\
e7e8e8eaeeeee0e0e0c0a2a1a250509e2729a7292cab2c2ea83233af6061c9afafe2e4e4e9ecec\
e7e7e7e6e6e6e6e6e6e6e6e6e6e6e6eaeaeac2c2c2050505a5a5a5eaeaeaf1f1f17a7a7a151515\
dcdcdce8e8e8e6e6e6e6e6e6e7e8e8eaeeeedfdedebe9c9ca04b4b9d2627a7292cac3133af3436\
b33739b7393bb83538b4393ab56262c9acace0e2e2e9ecede7e7e7e6e6e6e6e6e6eaeaeac2c2c2\
050505a5a5a5eaeaeaf1f1f17a7a7a151515dcdcdce8e8e8e7e8e8eaeeeededcdbbb97969f4647\
9c2426a6292bab3032ae3335b23638b5383bb83b3dbc3d3fbf4042c34244c54143bf4143bb6364\
c9a9a8dfe0e0e8ecece7e7e8eaeaeac2c2c2050505a5a5a5eaeaeaf1f1f17a7a7a151515dcdcdc\
ebededddd9d9b991909d42429b2325a5292baa3032ad3234b13537b4383ab73a3cbb3c3ebe3f41\
c14244c44547c74749ca494ccd4c4ed04b4dc94a4bc06666c9a6a6e1dfdfeceeeec2c2c2050505\
a5a5a5eaeaeaf1f1f17a7a7a151515dfe1e1bda5a48f39399a2123a6292ba92f31ac3234b03537\
b4383ab83b3eba3c3fbd3f41c04143c34446c74649c9494bcc4b4ecf4e50d25153d45355d85658\
de575ad45355ac5858cbbcbbc5c6c6050505a5a5a5eaeaeaf1f1f17a7a7a151515dfe3e3b48281\
972c2c932e2e9d2d2eae3335b5383ab73a3db33335af282aba393bc44547c74749c9484bcb4a4d\
ce4d4fd15052d35254d65557dc5a5cda5a5cc24d4ea0393a852222bfa2a2c6c9c9050505a5a5a5\
eaeaeaf1f1f17a7a7a151515dfe3e3b68585aa3839b24444a63f409b3736a22f30a91f20ab0f11\
ad0b0dae1013b52628c34143ce4e51d15153d25153d65456db595bd8585ac04c4da43d3d9a3536\
9933348b2728c1a6a5c6c9c9050505a5a5a5eaeaeaf1f1f17a7a7a151515dfe3e3b48484a33536\
b04243b13b3ca52021950c0c900b0ba10d0eb50d10bd0c10bc0a0db90f11bd2729cb4748db595b\
d6585abe4b4ca94141a94041ae4042a63b3d993334862526c1a5a5c6c9c9050505a5a5a5eaeaea\
f1f1f17a7a7a151515dfe4e3b38484972728951a1b9a0b0da5090bb00b0db20b0ea50c0d9b0c0d\
aa0c0ec20d0fcc0c10cf0a0dc20f11a82626a93e3eb94b4cc14c4eb94749ad3f41a2383a963132\
832324c0a5a4c6c9c9050505a5a5a5eaeaeaf1f1f17a7a7a151515e0e4e4b285848916178a0708\
940b0ca10b0dad0b0db50b0ebe0b0ec10b0eb20c0ea60d0eb70d0fb20d0e990c0c950707bf3d3f\
cc5658bf4b4db54446aa3d3f9e3638922f307f2122bfa4a4c6c9c9050505a5a5a5eaeaeaf1f1f1\
7a7a7a151515e0e4e4b083838616168b090a940b0d970c0c9e0b0cae0b0dbc0b0ec50b0ece0b0f\
c70c0e950c0c9b0c0dab0b0ea4090bbe3d3fc85355bc494bb24244a73b3d9b34358f2d2e7c2020\
bea4a4c6c9c9050505a5a5a5eaeaeaf1f1f17a7a7a151515e0e4e4ae828281141486090a910b0c\
9a0c0da00c0ea20c0da90c0db60b0db00b0dae0c0e9c0c0ea90c0eab0b0ea0090bbc3c3ec55153\
b94749af4042a43a3c9833348b2b2c781d1ebea4a4c6c9c9050505a5a5a5eaeaeaf1f1f17a7a7a\
151515e0e4e4ac81817c121381090a8b0b0c940b0d9e0c0ea80d0fad0e0fa30c0eac0c0fb10c0f\
9b0c0da60c0ea90b0e9e080ab93b3cc34f51b74547ac3f41a13839943131882a2b751c1dbda4a3\
c7c9c9050505a5a5a5eaeaeaf1f1f17a7a7a151515e0e4e4aa807f7710117c080a860a0c8f0b0c\
980c0da10c0eab0d0fa30c0eaa0c0ead0c0e990c0da50b0ea60b0d9d080bb73a3cc04d4fb44345\
a93d3f9e3637912f30842829711a1bbca3a3c7c9c9050505a5a5a5eaeaeaf1f1f17a7a7a151515\
e1e4e4a87e7e720e0f77080a800a0b890b0c930b0d9c0c0da50d0e9f0c0da60c0eaa0b0e970b0d\
a30b0ea40b0d9b090bb5393abd4b4db14244a63b3d9a34358e2d2e8126276d1819bca3a2c7c9c9\
050505a5a5a5eaeaeaf1f1f17a7a7a151515e1e4e4a67d7d6c0c0e7107087b0a0b850a0c8d0b0c\
970c0da00c0e9c0c0da30c0ea60b0e950b0da10b0da20a0c980609b33739bb494bae4042a3393b\
9732338a2b2c7d24256a1617bba3a2c7c9c9050505a5a5a5eaeaeaf1f1f17a7a7a151515e1e4e4\
a27a7a690d0f73111276090b7e090a880b0c910b0d9a0c0d980c0d9f0c0da30c0d920b0c9d080a\
a10d0fad292bbc4749b64648ac3e40a0373994303187292a782021620e0fbaa2a2c7c9ca050505\
a5a5a5eaeaeaf1f1f17a7a7a151515dedfdfd6cdcd9869697926277b1a1b7e1314810a0b8b0a0b\
950b0d940b0c9c0b0d9e090b8e0b0cad2829c84b4dc95456be4b4db34345a83c3e9d3537902d2e\
7e1f20782c2ca17b7be1dcdcc3c4c4050505a5a5a5eaeaeaf1f1f17a7a7a151515dcdcdceaecec\
e9ececcabbbb975f5f842829881f208914158d0a0b8f090a950b0ca42021a43535cb5759d0585a\
c54f51bb484ab04143a63a3c962c2d893030a17271d4cbcbebeeeeecececc2c2c2050505a5a5a5\
eaeaeaf1f1f17a7a7a151515dcdcdce8e8e8e6e6e6eaecece6e9e8c4b0af9957578f2c2d932324\
921a1ba63434bb494aaa4141c75254cc5557c24d4fb94648ac3a3c9b3637a56a6acfc2c1e9ecec\
e9eaeae6e6e6eaeaeac2c2c2050505a5a5a5eaeaeaf1f1f17a7a7a151515dcdcdce8e8e8e6e6e6\
e6e6e6e6e7e7eaedede3e4e4bfa4a39d51519d3334ac3d3eb64546a63d3dc65152cb5355bf4749\
ac3e40aa6565cbb8b8e7eaeae9ebebe6e6e6e6e6e6e6e6e6eaeaeac2c2c2050505a5a5a5eaeaea\
f1f1f17a7a7a151515dcdcdce8e8e8e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7eaededdfdedeba9897\
a14c4cab3a3ba33939c44d4ebf494bb26263c7afaee4e6e6e9ecece6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6eaeaeac2c2c2050505a5a5a5eaeaeaf1f1f17a7a7a151515dcdcdce8e8e8e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e8e8e8eaeeeedbd7d7ba8e8d98403fb25a5bc7a7a7e1e2e2eaeded\
e7e7e7e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6eaeaeac2c2c2050505a5a5a5eaeaeaf1f1f1\
7a7a7a151515dfdfdfebebebe9e9e9e9e9e9e9e9e9e9e9e9e9e9e9e9e9e9e9e9e9e9e9e9eaebeb\
ecefefd5ccccddd9d9ecf0f0e9eaeae9e9e9e9e9e9e9e9e9e9e9e9e9e9e9e9e9e9e9e9e9e9e9e9\
edededc4c4c4050505a5a5a5eaeaeaf1f1f17b7b7b0000002c2c2c2f2f2f2e2e2e2e2e2e2e2e2e\
2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e3032323030302e2e2e2e2e2e2e2e2e2e2e2e\
2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2f2f2f262626000000a6a6a6eaeaeaeaeaeab4b4b4\
636363595959595959595959595959595959595959595959595959595959595959595959595959\
595959595959595959595959595959595959595959595959595959595959595959595959595959\
5959596a6a6ac7c7c7e4e4e4f4f4f4e2e2e2eaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaea\
eaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaea\
eaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeae0e0e0f2f2f2\
""")

mark_snap_back_img = img_data(width=32, height=32, mask=-1, encoded_data = """\
fefefef7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7\
f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7f7\
f7f7f7f7f7f7f7f7f7f7f7f7f6f6f6fdfdfdebebebcfcfcfd7d7d7d7d7d7d9d9d9d1d1d1cdcdcd\
cdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdd0d0d0d9d9d9d8d8d8d6d6d6d6d6d6\
d6d6d6d6d6d6d6d6d6d6d6d6d6d6d6d6d6d6d6d6d6d6d6d6d6d6d6d7d7d7d1d1d1e3e3e3e9e9e9\
dcdcdcebebebdfdfdfbebebec7c7c7d3d3d3d2d2d2cfcfcfc9c9c9c9c9c9c9c9c9d0d0d0d2d2d2\
d3d3d3c6c6c6bebebeddddddeaeaeae7e7e7e8e8e8e8e8e8e8e8e8e8e8e8e8e8e8e8e8e8e8e8e8\
e8e8e8e8e8e8e9e9e9e0e0e0e2e2e2e9e9e9dcdcdcdededebababae9e9e9dcdcdca7a7a7a7a7a7\
c0c0c0f8f8f8f6f6f6f6f6f6b8b8b8a7a7a7a8a8a8e6e6e6eaeaeabbbbbbdbdbdbe7e7e7e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7dfdfdfe2e2e2e9e9e9dedede\
bebebee6e6e6fefefe9e9e9e000000000000282828efefeff5f5f5e3e3e3131313000000000000\
c1c1c1fcfcfceaeaeabcbcbce8e8e8e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e7e7e7dfdfdfe2e2e2e9e9e9d6d6d6c3c3c3f6f6f6fbfbfba1a1a10000000d0d0d0b0b0b\
d1d1d1fcfcfcbcbcbc0303030b0b0b000000bcbabaece8e8f8fafac7c8c8dddddde7e7e7e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7dfdfdfe2e2e2eaeaead2d2d2c8c8c8\
f6f6f6fbfbfba1a1a1000000393939060606a3a3a3ffffff8686861112122f2f2f0000009d7474\
c88e8ed1b1b1bcb6b6d9dedeebeeeee6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e7e7e7dfdfdfe2e2e2eaeaead2d2d2c8c8c8f6f6f6fbfbfba1a1a10000005a5a5a1f1f1f6a6a6a\
ffffff4d4e4e2d2222382d2d000000a66a6bd68889d48686a26061924d4dc2b1b1e4e9e9ebeeee\
e7e7e7e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7dfdfdfe2e2e2eaeaead2d2d2c8c8c8f6f6f6\
fbfbfba1a1a10000006d6d6d5153532e2d2dccb6b5151312603d3e402929000000a86b6cd9898a\
da8a8bb25e60a50104a10c0d9e4848bda8a7e1e6e5ebeeeee7e7e7e6e6e6e6e6e6e6e6e6e7e7e7\
dfdfdfe2e2e2eaeaead2d2d2c8c8c8f6f6f6fbfbfba2a2a200000065605f766a6a080303935f60\
010000925e5f3f2929000000ab6b6cdc898add8a8bb45f60af090cc10c0fc00609ad090ba13e3f\
b99e9ddee2e2ebefefe6e6e6e6e6e6e7e7e7dfdfdfe2e2e2eaeaead2d2d2c8c8c8f6f6f6fbfbfb\
9c9a9a000000573b3b9c6767020101492f30080505bb77783d2627000000ad6b6cdf898ae08a8b\
b75f61b5090cc50d10c80d11ce0d11d0070bc0070aa83536b19594e4e4e4e6e7e7e7e7e7dfdfdf\
e2e2e2eaeaead5d5d5c4c4c4f6f6f6fbfcfc948d8d000000533939bf7f7f100a0a040202261818\
d787883b2525000000b06b6ce3898ae48b8cb6595abe080ccb0d11cf0d11d70d11d60d11b70d0f\
7c0304652220dfdddceaebe7eaeae7e0e0dfe2e2e2e9e9e9dcdcdcbebebeedededfdfdfd938d8d\
0000004b3535c58e8d261c1c000000503132e78e8f342020000000b06a6be78a8be18b8caa3437\
ce090dd60d11d20d11ae0d0f7b0d0d5f0c0c5a07096c2a29dbd9dfcccce9cbcbe9d5d5e0e3e3e2\
e9e9e9ddddddd8d8d8bfbfbff5f6f6bbadad6f4e4f97696ad391929967687651529e706fdd8d8e\
9d6060865051d37f80e68d8fb65759c40c10d00d10a70d0f790d0d670d0d680c0e660c0d5e0709\
6e2d29c4c3e05e5ef15757f1ababe2e8e8e2e9e9e9dbdbdbeaeaead5d5d5bec1c1aa9696a26869\
a56a6ba36768ad6b6cb46e6fae6b6c9f6767ac6a6abb6b6cc06163b5393cb80c10a30c0d780e0e\
6f0e0e740e0f710d0f6a0c0e640c0d5c07086d2c29c4c3e05d5df15555f1ababe2e8e8e2e9e9e9\
dededcededeaebebe9ebefef977272690204770c0e7e0d0f850e108c0f119410129c10139d1113\
850f10840b0b9b0905800e0a780f0f7f0f117c0e10750d0f6e0d0e680c0e630b0d5a07086c2c29\
c4c3e05d5df15656f1ababe2e8e8e2ebebeac3c4d0b6b6cfd1d3ddf4f7f4a179796f04057e0e10\
850f118d10129411139c1214a41315ac1416b71517a6141a3f0b476c1033841014820e0a7a0d0c\
730d0f6d0d0e670c0d610b0c5806086b2c29c5c3e05d5df15656f1ababe2e8e8e2f1f1ed8c91b8\
00017a283191bcc2dba47b776e04017b0e0e810f108810128f10139712149e1215a61316af1416\
aa141b15077b0e1199311c8c551d626c152e710d0d6d0a06660b0a5f0b0c5706086b2c29c5c3e0\
5d5df15656f1ababe2e8e8e2eaeaead8d8da4e57a40000790311842c2574460b34670d1d7b0e11\
880f0d91100d98110f9e1211a51312ae1413a813181907760f11981d1fab292dbe3735bf49309c\
59235f6113255e09065503006a2b26c5c3e05d5df15656f1ababe2e8e8e2e9e9e9dededce5e5e6\
8489ba1f278c000882000d89040d7d170d6a2f0e58460e475b0f3a6e10317d112b8a12278a1228\
1507780f11981f1fa72c2cb73636c43b3dd14144db4a45cf53399e53205369323bc4c2df5d5df1\
5656f1ababe2e8e8e2e9e9e9dbdbdbe8e8e8efefeadee1e7725f8322054c110d6e020d7e000d87\
000d89000d89000d86000d84000d81010c7f0507861211961f1fa72c2cb73636c33c3ccb4242d3\
494adf4e54f15458f7645acfa8a6e75f5ff05656f1ababe2e8e8e2e9e9e9dbdbdbe7e7e7e6e6e6\
eef3f29f7873580000650c0f5f0d1e550d2f490e3e3e0e4c340e572d0e5f280e64230d68090782\
1111971f1fa72c2cb73636c43b3dd04144db4a46d1523aa14f1d53632c35c4c2df5d5df15656f1\
ababe2e8e8e2e9e9e9dbdbdbe7e7e7e6e6e6e9eaeac8bbbb783f3e5d0606690606760d0b7f0e0b\
870f0c8e100e9411109b12119611171707760f11981d1faa292dbe3735c046319f552362591023\
5100005e1b15a78882cbcbe95c5cf05656f1ababe2e8e8e2e9e9e9dbdbdbe7e7e7e6e6e6e6e6e6\
eaebebe6e7e7b6a09f78383865060773080a7d0e10840f118b101295111391111713077a0e1199\
2e1c8d4f1d6464152f670a0a5c0000611816987472d8d3d2eff2eecacae85c5cf05656f1ababe2\
e8e8e2e9e9e9dbdbdbe7e7e7e6e6e6e6e6e6e6e6e6e7e7e7eceeeee3e3e3b096967831306e0607\
7e0b0d8810129011128c1117410a49620f33760e13750a07670301651514936a69d3ccccecefef\
e8e9e9e9e9e6cacae85c5cf05656f1ababe2e8e8e2e9e9e9dbdbdbe7e7e7e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e7e7e7ecefefdfdfdeab8c8b7a2a2a7906078b0d0f8b1112770f0b820d0b710506\
6a11128f605fcec5c4ebefefe9eaeae6e6e6e6e6e6e9e9e6cacae85c5cf05656f1ababe2e8e8e2\
e9e9e9dbdbdbe7e7e7e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e8e8ecefefdcdad9\
a682817e24247d07086d0707720e0f8c5655c9bdbceaeeede9ebebe6e6e6e6e6e6e6e6e6e6e6e6\
e9e9e6cacae85c5cf05656f1ababe2e8e8e2e9e9e9dbdbdbe7e7e7e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e8e8e8ecefefd8d4d49d7271824b49c4b4b4e9ececeaecec\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e9e9e6cacae85c5cf05656f1ababe2e8e8e2e9e9e9\
dbdbdbe7e7e7e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e8e9e9e9ecece6e8e8eaecece6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e6\
e0e0e6cacae8c9c9e9d4d4e0e3e3e2e9e9e9dbdbdbe7e7e7e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7e7e7e7e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e6eaeae6ebebe7e1e1dfe2e2e2e8e8e8d4d4d4\
e0e0e0dfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdf\
dfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdf\
dfdfdfe0e0e0d8d8d8e0e0e0f6f6f6e0e0e0e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2\
e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2\
e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e0e0e0f2f2f2\
""")

mcs_img = img_data(width=32, height=32, mask=-1, encoded_data = """\
f8f8f8e9e9e9eaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaebebea\
eeeeecf1f1edf2f2edf2f2edf1f1edefeeecebebeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaeaea\
eaeaeaeaeaeaeaeaeaeaeaeae8e8e8f6f6f6e4e4e4d2d2d2dcdcdcdbdbdbdbdbdbdbdbdbdbdbdb\
dbdbdbdbdbdbdcdcdbe2e1dee3e3ded2d3d7b6b7ca9b9ebe8c90b88b8fb7999cbdb2b4c8cfcfd5\
e2e2dee3e2dedcdcdbdbdbdbdbdbdbdbdbdbdbdbdbdbdbdbdbdbdbdbdbdbd5d5d5dededee5e5e5\
dededee8e8e8e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7eeeeeae7e7e7abaecc5c62a8212b8f010e81\
00017b00007900007900017b000b801c268c5259a4a1a4c8e2e3e5efefebe8e8e7e7e7e7e7e7e7\
e7e7e7e7e7e7e7e7e7e1e1e1e0e0e0e5e5e5dddddde7e7e7e6e6e6e6e6e6e6e6e6e8e8e7edede9\
abaecc39409800047c0000780713832e38945059a46671b26873b4545da6323c960c1785000079\
00017a2d35939ca0c5eaeae8e9e9e8e6e6e6e6e6e6e6e6e6e6e6e6e0e0e0e0e0e0e5e5e5dddddd\
e7e7e7e6e6e6e6e6e6eaeae8e2e2e4676dad00097e00007a2c3593878cbbcaccdaeaeeeeeaece8\
c2aaa4bb9b96e5e5e0ecf0f0d0d2de9296c037409800027b00037b545ba5d8d9e0ecebe9e6e6e6\
e6e6e6e6e6e6e0e0e0e0e0e0e5e5e5dddddde7e7e7e6e6e6eaeae8dadbe1424b9d000078111b86\
898dbce3e4e6f5f8f3e4e5e3b69d9b8d3c3c8b080a8f05078e2e2eae8a89dcdcdaf4f8f4e9eae9\
999dc41d268c000078303894cdcedbecece9e6e6e6e6e6e6e0e0e0e0e0e0e5e5e5dddddde7e7e7\
e9e8e7e0e0e33f489c0000782c3492c4c7d8f6f9f4dfdfdeb193928a35358a07089b070aa20d10\
a50d10a7080c9d0407942728ab807fd6d5d4f4f9f4d2d5e03e469a0000782b3492d4d5deeaeae8\
e6e6e6e0e0e0e0e0e0e5e5e5dddddde7e7e7ecece95e66aa0000782f3996d8dde7e2e0dcac8989\
882e2e8b05079b080ba10d10a30d10a60d10aa0d10ad0d10b20d10b5090cab04069b2122a97776\
d7d4d0e2e8ec444ea1000078444d9ee6e6e6e7e7e7e0e0e0e0e0e0e5e5e5ddddddefefea9fa3c7\
00077e1a2791b8b7c6ae87828627278b04069a080b9f0d10a20d10a50d10a90d10ac0d10b00d10\
b30d10b60d10ba0d10bf0d10c30a0db90406a31c1dae726fbebac129389800017c848abaf0efeb\
e0e0e0e0e0e0e5e5e5dfdfdee1e1e42834940304725936578f2a258d04069a090c9e0d10a10d10\
a40d10a70d10ab0d10ae0d10b20d10b50d10b90d10bc0d10c00d10c30d10c70d10cb0d11d10b0f\
c90307ba1e1c74384e07076e16218bd2d3dde3e3e1e0e0e0e5e5e5e6e6e1989cc4000580221763\
6e0d06770a0a8f0d0fa20d10a50d10a70d10aa0d10ad0d10b10d10b40d10b80d10bb0d10bf0d10\
c20d10c60d10c90d11cd0d11d20d11d90d11cc0d109e0b0c6a09022d1c5a0002807b81b7eae9e5\
e0e0e0e5e5e5e2e2e0444d9e000680716388851310861011780f0f7b0e0e970d0eae0d10b30d10\
b40d10b70d10ba0d10be0d10c10d10c50d10c80d11cc0d11d20d11d80d11c60d10950d0e690c0c\
5c0b0c5c09077f6982051186293493dddddfe1e1e1e8e8e6c7c8d40e1a86192890af9ea47a0d0d\
8b10129311139011137f10107f0e0e9e0d0eba0d10c00d10c10d10c40d10c70d10cb0d11d10d11\
d60d11c10d10910d0e6c0d0d650d0d670c0d630b0d570404b09898313e9c020b7fb6b8cde5e5e3\
ecece8a1a4c300037b4a56a6c5b1ae740b0c860f118c10129411139d12159a1314871111830e0e\
a40d0ec60d10ce0d11d10d11d40d11bb0d0f8d0d0e6f0e0e6f0e0f720d0f6d0c0e660c0d610b0d\
550304bca39d6872b4000078888db9e9e9e4eeeee98186b4000078747db9c9b5af710a0b810f11\
8810128f11139612149e1215a81316a514168e1212870f0fac0d0fb70d0f8a0e0e740e0f790f10\
7c0e10760e0f700d0f6b0c0e650c0d5f0b0c540304bba39d9098c4000072646ba6eaeae5efeee9\
6c72ab000078747db9ccb8af6f0a097d0e10840f118b1012921113991214a01315a81316b21417\
b1151890120f770f09890f0b8a0f0c820e0d7a0d0e740d0e6f0d0e690c0e630c0d5e0b0c520202\
bba297aeb4e13336c36f74d1e5e5e2efeee96a71aa00037b0c1988534d89620e1b7c0e0c850f0c\
8a100f8f11129511139c1214a31315ab1416ab141c490b5844105a5f164e6b173f71152f73121f\
720e136e0c0a6809056208035c0803550c148d7cb27b81ff666aff8084e0e4e4dfefeee9767cb0\
00057c000a7e00017d070d7b260d5c4a0e3e690f2780101a9011139c1211a51311ad1411b71410\
2f086a050e9c171ca92729b63533bd3f36b94937af51369f5732895a2c725d3d95625cde6065ff\
6266fe363dc95e66a8e9e9e4edede99296bc00027b3e479c5a5d9d080973000d87000d89000d83\
0b0d771c0e6a2f0e5e400f544f104c5f11442b0969080b9119199f2626af3132bf3839c93e40d2\
4447dd4a4ee75056f5595fff5f5ef18b88ec6269c3000077767cb0eaeae5eaeae7b7b9cc030d80\
333f9cc3b0ac5809124b0c31330d4e1e0d650d0d75010d7f000d85000d88000d89000c89000986\
09098b16169c2323ac2f2fbb3838c53d3dcc4345d8494ce3533eac5a2a63501025baa29b4c58a5\
00027ba1a5c4e7e7e3e6e6e5d9d9dc273292061286928297630d096c0c09740d0a780e0e760e17\
710f216a0f2c6310365d103f5a1044490e4f0907851313982020a82d2db83636c43a3ed3453ec1\
57235e5c0a0b5606014e03009a848e13228e121e88cecfd8e3e3e1e5e5e5e7e6e27177b200017e\
3e34735e0b066207096c0c0e730d0f7b0e0f830f0f8c100f94110f9c1110a7130f961112110672\
0f10971d1da5292bb93435c44c2a856111226108045a0a0b5207085005014e3d6e000480535ca5\
e8e7e4e0e0e0e5e5e5e2e2dfc7c9d90b16850a117e866a7a702a275f03046d0a0b760e0f7c0e10\
830f118b10129211139b121492110f22075b090d96171ba83323985d18436b0b09650b0a5d090a\
52010263211f8f7077161d81020a7fb0b3cee7e6e3e0e0e0e5e5e5ddddddefefeb686fae000079\
4c58a8dedad8a17d7c6c1e1e690405780c0e800f118610118d101296111491110d3b0844090a90\
44135c6f0e17700c08680a0c5c0204611818987271e0dad56671b40000794c55a2ebebe9e0e0e0\
e0e0e0e5e5e5dddddde9e9e8d8d9e0242e90000079737bb5f5f8f3d7d1d099706f6f1818740507\
830e108a10129211138a1110610c22620c2d7c0e0a730c0c660405641313916565d2cacaf7f9f4\
8d94c100057c141d87c8c9d9ebebe9e0e0e0e0e0e0e5e5e5dddddde7e7e7edede9b4b7d00c1483\
00057c787eb5efefeceff3f1d0c8c79464637414148007098f0f12841011770e0d810e0c710607\
690f0f8c5a59ccc1c0eef0eff2f3ee8e93bf050c80030a7e9da1c6efeeeae6e6e6e0e0e0e0e0e0\
e5e5e5dddddde7e7e7e6e6e6efeeeaa1a5c80a128300027b575ea6d4d6def3f4efedf0efcabfbe\
9158577c10117d090a700808710c0c884e4ec5b7b6ebefedf3f4f0dedee26a70af00077d02097e\
8a8fbdeeeeeae6e6e6e6e6e6e0e0e0e0e0e0e5e5e5dddddde7e7e7e6e6e6e6e6e6efeeeaabafcc\
1b238a0000781d268c868bbbd6d7dff2f4eff2f5f0cbbbb78a4c49824340c5b3aff1f3eef4f5f0\
dcdce19498c1283191000078101885989dc3eeeeeae6e6e6e6e6e6e6e6e6e0e0e0e0e0e0e5e5e5\
dddddde7e7e7e6e6e6e6e6e6e6e6e6eeeeeacdcfdb5158a300087e000078162089555ca58c91be\
b3b8d4bcbfd2bbbdd1b7bcd69297c15d64a91d288c00007900037b42499cc0c3d5efeeeae6e6e6\
e6e6e6e6e6e6e6e6e6e0e0e0e0e0e0e5e5e5dddddde7e7e7e6e6e6e6e6e6e6e6e6e6e6e6ebeae8\
ebebe9aeb1cd4d54a20c168500007900007800047c000c80000d8100057c000079000079061182\
42499da2a5c8e8e8e7ecece9e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e0e0e0e0e0e0e3e3e3d6d6d6\
e0e0e0dfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfe6e6e2e5e5e2c4c6d38f93bb5f66a6404898\
3039912f39913d45975b61a4898db8bec0d0e3e2e1e7e6e2e0e0dfdfdfdfdfdfdfdfdfdfdfdfdf\
dfdfdfdfdfdfd9d9d9dededef4f4f4e0e0e0e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2\
e2e2e2e2e2e2e5e5e3eaeae6ebebe6e8e8e5e4e4e3e4e4e3e7e7e4ebebe6ebeae6e6e6e4e2e2e2\
e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e0e0e0f1f1f1\
""")

snap_back_img = img_data(width=32, height=32, mask=-1, encoded_data = """\
fafafaeaeaeaebebebebebebebebebebebebebebebebebebebebebebebebebebebebebebebebeb\
ebebebebebebebebebebebebebebebebebebebebebebebebebebebebebebebebebebebebebebeb\
ebebebebebebebebebebebebeaeaeaf8f8f8e6e6e6d1d1d1dbdbdbdadadadadadadadadadadada\
dadadadadadadadadadadadadadadadadadadadadadadadadadadadadadadadadadadadadadada\
dadadadadadadadadadadadadadadadadadadadadadadadadadadadbdbdbd2d2d2e3e3e3e7e7e7\
dddddde8e8e8e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7\
e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7\
e7e7e7e7e7e7e8e8e8dfdfdfe4e4e4e7e7e7dcdcdce7e7e7e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7dededee4e4e4e7e7e7dcdcdc\
e7e7e7e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7\
eaececebeeeee7e8e8e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e7e7e7dededee4e4e4e7e7e7dcdcdce7e7e7e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e7e7e7ebeeeee4e8e8bda9a8af908fdbdbdaebefefe8e9e9e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7dededee4e4e4e7e7e7dcdcdce7e7e7\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7ebeeeee2e5e5baa5a49045448a0a0c\
9004068e2a2aab8484d7d6d6eaefefe8e9e9e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e7e7e7dededee4e4e4e7e7e7dcdcdce7e7e7e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e8e8ebefef\
e0e2e2b69c9b8d3d3c8a080a9b0609a30c10a60d10a9090c9f0406942424a97b7bd3d1d0eaefef\
e9eaeae6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7dededee4e4e4e7e7e7dcdcdce7e7e7e6e6e6\
e6e6e6e6e6e6e8e8e8ebefefdddeddb193928a35358a07089b070aa10d10a40d10a70d10ab0d10\
af0d10b30d10b80a0dad04069d1e1fa87271cfcbcbe9efeee9ebebe6e6e6e6e6e6e6e6e6e7e7e7\
dededee4e4e4e7e7e7dcdcdce7e7e7e6e6e6e6e6e6ebededdcdad9ac8a89882e2e8a05079a080b\
a00d10a20d10a60d10aa0d10ad0d10b10d10b50d10b80d10bc0d10c10d10c60a0dbc0407a6191b\
a86868cdc5c4eaecece7e7e7e6e6e6e7e7e7dededee4e4e4e7e7e7dcdcdce7e7e7e6e6e6e9ebeb\
ac94937725248b04069c080b9f0d10a10d10a50d10a90d10ac0d10b00d10b40d10b70d10bb0d10\
bf0d10c20d10c60d10c90d11ce0d11d60b0fd20408a41415946968e2e2e2e7e7e7e7e7e7dedede\
e4e4e4e7e7e7dcdcdce7e7e7e6e6e6eaeeee8f56556f0202760e0e8e0d0ea50d10aa0d10ac0d10\
af0d10b30d10b60d10ba0d10be0d10c10d10c50d10c80d11cc0d11d20d11d90d11ca0d109a0d0e\
6906066a2a29e4e3e1edede7edece7dfdfdee4e4e4e7e7e7dcdcdce7e7e7e6e6e6eaeeee945c5c\
8407098910127c0f107b0e0e960d0eb10d10b90d10b90d10bd0d10c00d10c40d10c70d11cb0d11\
d20d11d70d11c50d10950d0e6b0c0c5f0c0c5d0608723330cfd0e3afb1ebb1b3ebd2d2dfe5e5e4\
e7e7e7dcdcdce7e7e7e6e6e6eaeeee935c5c7d07088b10129411139412148411117f0e0e9c0d0e\
bd0d10c70d10c70d10ca0d11d10d11d50d11bf0d10900d0e6e0d0d690d0e6b0c0e660c0d5d0608\
743630afb0e55156f1565af1bebfe0e7e7e3e7e7e7dcdcdce7e7e7e6e6e6eaeeee925c5c790608\
8610118d10129511149f12159f13158c1212840f0ea20d0ec90d10d40d11ba0d0f8d0d0e720e0e\
730e0f760e0f700d0e6a0c0e640c0d5b0608733630b1b2e5575bf15b5ff1bfc0e0e7e7e3e7e7e7\
e1e1def0f0ebeaeae8eaeeee915c5b750607810f11891012901113981214a01315aa1416ab1417\
961314880f0f8a0e0a7c0f0a7f0f0f810f117a0e10740d0f6e0d0e680c0e620b0d59060772362f\
b1b2e5575bf15b5ff1bfc0e0e7e7e3ebeae9abaec69293bfc5c7d7f4f8f2905d5b7005077d0e10\
850f118c10129411139b1214a21315ab1416b81516961228300a5e68113c801019810d0a7a0d0b\
730d0e6d0c0e660c0d600b0c57060772362fb1b2e5575bf15b5ff1bfc0e0e7e7e3f0f0ec7e83b2\
0000761f288da9b0d18e5a597105017c0e0d810f108810128f11139712149e1215a61316b11514\
93112b06088d11159e2e2097512170691739700d116d0a05650b095f0b0c56050771362fb1b2e5\
575bf15b5ff1bfc0e0e7e7e3e8e8e8d9d9db555ea700007a00087f1a16703b0c415d0d26750e16\
850f0f90100e99110ea01210a71311b214109311280a088814159a2022ad2c30c13737c64734a8\
57276d5f152e5d0a0954020070342cb1b2e5575bf15b5ff1bfc0e0e7e7e3e7e7e7dededde8e8e8\
9397c12d3592000d84000d8a000d830d0d75210d64360e544b0f475d103d6d10367d12306b0f3e\
0a088814159a2222aa2f2fba3737c63c3ed24246dd4b48d7543eab53245f703d4aafafe4575bf1\
5b5ff1bfc0e0e7e7e3e7e7e7dcdcdce8e8e7efeeeae5e8ea6e4f6a2b0542190d65080d78000d83\
000d88000d89000d89000d87000d86000b8408088a15159a2222aa2f2fba3737c53d3dcd4444d5\
494ce25056f45556f16b5dc19e9ee8585cf05b5ff1bfc0e0e7e7e3e7e7e7dcdcdce7e7e7e6e6e6\
edf0ef8a58545a0000690c0c660d175f0e26550e344a0e42410e4d3b0f55370f5a2a0c64080889\
15159a2222aa2f2fba3638c73b3fd54345d94d41be5430804d0f2f6a312cb2b3e5575bf15b5ff1\
bfc0e0e7e7e3e7e7e7dcdcdce7e7e7e6e6e6e9eaeac5b6b67a42415d0707690607760d0c7e0e0c\
870f0c8f100d96110fa1120e850f250a088814159b1f23af2d30c03c33b44d2b845a1b445a090f\
510000682b27b8a19ab6b8eb565af05b5ff1bfc0e0e7e7e3e7e7e7dcdcdce7e7e7e6e6e6e6e6e6\
eaecece6e7e7b7a2a178393865060773090a7d0e10840f118c10129711117d0e2906088d191594\
3b1c7d5a194c69101d6807035b0000682524a78a89e0dedef1f3eeb4b6e9565af05b5ff1bfc0e0\
e7e7e3e7e7e7dcdcdce7e7e7e6e6e6e6e6e6e6e6e6e7e7e7ebeeeee3e3e3b096957830306f0506\
7f0b0d8810129111117f0f20470b456f10237a0e0c740906650202691f1ea07d7ddcd8d8ecefef\
e7e8e8ebebe6b4b6e9565af05b5ff1bfc0e0e7e7e3e7e7e7dcdcdce7e7e7e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e7e7e7ecefefdfdedeaa8a897928287a06078c0d0f891011790e0a7f0d0c6f0505\
6c19199a7170d7d1d1ecefefe8e9e9e6e6e6e6e6e6ebebe6b4b6e9565af05b5ff1bfc0e0e7e7e3\
e7e7e7dcdcdce7e7e7e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e8e8ecefefdbd8d8\
a47e7d7d21227b07076d0506731414946665d1c9c9ecefefe8e9e9e6e6e6e6e6e6e6e6e6e6e6e6\
ebebe6b4b6e9565af05b5ff1bfc0e0e7e7e3e7e7e7dcdcdce7e7e7e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e8e9e9ebefefd6d2d1986c6b885554ccc0c0ebeeeee9eaea\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6ebebe6b4b6e9575bf05c60f1bfc0e0e7e7e3e7e7e7\
dcdcdce7e7e7e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e8e9e9e9ebebe8e9e9e9ebebe6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e6\
dcdde7cacbe8cccce9d8d8dee5e5e4e7e7e7dcdcdce7e7e7e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7e7e7e7e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e8e8e6eaeae6ebebe7dfdfdee4e4e4e6e6e6d6d6d6\
e1e1e1e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0\
e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0\
e0e0e0e1e1e1d8d8d8e2e2e2f5f5f5dededee1e1e1e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0\
e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0\
e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e1e1e1dededef2f2f2\
""")

spin_img = img_data(width=32, height=32, mask=-1, encoded_data = """\
f8f8f8eaeaeaebebebebebebebebebebebebebebebebebebebebebebebebebebebebebebebebeb\
ebebebebebebebebebebebebebebebebebebebebebebebebebebebebebebebebebebebebebebeb\
ebebebebebebebebebebebebeaeaeaf7f7f7e4e4e4d2d2d2dbdbdbdadadadadadadadadadadada\
dadadadadadadadadadadadadadadadadadadadadadadadadadadadadadadadadadadadadadada\
dadadadadadadadadadadadadadadadadadadadadadadadadadadadadadad4d4d4dededee5e5e5\
dededee8e8e8e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7\
e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7\
e7e7e7e7e7e7e7e7e7e1e1e1e0e0e0e5e5e5dddddde7e7e7e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e0e0e0e0e0e0e5e5e5dddddd\
e7e7e7e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
eaececebefefe8e8e8e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e0e0e0e0e0e0e5e5e5dddddde7e7e7e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e7e7e7ebedede5e9e9bfacacae8e8dd9d8d8ebefefe8e9e9e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e0e0e0e0e0e0e5e5e5dddddde7e7e7\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7ebeeeee3e7e6bda9a8914948890c0d\
9003068d2728aa807fd6d4d4eaefefe8e9eae6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e0e0e0e0e0e0e5e5e5dddddde7e7e7e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e8e8ebefef\
e1e3e3b8a09f8e404089090b9a0609a20c0fa50d10a9090c9f0406942122a87776d1cecee9efef\
e9eaeae6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e0e0e0e0e0e0e5e5e5dddddde7e7e7e6e6e6\
e6e6e6e6e6e6e7e8e8ebefefdfe0e0b397978b38388908099a0709a10d10a30d10a70d10aa0d10\
ae0d10b30d10b70a0dae04069d1c1da76d6dcdc8c7e8eeeee9ebebe6e6e6e6e6e6e6e6e6e6e6e6\
e0e0e0e0e0e0e5e5e5dddddde7e7e7e6e6e6e6e6e6eaececdedcdcae8e8e89313189060799070a\
a00d10a20d10a60d10a90d10ad0d10b10d10b40d10b80d10bb0d10c00d10c60b0ebd0407a71719\
a76464cbc1c1e9ecece7e7e7e6e6e6e6e6e6e0e0e0e0e0e0e5e5e5dddddde7e7e7e6e6e6eaebeb\
b19c9a7728278a05069b080b9f0d10a10d10a50d10a80d10ac0d10b00d10b30d10b70d10ba0d10\
be0d10c20d10c50d10c90d11ce0d11d60b0fd30408a71213916261e0dfdfe7e7e7e6e6e6e0e0e0\
e0e0e0e5e5e5dddddde7e7e7e6e6e6ecefef9766646e0102770e0d8d0d0ea40d10aa0d10ab0d10\
af0d10b20d10b60d10ba0d10bd0d10c10d10c40d10c80d11cc0d11d10d11d90d11cb0d109d0d0e\
6b0707641f1fdddadae7e8e8e6e6e6e0e0e0e0e0e0e5e5e5dddddde7e7e7ebeae8f2f6f29a6a6a\
8207088910127d10107a0e0e940d0eb00d10b80d10b90d10bc0d10c00d10c40d10c70d10cb0d11\
d10d11d70d11c60d10970d0e6c0d0d5f0c0d5e08096a2626e2e0daeaebe7e6e6e6e0e0e0e0e0e0\
e5e5e5dededdefeeeac3c6d7626bb1471d45830d0b8a10129311139512148511117f0e0e9b0d0e\
bc0d0fc70d10c70d10ca0d11d00d11d50d11c10d10920d0e6e0d0d690d0e6b0c0e660c0d600909\
5b19289696e9d0d2ecebebe5e0e0e0e0e0e0e5e5e5e2e2e0868bbc0c148400007d330b3d810f0b\
8510118c10129411139e1214a013158e1212840f0fa00d0ec70d10d40d11bc0d0f8e0d0e720e0e\
730e0f760e0f710d0f6a0c0e650c0d5e09085716295a5cf5696dfeadaef2e2e2e0e0e0e0ecece8\
969abe00077d0a1282707ab8855861750707810f118810128f1113971114a31311ae1312ac1416\
971314890f0f870e0e780f0f7e1011810f117b0e10750e0f6f0d0e690c0e630b0d5b0809642326\
9f9fe76b70fe6165ffb5b6e8e5e4dfefeee95a61a302037a7b81b6fffff99b6f6c6e04067d0e10\
840f118f1110740e2a3e0b5f7b133aa5141bba1411ac131279100f8e1012860f117f0f11790e10\
730d0f6d0d0e670c0d610b0d590708662625eae7d9b9bbf16064ff8a8df1e4e4dfedece88e93ba\
00037b20288da4acd09568676f05017b0e0d810f0f8b100e6a0c2e01089012159d3620946b236e\
8f1b397e10108e0e0a840e0d7d0e10770e0f710d0f6b0c0e650b0b5f0907570300652521c5c3e1\
868afa5d62ff989aeee5e5dfe6e6e5dddddd5d65aa00027a00067e1a1873390c435c0d27740e17\
88100c6b0c2a07088b15159b1f22ae2b31c23738c44d34a46a27697a172c7d0d0b770a05700905\
6a0a09640f165f1b355e306c6353be656afd5d61ff8689f9d7d7e2e2e2e0e5e5e5dfdfdeeae9e8\
989cc3313894000d84000d8a000d830c0d75210e63260b6108088a15159b2222ab3030bb3838c6\
3c3fd24146dd4d48d45d3ca368337b6941986750bb665edf666aff6772ff666eff767afbacaef1\
e3e3e7e2e2e0e0e0e0e5e5e5dddddde8e8e7eeeeeae8eaeb775c752c04401a0d64090d77000d83\
000a8608088a15159b2222ab3030bb3838c53e3ecd4444d5494ce34e56f4565fff6069ff656dff\
6665f26457ce5c3e94653c68d9d6ddecede7e7e7e6e0e0e0e0e0e0e5e5e5dddddde7e7e7e6e6e6\
edf1f0946864580000680b0b660d17610e23410a4607088b15159b2222ab3030bb3739c83c40d5\
4344d7533fb862358a693479692d61652142601424590a0d4d00005d1c17e0dddbe7e8e8e6e6e6\
e0e0e0e0e0e0e5e5e5dddddde7e7e7e6e6e6e8eaeacabebd7e49485d0809670506780d085e0a28\
07088b14159c1e23b12d31c04034b1572a7f721c417a0f14770b067009046a09056409075c0605\
510101652827ad9392e6e7e6e6e6e6e6e6e6e0e0e0e0e0e0e5e5e5dddddde7e7e7e6e6e6e6e6e6\
eaebebe8e9e9bca9a87c3f3f6807045304270308901c1593441c79731b4a8a141d780d08830d0b\
7a0e0f740d0f6e0d0e67090b5b0203662120a28281dedbdaecefefe6e6e6e6e6e6e6e6e6e0e0e0\
e0e0e0e5e5e5dddddde7e7e7e6e6e6e6e6e6e6e6e6e6e7e7ebeeeee5e6e6b79e9b6834483e033b\
710b1b8b0f0d93100d8d1010740e0f7f0f11780e10720b0d650304681b1b9b7675d9d4d4eceff0\
e8e8e8e6e6e6e6e6e6e6e6e6e6e6e6e0e0e0e0e0e0e5e5e5dddddde7e7e7e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e7e7e7ebeeefe3e2e0b3928c7d2d2b7806078a0c0f891012730e0f7f0d0f700507\
6c1515956a69d3cdccecefefe8e9e9e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e0e0e0e0e0e0\
e5e5e5dddddde7e7e7e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7ecefefdddcdc\
a886857e26267b07076c0606721112905e5dcec4c3ebeeeee9eaeae6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e0e0e0e0e0e0e5e5e5dddddde7e7e7e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e8e8ecefefd9d6d69d747385504ec8babaeaedede9ebeb\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e0e0e0e0e0e0e5e5e5\
dddddde7e7e7e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e8e9e9e9ecece7e9e9eaecece6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e0e0e0e0e0e0e5e5e5dddddde7e7e7e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e7e7e7e7e7e7e6e6e6e6e6e6e6e6e6e6e6e6\
e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e6e0e0e0e0e0e0e3e3e3d7d7d7\
e1e1e1e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0\
e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0\
e0e0e0e0e0e0dadadadededef3f3f3dededee1e1e1e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0\
e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0\
e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0e0dededef0f0f0\
""")

