---
title: 2024 Tutorial
---

This tutorial shows debugging simulation warnings, pedestrian models, flying taxis, and more!

# Files

- [sumo2024_tutorial.zip](https://sumo.dlr.de/daily/sumo2024_tutorial.zip)

# Video
<a class="no-arrow-link" data-youtube href="https://www.youtube.com/watch?v=9WCGxJDdY9s">Watch the 2024 Tutorial</a>


# Transcription

## Intro
Hello everybody and welcome to the SUMO User Conference tutorial. My name is Jakob Erdmann and I will present what I think is the tenth tutorial in the series. So enjoy. The topics we'll be covering today are as usual something about OSMWebWizard to get all of you started, especially the newer users. Then we'll talk about how to look at strange things that might happen during the simulation. We'll get a deeper look at some of the pedestrian models included in SUMO, especially the new ones. And for final fun, we'll be looking at flying taxis. To follow the tutorial, you'll be needing the latest SUMO release, which is version 1.20.0. And you may be needing Python and the data files are behind the link, you can find it also in the tutorial section on the SUMO Documentation pages. So first of all, OSMWebWizard. This is our tool to get you started with the SUMO simulation with, well, about three clicks. It's a Python application that you can launch from your start menu if you've installed SUMO, or you can find it in the SUMO tools folder. And upon launching it, it will open up a web browser and show you a map. Basically, an OpenStreetMap based rendering of the world, and there you can select an area, modes of traffic that you want to see in your simulation, and then when you click "generate scenario" the data will be downloaded, processed and sumo-gui will open on your machine and you are ready to watch a simulation. So, the things that you configure here are, as I mentioned, the location, it will then select the data, the corresponding data from the OpenStreetMap database and populate it with random traffic according to the selected traffic modes. So cars, trucks, buses, motorcycles, pedestrians, etc, etc. And you can also configure the road types that should be included in the simulation, such as with or without rails or only the roads or only pedestrian stuff. And for each mode of traffic, you can select the traffic volume that you want to see and also how much traffic is generated at the borders of the network or rather within the network. This is the fraction of through traffic, the through traffic factor. You can also select whether you want to have public transport in your simulation, for how long the scenario will be running, which is basically for how long traffic should be inserted into the scenario. And you can also configure it to include the shapes of buildings and points of interest for trees, post boxes, whatever is in OpenStreetMap. And then there's also a checkbox that lets you switch on a satellite background instead of the normal shapes.

Now, all these files will be downloaded to your computer in a folder. If you downloaded the tutorial files, you can find such an example folder named 0_wizard. But today, we want to look at the deeper implications of some of these checkboxes here. So let's go into more details. The through traffic factor. This is useful if you want to discriminate between smaller and larger networks. If you have a small network, then probably most of the traffic will be through traffic. So the traffic should start at the network boundary, and you will want to set a high through traffic factor value. Whereas if you have a larger network, then it's fair to say that lots of traffic will be starting and ending within the network. So the through traffic factor doesn't need to be so high. Then there's the count setting, which you can set for each mode. And it means vehicles per hour per road kilometer. So here in this case, where it's set to 12, if you had a network with just one kilometer of roads for cars, then that would give you 12 cars within one hour, which is the default duration of the scenario, 3600 seconds. But there's more. If you enable specific modes, this will trigger additional processing of the network. So if you select the checkbox for the mode pedestrians, then the network will come with extra infrastructure. This will be sidewalks as well as pedestrian crossings. Otherwise, you won't have those. And there's one more thing. For all the roads where OpenStreetMap doesn't record the speed limit, which sometimes happens, depending on you location on the World, the default will differ, depending on whether you activated pedestrians or not. If you do, then an urban settings will be assumed. And you'll have a default road speed limit of 50 kilometers per hour, which is tailored to Germany, where you have a higher speed limit of 100 kilometers per hour outside urban settings, which is the default. Now, if you select the mode ship, then also the rivers and ferry routes that are known to OSM will be imported as part of the network. If you select bicycles, then extra bike lanes will be part of your generated network. Now, apart from those traffic modes, there's also the checkbox public transport. If you do that, then all the trains, buses, and ferries, which are in OSM, that run through your network, will be imported. And they will even get a synthetic schedule, because schedules are not part of OSM. This has to be generated by the toolchain. And if you do, then the pedestrians may also use public transport. So without public transport, they all walk. But if you select public transport, then they can also ride one or more lines to reach their destination. If you set the checkbox car only, here in the lower right corner, then it will only keep edges for cars, plus all the edges for public transport, if you also activate the public transport. And now we're coming to one interesting setting. If you select satellite background, then, well, there will be satellite tiles downloaded from a server, and they will be put into your SUMO simulation. But it will also change the geo-projection of your network. This has to do with the standards that are typically used for satellite tiles. And the problem with that is, this different projection is not something that the geo people really like. It's a bad projection, plainly speaking, because it distorts distances. So in the worst case, the roads may be twice as long as they should be, or even worse. So really only do this if you know what you're doing, and if you really need a satellite background. And then be prepared that you may have wrong distances in your network. And lastly, the left-hand traffic, well, you should know when to check this. If, for example, you're in Great Britain, then you'll know that there are different right-of-way rules, different from most of the rest of the world. So then check this box, and you'll be fine. And then, once all this has generated, you're looking at a folder full of files, and they can be distinguished in basically two sets of data. First of all, stuff that is really needed by SUMO to run. So this is the SUMO configuration, which binds everything together. And it can be loaded by sumo-gui, by sumo, and even by netedit. Then, of course, there's the traffic network. And there is the traffic demand. There is a file for each mode that you selected. Also, the traffic demand for the persons. Then there are the building shapes. And then there is a file that says how the initial view should be presented with regard to delay and color settings. And the second set of files are those that are needed if you want to rebuild the scenario with different options or different traffic. This is mainly the raw OSM data, the netconvert configuration for rebuilding the network. The configuration for polyconvert to rebuild the shapes. And the batch file to regenerate all the traffic and the public transport. Now, let's look at the simulation.

## Debugging warnings
I'm launching the SUMO configuration file, which would also be launched if you press "generate scenario". So when we press play we can see stuff moving, but everything is very small, so let's maybe increase the size of the things, for this I'm going to the viewsettings and I change the vehicles to be drawn with constant size and to better appreciate what they are doing, I change the coloring to "by speed", and now let's look at this again. So you can see cars with different colors moving, what do the colors mean? Well, let's have a legend that tells us what the vehicle colors are and so you can see red cars are stationary, yellow and green cars are driving at different speeds and the blue cars are the fastest here in the scenario they're driving on a piece of motorway. So basically everything is looking good we have cars moving nothing out of the ordinary if we look close we can even see some tram lines in this part of the network, so maybe wait for another tram to appear and then I will zoom in to show you we can also see some buses because they have slightly different shapes from the cars so there are buses here in this part of the network and at some point we even have a tram running here, actually two that's fun. All right so we have cars in the network in the bottom you can see 70 cars but we also have persons 290 so where are these? Let's change the settings to make the persons more prominent, so i'll make the vehicle small again and now i'll increase the size of the persons and i'll also change the coloring to better show what they're doing. So let's color them by the mode mode now we have persons in the network you can see them moving on these roads in different colors, let's zoom in. And so what do these colors mean again yellow means they're waiting for a ride so you see they're waiting here at a bus stop waiting for the bus to come and green is walking and blue is riding so let's zoom out, we have some blue persons here riding the bus and of course we have plenty of green persons walking through the network, and there's the light blue those are using an access structure to get to a bus stop maybe crossing the street or using some stairs to get to to a rail stop. So we have the persons in the network. Now the next thing we want to do with this is to we want to look at some oddities, first of all let's just look at warning thrown up by the simulation. The first warning we saw down here in the sumo-gui was regarding the length of a bus stop now you can click on the underlying words in the warning and it will take you to the location either to the stop or to the lane, and you can even click to jump to the vehicle if it's still in the area. Now the warning is the bus stop is too short for a vehicle as you can see here it's really a very short piece of bus stop. If we want to know how long exactly we can see that it's just a length of 5 meters starting at position 0 going to position 5 and so this is enough to fit a normal car but not a bus. Well, what happened here in reality the bus stop would cover this part but there is an intersection here in the simulation where a side road enters just a small side road but the simulation considers all of this an intersection, and it is currently not possible to place bus stops on an intersection, so for this reason the bus stop has been artificially shortened in SUMO which was causing this warning. Now do you need to be worried about this? No. Unless you have multiple buses that want to use a stop at the same time it's really no problem the bus will stop here and persons can be can enter and leave it just fine, even with the shorter length. So basically this is a known issue and working as expected. Let's run the simulation some more, and get more warnings (maybe). To speed up the simulation I can lower the delay value here, and so then it's over real quick and indeed we have some more warnings that we can look at.

So a person is jammed on some edge, so we can again click on the underlined location the edge id and see where that is, but now it would be nice to also see the situation while it develops so i'm clicking on the time which is also a link, here it says a breakpoint has been set and the time is 5 seconds ahead of that time this is a convenience feature you can actually set the time difference in the menu so it's set to minus 5 seconds when you click on a timestamp and now we can just reload the simulation and rerun it to that time so it will automatically stop at the time of the breakpoint. If you want to see or edit breakpoints you can also do this from the breakpoint menu accessible by <kbd>Ctrl</kbd> + <kbd>B</kbd> the breakpoint editor. So now we have this situation which will in 5 seconds lead to this warning so i'm going to single step the simulation which you can do with the <kbd>D</kbd>-key or by pressing this step button, and now there's our warning. This is the pedestrian and it's jammed with regards probably to this vehicle and it looks pretty weird because apparently the pedestrian is walking on the road, so what is going on here? First of all i'll try to visualize for you which way the pedestrian wants to walk so I right click and select walking area path as you can see this is the way the pedestrian would like to walk within the intersection, but then you can see already some strange shapes and I will make this strange shape more obvious to you by highlighting it, so the person is on a walking area which is an area within the intersection but when I right click here I have to select this one. All right, so this is a walking area and i'm marking it here i'm adding it to the set of selected objects and this allows me to show it more prominently in the visuals by changing the edge coloring to "by selection". I think I picked the wrong one, so let's remove this from the selected set and try it. Now in this part when I right-click I only get the junction to get all the objects that are in the same place I hold down the <kbd>alt</kbd> key and then do a right click again, so this is the one area I want to select and now we can better see that it has a very strange shape it has this little triangle here and then another triangle there and if we want to see all of this and nothing else there's a neat trick you can do simply make everything that is not selected transparent and also hide the junction shape, and now you can see this is the shape of the walking area something bad happened here during network generation and so the best way here is if we want to get rid of this warning is really to fix the network and I'll show you how to do this in the next step. So let's look at that intersection in netedit. For this I can launch the network editor directly on the spot and as you can see this intersection is really a cluster of multiple junctions and this is something that comes out of OSM and is generally not very good for micro simulation having such a cluster of things. The automatic network conversion tries its best to join these clusters but sometimes you have to do this manually so I'm switching to the selection mode this button or the <kbd>S</kbd> key you can see it down here which keys are pressed, then I left click on all the parts of this junction cluster, and then I join them into a single junction. This is the joint selected junction functions <kbd>F7</kbd> and now there's only a single point here and I want to see the geometry, this is the <kbd>F5</kbd>-key "compute junctions", and then I have it. Now this has a much better shape, we don't see any strange triangles, however, in the process of fixing this junction, we lost the pedestrian crossing. So let's restore this as well. There's another mode for this, it's the crossing mode. So I can press the <kbd>R</kbd> key to go to the crossing mode, then I click on the junction where I want to add a pedestrian crossing. And then I click on all the network edges that should be crossed until they're all bright green. And then I create crossing or press the <kbd>enter</kbd> key, which has the same effect. And now the network is fixed. So are we done yet? Not quite, because we changed the edges in the network as well. So we have to rebuild the traffic. So you just run the build batch file, that's what it's for. But while you do, make sure that sumo-gui has been closed on Windows, because otherwise it will prevent you from overwriting the files. Now, we are at the next step, we've changed the network, and now when we run the simulation in this place, we can see that the geometry looks much better. And we can see that no pedestrian jamming occurs anymore in that section of the network. All right. Moving on. More oddities. So we find that at the end of the scenario, there are lots of warnings about pedestrians that missed their bus. So basically, they aborted waiting at a bus stop at the end of the scenario. This abortion is a convenience feature. The simulation noticed that no buses will come anymore, there are only waiting persons. And so it makes sense to terminate the simulation automatically. But of course, there is a warning. Now, let's find out why these persons missed their bus. And first of all, let's have a look at the input files. So we pick the first person. It's called ped774. And we'll find it in the input file. This is part of the scenario. OSMPedestrians.rou.xml. And I've already extracted the relevant lines of XML code, that describe what this person is doing. At this point in time, the person enters the scenario and it walks to a bus stop, so here it started with a walk that ends at the bus stop, and then it wants to ride to some other bus stop, using this line 160:0, and it even now which bus the person wants to take, the fifth one of a series of buses, which is departing at this time. So that's the plan. And then finally, after reaching the second bus stop, it should walk again to its destination. But somehow this doesn't work. The person keeps waiting there at the bus stop, at this one, and the bus isn't coming.

So to figure this out, we basically have two strategies. One is to look at output data that is generated by the simulation, and the second strategy is looking at the UI, at sumo-gui. And we'll, of course, we'll do both. So to see how they reinforce each other. So for the data-driven analysis, we'll run the simulation with an option to generate output. This looks about like this. If you have a command line window, this is sumo -c, which is the option for configuration file. And of course, we need a file name for this. And that's it. So now, after this is done, we have a new file in this folder. It's the tripinfo output. This is what it looks like. It's another XML file, which holds information about all the cars and all the persons in the simulation, and gives a summary of what they did. So I've copied this out here for you to the slides. And we can see, the different stages of what the person did, it was walking, then it was accessing a bus stop (this is automatically generated) so you didn't find this on the input, then there is a ride and a final walk, but here we can already see that the vehicle is NULL, so there is no proper vehicle, and the time of departure has a error value of -1, that's an error value and also the arrival has an error value, so the ride did not start and it also did not arrive. So the next walk did not depart or arrived. We can see the time at which the person reached the stop, and the arrival at the stop is 3201, whereas the departure of the bus was 3156. So the bus was missed by roughly 45 seconds. Don't you hate it when that happens? So why did it happen? Well, there's the key information here. The speed factor and the time loss. The speed factor here means that the person was walking slower than average. Every person gets assigned a factor, a random factor centered at 1 with a standard deviation of 0.1. And this describes the walking speed, the maximum walking speed of the person. So they don't all walk at the same speed. So this one was a slow person. And secondly, there's the time loss. So a person that walks slower than its desired speed loses time relative to its expectation. And so this person was walking even slower. And the reason why that happens is that there's additionally to this random speed factor, some random slowdowns during walking. So a person that walks doesn't walk with constant speed, but rather there is some variation in the walking speed, which is controlled by a SUMO option. And basically this means that the person walks only with 90% of the maximum speed on average. And this causes the loss of 71 seconds and overall missing the bus. So that's what we can get from the data. But let's also do a visual analysis and see how this looks in sumo-gui. So we know that the person departs at time 2519. So let's track this in the simulation. I'll set a breakpoint to the time of the departure. We'll run the simulation and forward it to that time. So that was the <kbd>space</kbd> key, which toggles running and stopping. You can remind yourself of these hotkeys in all the menus. And now I want to go to the, point where that person started. So I'll find it. And one thing we can do is track its speed. For this I do a right click on the person and then show parameter. Actually, I think I got the wrong person here. Because we're in the, let's see. This one. Show parameter, here you can see the speed factor that we already talked about, and now, when I do a left click on this icon, I get a plot of the speed over time.
Let's follow the speeds. Another thing we can do is we can track the person. Let's see, the person is walking happily along the road and then there is this little extra stage following this thin line and the person is at the bus stop unfortunately too late, and here you can see the walking speed you can see that it varies over time and this comes out about 90% of the walking speed. So at least this showed you how to find a person, track a person and plot its properties. It still missed the bus. So how do we fix this? Well there are several approaches, we could have done better planning and just assume that the persons will be slower when they walk so there's a default assumption of persons walking with 75% speed, but we can reduce this in the traffic generation and then all the timings will have more reserves. Another option to do is we can plan the intermodal routes so which bus to take within the simulation rather than beforehand, and this gives us the knowledge of how fast a person actually is so is it a fast or a slow person planning their route, and the final solution is we can just send more buses so how does that come out? For the different mitigations which you can all find here in the tutorial files in the "catch bus"-folder, well if we if we generally plan with slow walking speeds then this specific person catches the bus other person still miss it. If we plan the intermodal routing in the simulation, then even more persons will manage to catch the bus, but there still 2 misses, if we do the final mitigation attempt then well if as long as we send enough buses then everybody can catch one because eventually there will be a next bus. All right for the final oddity, this is one that didn't generate an error but it's something that may have you wondering nevertheless, so we specify the scenario with a traffic demand for one hour but the simulation ended more than two hours after the first person entered so this is something that you can see in the in the final line of the simulation, here, simulation ended at this time, so what took so long? Again we can do a data-driven analysis we can just look in the trip info output and see what the last arrivals were, or we can use sumo-gui to see who's still active in the simulation before it ends. So this is not something we can see in the final picture because there everybody has been removed, but if we set a breakpoint to almost the simulation end, let's say time 7835 and rerun it, then we can see persons that are still walking. So let's find these persons, and we don't want the blue one so let's make them even more visible we can make everything bigger and I would have to color them according to their mode, and then we have this green person which is walking and we can figure out where it's walking, and we can see it's walking all over the network. Let's play with the exaggeration a bit to make this more visible, so you can see this is a snaking path through the network and so it's a very very long walk that was actually causing the problem and if we look closer we find that there are some artifacts in the network that caused this long walk. So of course the network is only a small part of a larger city of Berlin and where we cut the network we cut some connectivity, so actually the person has to do a detour to walk around these missing edges and this occurs in two locations. And if we look even closer, we can even spot a small connectivity problem where a pedestrian crossing is missing. So just looking at these oddities teaches you a lot about your scenario and about things that you may want to change, for example, picking a better bounding box for what you want to simulate.

## Pedestrian models
Now, going to the next step of the tutorial, I want to show you some pedestrian models. So because we did talk about persons and persons that walk around the network, now the question is, how do they actually walk? Well, SUMO does provide different models for walking persons. But first of all, let's describe the scenario that we want to look at. It's a spring sale at the Hardware Store, everybody wants to buy gardening supplies. We have a hardware store here, and we have an entrance here and then a big parking lot that everybody has to walk across. Of course, we are very environmentally friendly, so everybody is taking the bus to buy their stuff at the hardware store, so they have to walk all across this parking area. So to set this up in netedit, we'll have to define a flow of persons. And here's how this goes. So I'm launching netedit here, and opening the network. You see some background, I'm also loading the shapes here. Here is the hardware store, and the parking. So what do we do? netedit has three major modes, one for network editing, one for traffic demand editing, and one for data editing. Now that we want to define a person flow, we go to the demand mode, which is the <kbd>F3</kbd> key. Then we go to the person mode, P, and then we define a person flow. So demand and person mode. And the hotkeys are always in the menu. So P would be the person mode. And now we select not only a single person, but rather a person flow. And we click on the origin edge. Let's use this one. And the destination edge, it's this one. And we define the kind of flow we want. Let's have it not evenly spaced, but with a Poisson distribution, which is this. And then I press "finish route creation", or hit the <kbd>enter</kbd> key. And here's the person flow. And of course, we can do the same thing in reverse order, and we'll have another person flow. So let's look at the file that was generated for this. And when we save this to a file, we have two person flows. This is how they look like. Now, let's look at the first pedestrian model. It's the default model, and it's called "striping model" because it divides the sidewalks and other spaces for walking in some stripes, and it has the person walking there in parallel. So this is the first SUMO configuration. And let's see them go. So you can see the persons are walking here in both directions. The coloring is according to the angle, but oh no, there's a big jam. And well, this does resolve itself at some time, but it's really a mess. So this, to put it bluntly, this model, it has problems if there are lots of persons in very small spaces. So it's good for pedestrian crossings and sidewalks, but maybe not so good if everybody wants to walk here across this path. What can we do? Maybe it doesn't make sense that everybody follows the same path. So maybe they should spread out over the parking lot. That would make more sense. So we can set an option in SUMO that lets the persons randomize their path over the parking lot. And let's see how that looks. So again, we have our persons walking, but to better appreciate where they walk, I'll make them bigger again. And now, as you can see, they're spreading out. And also, they're not jamming here in this area so quickly. So much better. Unfortunately, there's still so much traffic and they all have to be near these locations. Even if they can spread out in between, many have to pass this way. And so there's another jam after 25 minutes of simulation. Okay. But that's not the end of it. We can make the pedestrians a bit smarter here, and have them always reserve part of their ways for the incoming traffic, and so we can set this SUMO option for reserving a bit of space, and if we look at this, finally, there is no jam. So they're just a bit more cautious in making use of the space. So if you have a typical scenario with not so much pedestrian traffic, you don't need this option. But for scenarios like this, it's helpful to set it. Just be aware that it's still not a guarantee against any kind of jamming. So if you run this simulation multiple times with different random seeds, then the simulation will behave slightly different in each run. And some of these runs may see jam. Here we can see this finished without any jam. And the pedestrians, well, you saw them walk pretty straightforward. Let's have it one more time. Let's really look at the details, of how they're walking. So they're spreading over the space. They are avoiding each other. But one thing to note here is that they're always walking forward. They're never going backwards, even to avoid each other. They may move sideways, but never backwards. So let's look at another model. A new one. It's the JuPedSim model that was recently added to SUMO. And we can see this in the third configuration. To activate this model, we need to set this option: pedestrian model JuPedSim. And this is what it looks like. First of all, you notice that all the space that's fit for walking has an extra color just to make it more visible that there is JuPedSim are running here. But you can disable this in the person settings. "Show JuPedSim network", just disable the checkbox. And also, let's make the persons a bit bigger. So you see how they walk. So again, this is with them all having the same path. No randomization here. It looks pretty smooth. And they don't jam. What you may also notice is that it's running a bit slower. Because I'm not setting any delay here. But it's still easy to follow them. Let's discuss the speed, actually. So first of all, the speed depends on the total network size. At least for the current version of JuPedSim. So it's better to not have the large network here. But rather cut out the smaller part. We recently learned one of the reasons for the slowdown. So it may go away in the future. But here we still have an advantage of having only a small network. Just as big as is needed. And even then, whereas the Striping model runs at about 6000 times real time, this model here is running at 10 times real time. So. Yeah. There is a difference, a factor of 600 between the two models. Unfortunately, there's another disadvantage to the model. And this is that it's not yet interacting with cars or traffic lights. So it's for pure pedestrian simulation. Suitable at the moment. But we are planning to change this, to also add the interaction. And now for the last bit, for a bit of fun, if we also do the route randomization, so we spread out the persons over the whole parking lot, then, we can see some more interesting interactions. At a corner here. So forwarding to an interesting situation. At 10 minutes, wait for it, and now if you look closely, we can see that the persons are really interacting with each other, they are sometimes walking backwards, they're doing a little dance. So you see it's really a different model in there. It's not the striping model anymore. Of course, they're evading each other. All right. Are we done with the models? Not yet. There's yet one more model at SUMO. It's called the non-interacting model. And so it's really, really fast, even ten times faster than striping. In this model, the pedestrians jump over junctions, and they don't interact with anything. Of course, it doesn't jam. So when would you want to do this? Well, mainly if you're interested in something like public transport and you want to have those different riding stages connected with some rough estimate of walking time. So if you're not interested in the walking itself but only all the other things a person is doing, then you can use the non-interacting model to speed things up. So that was it for pedestrian models.

## Flying taxis
Moving on to the next topic, flying taxis. So as we discussed before, the scenario has several obstructions caused by cutting of the network but also by there being a canal in the middle and a motorway. So many pedestrians have to walk or have to take long detours to reach their destination. Well, in such a situation with these long detours, we have an ideal test bedfloor for future mobility. So the flying taxis, which can just go over the obstacle and have fast and efficient routes to the destination. So I will take you through all the steps needed to have a simulation of flying taxis. Now, for the first step, there is a small complication that we have to take. Because at the moment, the taxis in SUMO, they really need to use the taxi vehicle class. They can't yet be aircraft. So the first thing we have to do is to remove the taxi permissions from all the roads because we want our taxis to fly. We don't want them driving on the roads. So first of all, we want a network where the taxis cannot drive. For this, there's a small Python script, it's called patchVClasses.py, and there's even a batch file in the tutorial folder, in the flying_taxi folder for you to run. It's the buildnet batch file. And the next thing we do is we use netedit to define takeoff and landing zones, in the network. So let's do this. Let's load the network. So I've picked a few spots, three in total. And this is how these landing zones look. They're basically disconnected edges that allow only taxi. So if you want to create such an edge, you can go to the create edge mode. And then you set the permissions. So in this case, first disallow everything. And then just allow the taxi. And then we can create an edge. And that's it. And maybe we want to change also the width of the edge. So the default width is, well, actually it's 3.2 meters. And here I set this to 6 meters. So we have now, let's make this more visible and let's find all the edges in the network that allow taxi, three edges in all, overall. And to make them stand out, we can use this visual scaling thing. And you can see here those are well distributed flying, landing and takeoff zones for our aerial taxis.

Next step. We have to define the stops. Well, we would like to call them air stop, but we don't have that in SUMO, so it's a bus stop, basically, for an air bus, a flying bus. So we place a bus stop on each of these edges. This can be done here in the additional mode -> bus stop -> click. And then we have to connect it to the pedestrian network by defining an access element. So we first click on the bus stop. And then on the sidewalk. And this is our access. And we do this for all the landing and takeoff edges. And then save the bus stops to a file. And now the third thing we want to do. There is no flying mode yet in SUMO. So we will create plane edges that connect each point, well, each landing and takeoff edge with each other of these edges. And there's also a Python script for that, too. To building a fully connected graph between particular edges. And this is another batch file in the folder. Actually, it's buildnet2. Which runs the build full graph, so it's buildnet2.bat. All right. This is the third step. For the fourth step, we define the taxis. Well, the flying taxis that run through the network. This is, again, the demand mode. And we define vehicles. Well, first of all, we define a new vehicle type. So we create a new type here. And we change the attribute. So let's have this be a taxi. But let's have it at least look like an aircraft. There. And maybe we want to better fit the width to that of an aircraft. See which values did I want. The length and width. Six meters. It's a small. All right. And now we have our taxi type. And we can create the vehicle of that type. And we place it here. Notice that all the edges that permit this taxi to drive are green and all the ones that don't permit it cyan. That's a conflict. Place this here, press enter and there we have it. And of course I can do this multiple times, if I want to have multiple aircraft in the network. So now, the fifth step. We want all the persons to be able to make use of the new taxi mode. So far they can only walk and use public transport. But taxi is something else because it doesn't run on the schedule. So we have to change the file that generates the traffic demand, the build batch file. And I've highlighted here all the changes that we do. In the attributes for the persons we add the mode taxi. And in the additional files that are being loaded, we add the bus stops, air stops, and we save to a file. And then we need to set two more options that define where people can enter and leave a taxi. And so we set this to the value of ptStops, which means all public transport stops like bus stops. And of course we need to also adapt the network name because when we patched the network, we gave it a new name. And then we can generate the new Pedestrian demand. Let's see how that looks like after running the batch file. And as we can see, there are some persons. Now that want to walk and then ride with a taxi. So let's have a look at the simulation. And best of all, make the Persons big. So you can see the first air taxi here. You can see persons, that are being picked up and flown to the destination. Weee! And they fly around. Well, are we happy? Not quite. Once the simulation finishes. First of all, we see that there's actually jamming. Look at this jam. But the most important thing we see is, that at the end of the simulation, there are lots of persons that aborted waiting for the taxi. Some stop. So. What is the reason for this? Let's discuss this. In the setting we now used, each taxi only transported one passenger, and there was just not enough transport capacity. This means many passengers had to abort their flight at the end of the simulation, had to abort their wait for a flight. So what can we do? We can allow ride pooling. So let's have at least four persons per taxi. And the way to do this is either by defining for individual persons a group, and everybody who's in the same group may share a taxi. But we can simply set a default group for all the persons. So they're all in the same group, and they can all do ride sharing. And if we do this, it runs much nicer. We have only 12 people that couldn't get on their flight. So it's a lot more efficient. But there is something else we can do. Because the default dispatch algorithm for the taxis, it tries to be very fair. It tries to service the persons in the order in which they arrived at the stop. So first come, first serve. And this may lead to wasteful flights. Because an airplane may take off empty to get to another person that came first. So we can change the dispatch algorithm to the one that's called greedy closest. And this is more efficient on the taxi resource, because it lets every taxi pick up the closest person. And if we do this, then almost everybody catches their flight. And on top of that, the service is so much more efficient, that the average waiting time for flight goes down by 3 minutes. So you can see there's a number of things you can do to have an efficient taxi service. We can also get this from the outputs. If the simulation writes trip info files, then we can use this tool that comes with SUMO, the attributeStats.py tool, which tells us how the travel times are distributed for the persons. And so we can see that not only is the average overall travel time going down, but also the maximum travel time goes down because all the persons that would have taken a long walk can now take a quick flight. And also we can get a little plot, there's another Python tool that comes with SUMO that makes these plots out of the output files, if you want to look at how it works there is a batch file in the tutorial folder, that calls this tool, and here we can see on the x-axis the travel time and on the y-axis the count. So how often did which travel time occur? And we see that the version without taxis had plenty of high travel times, whereas the one with the taxis has more of those medium-sized travel times. And this is the reason why the maximum and the mean values have improved with the flying taxi simulation. So in conclusion, flying taxis are great if you can get them. And I wish you a lot of fun and success with using SUMO tools to develop your simulations. Make sure to read the documentation before you ask any questions. But if you have questions or if you find any bugs, then report them at this address or open up an issue on GitHub. And talk to us. We're always looking for project partners. Thanks.

# Other conference tutorials

Take a look at our other conference tutorials, [here](index.md#sumo_user_conference_tutorials).