# 2023-08-14 Triage Log

A light week. Main thing to report is we got some improvements from telling LLVM
that the negation in `<*const T>::sub` cannot overflow.

Triage done by **@pnkfelix**.
Revision range: [443c3161..e8459109](https://perf.rust-lang.org/?start=443c3161dd04f4c1b656a626f9079921bee9c326&end=e8459109bbb440764c1c877032189a27b9e76c4e&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-1.6%, -0.4%] | 11    |
| Improvements ✅ <br /> (secondary) | -0.5% | [-1.6%, -0.3%] | 8     |
| All ❌✅ (primary)                 | -0.7% | [-1.6%, -0.4%] | 11    |


0 Regressions, 1 Improvements, 4 Mixed; 1 of them in rollups
49 artifact comparisons made in total

#### Regressions



#### Improvements

Tell LLVM that the negation in `<*const T>::sub` cannot overflow [#114720](https://github.com/rust-lang/rust/pull/114720) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a6f8aa5a092c5e46fcbdafe4c80b4e55ba0de41c&end=b08dd92552d663e3c877c8e5ce859e212205a09f&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.2%] | 9     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.5%, -0.3%] | 4     |
| All ❌✅ (primary)                 | -0.3% | [-0.3%, -0.2%] | 9     |


#### Mixed

Rollup of 7 pull requests [#114604](https://github.com/rust-lang/rust/pull/114604) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=443c3161dd04f4c1b656a626f9079921bee9c326&end=8e7fd551311d424e4e63fa45906a2a928fce96a7&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.4%  | [0.4%, 2.0%]   | 3     |
| Regressions ❌ <br /> (secondary)  | 1.2%  | [1.1%, 1.3%]   | 6     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-0.9%, -0.4%] | 2     |
| Improvements ✅ <br /> (secondary) | -1.0% | [-1.5%, -0.5%] | 2     |
| All ❌✅ (primary)                 | 0.5%  | [-0.9%, 2.0%]  | 5     |

* already marked as triaged due to follow-up PR #114648


Only resolve target type in `try_coerce` in new solver [#114648](https://github.com/rust-lang/rust/pull/114648) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=832db2fcee27ee1079608ac78f82b7c14394e89b&end=fd1698860086db56e047f38d74337cf24dac5f24&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.0%  | [1.0%, 1.0%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.7% | [-1.8%, -1.6%] | 2     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.8% | [-1.8%, 1.0%]  | 3     |

* This was specifically added to undo regressions flagged in PR #114604
* it did indeed undo the big changes: e.g. cranelift-codegen-0.82.1 had regressed by {2%, 1.7%}, and this improved it back by {-1.84%, -1.59%}
* likewise cargo-0.60.0 had improved by -0.93%, and this regressed it back by 0.99%. (I.e. we returned to prior status quo.)
* some other effects were not addressed by this PR, but they are all minor.
* marking as triaged.

Only check outlives goals on impl compared to trait [#109356](https://github.com/rust-lang/rust/pull/109356) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b08dd92552d663e3c877c8e5ce859e212205a09f&end=f1b854818db00bec14accbc9d1c72e6ebefe64db&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.4%, 0.4%]   | 2     |
| Improvements ✅ <br /> (primary)   | -0.9% | [-1.6%, -0.6%] | 6     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.9% | [-1.6%, -0.6%] | 6     |

* regression is solely to the opt and debug profiles externs secondary benchmark, by a small amount.
* marked as triaged

Respect `#[expect]` the same way `#[allow]` is with the `dead_code` lint [#114710](https://github.com/rust-lang/rust/pull/114710) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f1b854818db00bec14accbc9d1c72e6ebefe64db&end=1e836d12d39ea09b1d86ebda70cb11b41564cead&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.3%, 0.7%]   | 2     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.6% | [-0.8%, -0.5%] | 3     |
| All ❌✅ (primary)                 | 0.5%  | [0.3%, 0.7%]   | 2     |

* seems like noise
* marked as triaged

#### Untriaged Pull Requests

- [#114710 Respect `#[expect]` the same way `#[allow]` is with the `dead_code` lint](https://github.com/rust-lang/rust/pull/114710)
- [#114648 Only resolve target type in `try_coerce` in new solver](https://github.com/rust-lang/rust/pull/114648)
- [#114481 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/114481)
- [#114459 Do not run ConstProp on mir_for_ctfe.](https://github.com/rust-lang/rust/pull/114459)
- [#114321 get auto traits for parallel rustc](https://github.com/rust-lang/rust/pull/114321)
- [#114004 Add `riscv64gc-unknown-hermit` target](https://github.com/rust-lang/rust/pull/114004)
- [#113858 Always const-prop scalars and scalar pairs](https://github.com/rust-lang/rust/pull/113858)
- [#113758 Turn copy into moves during DSE.](https://github.com/rust-lang/rust/pull/113758)
- [#113485 Bump version to 1.73](https://github.com/rust-lang/rust/pull/113485)
- [#113370 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/113370)
- [#113320 Add some extra information to opaque type cycle errors](https://github.com/rust-lang/rust/pull/113320)
- [#113306 Update debuginfo test runner to provide more useful output](https://github.com/rust-lang/rust/pull/113306)
- [#113304 Upgrade to indexmap 2.0.0](https://github.com/rust-lang/rust/pull/113304)
- [#113270 perform TokenStream replacement in-place when possible in expand_macro](https://github.com/rust-lang/rust/pull/113270)
- [#113057 Rollup of 2 pull requests](https://github.com/rust-lang/rust/pull/113057)
- [#112963 Stop bubbling out hidden types from the eval obligation queries](https://github.com/rust-lang/rust/pull/112963)
- [#112882 Rewrite `UnDerefer`](https://github.com/rust-lang/rust/pull/112882)
- [#112420 Rollup of 4 pull requests](https://github.com/rust-lang/rust/pull/112420)
- [#112157 Resurrect: rustc_target: Add alignment to indirectly-passed by-value types, correcting the alignment of byval on x86 in the process.](https://github.com/rust-lang/rust/pull/112157)
- [#112083 Make `TrustedStep` require `Copy`](https://github.com/rust-lang/rust/pull/112083)
- [#112016 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/112016)
- [#112001 Enable MatchBranchSimplification](https://github.com/rust-lang/rust/pull/112001)
- [#111869 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/111869)
- [#111850 Specialize `StepBy<Range<{integer}>>`](https://github.com/rust-lang/rust/pull/111850)
- [#111813 MIR: opt-in normalization of `BasicBlock` and `Local` numbering](https://github.com/rust-lang/rust/pull/111813)
- [#111753 Only consider places with the same local in each_borrow_involving_path.](https://github.com/rust-lang/rust/pull/111753)
- [#111623 move `super_relate_consts` hack to `normalize_param_env_or_error`](https://github.com/rust-lang/rust/pull/111623)
- [#111524 `ascii::Char`-ify the escaping code in `core`](https://github.com/rust-lang/rust/pull/111524)
- [#111425 Populate effective visibilities in `rustc_privacy` (take 2)](https://github.com/rust-lang/rust/pull/111425)
- [#111364 Remove the ThinLTO CU hack](https://github.com/rust-lang/rust/pull/111364)
