// re2zig $INPUT -o $OUTPUT --header lexer/state.zig

const std = @import("std");
const state = @import("lexer/state.zig"); // the module is generated by re2c

%{header:on %}
pub const State = struct {
    yyinput: [:0]const u8,
    yycursor: usize,
    %{stags format = "@@: usize,"; %}
};
%{header:off %}

fn lex(yyrecord: *state.State) usize {
    var t: usize = 0;
    %{
        re2c:header = "lexer/state.zig";
        re2c:api = record;
        re2c:yyfill:enable = 0;
        re2c:tags = 1;

        [a]* @t [b]* { return t; }
    %}
}

test {
    var st = state.State {
        .yyinput = "ab",
        .yycursor = 0,
        %{stags format = ".@@ = 0,"; %}
    };
    try std.testing.expectEqual(lex(&st), 1);
}
