% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{set_vertex_attrs}
\alias{set_vertex_attrs}
\title{Set multiple vertex attributes}
\usage{
set_vertex_attrs(graph, ..., index = V(graph))
}
\arguments{
\item{graph}{The graph.}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> Named arguments, where the names are the attributes}

\item{index}{An optional vertex sequence to set the attributes
of a subset of vertices.}
}
\value{
The graph, with the vertex attributes added or set.
}
\description{
Set multiple vertex attributes
}
\examples{
g <- make_ring(10)
set_vertex_attrs(g, color = "blue", size = 10, name = LETTERS[1:10])
# use splicing if suplying a list
x <- list(color = "red", name = LETTERS[1:10])
set_vertex_attrs(g, !!!x)
# to set an attribute named "index" use `:=`
set_vertex_attrs(g, color = "blue", index := 10, name = LETTERS[1:10])
}
\seealso{
Vertex, edge and graph attributes
\code{\link{delete_edge_attr}()},
\code{\link{delete_graph_attr}()},
\code{\link{delete_vertex_attr}()},
\code{\link{edge_attr}()},
\code{\link{edge_attr<-}()},
\code{\link{edge_attr_names}()},
\code{\link{graph_attr}()},
\code{\link{graph_attr<-}()},
\code{\link{graph_attr_names}()},
\code{\link{igraph-attribute-combination}},
\code{\link{igraph-dollar}},
\code{\link{igraph-vs-attributes}},
\code{\link{set_edge_attr}()},
\code{\link{set_graph_attr}()},
\code{\link{set_vertex_attr}()},
\code{\link{vertex_attr}()},
\code{\link{vertex_attr<-}()},
\code{\link{vertex_attr_names}()}
}
\concept{attributes}
