/**********************************************************************************************
    Copyright (C) 2014 Oliver Eichler <oliver.eichler@gmx.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

**********************************************************************************************/

#include "helpers/CElevationDialog.h"

#include <QtWidgets>

#include "CMainWindow.h"
#include "gis/proj_x.h"
#include "units/IUnit.h"

CElevationDialog::CElevationDialog(QWidget* parent, QVariant& val, const QVariant& reset, const QPointF& pos)
    : QDialog(parent), val(val), reset(reset), pos(pos) {
  setupUi(this);

  QPushButton* pushReset = buttonBox->addButton(QDialogButtonBox::Reset);
  connect(pushReset, &QPushButton::clicked, this, &CElevationDialog::slotReset);
  connect(toolGetEle, &QToolButton::clicked, this, &CElevationDialog::slotGetEle);

  labelUnit->setText(IUnit::self().elevationUnit);
  if (val != NOINT) {
    QString unit;
    QString value;
    IUnit::self().meter2elevation(val.toDouble(), value, unit);
    lineValue->setText(value);
  }
}

CElevationDialog::~CElevationDialog() {}

void CElevationDialog::accept() {
  if (lineValue->text().isEmpty()) {
    val = reset;
  } else {
    val.setValue(lineValue->text().toDouble() / IUnit::self().elevationFactor);
  }

  QDialog::accept();
}

void CElevationDialog::slotReset() {
  if (reset == NOINT) {
    lineValue->clear();
  } else {
    QString str, unit;
    IUnit::self().meter2elevation(val.toDouble(), str, unit);
    lineValue->setText(str);
  }
}

void CElevationDialog::slotGetEle() {
  QVariant ele = CMainWindow::self().getElevationAt(pos * DEG_TO_RAD, false);
  if (ele != NOFLOAT) {
    QString str, unit;
    IUnit::self().meter2elevation(ele.toDouble(), str, unit);
    lineValue->setText(str);
  } else {
    labelMessage->setText(tr("No DEM data found for that point."));
  }
}
