# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.kubernetesconfiguration.fluxconfigurations import KubernetesConfigurationFluxConfigurationsMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestKubernetesConfigurationFluxConfigurationsMgmtFluxConfigurationsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(KubernetesConfigurationFluxConfigurationsMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_flux_configurations_get(self, resource_group):
        response = self.client.flux_configurations.get(
            resource_group_name=resource_group.name,
            cluster_rp="str",
            cluster_resource_name="str",
            cluster_name="str",
            flux_configuration_name="str",
            api_version="2025-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_flux_configurations_begin_create_or_update(self, resource_group):
        response = self.client.flux_configurations.begin_create_or_update(
            resource_group_name=resource_group.name,
            cluster_rp="str",
            cluster_resource_name="str",
            cluster_name="str",
            flux_configuration_name="str",
            flux_configuration={
                "azureBlob": {
                    "accountKey": "str",
                    "containerName": "str",
                    "localAuthRef": "str",
                    "managedIdentity": {"clientId": "str"},
                    "sasToken": "str",
                    "servicePrincipal": {
                        "clientCertificate": "str",
                        "clientCertificatePassword": "str",
                        "clientCertificateSendChain": False,
                        "clientId": "str",
                        "clientSecret": "str",
                        "tenantId": "str",
                    },
                    "syncIntervalInSeconds": 600,
                    "timeoutInSeconds": 600,
                    "url": "str",
                },
                "bucket": {
                    "accessKey": "str",
                    "bucketName": "str",
                    "insecure": True,
                    "localAuthRef": "str",
                    "syncIntervalInSeconds": 600,
                    "timeoutInSeconds": 600,
                    "url": "str",
                },
                "complianceState": "Unknown",
                "configurationProtectedSettings": {"str": "str"},
                "errorMessage": "str",
                "gitRepository": {
                    "httpsCACert": "str",
                    "httpsUser": "str",
                    "localAuthRef": "str",
                    "provider": "str",
                    "repositoryRef": {"branch": "str", "commit": "str", "semver": "str", "tag": "str"},
                    "sshKnownHosts": "str",
                    "syncIntervalInSeconds": 600,
                    "timeoutInSeconds": 600,
                    "url": "str",
                },
                "id": "str",
                "kustomizations": {
                    "str": {
                        "dependsOn": ["str"],
                        "force": False,
                        "name": "str",
                        "path": "",
                        "postBuild": {
                            "substitute": {"str": "str"},
                            "substituteFrom": [{"kind": "str", "name": "str", "optional": False}],
                        },
                        "prune": False,
                        "retryIntervalInSeconds": 0,
                        "syncIntervalInSeconds": 600,
                        "timeoutInSeconds": 600,
                        "wait": True,
                    }
                },
                "name": "str",
                "namespace": "default",
                "ociRepository": {
                    "insecure": False,
                    "layerSelector": {"mediaType": "str", "operation": "str"},
                    "localAuthRef": "str",
                    "repositoryRef": {"digest": "str", "semver": "str", "tag": "str"},
                    "serviceAccountName": "str",
                    "syncIntervalInSeconds": 600,
                    "timeoutInSeconds": 600,
                    "tlsConfig": {"caCertificate": "str", "clientCertificate": "str", "privateKey": "str"},
                    "url": "str",
                    "useWorkloadIdentity": False,
                    "verify": {
                        "matchOidcIdentity": [{"issuer": "str", "subject": "str"}],
                        "provider": "str",
                        "verificationConfig": {"str": "str"},
                    },
                },
                "provisioningState": "str",
                "reconciliationWaitDuration": "str",
                "repositoryPublicKey": "str",
                "scope": "cluster",
                "sourceKind": "str",
                "sourceSyncedCommitId": "str",
                "sourceUpdatedAt": "2020-02-20 00:00:00",
                "statusUpdatedAt": "2020-02-20 00:00:00",
                "statuses": [
                    {
                        "appliedBy": {"name": "str", "namespace": "str"},
                        "complianceState": "Unknown",
                        "helmReleaseProperties": {
                            "failureCount": 0,
                            "helmChartRef": {"name": "str", "namespace": "str"},
                            "installFailureCount": 0,
                            "lastRevisionApplied": 0,
                            "upgradeFailureCount": 0,
                        },
                        "kind": "str",
                        "name": "str",
                        "namespace": "str",
                        "statusConditions": [
                            {
                                "lastTransitionTime": "2020-02-20 00:00:00",
                                "message": "str",
                                "reason": "str",
                                "status": "str",
                                "type": "str",
                            }
                        ],
                    }
                ],
                "suspend": False,
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
                "waitForReconciliation": bool,
            },
            api_version="2025-04-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_flux_configurations_begin_update(self, resource_group):
        response = self.client.flux_configurations.begin_update(
            resource_group_name=resource_group.name,
            cluster_rp="str",
            cluster_resource_name="str",
            cluster_name="str",
            flux_configuration_name="str",
            flux_configuration_patch={
                "azureBlob": {
                    "accountKey": "str",
                    "containerName": "str",
                    "localAuthRef": "str",
                    "managedIdentity": {"clientId": "str"},
                    "sasToken": "str",
                    "servicePrincipal": {
                        "clientCertificate": "str",
                        "clientCertificatePassword": "str",
                        "clientCertificateSendChain": bool,
                        "clientId": "str",
                        "clientSecret": "str",
                        "tenantId": "str",
                    },
                    "syncIntervalInSeconds": 0,
                    "timeoutInSeconds": 0,
                    "url": "str",
                },
                "bucket": {
                    "accessKey": "str",
                    "bucketName": "str",
                    "insecure": bool,
                    "localAuthRef": "str",
                    "syncIntervalInSeconds": 0,
                    "timeoutInSeconds": 0,
                    "url": "str",
                },
                "configurationProtectedSettings": {"str": "str"},
                "gitRepository": {
                    "httpsCACert": "str",
                    "httpsUser": "str",
                    "localAuthRef": "str",
                    "provider": "str",
                    "repositoryRef": {"branch": "str", "commit": "str", "semver": "str", "tag": "str"},
                    "sshKnownHosts": "str",
                    "syncIntervalInSeconds": 0,
                    "timeoutInSeconds": 0,
                    "url": "str",
                },
                "kustomizations": {
                    "str": {
                        "dependsOn": ["str"],
                        "force": bool,
                        "path": "str",
                        "postBuild": {
                            "substitute": {"str": "str"},
                            "substituteFrom": [{"kind": "str", "name": "str", "optional": False}],
                        },
                        "prune": bool,
                        "retryIntervalInSeconds": 0,
                        "syncIntervalInSeconds": 0,
                        "timeoutInSeconds": 0,
                        "wait": bool,
                    }
                },
                "ociRepository": {
                    "insecure": False,
                    "layerSelector": {"mediaType": "str", "operation": "str"},
                    "localAuthRef": "str",
                    "repositoryRef": {"digest": "str", "semver": "str", "tag": "str"},
                    "serviceAccountName": "str",
                    "syncIntervalInSeconds": 0,
                    "timeoutInSeconds": 0,
                    "tlsConfig": {"caCertificate": "str", "clientCertificate": "str", "privateKey": "str"},
                    "url": "str",
                    "useWorkloadIdentity": False,
                    "verify": {
                        "matchOidcIdentity": [{"issuer": "str", "subject": "str"}],
                        "provider": "str",
                        "verificationConfig": {"str": "str"},
                    },
                },
                "sourceKind": "str",
                "suspend": bool,
            },
            api_version="2025-04-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_flux_configurations_begin_delete(self, resource_group):
        response = self.client.flux_configurations.begin_delete(
            resource_group_name=resource_group.name,
            cluster_rp="str",
            cluster_resource_name="str",
            cluster_name="str",
            flux_configuration_name="str",
            api_version="2025-04-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_flux_configurations_list(self, resource_group):
        response = self.client.flux_configurations.list(
            resource_group_name=resource_group.name,
            cluster_rp="str",
            cluster_resource_name="str",
            cluster_name="str",
            api_version="2025-04-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
