// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package accounts

import (
	"context"
	"fmt"
	"io"
	"math"
	"net/http"
	"net/url"
	"time"

	accountspb "cloud.google.com/go/shopping/merchant/accounts/apiv1beta/accountspb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/googleapi"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/protobuf/encoding/protojson"
)

var newTermsOfServiceClientHook clientHook

// TermsOfServiceCallOptions contains the retry settings for each method of TermsOfServiceClient.
type TermsOfServiceCallOptions struct {
	GetTermsOfService            []gax.CallOption
	RetrieveLatestTermsOfService []gax.CallOption
	AcceptTermsOfService         []gax.CallOption
}

func defaultTermsOfServiceGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("merchantapi.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("merchantapi.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("merchantapi.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://merchantapi.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultTermsOfServiceCallOptions() *TermsOfServiceCallOptions {
	return &TermsOfServiceCallOptions{
		GetTermsOfService: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		RetrieveLatestTermsOfService: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		AcceptTermsOfService: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
	}
}

func defaultTermsOfServiceRESTCallOptions() *TermsOfServiceCallOptions {
	return &TermsOfServiceCallOptions{
		GetTermsOfService: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		RetrieveLatestTermsOfService: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		AcceptTermsOfService: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
	}
}

// internalTermsOfServiceClient is an interface that defines the methods available from Merchant API.
type internalTermsOfServiceClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	GetTermsOfService(context.Context, *accountspb.GetTermsOfServiceRequest, ...gax.CallOption) (*accountspb.TermsOfService, error)
	RetrieveLatestTermsOfService(context.Context, *accountspb.RetrieveLatestTermsOfServiceRequest, ...gax.CallOption) (*accountspb.TermsOfService, error)
	AcceptTermsOfService(context.Context, *accountspb.AcceptTermsOfServiceRequest, ...gax.CallOption) error
}

// TermsOfServiceClient is a client for interacting with Merchant API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// Service to support TermsOfService API.
type TermsOfServiceClient struct {
	// The internal transport-dependent client.
	internalClient internalTermsOfServiceClient

	// The call options for this service.
	CallOptions *TermsOfServiceCallOptions
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *TermsOfServiceClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *TermsOfServiceClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *TermsOfServiceClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// GetTermsOfService retrieves the TermsOfService associated with the provided version.
func (c *TermsOfServiceClient) GetTermsOfService(ctx context.Context, req *accountspb.GetTermsOfServiceRequest, opts ...gax.CallOption) (*accountspb.TermsOfService, error) {
	return c.internalClient.GetTermsOfService(ctx, req, opts...)
}

// RetrieveLatestTermsOfService retrieves the latest version of the TermsOfService for a given kind and
// region_code.
func (c *TermsOfServiceClient) RetrieveLatestTermsOfService(ctx context.Context, req *accountspb.RetrieveLatestTermsOfServiceRequest, opts ...gax.CallOption) (*accountspb.TermsOfService, error) {
	return c.internalClient.RetrieveLatestTermsOfService(ctx, req, opts...)
}

// AcceptTermsOfService accepts a TermsOfService. Executing this method requires admin access.
func (c *TermsOfServiceClient) AcceptTermsOfService(ctx context.Context, req *accountspb.AcceptTermsOfServiceRequest, opts ...gax.CallOption) error {
	return c.internalClient.AcceptTermsOfService(ctx, req, opts...)
}

// termsOfServiceGRPCClient is a client for interacting with Merchant API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type termsOfServiceGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing TermsOfServiceClient
	CallOptions **TermsOfServiceCallOptions

	// The gRPC API client.
	termsOfServiceClient accountspb.TermsOfServiceServiceClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string
}

// NewTermsOfServiceClient creates a new terms of service service client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// Service to support TermsOfService API.
func NewTermsOfServiceClient(ctx context.Context, opts ...option.ClientOption) (*TermsOfServiceClient, error) {
	clientOpts := defaultTermsOfServiceGRPCClientOptions()
	if newTermsOfServiceClientHook != nil {
		hookOpts, err := newTermsOfServiceClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := TermsOfServiceClient{CallOptions: defaultTermsOfServiceCallOptions()}

	c := &termsOfServiceGRPCClient{
		connPool:             connPool,
		termsOfServiceClient: accountspb.NewTermsOfServiceServiceClient(connPool),
		CallOptions:          &client.CallOptions,
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *termsOfServiceGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *termsOfServiceGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *termsOfServiceGRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type termsOfServiceRESTClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// The x-goog-* headers to be sent with each request.
	xGoogHeaders []string

	// Points back to the CallOptions field of the containing TermsOfServiceClient
	CallOptions **TermsOfServiceCallOptions
}

// NewTermsOfServiceRESTClient creates a new terms of service service rest client.
//
// Service to support TermsOfService API.
func NewTermsOfServiceRESTClient(ctx context.Context, opts ...option.ClientOption) (*TermsOfServiceClient, error) {
	clientOpts := append(defaultTermsOfServiceRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultTermsOfServiceRESTCallOptions()
	c := &termsOfServiceRESTClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
	}
	c.setGoogleClientInfo()

	return &TermsOfServiceClient{internalClient: c, CallOptions: callOpts}, nil
}

func defaultTermsOfServiceRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://merchantapi.googleapis.com"),
		internaloption.WithDefaultEndpointTemplate("https://merchantapi.UNIVERSE_DOMAIN"),
		internaloption.WithDefaultMTLSEndpoint("https://merchantapi.mtls.googleapis.com"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://merchantapi.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *termsOfServiceRESTClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN")
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *termsOfServiceRESTClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *termsOfServiceRESTClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *termsOfServiceGRPCClient) GetTermsOfService(ctx context.Context, req *accountspb.GetTermsOfServiceRequest, opts ...gax.CallOption) (*accountspb.TermsOfService, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetTermsOfService[0:len((*c.CallOptions).GetTermsOfService):len((*c.CallOptions).GetTermsOfService)], opts...)
	var resp *accountspb.TermsOfService
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.termsOfServiceClient.GetTermsOfService(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *termsOfServiceGRPCClient) RetrieveLatestTermsOfService(ctx context.Context, req *accountspb.RetrieveLatestTermsOfServiceRequest, opts ...gax.CallOption) (*accountspb.TermsOfService, error) {
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, c.xGoogHeaders...)
	opts = append((*c.CallOptions).RetrieveLatestTermsOfService[0:len((*c.CallOptions).RetrieveLatestTermsOfService):len((*c.CallOptions).RetrieveLatestTermsOfService)], opts...)
	var resp *accountspb.TermsOfService
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.termsOfServiceClient.RetrieveLatestTermsOfService(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *termsOfServiceGRPCClient) AcceptTermsOfService(ctx context.Context, req *accountspb.AcceptTermsOfServiceRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).AcceptTermsOfService[0:len((*c.CallOptions).AcceptTermsOfService):len((*c.CallOptions).AcceptTermsOfService)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.termsOfServiceClient.AcceptTermsOfService(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

// GetTermsOfService retrieves the TermsOfService associated with the provided version.
func (c *termsOfServiceRESTClient) GetTermsOfService(ctx context.Context, req *accountspb.GetTermsOfServiceRequest, opts ...gax.CallOption) (*accountspb.TermsOfService, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/accounts/v1beta/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetTermsOfService[0:len((*c.CallOptions).GetTermsOfService):len((*c.CallOptions).GetTermsOfService)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &accountspb.TermsOfService{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// RetrieveLatestTermsOfService retrieves the latest version of the TermsOfService for a given kind and
// region_code.
func (c *termsOfServiceRESTClient) RetrieveLatestTermsOfService(ctx context.Context, req *accountspb.RetrieveLatestTermsOfServiceRequest, opts ...gax.CallOption) (*accountspb.TermsOfService, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/accounts/v1beta/termsOfService:retrieveLatest")

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetKind() != 0 {
		params.Add("kind", fmt.Sprintf("%v", req.GetKind()))
	}
	if req.GetRegionCode() != "" {
		params.Add("regionCode", fmt.Sprintf("%v", req.GetRegionCode()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := append(c.xGoogHeaders, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).RetrieveLatestTermsOfService[0:len((*c.CallOptions).RetrieveLatestTermsOfService):len((*c.CallOptions).RetrieveLatestTermsOfService)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &accountspb.TermsOfService{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// AcceptTermsOfService accepts a TermsOfService. Executing this method requires admin access.
func (c *termsOfServiceRESTClient) AcceptTermsOfService(ctx context.Context, req *accountspb.AcceptTermsOfServiceRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/accounts/v1beta/%v:accept", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("account", fmt.Sprintf("%v", req.GetAccount()))
	params.Add("regionCode", fmt.Sprintf("%v", req.GetRegionCode()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		// Returns nil if there is no error, otherwise wraps
		// the response code and body into a non-nil error
		return googleapi.CheckResponse(httpRsp)
	}, opts...)
}
