//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armvirtualmachineimagebuilder_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/virtualmachineimagebuilder/armvirtualmachineimagebuilder/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/imagebuilder/resource-manager/Microsoft.VirtualMachineImages/stable/2022-07-01/examples/ListImageTemplates.json
func ExampleVirtualMachineImageTemplatesClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armvirtualmachineimagebuilder.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewVirtualMachineImageTemplatesClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ImageTemplateListResult = armvirtualmachineimagebuilder.ImageTemplateListResult{
		// 	Value: []*armvirtualmachineimagebuilder.ImageTemplate{
		// 		{
		// 			Name: to.Ptr("myImageTemplate"),
		// 			Type: to.Ptr("Microsoft.VirtualMachineImages/imageTemplates"),
		// 			ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.VirtualMachineImages/imageTemplates/myImageTemplate"),
		// 			Location: to.Ptr("westus"),
		// 			Identity: &armvirtualmachineimagebuilder.ImageTemplateIdentity{
		// 				Type: to.Ptr(armvirtualmachineimagebuilder.ResourceIdentityTypeUserAssigned),
		// 				UserAssignedIdentities: map[string]*armvirtualmachineimagebuilder.UserAssignedIdentity{
		// 					"/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity_1": &armvirtualmachineimagebuilder.UserAssignedIdentity{
		// 						ClientID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 						PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 					},
		// 				},
		// 			},
		// 			Properties: &armvirtualmachineimagebuilder.ImageTemplateProperties{
		// 				Customize: []armvirtualmachineimagebuilder.ImageTemplateCustomizerClassification{
		// 					&armvirtualmachineimagebuilder.ImageTemplateShellCustomizer{
		// 						Name: to.Ptr("Shell customization example"),
		// 						Type: to.Ptr("Shell"),
		// 						ScriptURI: to.Ptr("https://example.com/path/to/script.sh"),
		// 				}},
		// 				Distribute: []armvirtualmachineimagebuilder.ImageTemplateDistributorClassification{
		// 					&armvirtualmachineimagebuilder.ImageTemplateManagedImageDistributor{
		// 						Type: to.Ptr("ManagedImage"),
		// 						ArtifactTags: map[string]*string{
		// 							"tagName": to.Ptr("value"),
		// 						},
		// 						RunOutputName: to.Ptr("image_it_pir_1"),
		// 						ImageID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/rg1/providers/Microsoft.Compute/images/image_it_1"),
		// 						Location: to.Ptr("1_location"),
		// 				}},
		// 				Source: &armvirtualmachineimagebuilder.ImageTemplateManagedImageSource{
		// 					Type: to.Ptr("ManagedImage"),
		// 					ImageID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/source_rg/providers/Microsoft.Compute/images/source_image"),
		// 				},
		// 				VMProfile: &armvirtualmachineimagebuilder.ImageTemplateVMProfile{
		// 					OSDiskSizeGB: to.Ptr[int32](64),
		// 					VMSize: to.Ptr("Standard_D2s_v3"),
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySecondImageTemplate"),
		// 			Type: to.Ptr("Microsoft.VirtualMachineImages/imageTemplates"),
		// 			ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/myOtherResourceGroup/providers/Microsoft.VirtualMachineImages/imageTemplates/mySecondImageTemplate"),
		// 			Location: to.Ptr("westus"),
		// 			Identity: &armvirtualmachineimagebuilder.ImageTemplateIdentity{
		// 				Type: to.Ptr(armvirtualmachineimagebuilder.ResourceIdentityTypeUserAssigned),
		// 				UserAssignedIdentities: map[string]*armvirtualmachineimagebuilder.UserAssignedIdentity{
		// 					"/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity_1": &armvirtualmachineimagebuilder.UserAssignedIdentity{
		// 						ClientID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 						PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 					},
		// 				},
		// 			},
		// 			Properties: &armvirtualmachineimagebuilder.ImageTemplateProperties{
		// 				Customize: []armvirtualmachineimagebuilder.ImageTemplateCustomizerClassification{
		// 					&armvirtualmachineimagebuilder.ImageTemplateShellCustomizer{
		// 						Name: to.Ptr("Shell customization example"),
		// 						Type: to.Ptr("Shell"),
		// 						ScriptURI: to.Ptr("https://example.com/path/to/script.sh"),
		// 				}},
		// 				Distribute: []armvirtualmachineimagebuilder.ImageTemplateDistributorClassification{
		// 					&armvirtualmachineimagebuilder.ImageTemplateManagedImageDistributor{
		// 						Type: to.Ptr("ManagedImage"),
		// 						ArtifactTags: map[string]*string{
		// 							"stage": to.Ptr("development"),
		// 						},
		// 						RunOutputName: to.Ptr("eus"),
		// 						ImageID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/rg1/providers/Microsoft.Compute/images/mySecondImage-eus"),
		// 						Location: to.Ptr("eastus"),
		// 				}},
		// 				Source: &armvirtualmachineimagebuilder.ImageTemplatePlatformImageSource{
		// 					Type: to.Ptr("PlatformImage"),
		// 					Offer: to.Ptr("UbuntuServer"),
		// 					PlanInfo: &armvirtualmachineimagebuilder.PlatformImagePurchasePlan{
		// 						PlanName: to.Ptr("example_plan_name"),
		// 						PlanProduct: to.Ptr("example_plan_product"),
		// 						PlanPublisher: to.Ptr("example_plan_publisher"),
		// 					},
		// 					Publisher: to.Ptr("Canonical"),
		// 					SKU: to.Ptr("18.04-LTS"),
		// 					Version: to.Ptr("18.04.201902121"),
		// 				},
		// 				VMProfile: &armvirtualmachineimagebuilder.ImageTemplateVMProfile{
		// 					OSDiskSizeGB: to.Ptr[int32](32),
		// 					VMSize: to.Ptr("Standard_D8s_v3"),
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/imagebuilder/resource-manager/Microsoft.VirtualMachineImages/stable/2022-07-01/examples/ListImageTemplatesByRg.json
func ExampleVirtualMachineImageTemplatesClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armvirtualmachineimagebuilder.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewVirtualMachineImageTemplatesClient().NewListByResourceGroupPager("myResourceGroup", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ImageTemplateListResult = armvirtualmachineimagebuilder.ImageTemplateListResult{
		// 	Value: []*armvirtualmachineimagebuilder.ImageTemplate{
		// 		{
		// 			Name: to.Ptr("myImageTemplate"),
		// 			Type: to.Ptr("Microsoft.VirtualMachineImages/imageTemplates"),
		// 			ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.VirtualMachineImages/imageTemplates/myImageTemplate"),
		// 			Location: to.Ptr("westus"),
		// 			Identity: &armvirtualmachineimagebuilder.ImageTemplateIdentity{
		// 				Type: to.Ptr(armvirtualmachineimagebuilder.ResourceIdentityTypeUserAssigned),
		// 				UserAssignedIdentities: map[string]*armvirtualmachineimagebuilder.UserAssignedIdentity{
		// 					"/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity_1": &armvirtualmachineimagebuilder.UserAssignedIdentity{
		// 						ClientID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 						PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 					},
		// 				},
		// 			},
		// 			Properties: &armvirtualmachineimagebuilder.ImageTemplateProperties{
		// 				Customize: []armvirtualmachineimagebuilder.ImageTemplateCustomizerClassification{
		// 					&armvirtualmachineimagebuilder.ImageTemplateShellCustomizer{
		// 						Name: to.Ptr("Shell customization example"),
		// 						Type: to.Ptr("Shell"),
		// 						ScriptURI: to.Ptr("https://example.com/path/to/script.sh"),
		// 				}},
		// 				Distribute: []armvirtualmachineimagebuilder.ImageTemplateDistributorClassification{
		// 					&armvirtualmachineimagebuilder.ImageTemplateManagedImageDistributor{
		// 						Type: to.Ptr("ManagedImage"),
		// 						ArtifactTags: map[string]*string{
		// 							"tagName": to.Ptr("value"),
		// 						},
		// 						RunOutputName: to.Ptr("image_it_pir_1"),
		// 						ImageID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/rg1/providers/Microsoft.Compute/images/image_it_1"),
		// 						Location: to.Ptr("1_location"),
		// 				}},
		// 				Source: &armvirtualmachineimagebuilder.ImageTemplateManagedImageSource{
		// 					Type: to.Ptr("ManagedImage"),
		// 					ImageID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/source_rg/providers/Microsoft.Compute/images/source_image"),
		// 				},
		// 				VMProfile: &armvirtualmachineimagebuilder.ImageTemplateVMProfile{
		// 					OSDiskSizeGB: to.Ptr[int32](64),
		// 					VMSize: to.Ptr("Standard_D2s_v3"),
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myOtherImageTemplate"),
		// 			Type: to.Ptr("Microsoft.VirtualMachineImages/imageTemplates"),
		// 			ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.VirtualMachineImages/imageTemplates/myOtherImageTemplate"),
		// 			Location: to.Ptr("eastus"),
		// 			Identity: &armvirtualmachineimagebuilder.ImageTemplateIdentity{
		// 				Type: to.Ptr(armvirtualmachineimagebuilder.ResourceIdentityTypeUserAssigned),
		// 				UserAssignedIdentities: map[string]*armvirtualmachineimagebuilder.UserAssignedIdentity{
		// 					"/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity_1": &armvirtualmachineimagebuilder.UserAssignedIdentity{
		// 						ClientID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 						PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 					},
		// 				},
		// 			},
		// 			Properties: &armvirtualmachineimagebuilder.ImageTemplateProperties{
		// 				Customize: []armvirtualmachineimagebuilder.ImageTemplateCustomizerClassification{
		// 					&armvirtualmachineimagebuilder.ImageTemplateShellCustomizer{
		// 						Name: to.Ptr("Shell customization example"),
		// 						Type: to.Ptr("Shell"),
		// 						ScriptURI: to.Ptr("https://example.com/path/to/script.sh"),
		// 				}},
		// 				Distribute: []armvirtualmachineimagebuilder.ImageTemplateDistributorClassification{
		// 					&armvirtualmachineimagebuilder.ImageTemplateManagedImageDistributor{
		// 						Type: to.Ptr("ManagedImage"),
		// 						RunOutputName: to.Ptr("singleImage"),
		// 						ImageID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/rg1/providers/Microsoft.Compute/images/baseimage-cus"),
		// 						Location: to.Ptr("centralus"),
		// 					},
		// 					&armvirtualmachineimagebuilder.ImageTemplateSharedImageDistributor{
		// 						Type: to.Ptr("SharedImage"),
		// 						RunOutputName: to.Ptr("gallery"),
		// 						ExcludeFromLatest: to.Ptr(true),
		// 						GalleryImageID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/rg1/providers/Microsoft.Compute/gallery/baseimages/images/baseimage"),
		// 						ReplicationRegions: []*string{
		// 							to.Ptr("eastus"),
		// 							to.Ptr("westus")},
		// 							StorageAccountType: to.Ptr(armvirtualmachineimagebuilder.SharedImageStorageAccountTypeStandardLRS),
		// 					}},
		// 					Source: &armvirtualmachineimagebuilder.ImageTemplatePlatformImageSource{
		// 						Type: to.Ptr("PlatformImage"),
		// 						Offer: to.Ptr("UbuntuServer"),
		// 						PlanInfo: &armvirtualmachineimagebuilder.PlatformImagePurchasePlan{
		// 							PlanName: to.Ptr("example_plan_name"),
		// 							PlanProduct: to.Ptr("example_plan_product"),
		// 							PlanPublisher: to.Ptr("example_plan_publisher"),
		// 						},
		// 						Publisher: to.Ptr("Canonical"),
		// 						SKU: to.Ptr("18.04-LTS"),
		// 						Version: to.Ptr("18.04.201902121"),
		// 					},
		// 					VMProfile: &armvirtualmachineimagebuilder.ImageTemplateVMProfile{
		// 						OSDiskSizeGB: to.Ptr[int32](64),
		// 						VMSize: to.Ptr("Standard_D8s_v3"),
		// 					},
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/imagebuilder/resource-manager/Microsoft.VirtualMachineImages/stable/2022-07-01/examples/CreateImageTemplateLinux.json
func ExampleVirtualMachineImageTemplatesClient_BeginCreateOrUpdate_createAnImageTemplateForLinux() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armvirtualmachineimagebuilder.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualMachineImageTemplatesClient().BeginCreateOrUpdate(ctx, "myResourceGroup", "myImageTemplate", armvirtualmachineimagebuilder.ImageTemplate{
		Location: to.Ptr("westus"),
		Tags: map[string]*string{
			"imagetemplate_tag1": to.Ptr("IT_T1"),
			"imagetemplate_tag2": to.Ptr("IT_T2"),
		},
		Identity: &armvirtualmachineimagebuilder.ImageTemplateIdentity{
			Type: to.Ptr(armvirtualmachineimagebuilder.ResourceIdentityTypeUserAssigned),
			UserAssignedIdentities: map[string]*armvirtualmachineimagebuilder.UserAssignedIdentity{
				"/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity_1": {},
			},
		},
		Properties: &armvirtualmachineimagebuilder.ImageTemplateProperties{
			Customize: []armvirtualmachineimagebuilder.ImageTemplateCustomizerClassification{
				&armvirtualmachineimagebuilder.ImageTemplateShellCustomizer{
					Name:      to.Ptr("Shell Customizer Example"),
					Type:      to.Ptr("Shell"),
					ScriptURI: to.Ptr("https://example.com/path/to/script.sh"),
				}},
			Distribute: []armvirtualmachineimagebuilder.ImageTemplateDistributorClassification{
				&armvirtualmachineimagebuilder.ImageTemplateManagedImageDistributor{
					Type: to.Ptr("ManagedImage"),
					ArtifactTags: map[string]*string{
						"tagName": to.Ptr("value"),
					},
					RunOutputName: to.Ptr("image_it_pir_1"),
					ImageID:       to.Ptr("/subscriptions/{subscription-id}/resourceGroups/rg1/providers/Microsoft.Compute/images/image_it_1"),
					Location:      to.Ptr("1_location"),
				}},
			Source: &armvirtualmachineimagebuilder.ImageTemplateManagedImageSource{
				Type:    to.Ptr("ManagedImage"),
				ImageID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/images/source_image"),
			},
			VMProfile: &armvirtualmachineimagebuilder.ImageTemplateVMProfile{
				OSDiskSizeGB: to.Ptr[int32](64),
				VMSize:       to.Ptr("Standard_D2s_v3"),
				VnetConfig: &armvirtualmachineimagebuilder.VirtualNetworkConfig{
					SubnetID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet_name/subnets/subnet_name"),
				},
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ImageTemplate = armvirtualmachineimagebuilder.ImageTemplate{
	// 	Name: to.Ptr("myImageTemplate"),
	// 	Type: to.Ptr("Microsoft.VirtualMachineImages/imageTemplates"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.VirtualMachineImages/imageTemplates/myImageTemplate"),
	// 	Location: to.Ptr("westus"),
	// 	Identity: &armvirtualmachineimagebuilder.ImageTemplateIdentity{
	// 		Type: to.Ptr(armvirtualmachineimagebuilder.ResourceIdentityTypeUserAssigned),
	// 		UserAssignedIdentities: map[string]*armvirtualmachineimagebuilder.UserAssignedIdentity{
	// 			"/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity_1": &armvirtualmachineimagebuilder.UserAssignedIdentity{
	// 				ClientID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 				PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 			},
	// 		},
	// 	},
	// 	Properties: &armvirtualmachineimagebuilder.ImageTemplateProperties{
	// 		Customize: []armvirtualmachineimagebuilder.ImageTemplateCustomizerClassification{
	// 			&armvirtualmachineimagebuilder.ImageTemplateShellCustomizer{
	// 				Name: to.Ptr("Shell Customizer Example"),
	// 				Type: to.Ptr("Shell"),
	// 				ScriptURI: to.Ptr("https://example.com/path/to/script.sh"),
	// 		}},
	// 		Distribute: []armvirtualmachineimagebuilder.ImageTemplateDistributorClassification{
	// 			&armvirtualmachineimagebuilder.ImageTemplateManagedImageDistributor{
	// 				Type: to.Ptr("ManagedImage"),
	// 				ArtifactTags: map[string]*string{
	// 					"tagName": to.Ptr("value"),
	// 				},
	// 				RunOutputName: to.Ptr("image_it_pir_1"),
	// 				ImageID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/rg1/providers/Microsoft.Compute/images/image_it_1"),
	// 				Location: to.Ptr("1_location"),
	// 		}},
	// 		Source: &armvirtualmachineimagebuilder.ImageTemplateManagedImageSource{
	// 			Type: to.Ptr("ManagedImage"),
	// 			ImageID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/images/source_image"),
	// 		},
	// 		VMProfile: &armvirtualmachineimagebuilder.ImageTemplateVMProfile{
	// 			OSDiskSizeGB: to.Ptr[int32](64),
	// 			VMSize: to.Ptr("Standard_D2s_v3"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/imagebuilder/resource-manager/Microsoft.VirtualMachineImages/stable/2022-07-01/examples/CreateImageTemplateWindows.json
func ExampleVirtualMachineImageTemplatesClient_BeginCreateOrUpdate_createAnImageTemplateForWindows() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armvirtualmachineimagebuilder.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualMachineImageTemplatesClient().BeginCreateOrUpdate(ctx, "myResourceGroup", "myImageTemplate", armvirtualmachineimagebuilder.ImageTemplate{
		Location: to.Ptr("westus"),
		Tags: map[string]*string{
			"imagetemplate_tag1": to.Ptr("IT_T1"),
			"imagetemplate_tag2": to.Ptr("IT_T2"),
		},
		Identity: &armvirtualmachineimagebuilder.ImageTemplateIdentity{
			Type: to.Ptr(armvirtualmachineimagebuilder.ResourceIdentityTypeUserAssigned),
			UserAssignedIdentities: map[string]*armvirtualmachineimagebuilder.UserAssignedIdentity{
				"/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity_1": {},
			},
		},
		Properties: &armvirtualmachineimagebuilder.ImageTemplateProperties{
			Customize: []armvirtualmachineimagebuilder.ImageTemplateCustomizerClassification{
				&armvirtualmachineimagebuilder.ImageTemplatePowerShellCustomizer{
					Name: to.Ptr("PowerShell (inline) Customizer Example"),
					Type: to.Ptr("PowerShell"),
					Inline: []*string{
						to.Ptr("Powershell command-1"),
						to.Ptr("Powershell command-2"),
						to.Ptr("Powershell command-3")},
				},
				&armvirtualmachineimagebuilder.ImageTemplatePowerShellCustomizer{
					Name: to.Ptr("PowerShell (inline) Customizer Elevated user Example"),
					Type: to.Ptr("PowerShell"),
					Inline: []*string{
						to.Ptr("Powershell command-1"),
						to.Ptr("Powershell command-2"),
						to.Ptr("Powershell command-3")},
					RunElevated: to.Ptr(true),
				},
				&armvirtualmachineimagebuilder.ImageTemplatePowerShellCustomizer{
					Name: to.Ptr("PowerShell (inline) Customizer Elevated Local System user Example"),
					Type: to.Ptr("PowerShell"),
					Inline: []*string{
						to.Ptr("Powershell command-1"),
						to.Ptr("Powershell command-2"),
						to.Ptr("Powershell command-3")},
					RunAsSystem: to.Ptr(true),
					RunElevated: to.Ptr(true),
				},
				&armvirtualmachineimagebuilder.ImageTemplatePowerShellCustomizer{
					Name:      to.Ptr("PowerShell (script) Customizer Example"),
					Type:      to.Ptr("PowerShell"),
					ScriptURI: to.Ptr("https://example.com/path/to/script.ps1"),
					ValidExitCodes: []*int32{
						to.Ptr[int32](0),
						to.Ptr[int32](1)},
				},
				&armvirtualmachineimagebuilder.ImageTemplatePowerShellCustomizer{
					Name:        to.Ptr("PowerShell (script) Customizer Elevated Local System user Example"),
					Type:        to.Ptr("PowerShell"),
					RunElevated: to.Ptr(true),
					ScriptURI:   to.Ptr("https://example.com/path/to/script.ps1"),
					ValidExitCodes: []*int32{
						to.Ptr[int32](0),
						to.Ptr[int32](1)},
				},
				&armvirtualmachineimagebuilder.ImageTemplatePowerShellCustomizer{
					Name:        to.Ptr("PowerShell (script) Customizer Elevated Local System user Example"),
					Type:        to.Ptr("PowerShell"),
					RunAsSystem: to.Ptr(true),
					RunElevated: to.Ptr(true),
					ScriptURI:   to.Ptr("https://example.com/path/to/script.ps1"),
					ValidExitCodes: []*int32{
						to.Ptr[int32](0),
						to.Ptr[int32](1)},
				},
				&armvirtualmachineimagebuilder.ImageTemplateRestartCustomizer{
					Name:                to.Ptr("Restart Customizer Example"),
					Type:                to.Ptr("WindowsRestart"),
					RestartCheckCommand: to.Ptr("powershell -command \"& {Write-Output 'restarted.'}\""),
					RestartCommand:      to.Ptr("shutdown /f /r /t 0 /c \"packer restart\""),
					RestartTimeout:      to.Ptr("10m"),
				},
				&armvirtualmachineimagebuilder.ImageTemplateWindowsUpdateCustomizer{
					Name: to.Ptr("Windows Update Customizer Example"),
					Type: to.Ptr("WindowsUpdate"),
					Filters: []*string{
						to.Ptr("$_.BrowseOnly")},
					SearchCriteria: to.Ptr("BrowseOnly=0 and IsInstalled=0"),
					UpdateLimit:    to.Ptr[int32](100),
				}},
			Distribute: []armvirtualmachineimagebuilder.ImageTemplateDistributorClassification{
				&armvirtualmachineimagebuilder.ImageTemplateManagedImageDistributor{
					Type: to.Ptr("ManagedImage"),
					ArtifactTags: map[string]*string{
						"tagName": to.Ptr("value"),
					},
					RunOutputName: to.Ptr("image_it_pir_1"),
					ImageID:       to.Ptr("/subscriptions/{subscription-id}/resourceGroups/rg1/providers/Microsoft.Compute/images/image_it_1"),
					Location:      to.Ptr("1_location"),
				}},
			Source: &armvirtualmachineimagebuilder.ImageTemplateManagedImageSource{
				Type:    to.Ptr("ManagedImage"),
				ImageID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/images/source_image"),
			},
			VMProfile: &armvirtualmachineimagebuilder.ImageTemplateVMProfile{
				OSDiskSizeGB: to.Ptr[int32](64),
				VMSize:       to.Ptr("Standard_D2s_v3"),
				VnetConfig: &armvirtualmachineimagebuilder.VirtualNetworkConfig{
					SubnetID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet_name/subnets/subnet_name"),
				},
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ImageTemplate = armvirtualmachineimagebuilder.ImageTemplate{
	// 	Name: to.Ptr("myImageTemplate"),
	// 	Type: to.Ptr("Microsoft.VirtualMachineImages/imageTemplates"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.VirtualMachineImages/imageTemplates/myImageTemplate"),
	// 	Location: to.Ptr("westus"),
	// 	Identity: &armvirtualmachineimagebuilder.ImageTemplateIdentity{
	// 		Type: to.Ptr(armvirtualmachineimagebuilder.ResourceIdentityTypeUserAssigned),
	// 		UserAssignedIdentities: map[string]*armvirtualmachineimagebuilder.UserAssignedIdentity{
	// 			"/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity_1": &armvirtualmachineimagebuilder.UserAssignedIdentity{
	// 				ClientID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 				PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 			},
	// 		},
	// 	},
	// 	Properties: &armvirtualmachineimagebuilder.ImageTemplateProperties{
	// 		Customize: []armvirtualmachineimagebuilder.ImageTemplateCustomizerClassification{
	// 			&armvirtualmachineimagebuilder.ImageTemplatePowerShellCustomizer{
	// 				Name: to.Ptr("PowerShell (inline) Customizer Example"),
	// 				Type: to.Ptr("PowerShell"),
	// 				Inline: []*string{
	// 					to.Ptr("Powershell command-1"),
	// 					to.Ptr("Powershell command-2"),
	// 					to.Ptr("Powershell command-3")},
	// 					RunAsSystem: to.Ptr(false),
	// 					RunElevated: to.Ptr(false),
	// 				},
	// 				&armvirtualmachineimagebuilder.ImageTemplatePowerShellCustomizer{
	// 					Name: to.Ptr("PowerShell (inline) Customizer Elevated user Example"),
	// 					Type: to.Ptr("PowerShell"),
	// 					Inline: []*string{
	// 						to.Ptr("Powershell command-1"),
	// 						to.Ptr("Powershell command-2"),
	// 						to.Ptr("Powershell command-3")},
	// 						RunAsSystem: to.Ptr(false),
	// 						RunElevated: to.Ptr(true),
	// 					},
	// 					&armvirtualmachineimagebuilder.ImageTemplatePowerShellCustomizer{
	// 						Name: to.Ptr("PowerShell (inline) Customizer Elevated Local System user Example"),
	// 						Type: to.Ptr("PowerShell"),
	// 						Inline: []*string{
	// 							to.Ptr("Powershell command-1"),
	// 							to.Ptr("Powershell command-2"),
	// 							to.Ptr("Powershell command-3")},
	// 							RunAsSystem: to.Ptr(true),
	// 							RunElevated: to.Ptr(true),
	// 						},
	// 						&armvirtualmachineimagebuilder.ImageTemplatePowerShellCustomizer{
	// 							Name: to.Ptr("PowerShell (script) Customizer Example"),
	// 							Type: to.Ptr("PowerShell"),
	// 							RunAsSystem: to.Ptr(false),
	// 							RunElevated: to.Ptr(false),
	// 							ScriptURI: to.Ptr("https://example.com/path/to/script.ps1"),
	// 							ValidExitCodes: []*int32{
	// 								to.Ptr[int32](0),
	// 								to.Ptr[int32](1)},
	// 							},
	// 							&armvirtualmachineimagebuilder.ImageTemplatePowerShellCustomizer{
	// 								Name: to.Ptr("PowerShell (script) Customizer Elevated Local System user Example"),
	// 								Type: to.Ptr("PowerShell"),
	// 								RunAsSystem: to.Ptr(false),
	// 								RunElevated: to.Ptr(true),
	// 								ScriptURI: to.Ptr("https://example.com/path/to/script.ps1"),
	// 								ValidExitCodes: []*int32{
	// 									to.Ptr[int32](0),
	// 									to.Ptr[int32](1)},
	// 								},
	// 								&armvirtualmachineimagebuilder.ImageTemplatePowerShellCustomizer{
	// 									Name: to.Ptr("PowerShell (script) Customizer Elevated Local System user Example"),
	// 									Type: to.Ptr("PowerShell"),
	// 									RunAsSystem: to.Ptr(true),
	// 									RunElevated: to.Ptr(true),
	// 									ScriptURI: to.Ptr("https://example.com/path/to/script.ps1"),
	// 									ValidExitCodes: []*int32{
	// 										to.Ptr[int32](0),
	// 										to.Ptr[int32](1)},
	// 									},
	// 									&armvirtualmachineimagebuilder.ImageTemplateRestartCustomizer{
	// 										Name: to.Ptr("Restart Customizer Example"),
	// 										Type: to.Ptr("WindowsRestart"),
	// 										RestartCheckCommand: to.Ptr("powershell -command \"& {Write-Output 'restarted.'}\""),
	// 										RestartCommand: to.Ptr("shutdown /f /r /t 0 /c \"packer restart\""),
	// 										RestartTimeout: to.Ptr("10m"),
	// 									},
	// 									&armvirtualmachineimagebuilder.ImageTemplateWindowsUpdateCustomizer{
	// 										Name: to.Ptr("Windows Update Customizer Example"),
	// 										Type: to.Ptr("WindowsUpdate"),
	// 										Filters: []*string{
	// 											to.Ptr("$_.BrowseOnly")},
	// 											SearchCriteria: to.Ptr("BrowseOnly=0 and IsInstalled=0"),
	// 											UpdateLimit: to.Ptr[int32](100),
	// 									}},
	// 									Distribute: []armvirtualmachineimagebuilder.ImageTemplateDistributorClassification{
	// 										&armvirtualmachineimagebuilder.ImageTemplateManagedImageDistributor{
	// 											Type: to.Ptr("ManagedImage"),
	// 											ArtifactTags: map[string]*string{
	// 												"tagName": to.Ptr("value"),
	// 											},
	// 											RunOutputName: to.Ptr("image_it_pir_1"),
	// 											ImageID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/rg1/providers/Microsoft.Compute/images/image_it_1"),
	// 											Location: to.Ptr("1_location"),
	// 									}},
	// 									Source: &armvirtualmachineimagebuilder.ImageTemplateManagedImageSource{
	// 										Type: to.Ptr("ManagedImage"),
	// 										ImageID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/images/source_image"),
	// 									},
	// 									VMProfile: &armvirtualmachineimagebuilder.ImageTemplateVMProfile{
	// 										OSDiskSizeGB: to.Ptr[int32](64),
	// 										VMSize: to.Ptr("Standard_D2s_v3"),
	// 									},
	// 								},
	// 							}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/imagebuilder/resource-manager/Microsoft.VirtualMachineImages/stable/2022-07-01/examples/UpdateImageTemplateToRemoveIdentities.json
func ExampleVirtualMachineImageTemplatesClient_BeginUpdate_removeIdentitiesForAnImageTemplate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armvirtualmachineimagebuilder.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualMachineImageTemplatesClient().BeginUpdate(ctx, "myResourceGroup", "myImageTemplate", armvirtualmachineimagebuilder.ImageTemplateUpdateParameters{
		Identity: &armvirtualmachineimagebuilder.ImageTemplateIdentity{
			Type: to.Ptr(armvirtualmachineimagebuilder.ResourceIdentityTypeNone),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ImageTemplate = armvirtualmachineimagebuilder.ImageTemplate{
	// 	Name: to.Ptr("myImageTemplate"),
	// 	Type: to.Ptr("Microsoft.VirtualMachineImages/imageTemplates"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.VirtualMachineImages/imageTemplates/myImageTemplate"),
	// 	Location: to.Ptr("westus"),
	// 	Tags: map[string]*string{
	// 		"new-tag": to.Ptr("new-value"),
	// 	},
	// 	Identity: &armvirtualmachineimagebuilder.ImageTemplateIdentity{
	// 		Type: to.Ptr(armvirtualmachineimagebuilder.ResourceIdentityTypeNone),
	// 	},
	// 	Properties: &armvirtualmachineimagebuilder.ImageTemplateProperties{
	// 		Customize: []armvirtualmachineimagebuilder.ImageTemplateCustomizerClassification{
	// 			&armvirtualmachineimagebuilder.ImageTemplateShellCustomizer{
	// 				Name: to.Ptr("Shell customization example"),
	// 				Type: to.Ptr("Shell"),
	// 				ScriptURI: to.Ptr("https://example.com/path/to/script.sh"),
	// 		}},
	// 		Distribute: []armvirtualmachineimagebuilder.ImageTemplateDistributorClassification{
	// 			&armvirtualmachineimagebuilder.ImageTemplateManagedImageDistributor{
	// 				Type: to.Ptr("ManagedImage"),
	// 				ArtifactTags: map[string]*string{
	// 					"tagName": to.Ptr("value"),
	// 				},
	// 				RunOutputName: to.Ptr("image_it_pir_1"),
	// 				ImageID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/rg1/providers/Microsoft.Compute/images/image_it_1"),
	// 				Location: to.Ptr("1_location"),
	// 		}},
	// 		Source: &armvirtualmachineimagebuilder.ImageTemplateManagedImageSource{
	// 			Type: to.Ptr("ManagedImage"),
	// 			ImageID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/source_rg/providers/Microsoft.Compute/images/source_image"),
	// 		},
	// 		VMProfile: &armvirtualmachineimagebuilder.ImageTemplateVMProfile{
	// 			OSDiskSizeGB: to.Ptr[int32](64),
	// 			VMSize: to.Ptr("Standard_D2s_v3"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/imagebuilder/resource-manager/Microsoft.VirtualMachineImages/stable/2022-07-01/examples/UpdateImageTemplateTags.json
func ExampleVirtualMachineImageTemplatesClient_BeginUpdate_updateTheTagsForAnImageTemplate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armvirtualmachineimagebuilder.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualMachineImageTemplatesClient().BeginUpdate(ctx, "myResourceGroup", "myImageTemplate", armvirtualmachineimagebuilder.ImageTemplateUpdateParameters{
		Tags: map[string]*string{
			"new-tag": to.Ptr("new-value"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ImageTemplate = armvirtualmachineimagebuilder.ImageTemplate{
	// 	Name: to.Ptr("myImageTemplate"),
	// 	Type: to.Ptr("Microsoft.VirtualMachineImages/imageTemplates"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.VirtualMachineImages/imageTemplates/myImageTemplate"),
	// 	Location: to.Ptr("westus"),
	// 	Tags: map[string]*string{
	// 		"new-tag": to.Ptr("new-value"),
	// 	},
	// 	Identity: &armvirtualmachineimagebuilder.ImageTemplateIdentity{
	// 		Type: to.Ptr(armvirtualmachineimagebuilder.ResourceIdentityTypeUserAssigned),
	// 		UserAssignedIdentities: map[string]*armvirtualmachineimagebuilder.UserAssignedIdentity{
	// 			"/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity_1": &armvirtualmachineimagebuilder.UserAssignedIdentity{
	// 				ClientID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 				PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 			},
	// 		},
	// 	},
	// 	Properties: &armvirtualmachineimagebuilder.ImageTemplateProperties{
	// 		Customize: []armvirtualmachineimagebuilder.ImageTemplateCustomizerClassification{
	// 			&armvirtualmachineimagebuilder.ImageTemplateShellCustomizer{
	// 				Name: to.Ptr("Shell customization example"),
	// 				Type: to.Ptr("Shell"),
	// 				ScriptURI: to.Ptr("https://example.com/path/to/script.sh"),
	// 		}},
	// 		Distribute: []armvirtualmachineimagebuilder.ImageTemplateDistributorClassification{
	// 			&armvirtualmachineimagebuilder.ImageTemplateManagedImageDistributor{
	// 				Type: to.Ptr("ManagedImage"),
	// 				ArtifactTags: map[string]*string{
	// 					"tagName": to.Ptr("value"),
	// 				},
	// 				RunOutputName: to.Ptr("image_it_pir_1"),
	// 				ImageID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/rg1/providers/Microsoft.Compute/images/image_it_1"),
	// 				Location: to.Ptr("1_location"),
	// 		}},
	// 		Source: &armvirtualmachineimagebuilder.ImageTemplateManagedImageSource{
	// 			Type: to.Ptr("ManagedImage"),
	// 			ImageID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/source_rg/providers/Microsoft.Compute/images/source_image"),
	// 		},
	// 		VMProfile: &armvirtualmachineimagebuilder.ImageTemplateVMProfile{
	// 			OSDiskSizeGB: to.Ptr[int32](64),
	// 			VMSize: to.Ptr("Standard_D2s_v3"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/imagebuilder/resource-manager/Microsoft.VirtualMachineImages/stable/2022-07-01/examples/GetImageTemplate.json
func ExampleVirtualMachineImageTemplatesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armvirtualmachineimagebuilder.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewVirtualMachineImageTemplatesClient().Get(ctx, "myResourceGroup", "myImageTemplate", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ImageTemplate = armvirtualmachineimagebuilder.ImageTemplate{
	// 	Name: to.Ptr("myImageTemplate"),
	// 	Type: to.Ptr("Microsoft.VirtualMachineImages/imageTemplates"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.VirtualMachineImages/imageTemplates/myImageTemplate"),
	// 	Location: to.Ptr("westus"),
	// 	Identity: &armvirtualmachineimagebuilder.ImageTemplateIdentity{
	// 		Type: to.Ptr(armvirtualmachineimagebuilder.ResourceIdentityTypeUserAssigned),
	// 		UserAssignedIdentities: map[string]*armvirtualmachineimagebuilder.UserAssignedIdentity{
	// 			"/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity_1": &armvirtualmachineimagebuilder.UserAssignedIdentity{
	// 				ClientID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 				PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 			},
	// 		},
	// 	},
	// 	Properties: &armvirtualmachineimagebuilder.ImageTemplateProperties{
	// 		Customize: []armvirtualmachineimagebuilder.ImageTemplateCustomizerClassification{
	// 			&armvirtualmachineimagebuilder.ImageTemplateShellCustomizer{
	// 				Name: to.Ptr("Shell Customizer Example"),
	// 				Type: to.Ptr("Shell"),
	// 				ScriptURI: to.Ptr("https://example.com/path/to/script.sh"),
	// 		}},
	// 		Distribute: []armvirtualmachineimagebuilder.ImageTemplateDistributorClassification{
	// 			&armvirtualmachineimagebuilder.ImageTemplateManagedImageDistributor{
	// 				Type: to.Ptr("ManagedImage"),
	// 				ArtifactTags: map[string]*string{
	// 					"tagName": to.Ptr("value"),
	// 				},
	// 				RunOutputName: to.Ptr("image_it_pir_1"),
	// 				ImageID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/rg1/providers/Microsoft.Compute/images/image_it_1"),
	// 				Location: to.Ptr("1_location"),
	// 		}},
	// 		Source: &armvirtualmachineimagebuilder.ImageTemplateManagedImageSource{
	// 			Type: to.Ptr("ManagedImage"),
	// 			ImageID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/source_rg/providers/Microsoft.Compute/images/source_image"),
	// 		},
	// 		VMProfile: &armvirtualmachineimagebuilder.ImageTemplateVMProfile{
	// 			OSDiskSizeGB: to.Ptr[int32](64),
	// 			VMSize: to.Ptr("Standard_D2s_v3"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/imagebuilder/resource-manager/Microsoft.VirtualMachineImages/stable/2022-07-01/examples/DeleteImageTemplate.json
func ExampleVirtualMachineImageTemplatesClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armvirtualmachineimagebuilder.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualMachineImageTemplatesClient().BeginDelete(ctx, "myResourceGroup", "myImageTemplate", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/imagebuilder/resource-manager/Microsoft.VirtualMachineImages/stable/2022-07-01/examples/RunImageTemplate.json
func ExampleVirtualMachineImageTemplatesClient_BeginRun() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armvirtualmachineimagebuilder.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualMachineImageTemplatesClient().BeginRun(ctx, "myResourceGroup", "myImageTemplate", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/imagebuilder/resource-manager/Microsoft.VirtualMachineImages/stable/2022-07-01/examples/CancelImageBuild.json
func ExampleVirtualMachineImageTemplatesClient_BeginCancel() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armvirtualmachineimagebuilder.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVirtualMachineImageTemplatesClient().BeginCancel(ctx, "myResourceGroup", "myImageTemplate", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/imagebuilder/resource-manager/Microsoft.VirtualMachineImages/stable/2022-07-01/examples/ListRunOutputs.json
func ExampleVirtualMachineImageTemplatesClient_NewListRunOutputsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armvirtualmachineimagebuilder.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewVirtualMachineImageTemplatesClient().NewListRunOutputsPager("myResourceGroup", "myImageTemplate", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.RunOutputCollection = armvirtualmachineimagebuilder.RunOutputCollection{
		// 	Value: []*armvirtualmachineimagebuilder.RunOutput{
		// 		{
		// 			Name: to.Ptr("myManagedImageOutput"),
		// 			Type: to.Ptr("Microsoft.VirtualMachineImages/imageTemplates/runOutputs"),
		// 			ID: to.Ptr("/subscriptions/{subscription-id}/resourcegroups/myResourceGroup/providers/Microsoft.VirtualMachineImages/imageTemplates/myImageTemplate/runOutputs/myManagedImageOutput"),
		// 			Properties: &armvirtualmachineimagebuilder.RunOutputProperties{
		// 				ArtifactID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/rg1/providers/Microsoft.Compute/images/output_managed_image"),
		// 				ProvisioningState: to.Ptr(armvirtualmachineimagebuilder.ProvisioningStateSucceeded),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("mySharedImageOutput"),
		// 			Type: to.Ptr("Microsoft.VirtualMachineImages/imageTemplates/runOutputs"),
		// 			ID: to.Ptr("/subscriptions/{subscription-id}/resourcegroups/myResourceGroup/providers/Microsoft.VirtualMachineImages/imageTemplates/myImageTemplate/runOutputs/mySharedImageOutput"),
		// 			Properties: &armvirtualmachineimagebuilder.RunOutputProperties{
		// 				ArtifactID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/rg1/providers/Microsoft.Compute/galleries/Gallery1/images/SharedImageOutput/imageversions/1.2.3"),
		// 				ProvisioningState: to.Ptr(armvirtualmachineimagebuilder.ProvisioningStateSucceeded),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1f22d4dbd99b0fe347ad79e79d4eb1ed44a87291/specification/imagebuilder/resource-manager/Microsoft.VirtualMachineImages/stable/2022-07-01/examples/GetRunOutput.json
func ExampleVirtualMachineImageTemplatesClient_GetRunOutput() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armvirtualmachineimagebuilder.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewVirtualMachineImageTemplatesClient().GetRunOutput(ctx, "myResourceGroup", "myImageTemplate", "myManagedImageOutput", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RunOutput = armvirtualmachineimagebuilder.RunOutput{
	// 	Name: to.Ptr("myManagedImageOutput"),
	// 	Type: to.Ptr("Microsoft.VirtualMachineImages/imageTemplates/runOutputs"),
	// 	ID: to.Ptr("/subscriptions/{subscription-id}/resourcegroups/myResourceGroup/providers/Microsoft.VirtualMachineImages/imageTemplates/myImageTemplate/runOutputs/myManagedImageOutput"),
	// 	Properties: &armvirtualmachineimagebuilder.RunOutputProperties{
	// 		ArtifactID: to.Ptr("/subscriptions/{subscription-id}/resourceGroups/rg1/providers/Microsoft.Compute/images/output_managed_image"),
	// 		ProvisioningState: to.Ptr(armvirtualmachineimagebuilder.ProvisioningStateSucceeded),
	// 	},
	// }
}
