//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storagesync/armstoragesync"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// ServerEndpointsServer is a fake server for instances of the armstoragesync.ServerEndpointsClient type.
type ServerEndpointsServer struct {
	// BeginCreate is the fake for method ServerEndpointsClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreate func(ctx context.Context, resourceGroupName string, storageSyncServiceName string, syncGroupName string, serverEndpointName string, parameters armstoragesync.ServerEndpointCreateParameters, options *armstoragesync.ServerEndpointsClientBeginCreateOptions) (resp azfake.PollerResponder[armstoragesync.ServerEndpointsClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method ServerEndpointsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginDelete func(ctx context.Context, resourceGroupName string, storageSyncServiceName string, syncGroupName string, serverEndpointName string, options *armstoragesync.ServerEndpointsClientBeginDeleteOptions) (resp azfake.PollerResponder[armstoragesync.ServerEndpointsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ServerEndpointsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, storageSyncServiceName string, syncGroupName string, serverEndpointName string, options *armstoragesync.ServerEndpointsClientGetOptions) (resp azfake.Responder[armstoragesync.ServerEndpointsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListBySyncGroupPager is the fake for method ServerEndpointsClient.NewListBySyncGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySyncGroupPager func(resourceGroupName string, storageSyncServiceName string, syncGroupName string, options *armstoragesync.ServerEndpointsClientListBySyncGroupOptions) (resp azfake.PagerResponder[armstoragesync.ServerEndpointsClientListBySyncGroupResponse])

	// BeginRecallAction is the fake for method ServerEndpointsClient.BeginRecallAction
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRecallAction func(ctx context.Context, resourceGroupName string, storageSyncServiceName string, syncGroupName string, serverEndpointName string, parameters armstoragesync.RecallActionParameters, options *armstoragesync.ServerEndpointsClientBeginRecallActionOptions) (resp azfake.PollerResponder[armstoragesync.ServerEndpointsClientRecallActionResponse], errResp azfake.ErrorResponder)

	// BeginUpdate is the fake for method ServerEndpointsClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, storageSyncServiceName string, syncGroupName string, serverEndpointName string, options *armstoragesync.ServerEndpointsClientBeginUpdateOptions) (resp azfake.PollerResponder[armstoragesync.ServerEndpointsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewServerEndpointsServerTransport creates a new instance of ServerEndpointsServerTransport with the provided implementation.
// The returned ServerEndpointsServerTransport instance is connected to an instance of armstoragesync.ServerEndpointsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerEndpointsServerTransport(srv *ServerEndpointsServer) *ServerEndpointsServerTransport {
	return &ServerEndpointsServerTransport{
		srv:                     srv,
		beginCreate:             newTracker[azfake.PollerResponder[armstoragesync.ServerEndpointsClientCreateResponse]](),
		beginDelete:             newTracker[azfake.PollerResponder[armstoragesync.ServerEndpointsClientDeleteResponse]](),
		newListBySyncGroupPager: newTracker[azfake.PagerResponder[armstoragesync.ServerEndpointsClientListBySyncGroupResponse]](),
		beginRecallAction:       newTracker[azfake.PollerResponder[armstoragesync.ServerEndpointsClientRecallActionResponse]](),
		beginUpdate:             newTracker[azfake.PollerResponder[armstoragesync.ServerEndpointsClientUpdateResponse]](),
	}
}

// ServerEndpointsServerTransport connects instances of armstoragesync.ServerEndpointsClient to instances of ServerEndpointsServer.
// Don't use this type directly, use NewServerEndpointsServerTransport instead.
type ServerEndpointsServerTransport struct {
	srv                     *ServerEndpointsServer
	beginCreate             *tracker[azfake.PollerResponder[armstoragesync.ServerEndpointsClientCreateResponse]]
	beginDelete             *tracker[azfake.PollerResponder[armstoragesync.ServerEndpointsClientDeleteResponse]]
	newListBySyncGroupPager *tracker[azfake.PagerResponder[armstoragesync.ServerEndpointsClientListBySyncGroupResponse]]
	beginRecallAction       *tracker[azfake.PollerResponder[armstoragesync.ServerEndpointsClientRecallActionResponse]]
	beginUpdate             *tracker[azfake.PollerResponder[armstoragesync.ServerEndpointsClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for ServerEndpointsServerTransport.
func (s *ServerEndpointsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ServerEndpointsClient.BeginCreate":
		resp, err = s.dispatchBeginCreate(req)
	case "ServerEndpointsClient.BeginDelete":
		resp, err = s.dispatchBeginDelete(req)
	case "ServerEndpointsClient.Get":
		resp, err = s.dispatchGet(req)
	case "ServerEndpointsClient.NewListBySyncGroupPager":
		resp, err = s.dispatchNewListBySyncGroupPager(req)
	case "ServerEndpointsClient.BeginRecallAction":
		resp, err = s.dispatchBeginRecallAction(req)
	case "ServerEndpointsClient.BeginUpdate":
		resp, err = s.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *ServerEndpointsServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if s.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := s.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorageSync/storageSyncServices/(?P<storageSyncServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/syncGroups/(?P<syncGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/serverEndpoints/(?P<serverEndpointName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armstoragesync.ServerEndpointCreateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		storageSyncServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("storageSyncServiceName")])
		if err != nil {
			return nil, err
		}
		syncGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("syncGroupName")])
		if err != nil {
			return nil, err
		}
		serverEndpointNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverEndpointName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginCreate(req.Context(), resourceGroupNameParam, storageSyncServiceNameParam, syncGroupNameParam, serverEndpointNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		s.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		s.beginCreate.remove(req)
	}

	return resp, nil
}

func (s *ServerEndpointsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if s.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := s.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorageSync/storageSyncServices/(?P<storageSyncServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/syncGroups/(?P<syncGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/serverEndpoints/(?P<serverEndpointName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		storageSyncServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("storageSyncServiceName")])
		if err != nil {
			return nil, err
		}
		syncGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("syncGroupName")])
		if err != nil {
			return nil, err
		}
		serverEndpointNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverEndpointName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginDelete(req.Context(), resourceGroupNameParam, storageSyncServiceNameParam, syncGroupNameParam, serverEndpointNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		s.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		s.beginDelete.remove(req)
	}

	return resp, nil
}

func (s *ServerEndpointsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorageSync/storageSyncServices/(?P<storageSyncServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/syncGroups/(?P<syncGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/serverEndpoints/(?P<serverEndpointName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	storageSyncServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("storageSyncServiceName")])
	if err != nil {
		return nil, err
	}
	syncGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("syncGroupName")])
	if err != nil {
		return nil, err
	}
	serverEndpointNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverEndpointName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, storageSyncServiceNameParam, syncGroupNameParam, serverEndpointNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ServerEndpoint, req)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).XMSCorrelationRequestID; val != nil {
		resp.Header.Set("x-ms-correlation-request-id", *val)
	}
	if val := server.GetResponse(respr).XMSRequestID; val != nil {
		resp.Header.Set("x-ms-request-id", *val)
	}
	return resp, nil
}

func (s *ServerEndpointsServerTransport) dispatchNewListBySyncGroupPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListBySyncGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySyncGroupPager not implemented")}
	}
	newListBySyncGroupPager := s.newListBySyncGroupPager.get(req)
	if newListBySyncGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorageSync/storageSyncServices/(?P<storageSyncServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/syncGroups/(?P<syncGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/serverEndpoints`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		storageSyncServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("storageSyncServiceName")])
		if err != nil {
			return nil, err
		}
		syncGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("syncGroupName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListBySyncGroupPager(resourceGroupNameParam, storageSyncServiceNameParam, syncGroupNameParam, nil)
		newListBySyncGroupPager = &resp
		s.newListBySyncGroupPager.add(req, newListBySyncGroupPager)
	}
	resp, err := server.PagerResponderNext(newListBySyncGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListBySyncGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySyncGroupPager) {
		s.newListBySyncGroupPager.remove(req)
	}
	return resp, nil
}

func (s *ServerEndpointsServerTransport) dispatchBeginRecallAction(req *http.Request) (*http.Response, error) {
	if s.srv.BeginRecallAction == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRecallAction not implemented")}
	}
	beginRecallAction := s.beginRecallAction.get(req)
	if beginRecallAction == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorageSync/storageSyncServices/(?P<storageSyncServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/syncGroups/(?P<syncGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/serverEndpoints/(?P<serverEndpointName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/recallAction`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armstoragesync.RecallActionParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		storageSyncServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("storageSyncServiceName")])
		if err != nil {
			return nil, err
		}
		syncGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("syncGroupName")])
		if err != nil {
			return nil, err
		}
		serverEndpointNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverEndpointName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginRecallAction(req.Context(), resourceGroupNameParam, storageSyncServiceNameParam, syncGroupNameParam, serverEndpointNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRecallAction = &respr
		s.beginRecallAction.add(req, beginRecallAction)
	}

	resp, err := server.PollerResponderNext(beginRecallAction, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginRecallAction.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRecallAction) {
		s.beginRecallAction.remove(req)
	}

	return resp, nil
}

func (s *ServerEndpointsServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := s.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorageSync/storageSyncServices/(?P<storageSyncServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/syncGroups/(?P<syncGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/serverEndpoints/(?P<serverEndpointName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armstoragesync.ServerEndpointUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		storageSyncServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("storageSyncServiceName")])
		if err != nil {
			return nil, err
		}
		syncGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("syncGroupName")])
		if err != nil {
			return nil, err
		}
		serverEndpointNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverEndpointName")])
		if err != nil {
			return nil, err
		}
		var options *armstoragesync.ServerEndpointsClientBeginUpdateOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armstoragesync.ServerEndpointsClientBeginUpdateOptions{
				Parameters: &body,
			}
		}
		respr, errRespr := s.srv.BeginUpdate(req.Context(), resourceGroupNameParam, storageSyncServiceNameParam, syncGroupNameParam, serverEndpointNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		s.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		s.beginUpdate.remove(req)
	}

	return resp, nil
}
