//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/devtestlabs/armdevtestlabs"
	"net/http"
	"net/url"
	"regexp"
)

// PolicySetsServer is a fake server for instances of the armdevtestlabs.PolicySetsClient type.
type PolicySetsServer struct {
	// EvaluatePolicies is the fake for method PolicySetsClient.EvaluatePolicies
	// HTTP status codes to indicate success: http.StatusOK
	EvaluatePolicies func(ctx context.Context, resourceGroupName string, labName string, name string, evaluatePoliciesRequest armdevtestlabs.EvaluatePoliciesRequest, options *armdevtestlabs.PolicySetsClientEvaluatePoliciesOptions) (resp azfake.Responder[armdevtestlabs.PolicySetsClientEvaluatePoliciesResponse], errResp azfake.ErrorResponder)
}

// NewPolicySetsServerTransport creates a new instance of PolicySetsServerTransport with the provided implementation.
// The returned PolicySetsServerTransport instance is connected to an instance of armdevtestlabs.PolicySetsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPolicySetsServerTransport(srv *PolicySetsServer) *PolicySetsServerTransport {
	return &PolicySetsServerTransport{srv: srv}
}

// PolicySetsServerTransport connects instances of armdevtestlabs.PolicySetsClient to instances of PolicySetsServer.
// Don't use this type directly, use NewPolicySetsServerTransport instead.
type PolicySetsServerTransport struct {
	srv *PolicySetsServer
}

// Do implements the policy.Transporter interface for PolicySetsServerTransport.
func (p *PolicySetsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PolicySetsClient.EvaluatePolicies":
		resp, err = p.dispatchEvaluatePolicies(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PolicySetsServerTransport) dispatchEvaluatePolicies(req *http.Request) (*http.Response, error) {
	if p.srv.EvaluatePolicies == nil {
		return nil, &nonRetriableError{errors.New("fake for method EvaluatePolicies not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevTestLab/labs/(?P<labName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/policysets/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/evaluatePolicies`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdevtestlabs.EvaluatePoliciesRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	labNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("labName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.EvaluatePolicies(req.Context(), resourceGroupNameParam, labNameParam, nameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).EvaluatePoliciesResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
