//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/customerinsights/armcustomerinsights"
	"net/http"
	"net/url"
	"regexp"
)

// AuthorizationPoliciesServer is a fake server for instances of the armcustomerinsights.AuthorizationPoliciesClient type.
type AuthorizationPoliciesServer struct {
	// CreateOrUpdate is the fake for method AuthorizationPoliciesClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, hubName string, authorizationPolicyName string, parameters armcustomerinsights.AuthorizationPolicyResourceFormat, options *armcustomerinsights.AuthorizationPoliciesClientCreateOrUpdateOptions) (resp azfake.Responder[armcustomerinsights.AuthorizationPoliciesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method AuthorizationPoliciesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, hubName string, authorizationPolicyName string, options *armcustomerinsights.AuthorizationPoliciesClientGetOptions) (resp azfake.Responder[armcustomerinsights.AuthorizationPoliciesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByHubPager is the fake for method AuthorizationPoliciesClient.NewListByHubPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByHubPager func(resourceGroupName string, hubName string, options *armcustomerinsights.AuthorizationPoliciesClientListByHubOptions) (resp azfake.PagerResponder[armcustomerinsights.AuthorizationPoliciesClientListByHubResponse])

	// RegeneratePrimaryKey is the fake for method AuthorizationPoliciesClient.RegeneratePrimaryKey
	// HTTP status codes to indicate success: http.StatusOK
	RegeneratePrimaryKey func(ctx context.Context, resourceGroupName string, hubName string, authorizationPolicyName string, options *armcustomerinsights.AuthorizationPoliciesClientRegeneratePrimaryKeyOptions) (resp azfake.Responder[armcustomerinsights.AuthorizationPoliciesClientRegeneratePrimaryKeyResponse], errResp azfake.ErrorResponder)

	// RegenerateSecondaryKey is the fake for method AuthorizationPoliciesClient.RegenerateSecondaryKey
	// HTTP status codes to indicate success: http.StatusOK
	RegenerateSecondaryKey func(ctx context.Context, resourceGroupName string, hubName string, authorizationPolicyName string, options *armcustomerinsights.AuthorizationPoliciesClientRegenerateSecondaryKeyOptions) (resp azfake.Responder[armcustomerinsights.AuthorizationPoliciesClientRegenerateSecondaryKeyResponse], errResp azfake.ErrorResponder)
}

// NewAuthorizationPoliciesServerTransport creates a new instance of AuthorizationPoliciesServerTransport with the provided implementation.
// The returned AuthorizationPoliciesServerTransport instance is connected to an instance of armcustomerinsights.AuthorizationPoliciesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAuthorizationPoliciesServerTransport(srv *AuthorizationPoliciesServer) *AuthorizationPoliciesServerTransport {
	return &AuthorizationPoliciesServerTransport{
		srv:               srv,
		newListByHubPager: newTracker[azfake.PagerResponder[armcustomerinsights.AuthorizationPoliciesClientListByHubResponse]](),
	}
}

// AuthorizationPoliciesServerTransport connects instances of armcustomerinsights.AuthorizationPoliciesClient to instances of AuthorizationPoliciesServer.
// Don't use this type directly, use NewAuthorizationPoliciesServerTransport instead.
type AuthorizationPoliciesServerTransport struct {
	srv               *AuthorizationPoliciesServer
	newListByHubPager *tracker[azfake.PagerResponder[armcustomerinsights.AuthorizationPoliciesClientListByHubResponse]]
}

// Do implements the policy.Transporter interface for AuthorizationPoliciesServerTransport.
func (a *AuthorizationPoliciesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AuthorizationPoliciesClient.CreateOrUpdate":
		resp, err = a.dispatchCreateOrUpdate(req)
	case "AuthorizationPoliciesClient.Get":
		resp, err = a.dispatchGet(req)
	case "AuthorizationPoliciesClient.NewListByHubPager":
		resp, err = a.dispatchNewListByHubPager(req)
	case "AuthorizationPoliciesClient.RegeneratePrimaryKey":
		resp, err = a.dispatchRegeneratePrimaryKey(req)
	case "AuthorizationPoliciesClient.RegenerateSecondaryKey":
		resp, err = a.dispatchRegenerateSecondaryKey(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AuthorizationPoliciesServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if a.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CustomerInsights/hubs/(?P<hubName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/authorizationPolicies/(?P<authorizationPolicyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armcustomerinsights.AuthorizationPolicyResourceFormat](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	hubNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("hubName")])
	if err != nil {
		return nil, err
	}
	authorizationPolicyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("authorizationPolicyName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, hubNameParam, authorizationPolicyNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AuthorizationPolicyResourceFormat, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AuthorizationPoliciesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if a.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CustomerInsights/hubs/(?P<hubName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/authorizationPolicies/(?P<authorizationPolicyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	hubNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("hubName")])
	if err != nil {
		return nil, err
	}
	authorizationPolicyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("authorizationPolicyName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Get(req.Context(), resourceGroupNameParam, hubNameParam, authorizationPolicyNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AuthorizationPolicyResourceFormat, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AuthorizationPoliciesServerTransport) dispatchNewListByHubPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListByHubPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByHubPager not implemented")}
	}
	newListByHubPager := a.newListByHubPager.get(req)
	if newListByHubPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CustomerInsights/hubs/(?P<hubName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/authorizationPolicies`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		hubNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("hubName")])
		if err != nil {
			return nil, err
		}
		resp := a.srv.NewListByHubPager(resourceGroupNameParam, hubNameParam, nil)
		newListByHubPager = &resp
		a.newListByHubPager.add(req, newListByHubPager)
		server.PagerResponderInjectNextLinks(newListByHubPager, req, func(page *armcustomerinsights.AuthorizationPoliciesClientListByHubResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByHubPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListByHubPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByHubPager) {
		a.newListByHubPager.remove(req)
	}
	return resp, nil
}

func (a *AuthorizationPoliciesServerTransport) dispatchRegeneratePrimaryKey(req *http.Request) (*http.Response, error) {
	if a.srv.RegeneratePrimaryKey == nil {
		return nil, &nonRetriableError{errors.New("fake for method RegeneratePrimaryKey not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CustomerInsights/hubs/(?P<hubName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/authorizationPolicies/(?P<authorizationPolicyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/regeneratePrimaryKey`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	hubNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("hubName")])
	if err != nil {
		return nil, err
	}
	authorizationPolicyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("authorizationPolicyName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.RegeneratePrimaryKey(req.Context(), resourceGroupNameParam, hubNameParam, authorizationPolicyNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AuthorizationPolicy, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AuthorizationPoliciesServerTransport) dispatchRegenerateSecondaryKey(req *http.Request) (*http.Response, error) {
	if a.srv.RegenerateSecondaryKey == nil {
		return nil, &nonRetriableError{errors.New("fake for method RegenerateSecondaryKey not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CustomerInsights/hubs/(?P<hubName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/authorizationPolicies/(?P<authorizationPolicyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/regenerateSecondaryKey`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	hubNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("hubName")])
	if err != nil {
		return nil, err
	}
	authorizationPolicyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("authorizationPolicyName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.RegenerateSecondaryKey(req.Context(), resourceGroupNameParam, hubNameParam, authorizationPolicyNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AuthorizationPolicy, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
