//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package generated

import (
	"context"
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// AzureAppConfigurationClient contains the methods for the AzureAppConfiguration group.
// Don't use this type directly, use a constructor function instead.
type AzureAppConfigurationClient struct {
	internal  *azcore.Client
	endpoint  string
	syncToken *string
}

// CheckKeyValue - Requests the headers and status of the given resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01
//   - key - The key of the key-value to retrieve.
//   - options - AzureAppConfigurationClientCheckKeyValueOptions contains the optional parameters for the AzureAppConfigurationClient.CheckKeyValue
//     method.
func (client *AzureAppConfigurationClient) CheckKeyValue(ctx context.Context, key string, options *AzureAppConfigurationClientCheckKeyValueOptions) (AzureAppConfigurationClientCheckKeyValueResponse, error) {
	var err error
	req, err := client.checkKeyValueCreateRequest(ctx, key, options)
	if err != nil {
		return AzureAppConfigurationClientCheckKeyValueResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AzureAppConfigurationClientCheckKeyValueResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AzureAppConfigurationClientCheckKeyValueResponse{}, err
	}
	resp, err := client.checkKeyValueHandleResponse(httpResp)
	return resp, err
}

// checkKeyValueCreateRequest creates the CheckKeyValue request.
func (client *AzureAppConfigurationClient) checkKeyValueCreateRequest(ctx context.Context, key string, options *AzureAppConfigurationClientCheckKeyValueOptions) (*policy.Request, error) {
	urlPath := "/kv/{key}"
	if key == "" {
		return nil, errors.New("parameter key cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key}", url.PathEscape(key))
	req, err := runtime.NewRequest(ctx, http.MethodHead, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Label != nil {
		reqQP.Set("label", *options.Label)
	}
	reqQP.Set("api-version", "2023-10-01")
	if options != nil && options.Select != nil {
		reqQP.Set("$Select", strings.Join(strings.Fields(strings.Trim(fmt.Sprint(options.Select), "[]")), ","))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if client.syncToken != nil {
		req.Raw().Header["Sync-Token"] = []string{*client.syncToken}
	}
	if options != nil && options.AcceptDatetime != nil {
		req.Raw().Header["Accept-Datetime"] = []string{*options.AcceptDatetime}
	}
	if options != nil && options.IfMatch != nil {
		req.Raw().Header["If-Match"] = []string{*options.IfMatch}
	}
	if options != nil && options.IfNoneMatch != nil {
		req.Raw().Header["If-None-Match"] = []string{*options.IfNoneMatch}
	}
	return req, nil
}

// checkKeyValueHandleResponse handles the CheckKeyValue response.
func (client *AzureAppConfigurationClient) checkKeyValueHandleResponse(resp *http.Response) (AzureAppConfigurationClientCheckKeyValueResponse, error) {
	result := AzureAppConfigurationClientCheckKeyValueResponse{}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Sync-Token"); val != "" {
		result.SyncToken = &val
	}
	return result, nil
}

// CheckKeyValues - Requests the headers and status of the given resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01
//   - options - AzureAppConfigurationClientCheckKeyValuesOptions contains the optional parameters for the AzureAppConfigurationClient.CheckKeyValues
//     method.
func (client *AzureAppConfigurationClient) CheckKeyValues(ctx context.Context, options *AzureAppConfigurationClientCheckKeyValuesOptions) (AzureAppConfigurationClientCheckKeyValuesResponse, error) {
	var err error
	req, err := client.checkKeyValuesCreateRequest(ctx, options)
	if err != nil {
		return AzureAppConfigurationClientCheckKeyValuesResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AzureAppConfigurationClientCheckKeyValuesResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AzureAppConfigurationClientCheckKeyValuesResponse{}, err
	}
	resp, err := client.checkKeyValuesHandleResponse(httpResp)
	return resp, err
}

// checkKeyValuesCreateRequest creates the CheckKeyValues request.
func (client *AzureAppConfigurationClient) checkKeyValuesCreateRequest(ctx context.Context, options *AzureAppConfigurationClientCheckKeyValuesOptions) (*policy.Request, error) {
	urlPath := "/kv"
	req, err := runtime.NewRequest(ctx, http.MethodHead, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Key != nil {
		reqQP.Set("key", *options.Key)
	}
	if options != nil && options.Label != nil {
		reqQP.Set("label", *options.Label)
	}
	reqQP.Set("api-version", "2023-10-01")
	if options != nil && options.After != nil {
		reqQP.Set("After", *options.After)
	}
	if options != nil && options.Select != nil {
		reqQP.Set("$Select", strings.Join(strings.Fields(strings.Trim(fmt.Sprint(options.Select), "[]")), ","))
	}
	if options != nil && options.Snapshot != nil {
		reqQP.Set("snapshot", *options.Snapshot)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if client.syncToken != nil {
		req.Raw().Header["Sync-Token"] = []string{*client.syncToken}
	}
	if options != nil && options.AcceptDatetime != nil {
		req.Raw().Header["Accept-Datetime"] = []string{*options.AcceptDatetime}
	}
	if options != nil && options.IfMatch != nil {
		req.Raw().Header["If-Match"] = []string{*options.IfMatch}
	}
	if options != nil && options.IfNoneMatch != nil {
		req.Raw().Header["If-None-Match"] = []string{*options.IfNoneMatch}
	}
	return req, nil
}

// checkKeyValuesHandleResponse handles the CheckKeyValues response.
func (client *AzureAppConfigurationClient) checkKeyValuesHandleResponse(resp *http.Response) (AzureAppConfigurationClientCheckKeyValuesResponse, error) {
	result := AzureAppConfigurationClientCheckKeyValuesResponse{}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Sync-Token"); val != "" {
		result.SyncToken = &val
	}
	return result, nil
}

// CheckKeys - Requests the headers and status of the given resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01
//   - options - AzureAppConfigurationClientCheckKeysOptions contains the optional parameters for the AzureAppConfigurationClient.CheckKeys
//     method.
func (client *AzureAppConfigurationClient) CheckKeys(ctx context.Context, options *AzureAppConfigurationClientCheckKeysOptions) (AzureAppConfigurationClientCheckKeysResponse, error) {
	var err error
	req, err := client.checkKeysCreateRequest(ctx, options)
	if err != nil {
		return AzureAppConfigurationClientCheckKeysResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AzureAppConfigurationClientCheckKeysResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AzureAppConfigurationClientCheckKeysResponse{}, err
	}
	resp, err := client.checkKeysHandleResponse(httpResp)
	return resp, err
}

// checkKeysCreateRequest creates the CheckKeys request.
func (client *AzureAppConfigurationClient) checkKeysCreateRequest(ctx context.Context, options *AzureAppConfigurationClientCheckKeysOptions) (*policy.Request, error) {
	urlPath := "/keys"
	req, err := runtime.NewRequest(ctx, http.MethodHead, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Name != nil {
		reqQP.Set("name", *options.Name)
	}
	reqQP.Set("api-version", "2023-10-01")
	if options != nil && options.After != nil {
		reqQP.Set("After", *options.After)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if client.syncToken != nil {
		req.Raw().Header["Sync-Token"] = []string{*client.syncToken}
	}
	if options != nil && options.AcceptDatetime != nil {
		req.Raw().Header["Accept-Datetime"] = []string{*options.AcceptDatetime}
	}
	return req, nil
}

// checkKeysHandleResponse handles the CheckKeys response.
func (client *AzureAppConfigurationClient) checkKeysHandleResponse(resp *http.Response) (AzureAppConfigurationClientCheckKeysResponse, error) {
	result := AzureAppConfigurationClientCheckKeysResponse{}
	if val := resp.Header.Get("Sync-Token"); val != "" {
		result.SyncToken = &val
	}
	return result, nil
}

// CheckLabels - Requests the headers and status of the given resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01
//   - options - AzureAppConfigurationClientCheckLabelsOptions contains the optional parameters for the AzureAppConfigurationClient.CheckLabels
//     method.
func (client *AzureAppConfigurationClient) CheckLabels(ctx context.Context, options *AzureAppConfigurationClientCheckLabelsOptions) (AzureAppConfigurationClientCheckLabelsResponse, error) {
	var err error
	req, err := client.checkLabelsCreateRequest(ctx, options)
	if err != nil {
		return AzureAppConfigurationClientCheckLabelsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AzureAppConfigurationClientCheckLabelsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AzureAppConfigurationClientCheckLabelsResponse{}, err
	}
	resp, err := client.checkLabelsHandleResponse(httpResp)
	return resp, err
}

// checkLabelsCreateRequest creates the CheckLabels request.
func (client *AzureAppConfigurationClient) checkLabelsCreateRequest(ctx context.Context, options *AzureAppConfigurationClientCheckLabelsOptions) (*policy.Request, error) {
	urlPath := "/labels"
	req, err := runtime.NewRequest(ctx, http.MethodHead, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Name != nil {
		reqQP.Set("name", *options.Name)
	}
	reqQP.Set("api-version", "2023-10-01")
	if options != nil && options.After != nil {
		reqQP.Set("After", *options.After)
	}
	if options != nil && options.Select != nil {
		reqQP.Set("$Select", strings.Join(strings.Fields(strings.Trim(fmt.Sprint(options.Select), "[]")), ","))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if client.syncToken != nil {
		req.Raw().Header["Sync-Token"] = []string{*client.syncToken}
	}
	if options != nil && options.AcceptDatetime != nil {
		req.Raw().Header["Accept-Datetime"] = []string{*options.AcceptDatetime}
	}
	return req, nil
}

// checkLabelsHandleResponse handles the CheckLabels response.
func (client *AzureAppConfigurationClient) checkLabelsHandleResponse(resp *http.Response) (AzureAppConfigurationClientCheckLabelsResponse, error) {
	result := AzureAppConfigurationClientCheckLabelsResponse{}
	if val := resp.Header.Get("Sync-Token"); val != "" {
		result.SyncToken = &val
	}
	return result, nil
}

// CheckRevisions - Requests the headers and status of the given resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01
//   - options - AzureAppConfigurationClientCheckRevisionsOptions contains the optional parameters for the AzureAppConfigurationClient.CheckRevisions
//     method.
func (client *AzureAppConfigurationClient) CheckRevisions(ctx context.Context, options *AzureAppConfigurationClientCheckRevisionsOptions) (AzureAppConfigurationClientCheckRevisionsResponse, error) {
	var err error
	req, err := client.checkRevisionsCreateRequest(ctx, options)
	if err != nil {
		return AzureAppConfigurationClientCheckRevisionsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AzureAppConfigurationClientCheckRevisionsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AzureAppConfigurationClientCheckRevisionsResponse{}, err
	}
	resp, err := client.checkRevisionsHandleResponse(httpResp)
	return resp, err
}

// checkRevisionsCreateRequest creates the CheckRevisions request.
func (client *AzureAppConfigurationClient) checkRevisionsCreateRequest(ctx context.Context, options *AzureAppConfigurationClientCheckRevisionsOptions) (*policy.Request, error) {
	urlPath := "/revisions"
	req, err := runtime.NewRequest(ctx, http.MethodHead, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Key != nil {
		reqQP.Set("key", *options.Key)
	}
	if options != nil && options.Label != nil {
		reqQP.Set("label", *options.Label)
	}
	reqQP.Set("api-version", "2023-10-01")
	if options != nil && options.After != nil {
		reqQP.Set("After", *options.After)
	}
	if options != nil && options.Select != nil {
		reqQP.Set("$Select", strings.Join(strings.Fields(strings.Trim(fmt.Sprint(options.Select), "[]")), ","))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if client.syncToken != nil {
		req.Raw().Header["Sync-Token"] = []string{*client.syncToken}
	}
	if options != nil && options.AcceptDatetime != nil {
		req.Raw().Header["Accept-Datetime"] = []string{*options.AcceptDatetime}
	}
	return req, nil
}

// checkRevisionsHandleResponse handles the CheckRevisions response.
func (client *AzureAppConfigurationClient) checkRevisionsHandleResponse(resp *http.Response) (AzureAppConfigurationClientCheckRevisionsResponse, error) {
	result := AzureAppConfigurationClientCheckRevisionsResponse{}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Sync-Token"); val != "" {
		result.SyncToken = &val
	}
	return result, nil
}

// CheckSnapshot - Requests the headers and status of the given resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01
//   - name - The name of the key-value snapshot to check.
//   - options - AzureAppConfigurationClientCheckSnapshotOptions contains the optional parameters for the AzureAppConfigurationClient.CheckSnapshot
//     method.
func (client *AzureAppConfigurationClient) CheckSnapshot(ctx context.Context, name string, options *AzureAppConfigurationClientCheckSnapshotOptions) (AzureAppConfigurationClientCheckSnapshotResponse, error) {
	var err error
	req, err := client.checkSnapshotCreateRequest(ctx, name, options)
	if err != nil {
		return AzureAppConfigurationClientCheckSnapshotResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AzureAppConfigurationClientCheckSnapshotResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AzureAppConfigurationClientCheckSnapshotResponse{}, err
	}
	resp, err := client.checkSnapshotHandleResponse(httpResp)
	return resp, err
}

// checkSnapshotCreateRequest creates the CheckSnapshot request.
func (client *AzureAppConfigurationClient) checkSnapshotCreateRequest(ctx context.Context, name string, options *AzureAppConfigurationClientCheckSnapshotOptions) (*policy.Request, error) {
	urlPath := "/snapshots/{name}"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodHead, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	if client.syncToken != nil {
		req.Raw().Header["Sync-Token"] = []string{*client.syncToken}
	}
	if options != nil && options.IfMatch != nil {
		req.Raw().Header["If-Match"] = []string{*options.IfMatch}
	}
	if options != nil && options.IfNoneMatch != nil {
		req.Raw().Header["If-None-Match"] = []string{*options.IfNoneMatch}
	}
	return req, nil
}

// checkSnapshotHandleResponse handles the CheckSnapshot response.
func (client *AzureAppConfigurationClient) checkSnapshotHandleResponse(resp *http.Response) (AzureAppConfigurationClientCheckSnapshotResponse, error) {
	result := AzureAppConfigurationClientCheckSnapshotResponse{}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Link"); val != "" {
		result.Link = &val
	}
	if val := resp.Header.Get("Sync-Token"); val != "" {
		result.SyncToken = &val
	}
	return result, nil
}

// CheckSnapshots - Requests the headers and status of the given resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01
//   - options - AzureAppConfigurationClientCheckSnapshotsOptions contains the optional parameters for the AzureAppConfigurationClient.CheckSnapshots
//     method.
func (client *AzureAppConfigurationClient) CheckSnapshots(ctx context.Context, options *AzureAppConfigurationClientCheckSnapshotsOptions) (AzureAppConfigurationClientCheckSnapshotsResponse, error) {
	var err error
	req, err := client.checkSnapshotsCreateRequest(ctx, options)
	if err != nil {
		return AzureAppConfigurationClientCheckSnapshotsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AzureAppConfigurationClientCheckSnapshotsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AzureAppConfigurationClientCheckSnapshotsResponse{}, err
	}
	resp, err := client.checkSnapshotsHandleResponse(httpResp)
	return resp, err
}

// checkSnapshotsCreateRequest creates the CheckSnapshots request.
func (client *AzureAppConfigurationClient) checkSnapshotsCreateRequest(ctx context.Context, options *AzureAppConfigurationClientCheckSnapshotsOptions) (*policy.Request, error) {
	urlPath := "/snapshots"
	req, err := runtime.NewRequest(ctx, http.MethodHead, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-10-01")
	if options != nil && options.After != nil {
		reqQP.Set("After", *options.After)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if client.syncToken != nil {
		req.Raw().Header["Sync-Token"] = []string{*client.syncToken}
	}
	return req, nil
}

// checkSnapshotsHandleResponse handles the CheckSnapshots response.
func (client *AzureAppConfigurationClient) checkSnapshotsHandleResponse(resp *http.Response) (AzureAppConfigurationClientCheckSnapshotsResponse, error) {
	result := AzureAppConfigurationClientCheckSnapshotsResponse{}
	if val := resp.Header.Get("Sync-Token"); val != "" {
		result.SyncToken = &val
	}
	return result, nil
}

// BeginCreateSnapshot - Creates a key-value snapshot.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01
//   - name - The name of the key-value snapshot to create.
//   - entity - The key-value snapshot to create.
//   - options - AzureAppConfigurationClientBeginCreateSnapshotOptions contains the optional parameters for the AzureAppConfigurationClient.BeginCreateSnapshot
//     method.
func (client *AzureAppConfigurationClient) BeginCreateSnapshot(ctx context.Context, name string, entity Snapshot, options *AzureAppConfigurationClientBeginCreateSnapshotOptions) (*runtime.Poller[AzureAppConfigurationClientCreateSnapshotResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createSnapshot(ctx, name, entity, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller[AzureAppConfigurationClientCreateSnapshotResponse](resp, client.internal.Pipeline(), nil)
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken[AzureAppConfigurationClientCreateSnapshotResponse](options.ResumeToken, client.internal.Pipeline(), nil)
	}
}

// CreateSnapshot - Creates a key-value snapshot.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01
func (client *AzureAppConfigurationClient) createSnapshot(ctx context.Context, name string, entity Snapshot, options *AzureAppConfigurationClientBeginCreateSnapshotOptions) (*http.Response, error) {
	var err error
	req, err := client.createSnapshotCreateRequest(ctx, name, entity, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createSnapshotCreateRequest creates the CreateSnapshot request.
func (client *AzureAppConfigurationClient) createSnapshotCreateRequest(ctx context.Context, name string, entity Snapshot, options *AzureAppConfigurationClientBeginCreateSnapshotOptions) (*policy.Request, error) {
	urlPath := "/snapshots/{name}"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	if client.syncToken != nil {
		req.Raw().Header["Sync-Token"] = []string{*client.syncToken}
	}
	req.Raw().Header["Accept"] = []string{"application/vnd.microsoft.appconfig.snapshot+json, application/problem+json"}
	if err := runtime.MarshalAsJSON(req, entity); err != nil {
		return nil, err
	}
	return req, nil
}

// DeleteKeyValue - Deletes a key-value.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01
//   - key - The key of the key-value to delete.
//   - options - AzureAppConfigurationClientDeleteKeyValueOptions contains the optional parameters for the AzureAppConfigurationClient.DeleteKeyValue
//     method.
func (client *AzureAppConfigurationClient) DeleteKeyValue(ctx context.Context, key string, options *AzureAppConfigurationClientDeleteKeyValueOptions) (AzureAppConfigurationClientDeleteKeyValueResponse, error) {
	var err error
	req, err := client.deleteKeyValueCreateRequest(ctx, key, options)
	if err != nil {
		return AzureAppConfigurationClientDeleteKeyValueResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AzureAppConfigurationClientDeleteKeyValueResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return AzureAppConfigurationClientDeleteKeyValueResponse{}, err
	}
	resp, err := client.deleteKeyValueHandleResponse(httpResp)
	return resp, err
}

// deleteKeyValueCreateRequest creates the DeleteKeyValue request.
func (client *AzureAppConfigurationClient) deleteKeyValueCreateRequest(ctx context.Context, key string, options *AzureAppConfigurationClientDeleteKeyValueOptions) (*policy.Request, error) {
	urlPath := "/kv/{key}"
	if key == "" {
		return nil, errors.New("parameter key cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key}", url.PathEscape(key))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Label != nil {
		reqQP.Set("label", *options.Label)
	}
	reqQP.Set("api-version", "2023-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	if client.syncToken != nil {
		req.Raw().Header["Sync-Token"] = []string{*client.syncToken}
	}
	if options != nil && options.IfMatch != nil {
		req.Raw().Header["If-Match"] = []string{*options.IfMatch}
	}
	req.Raw().Header["Accept"] = []string{"application/vnd.microsoft.appconfig.kv+json, application/problem+json"}
	return req, nil
}

// deleteKeyValueHandleResponse handles the DeleteKeyValue response.
func (client *AzureAppConfigurationClient) deleteKeyValueHandleResponse(resp *http.Response) (AzureAppConfigurationClientDeleteKeyValueResponse, error) {
	result := AzureAppConfigurationClientDeleteKeyValueResponse{}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Sync-Token"); val != "" {
		result.SyncToken = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyValue); err != nil {
		return AzureAppConfigurationClientDeleteKeyValueResponse{}, err
	}
	return result, nil
}

// DeleteLock - Unlocks a key-value.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01
//   - key - The key of the key-value to unlock.
//   - options - AzureAppConfigurationClientDeleteLockOptions contains the optional parameters for the AzureAppConfigurationClient.DeleteLock
//     method.
func (client *AzureAppConfigurationClient) DeleteLock(ctx context.Context, key string, options *AzureAppConfigurationClientDeleteLockOptions) (AzureAppConfigurationClientDeleteLockResponse, error) {
	var err error
	req, err := client.deleteLockCreateRequest(ctx, key, options)
	if err != nil {
		return AzureAppConfigurationClientDeleteLockResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AzureAppConfigurationClientDeleteLockResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AzureAppConfigurationClientDeleteLockResponse{}, err
	}
	resp, err := client.deleteLockHandleResponse(httpResp)
	return resp, err
}

// deleteLockCreateRequest creates the DeleteLock request.
func (client *AzureAppConfigurationClient) deleteLockCreateRequest(ctx context.Context, key string, options *AzureAppConfigurationClientDeleteLockOptions) (*policy.Request, error) {
	urlPath := "/locks/{key}"
	if key == "" {
		return nil, errors.New("parameter key cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key}", url.PathEscape(key))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Label != nil {
		reqQP.Set("label", *options.Label)
	}
	reqQP.Set("api-version", "2023-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	if client.syncToken != nil {
		req.Raw().Header["Sync-Token"] = []string{*client.syncToken}
	}
	if options != nil && options.IfMatch != nil {
		req.Raw().Header["If-Match"] = []string{*options.IfMatch}
	}
	if options != nil && options.IfNoneMatch != nil {
		req.Raw().Header["If-None-Match"] = []string{*options.IfNoneMatch}
	}
	req.Raw().Header["Accept"] = []string{"application/vnd.microsoft.appconfig.kv+json, application/problem+json"}
	return req, nil
}

// deleteLockHandleResponse handles the DeleteLock response.
func (client *AzureAppConfigurationClient) deleteLockHandleResponse(resp *http.Response) (AzureAppConfigurationClientDeleteLockResponse, error) {
	result := AzureAppConfigurationClientDeleteLockResponse{}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Sync-Token"); val != "" {
		result.SyncToken = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyValue); err != nil {
		return AzureAppConfigurationClientDeleteLockResponse{}, err
	}
	return result, nil
}

// GetKeyValue - Gets a single key-value.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01
//   - key - The key of the key-value to retrieve.
//   - options - AzureAppConfigurationClientGetKeyValueOptions contains the optional parameters for the AzureAppConfigurationClient.GetKeyValue
//     method.
func (client *AzureAppConfigurationClient) GetKeyValue(ctx context.Context, key string, options *AzureAppConfigurationClientGetKeyValueOptions) (AzureAppConfigurationClientGetKeyValueResponse, error) {
	var err error
	req, err := client.getKeyValueCreateRequest(ctx, key, options)
	if err != nil {
		return AzureAppConfigurationClientGetKeyValueResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AzureAppConfigurationClientGetKeyValueResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AzureAppConfigurationClientGetKeyValueResponse{}, err
	}
	resp, err := client.getKeyValueHandleResponse(httpResp)
	return resp, err
}

// getKeyValueCreateRequest creates the GetKeyValue request.
func (client *AzureAppConfigurationClient) getKeyValueCreateRequest(ctx context.Context, key string, options *AzureAppConfigurationClientGetKeyValueOptions) (*policy.Request, error) {
	urlPath := "/kv/{key}"
	if key == "" {
		return nil, errors.New("parameter key cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key}", url.PathEscape(key))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Label != nil {
		reqQP.Set("label", *options.Label)
	}
	reqQP.Set("api-version", "2023-10-01")
	if options != nil && options.Select != nil {
		reqQP.Set("$Select", strings.Join(strings.Fields(strings.Trim(fmt.Sprint(options.Select), "[]")), ","))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if client.syncToken != nil {
		req.Raw().Header["Sync-Token"] = []string{*client.syncToken}
	}
	if options != nil && options.AcceptDatetime != nil {
		req.Raw().Header["Accept-Datetime"] = []string{*options.AcceptDatetime}
	}
	if options != nil && options.IfMatch != nil {
		req.Raw().Header["If-Match"] = []string{*options.IfMatch}
	}
	if options != nil && options.IfNoneMatch != nil {
		req.Raw().Header["If-None-Match"] = []string{*options.IfNoneMatch}
	}
	req.Raw().Header["Accept"] = []string{"application/vnd.microsoft.appconfig.kv+json, application/problem+json"}
	return req, nil
}

// getKeyValueHandleResponse handles the GetKeyValue response.
func (client *AzureAppConfigurationClient) getKeyValueHandleResponse(resp *http.Response) (AzureAppConfigurationClientGetKeyValueResponse, error) {
	result := AzureAppConfigurationClientGetKeyValueResponse{}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Sync-Token"); val != "" {
		result.SyncToken = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyValue); err != nil {
		return AzureAppConfigurationClientGetKeyValueResponse{}, err
	}
	return result, nil
}

// NewGetKeyValuesPager - Gets a list of key-values.
//
// Generated from API version 2023-10-01
//   - options - AzureAppConfigurationClientGetKeyValuesOptions contains the optional parameters for the AzureAppConfigurationClient.NewGetKeyValuesPager
//     method.
func (client *AzureAppConfigurationClient) NewGetKeyValuesPager(options *AzureAppConfigurationClientGetKeyValuesOptions) *runtime.Pager[AzureAppConfigurationClientGetKeyValuesResponse] {
	return runtime.NewPager(runtime.PagingHandler[AzureAppConfigurationClientGetKeyValuesResponse]{
		More: func(page AzureAppConfigurationClientGetKeyValuesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *AzureAppConfigurationClientGetKeyValuesResponse) (AzureAppConfigurationClientGetKeyValuesResponse, error) {
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.getKeyValuesCreateRequest(ctx, options)
			}, &runtime.FetcherForNextLinkOptions{
				NextReq: func(ctx context.Context, encodedNextLink string) (*policy.Request, error) {
					return client.getNextPageCreateRequest(ctx, encodedNextLink)
				},
			})
			if err != nil {
				return AzureAppConfigurationClientGetKeyValuesResponse{}, err
			}
			return client.getKeyValuesHandleResponse(resp)
		},
	})
}

// getKeyValuesCreateRequest creates the GetKeyValues request.
func (client *AzureAppConfigurationClient) getKeyValuesCreateRequest(ctx context.Context, options *AzureAppConfigurationClientGetKeyValuesOptions) (*policy.Request, error) {
	urlPath := "/kv"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Key != nil {
		reqQP.Set("key", *options.Key)
	}
	if options != nil && options.Label != nil {
		reqQP.Set("label", *options.Label)
	}
	reqQP.Set("api-version", "2023-10-01")
	if options != nil && options.After != nil {
		reqQP.Set("After", *options.After)
	}
	if options != nil && options.Select != nil {
		reqQP.Set("$Select", strings.Join(strings.Fields(strings.Trim(fmt.Sprint(options.Select), "[]")), ","))
	}
	if options != nil && options.Snapshot != nil {
		reqQP.Set("snapshot", *options.Snapshot)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if client.syncToken != nil {
		req.Raw().Header["Sync-Token"] = []string{*client.syncToken}
	}
	if options != nil && options.AcceptDatetime != nil {
		req.Raw().Header["Accept-Datetime"] = []string{*options.AcceptDatetime}
	}
	if options != nil && options.IfMatch != nil {
		req.Raw().Header["If-Match"] = []string{*options.IfMatch}
	}
	if options != nil && options.IfNoneMatch != nil {
		req.Raw().Header["If-None-Match"] = []string{*options.IfNoneMatch}
	}
	req.Raw().Header["Accept"] = []string{"application/vnd.microsoft.appconfig.kvset+json, application/problem+json"}
	return req, nil
}

// getKeyValuesHandleResponse handles the GetKeyValues response.
func (client *AzureAppConfigurationClient) getKeyValuesHandleResponse(resp *http.Response) (AzureAppConfigurationClientGetKeyValuesResponse, error) {
	result := AzureAppConfigurationClientGetKeyValuesResponse{}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Sync-Token"); val != "" {
		result.SyncToken = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyValueListResult); err != nil {
		return AzureAppConfigurationClientGetKeyValuesResponse{}, err
	}
	return result, nil
}

// NewGetKeysPager - Gets a list of keys.
//
// Generated from API version 2023-10-01
//   - options - AzureAppConfigurationClientGetKeysOptions contains the optional parameters for the AzureAppConfigurationClient.NewGetKeysPager
//     method.
func (client *AzureAppConfigurationClient) NewGetKeysPager(options *AzureAppConfigurationClientGetKeysOptions) *runtime.Pager[AzureAppConfigurationClientGetKeysResponse] {
	return runtime.NewPager(runtime.PagingHandler[AzureAppConfigurationClientGetKeysResponse]{
		More: func(page AzureAppConfigurationClientGetKeysResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *AzureAppConfigurationClientGetKeysResponse) (AzureAppConfigurationClientGetKeysResponse, error) {
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.getKeysCreateRequest(ctx, options)
			}, &runtime.FetcherForNextLinkOptions{
				NextReq: func(ctx context.Context, encodedNextLink string) (*policy.Request, error) {
					return client.getNextPageCreateRequest(ctx, encodedNextLink)
				},
			})
			if err != nil {
				return AzureAppConfigurationClientGetKeysResponse{}, err
			}
			return client.getKeysHandleResponse(resp)
		},
	})
}

// getKeysCreateRequest creates the GetKeys request.
func (client *AzureAppConfigurationClient) getKeysCreateRequest(ctx context.Context, options *AzureAppConfigurationClientGetKeysOptions) (*policy.Request, error) {
	urlPath := "/keys"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Name != nil {
		reqQP.Set("name", *options.Name)
	}
	reqQP.Set("api-version", "2023-10-01")
	if options != nil && options.After != nil {
		reqQP.Set("After", *options.After)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if client.syncToken != nil {
		req.Raw().Header["Sync-Token"] = []string{*client.syncToken}
	}
	if options != nil && options.AcceptDatetime != nil {
		req.Raw().Header["Accept-Datetime"] = []string{*options.AcceptDatetime}
	}
	req.Raw().Header["Accept"] = []string{"application/vnd.microsoft.appconfig.keyset+json, application/problem+json"}
	return req, nil
}

// getKeysHandleResponse handles the GetKeys response.
func (client *AzureAppConfigurationClient) getKeysHandleResponse(resp *http.Response) (AzureAppConfigurationClientGetKeysResponse, error) {
	result := AzureAppConfigurationClientGetKeysResponse{}
	if val := resp.Header.Get("Sync-Token"); val != "" {
		result.SyncToken = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyListResult); err != nil {
		return AzureAppConfigurationClientGetKeysResponse{}, err
	}
	return result, nil
}

// NewGetLabelsPager - Gets a list of labels.
//
// Generated from API version 2023-10-01
//   - options - AzureAppConfigurationClientGetLabelsOptions contains the optional parameters for the AzureAppConfigurationClient.NewGetLabelsPager
//     method.
func (client *AzureAppConfigurationClient) NewGetLabelsPager(options *AzureAppConfigurationClientGetLabelsOptions) *runtime.Pager[AzureAppConfigurationClientGetLabelsResponse] {
	return runtime.NewPager(runtime.PagingHandler[AzureAppConfigurationClientGetLabelsResponse]{
		More: func(page AzureAppConfigurationClientGetLabelsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *AzureAppConfigurationClientGetLabelsResponse) (AzureAppConfigurationClientGetLabelsResponse, error) {
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.getLabelsCreateRequest(ctx, options)
			}, &runtime.FetcherForNextLinkOptions{
				NextReq: func(ctx context.Context, encodedNextLink string) (*policy.Request, error) {
					return client.getNextPageCreateRequest(ctx, encodedNextLink)
				},
			})
			if err != nil {
				return AzureAppConfigurationClientGetLabelsResponse{}, err
			}
			return client.getLabelsHandleResponse(resp)
		},
	})
}

// getLabelsCreateRequest creates the GetLabels request.
func (client *AzureAppConfigurationClient) getLabelsCreateRequest(ctx context.Context, options *AzureAppConfigurationClientGetLabelsOptions) (*policy.Request, error) {
	urlPath := "/labels"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Name != nil {
		reqQP.Set("name", *options.Name)
	}
	reqQP.Set("api-version", "2023-10-01")
	if options != nil && options.After != nil {
		reqQP.Set("After", *options.After)
	}
	if options != nil && options.Select != nil {
		reqQP.Set("$Select", strings.Join(strings.Fields(strings.Trim(fmt.Sprint(options.Select), "[]")), ","))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if client.syncToken != nil {
		req.Raw().Header["Sync-Token"] = []string{*client.syncToken}
	}
	if options != nil && options.AcceptDatetime != nil {
		req.Raw().Header["Accept-Datetime"] = []string{*options.AcceptDatetime}
	}
	req.Raw().Header["Accept"] = []string{"application/vnd.microsoft.appconfig.labelset+json, application/problem+json"}
	return req, nil
}

// getLabelsHandleResponse handles the GetLabels response.
func (client *AzureAppConfigurationClient) getLabelsHandleResponse(resp *http.Response) (AzureAppConfigurationClientGetLabelsResponse, error) {
	result := AzureAppConfigurationClientGetLabelsResponse{}
	if val := resp.Header.Get("Sync-Token"); val != "" {
		result.SyncToken = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.LabelListResult); err != nil {
		return AzureAppConfigurationClientGetLabelsResponse{}, err
	}
	return result, nil
}

// GetOperationDetails - Gets the state of a long running operation.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01
//   - snapshot - Snapshot identifier for the long running operation.
//   - options - AzureAppConfigurationClientGetOperationDetailsOptions contains the optional parameters for the AzureAppConfigurationClient.GetOperationDetails
//     method.
func (client *AzureAppConfigurationClient) GetOperationDetails(ctx context.Context, snapshot string, options *AzureAppConfigurationClientGetOperationDetailsOptions) (AzureAppConfigurationClientGetOperationDetailsResponse, error) {
	var err error
	req, err := client.getOperationDetailsCreateRequest(ctx, snapshot, options)
	if err != nil {
		return AzureAppConfigurationClientGetOperationDetailsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AzureAppConfigurationClientGetOperationDetailsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AzureAppConfigurationClientGetOperationDetailsResponse{}, err
	}
	resp, err := client.getOperationDetailsHandleResponse(httpResp)
	return resp, err
}

// getOperationDetailsCreateRequest creates the GetOperationDetails request.
func (client *AzureAppConfigurationClient) getOperationDetailsCreateRequest(ctx context.Context, snapshot string, options *AzureAppConfigurationClientGetOperationDetailsOptions) (*policy.Request, error) {
	urlPath := "/operations"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-10-01")
	reqQP.Set("snapshot", snapshot)
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getOperationDetailsHandleResponse handles the GetOperationDetails response.
func (client *AzureAppConfigurationClient) getOperationDetailsHandleResponse(resp *http.Response) (AzureAppConfigurationClientGetOperationDetailsResponse, error) {
	result := AzureAppConfigurationClientGetOperationDetailsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.OperationDetails); err != nil {
		return AzureAppConfigurationClientGetOperationDetailsResponse{}, err
	}
	return result, nil
}

// NewGetRevisionsPager - Gets a list of key-value revisions.
//
// Generated from API version 2023-10-01
//   - options - AzureAppConfigurationClientGetRevisionsOptions contains the optional parameters for the AzureAppConfigurationClient.NewGetRevisionsPager
//     method.
func (client *AzureAppConfigurationClient) NewGetRevisionsPager(options *AzureAppConfigurationClientGetRevisionsOptions) *runtime.Pager[AzureAppConfigurationClientGetRevisionsResponse] {
	return runtime.NewPager(runtime.PagingHandler[AzureAppConfigurationClientGetRevisionsResponse]{
		More: func(page AzureAppConfigurationClientGetRevisionsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *AzureAppConfigurationClientGetRevisionsResponse) (AzureAppConfigurationClientGetRevisionsResponse, error) {
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.getRevisionsCreateRequest(ctx, options)
			}, &runtime.FetcherForNextLinkOptions{
				NextReq: func(ctx context.Context, encodedNextLink string) (*policy.Request, error) {
					return client.getNextPageCreateRequest(ctx, encodedNextLink)
				},
			})
			if err != nil {
				return AzureAppConfigurationClientGetRevisionsResponse{}, err
			}
			return client.getRevisionsHandleResponse(resp)
		},
	})
}

// getRevisionsCreateRequest creates the GetRevisions request.
func (client *AzureAppConfigurationClient) getRevisionsCreateRequest(ctx context.Context, options *AzureAppConfigurationClientGetRevisionsOptions) (*policy.Request, error) {
	urlPath := "/revisions"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Key != nil {
		reqQP.Set("key", *options.Key)
	}
	if options != nil && options.Label != nil {
		reqQP.Set("label", *options.Label)
	}
	reqQP.Set("api-version", "2023-10-01")
	if options != nil && options.After != nil {
		reqQP.Set("After", *options.After)
	}
	if options != nil && options.Select != nil {
		reqQP.Set("$Select", strings.Join(strings.Fields(strings.Trim(fmt.Sprint(options.Select), "[]")), ","))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if client.syncToken != nil {
		req.Raw().Header["Sync-Token"] = []string{*client.syncToken}
	}
	if options != nil && options.AcceptDatetime != nil {
		req.Raw().Header["Accept-Datetime"] = []string{*options.AcceptDatetime}
	}
	req.Raw().Header["Accept"] = []string{"application/vnd.microsoft.appconfig.kvset+json, application/problem+json"}
	return req, nil
}

// getRevisionsHandleResponse handles the GetRevisions response.
func (client *AzureAppConfigurationClient) getRevisionsHandleResponse(resp *http.Response) (AzureAppConfigurationClientGetRevisionsResponse, error) {
	result := AzureAppConfigurationClientGetRevisionsResponse{}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Sync-Token"); val != "" {
		result.SyncToken = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyValueListResult); err != nil {
		return AzureAppConfigurationClientGetRevisionsResponse{}, err
	}
	return result, nil
}

// GetSnapshot - Gets a single key-value snapshot.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01
//   - name - The name of the key-value snapshot to retrieve.
//   - options - AzureAppConfigurationClientGetSnapshotOptions contains the optional parameters for the AzureAppConfigurationClient.GetSnapshot
//     method.
func (client *AzureAppConfigurationClient) GetSnapshot(ctx context.Context, name string, options *AzureAppConfigurationClientGetSnapshotOptions) (AzureAppConfigurationClientGetSnapshotResponse, error) {
	var err error
	req, err := client.getSnapshotCreateRequest(ctx, name, options)
	if err != nil {
		return AzureAppConfigurationClientGetSnapshotResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AzureAppConfigurationClientGetSnapshotResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AzureAppConfigurationClientGetSnapshotResponse{}, err
	}
	resp, err := client.getSnapshotHandleResponse(httpResp)
	return resp, err
}

// getSnapshotCreateRequest creates the GetSnapshot request.
func (client *AzureAppConfigurationClient) getSnapshotCreateRequest(ctx context.Context, name string, options *AzureAppConfigurationClientGetSnapshotOptions) (*policy.Request, error) {
	urlPath := "/snapshots/{name}"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-10-01")
	if options != nil && options.Select != nil {
		reqQP.Set("$Select", strings.Join(strings.Fields(strings.Trim(fmt.Sprint(options.Select), "[]")), ","))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if client.syncToken != nil {
		req.Raw().Header["Sync-Token"] = []string{*client.syncToken}
	}
	if options != nil && options.IfMatch != nil {
		req.Raw().Header["If-Match"] = []string{*options.IfMatch}
	}
	if options != nil && options.IfNoneMatch != nil {
		req.Raw().Header["If-None-Match"] = []string{*options.IfNoneMatch}
	}
	req.Raw().Header["Accept"] = []string{"application/vnd.microsoft.appconfig.snapshot+json, application/problem+json"}
	return req, nil
}

// getSnapshotHandleResponse handles the GetSnapshot response.
func (client *AzureAppConfigurationClient) getSnapshotHandleResponse(resp *http.Response) (AzureAppConfigurationClientGetSnapshotResponse, error) {
	result := AzureAppConfigurationClientGetSnapshotResponse{}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Link"); val != "" {
		result.Link = &val
	}
	if val := resp.Header.Get("Sync-Token"); val != "" {
		result.SyncToken = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.Snapshot); err != nil {
		return AzureAppConfigurationClientGetSnapshotResponse{}, err
	}
	return result, nil
}

// NewGetSnapshotsPager - Gets a list of key-value snapshots.
//
// Generated from API version 2023-10-01
//   - options - AzureAppConfigurationClientGetSnapshotsOptions contains the optional parameters for the AzureAppConfigurationClient.NewGetSnapshotsPager
//     method.
func (client *AzureAppConfigurationClient) NewGetSnapshotsPager(options *AzureAppConfigurationClientGetSnapshotsOptions) *runtime.Pager[AzureAppConfigurationClientGetSnapshotsResponse] {
	return runtime.NewPager(runtime.PagingHandler[AzureAppConfigurationClientGetSnapshotsResponse]{
		More: func(page AzureAppConfigurationClientGetSnapshotsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *AzureAppConfigurationClientGetSnapshotsResponse) (AzureAppConfigurationClientGetSnapshotsResponse, error) {
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.getSnapshotsCreateRequest(ctx, options)
			}, &runtime.FetcherForNextLinkOptions{
				NextReq: func(ctx context.Context, encodedNextLink string) (*policy.Request, error) {
					return client.getNextPageCreateRequest(ctx, encodedNextLink)
				},
			})
			if err != nil {
				return AzureAppConfigurationClientGetSnapshotsResponse{}, err
			}
			return client.getSnapshotsHandleResponse(resp)
		},
	})
}

// getSnapshotsCreateRequest creates the GetSnapshots request.
func (client *AzureAppConfigurationClient) getSnapshotsCreateRequest(ctx context.Context, options *AzureAppConfigurationClientGetSnapshotsOptions) (*policy.Request, error) {
	urlPath := "/snapshots"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Name != nil {
		reqQP.Set("name", *options.Name)
	}
	reqQP.Set("api-version", "2023-10-01")
	if options != nil && options.After != nil {
		reqQP.Set("After", *options.After)
	}
	if options != nil && options.Select != nil {
		reqQP.Set("$Select", strings.Join(strings.Fields(strings.Trim(fmt.Sprint(options.Select), "[]")), ","))
	}
	if options != nil && options.Status != nil {
		reqQP.Set("status", strings.Join(strings.Fields(strings.Trim(fmt.Sprint(options.Status), "[]")), ","))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if client.syncToken != nil {
		req.Raw().Header["Sync-Token"] = []string{*client.syncToken}
	}
	req.Raw().Header["Accept"] = []string{"application/vnd.microsoft.appconfig.snapshotset+json, application/problem+json"}
	return req, nil
}

// getSnapshotsHandleResponse handles the GetSnapshots response.
func (client *AzureAppConfigurationClient) getSnapshotsHandleResponse(resp *http.Response) (AzureAppConfigurationClientGetSnapshotsResponse, error) {
	result := AzureAppConfigurationClientGetSnapshotsResponse{}
	if val := resp.Header.Get("Sync-Token"); val != "" {
		result.SyncToken = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.SnapshotListResult); err != nil {
		return AzureAppConfigurationClientGetSnapshotsResponse{}, err
	}
	return result, nil
}

// PutKeyValue - Creates a key-value.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01
//   - key - The key of the key-value to create.
//   - entity - The key-value to create.
//   - options - AzureAppConfigurationClientPutKeyValueOptions contains the optional parameters for the AzureAppConfigurationClient.PutKeyValue
//     method.
func (client *AzureAppConfigurationClient) PutKeyValue(ctx context.Context, key string, entity KeyValue, options *AzureAppConfigurationClientPutKeyValueOptions) (AzureAppConfigurationClientPutKeyValueResponse, error) {
	var err error
	req, err := client.putKeyValueCreateRequest(ctx, key, entity, options)
	if err != nil {
		return AzureAppConfigurationClientPutKeyValueResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AzureAppConfigurationClientPutKeyValueResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AzureAppConfigurationClientPutKeyValueResponse{}, err
	}
	resp, err := client.putKeyValueHandleResponse(httpResp)
	return resp, err
}

// putKeyValueCreateRequest creates the PutKeyValue request.
func (client *AzureAppConfigurationClient) putKeyValueCreateRequest(ctx context.Context, key string, entity KeyValue, options *AzureAppConfigurationClientPutKeyValueOptions) (*policy.Request, error) {
	urlPath := "/kv/{key}"
	if key == "" {
		return nil, errors.New("parameter key cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key}", url.PathEscape(key))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Label != nil {
		reqQP.Set("label", *options.Label)
	}
	reqQP.Set("api-version", "2023-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	if client.syncToken != nil {
		req.Raw().Header["Sync-Token"] = []string{*client.syncToken}
	}
	if options != nil && options.IfMatch != nil {
		req.Raw().Header["If-Match"] = []string{*options.IfMatch}
	}
	if options != nil && options.IfNoneMatch != nil {
		req.Raw().Header["If-None-Match"] = []string{*options.IfNoneMatch}
	}
	req.Raw().Header["Accept"] = []string{"application/vnd.microsoft.appconfig.kv+json, application/problem+json"}
	if err := runtime.MarshalAsJSON(req, entity); err != nil {
		return nil, err
	}
	return req, nil
}

// putKeyValueHandleResponse handles the PutKeyValue response.
func (client *AzureAppConfigurationClient) putKeyValueHandleResponse(resp *http.Response) (AzureAppConfigurationClientPutKeyValueResponse, error) {
	result := AzureAppConfigurationClientPutKeyValueResponse{}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Sync-Token"); val != "" {
		result.SyncToken = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyValue); err != nil {
		return AzureAppConfigurationClientPutKeyValueResponse{}, err
	}
	return result, nil
}

// PutLock - Locks a key-value.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01
//   - key - The key of the key-value to lock.
//   - options - AzureAppConfigurationClientPutLockOptions contains the optional parameters for the AzureAppConfigurationClient.PutLock
//     method.
func (client *AzureAppConfigurationClient) PutLock(ctx context.Context, key string, options *AzureAppConfigurationClientPutLockOptions) (AzureAppConfigurationClientPutLockResponse, error) {
	var err error
	req, err := client.putLockCreateRequest(ctx, key, options)
	if err != nil {
		return AzureAppConfigurationClientPutLockResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AzureAppConfigurationClientPutLockResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AzureAppConfigurationClientPutLockResponse{}, err
	}
	resp, err := client.putLockHandleResponse(httpResp)
	return resp, err
}

// putLockCreateRequest creates the PutLock request.
func (client *AzureAppConfigurationClient) putLockCreateRequest(ctx context.Context, key string, options *AzureAppConfigurationClientPutLockOptions) (*policy.Request, error) {
	urlPath := "/locks/{key}"
	if key == "" {
		return nil, errors.New("parameter key cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key}", url.PathEscape(key))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Label != nil {
		reqQP.Set("label", *options.Label)
	}
	reqQP.Set("api-version", "2023-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	if client.syncToken != nil {
		req.Raw().Header["Sync-Token"] = []string{*client.syncToken}
	}
	if options != nil && options.IfMatch != nil {
		req.Raw().Header["If-Match"] = []string{*options.IfMatch}
	}
	if options != nil && options.IfNoneMatch != nil {
		req.Raw().Header["If-None-Match"] = []string{*options.IfNoneMatch}
	}
	req.Raw().Header["Accept"] = []string{"application/vnd.microsoft.appconfig.kv+json, application/problem+json"}
	return req, nil
}

// putLockHandleResponse handles the PutLock response.
func (client *AzureAppConfigurationClient) putLockHandleResponse(resp *http.Response) (AzureAppConfigurationClientPutLockResponse, error) {
	result := AzureAppConfigurationClientPutLockResponse{}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Sync-Token"); val != "" {
		result.SyncToken = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyValue); err != nil {
		return AzureAppConfigurationClientPutLockResponse{}, err
	}
	return result, nil
}

// UpdateSnapshot - Updates the state of a key-value snapshot.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01
//   - name - The name of the key-value snapshot to update.
//   - entity - The parameters used to update the snapshot.
//   - options - AzureAppConfigurationClientUpdateSnapshotOptions contains the optional parameters for the AzureAppConfigurationClient.UpdateSnapshot
//     method.
func (client *AzureAppConfigurationClient) UpdateSnapshot(ctx context.Context, name string, entity SnapshotUpdateParameters, options *AzureAppConfigurationClientUpdateSnapshotOptions) (AzureAppConfigurationClientUpdateSnapshotResponse, error) {
	var err error
	req, err := client.updateSnapshotCreateRequest(ctx, name, entity, options)
	if err != nil {
		return AzureAppConfigurationClientUpdateSnapshotResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AzureAppConfigurationClientUpdateSnapshotResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AzureAppConfigurationClientUpdateSnapshotResponse{}, err
	}
	resp, err := client.updateSnapshotHandleResponse(httpResp)
	return resp, err
}

// updateSnapshotCreateRequest creates the UpdateSnapshot request.
func (client *AzureAppConfigurationClient) updateSnapshotCreateRequest(ctx context.Context, name string, entity SnapshotUpdateParameters, options *AzureAppConfigurationClientUpdateSnapshotOptions) (*policy.Request, error) {
	urlPath := "/snapshots/{name}"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	if client.syncToken != nil {
		req.Raw().Header["Sync-Token"] = []string{*client.syncToken}
	}
	if options != nil && options.IfMatch != nil {
		req.Raw().Header["If-Match"] = []string{*options.IfMatch}
	}
	if options != nil && options.IfNoneMatch != nil {
		req.Raw().Header["If-None-Match"] = []string{*options.IfNoneMatch}
	}
	req.Raw().Header["Accept"] = []string{"application/vnd.microsoft.appconfig.snapshot+json, application/problem+json"}
	if err := runtime.MarshalAsJSON(req, entity); err != nil {
		return nil, err
	}
	return req, nil
}

// updateSnapshotHandleResponse handles the UpdateSnapshot response.
func (client *AzureAppConfigurationClient) updateSnapshotHandleResponse(resp *http.Response) (AzureAppConfigurationClientUpdateSnapshotResponse, error) {
	result := AzureAppConfigurationClientUpdateSnapshotResponse{}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Link"); val != "" {
		result.Link = &val
	}
	if val := resp.Header.Get("Sync-Token"); val != "" {
		result.SyncToken = &val
	}
	if err := runtime.UnmarshalAsJSON(resp, &result.Snapshot); err != nil {
		return AzureAppConfigurationClientUpdateSnapshotResponse{}, err
	}
	return result, nil
}

// getNextPageCreateRequest creates the getNextPageCreateRequest request.
func (client *AzureAppConfigurationClient) getNextPageCreateRequest(ctx context.Context, nextLink string) (*policy.Request, error) {
	urlPath := "/{nextLink}"
	urlPath = strings.ReplaceAll(urlPath, "{nextLink}", nextLink)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}
