"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OtGeometryTraverse = void 0;
const ot_glyph_1 = require("../ot-glyph");
class OtTransformedGeometrySink {
    constructor(sink, transform) {
        this.sink = sink;
        this.transform = transform;
    }
    beginContour() {
        this.sink.beginContour();
    }
    addControlKnot(knot) {
        this.sink.addControlKnot(ot_glyph_1.OtGlyph.PointOps.applyTransform(knot, this.transform));
    }
    endContour() {
        this.sink.endContour();
    }
    getResult() {
        return this.sink.getResult();
    }
}
class OtGeometryTraverse {
    constructor(sink) {
        this.sink = sink;
    }
    process(geom) {
        switch (geom.type) {
            case ot_glyph_1.OtGlyph.GeometryType.ContourSet: {
                for (const c of geom.contours) {
                    this.sink.beginContour();
                    for (const z of c) {
                        this.sink.addControlKnot(z);
                    }
                    this.sink.endContour();
                }
                break;
            }
            case ot_glyph_1.OtGlyph.GeometryType.TtReference: {
                const sub = new OtGeometryTraverse(new OtTransformedGeometrySink(this.sink, geom.transform));
                if (geom.to.geometry)
                    sub.process(geom.to.geometry);
                break;
            }
            case ot_glyph_1.OtGlyph.GeometryType.GeometryList: {
                for (const item of geom.items)
                    this.process(item);
                break;
            }
        }
    }
}
exports.OtGeometryTraverse = OtGeometryTraverse;
//# sourceMappingURL=shared.js.map