import { SfntIoTableSink } from "@ot-builder/io-bin-sfnt";
import { TtfWritingExtraInfoSink } from "@ot-builder/io-bin-ttf";
import { OtGlyph } from "@ot-builder/ot-glyphs";
import { Head, Maxp, OtFontMetadata } from "@ot-builder/ot-metadata";
import { Data } from "@ot-builder/prelude";
import { OtVar } from "@ot-builder/variance";
import { GlyphStoreCfg } from "../cfg/glyph-store-cfg";
export type GlyphStoreWriteExtraInfoSink = TtfWritingExtraInfoSink;
export type GlyphStoreWriteImplCtx = {
    head: Head.Table;
    maxp: Maxp.Table;
    designSpace?: Data.Maybe<OtVar.DesignSpace>;
    stat: OtGlyph.Stat.Sink;
    extraInfoSink: GlyphStoreWriteExtraInfoSink;
};
export interface WriteGlyphStoreImpl<C, T> {
    readonly writeMetricVariance: boolean;
    writeGlyphs(sink: SfntIoTableSink, cfg: C, coGlyphs: T, gOrd: Data.Order<OtGlyph>, ctx: GlyphStoreWriteImplCtx): void;
}
export declare function writeGlyphStore<C, T>(sink: SfntIoTableSink, cfg: C & GlyphStoreCfg, md: OtFontMetadata, coGlyphs: T, gOrd: Data.Order<OtGlyph>, extraInfoSink: GlyphStoreWriteExtraInfoSink, cb: WriteGlyphStoreImpl<C, T>): void;
//# sourceMappingURL=write.d.ts.map