import { Data } from "@ot-builder/prelude";
export type Operator = {
    opCode: number;
    flags?: Data.Maybe<number[]>;
};
export type Operand = {
    t: number;
};
export type IR = Operator | Operand;
export declare function isOperator(ir: IR): ir is Operator;
export declare function operand(x: number): Operand;
export declare function operator(x: number, flags?: Data.Maybe<number[]>): Operator;
export declare abstract class Interpreter {
    protected abstract doOperand(op: number): void;
    protected abstract doOperator(opCode: number, flags?: Data.Maybe<number[]>): void;
    operand(...xs: number[]): this;
    operator(opCode: number, flags?: number[]): this;
    next(ir: IR): void;
}
export declare abstract class Encoder<Sink> {
    protected abstract operand(op: number): void;
    protected abstract operator(opCode: number, flags?: Data.Maybe<number[]>): void;
    push(ir: IR): void;
}
export interface IrSource {
    next(): IR | null;
}
export interface IrFlagPuller {
    pullFlags(n: number): number[];
}
//# sourceMappingURL=ir.d.ts.map