"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createKit_Echo = createKit_Echo;
const console_styles_1 = require("../reporter/console-styles");
function createKit_Echo(ce) {
    const echoFn = Object.assign(function (...args) {
        ce.reporter.echo(...args);
    }, {
        debug: (...args) => ce.reporter.debug(...args),
        info: (...args) => ce.reporter.info(...args),
        warn: (...args) => ce.reporter.warn(...args),
        echo: (...args) => ce.reporter.echo(...args),
        note: (...args) => ce.reporter.note(...args),
        action: (...args) => ce.reporter.actions([args]),
        success: (...args) => ce.reporter.success(...args),
        fail: (...args) => ce.reporter.fail(...args),
        error: (...args) => ce.reporter.error(...args),
        fatal: (...args) => ce.reporter.fatal(...args),
        hl: {
            directive: (s) => new console_styles_1.HighlightedRun("directive", s),
            operator: (s) => new console_styles_1.HighlightedRun("operator", s),
            command: (s) => new console_styles_1.HighlightedRun("command", s),
            param: (s) => new console_styles_1.HighlightedRun("param", s),
            quote: (s) => new console_styles_1.HighlightedRun("quote", s),
            numeric: (s) => new console_styles_1.HighlightedRun("numeric", s),
        },
    });
    return {
        echo: echoFn,
    };
}
