#ifndef NUMINPUTDIALOG_H
#define NUMINPUTDIALOG_H

#include <cstdlib>
#include <sstream>

#include <gtkmm/box.h>
#include <gtkmm/dialog.h>
#include <gtkmm/entry.h>
#include <gtkmm/label.h>

class NumInputDialog : public Gtk::Dialog {
 public:
  NumInputDialog(const Glib::ustring& title, Gtk::Window& parent,
                 const Glib::ustring& valueCaption, double defaultValue)
      : Dialog(title, parent, true), _label(valueCaption) {
    _hBox.append(_label);

    std::ostringstream s;
    s << defaultValue;
    _entry.set_text(s.str());
    _entry.set_activates_default(true);
    _hBox.append(_entry);

    get_content_area()->append(_hBox);

    add_button("_Ok", Gtk::ResponseType::OK);
    add_button("_Cancel", Gtk::ResponseType::CANCEL);
    set_default_response(Gtk::ResponseType::OK);
  }

  double Value() const { return atof(_entry.get_text().c_str()); }

 private:
  Gtk::Label _label;
  Gtk::Entry _entry;
  Gtk::Box _hBox;
};

#endif  // NUMINPUTDIALOG_H
