if (typeof exports !== "undefined") {
  var test = require("./driver.js").test
  var testFail = require("./driver.js").testFail
}

test("/a/v", {}, { ecmaVersion: 2024 })
testFail("/a/v", "Invalid regular expression flag (1:1)", { ecmaVersion: 2023 })
testFail("/a/uv", "Invalid regular expression flag (1:1)", { ecmaVersion: 2024 })
test("/[]/v", {}, { ecmaVersion: 2024 })
test("/[^]/v", {}, { ecmaVersion: 2024 })
test("/[&]/v", {}, { ecmaVersion: 2024 })
test("/[\\b]/v", {}, { ecmaVersion: 2024 })
test("/[\\&]/v", {}, { ecmaVersion: 2024 })
testFail("/[\\z]/v", "Invalid regular expression: /[\\z]/: Invalid character in character class (1:1)", { ecmaVersion: 2024 })
testFail("/[a\\z]/v", "Invalid regular expression: /[a\\z]/: Unterminated character class (1:1)", { ecmaVersion: 2024 })
// Union
test("/[abc]/v", {}, { ecmaVersion: 2024 })
test("/[a-c]/v", {}, { ecmaVersion: 2024 })
test("/[a-bc]/v", {}, { ecmaVersion: 2024 })
test("/[ab-c]/v", {}, { ecmaVersion: 2024 })
testFail("/[c-a]/v", "Invalid regular expression: /[c-a]/: Range out of order in character class (1:1)", { ecmaVersion: 2024 })
testFail("/[a-\\b]/v", "Invalid regular expression: /[a-\\b]/: Range out of order in character class (1:1)", { ecmaVersion: 2024 })
// Expression
test("/[a&&b]/v", {}, { ecmaVersion: 2024 })
test("/[a--b]/v", {}, { ecmaVersion: 2024 })
test("/[a&&b&&c]/v", {}, { ecmaVersion: 2024 })
test("/[a--b--c]/v", {}, { ecmaVersion: 2024 })
testFail("/[a--]/v", "Invalid regular expression: /[a--]/: Invalid character in character class (1:1)", { ecmaVersion: 2024 })
testFail("/[a&&]/v", "Invalid regular expression: /[a&&]/: Invalid character in character class (1:1)", { ecmaVersion: 2024 })
testFail("/[a--b&&c]/v", "Invalid regular expression: /[a--b&&c]/: Unterminated character class (1:1)", { ecmaVersion: 2024 })
testFail("/[a&&b--c]/v", "Invalid regular expression: /[a&&b--c]/: Unterminated character class (1:1)", { ecmaVersion: 2024 })
testFail("/[a&&&]/v", "Invalid regular expression: /[a&&&]/: Invalid character in character class (1:1)", { ecmaVersion: 2024 })
testFail("/[a&&b&&]/v", "Invalid regular expression: /[a&&b&&]/: Invalid character in character class (1:1)", { ecmaVersion: 2024 })
testFail("/[a--b--]/v", "Invalid regular expression: /[a--b--]/: Invalid character in character class (1:1)", { ecmaVersion: 2024 })
test("/[a&&\\&]/v", {}, { ecmaVersion: 2024 })
testFail("/[&&]/v", "Invalid regular expression: /[&&]/: Invalid character in character class (1:1)", { ecmaVersion: 2024 })
testFail("/[!!]/v", "Invalid regular expression: /[!!]/: Invalid character in character class (1:1)", { ecmaVersion: 2024 })
testFail("/[##]/v", "Invalid regular expression: /[##]/: Invalid character in character class (1:1)", { ecmaVersion: 2024 })
testFail("/[--]/v", "Invalid regular expression: /[--]/: Invalid character in character class (1:1)", { ecmaVersion: 2024 })
// Nested
test("/[[a&&b]--[c&&d]]/v", {}, { ecmaVersion: 2024 })
test("/[[a--b]&&[c--d]]/v", {}, { ecmaVersion: 2024 })
test("/[[a&&b][c--d][ef]]/v", {}, { ecmaVersion: 2024 })
// Class String
test("/[\\q{a|b}]/v", {}, { ecmaVersion: 2024 })
test("/[\\q{abc}]/v", {}, { ecmaVersion: 2024 })
test("/[\\q{}]/v", {}, { ecmaVersion: 2024 })
test("/[\\q{abc|def}]/v", {}, { ecmaVersion: 2024 })
test("/[\\q{abc|d|ef}]/v", {}, { ecmaVersion: 2024 })
test("/[\\q{|||abc||||}]/v", {}, { ecmaVersion: 2024 })
testFail("/\\q{a|b}/v", "Invalid regular expression: /\\q{a|b}/: Invalid escape (1:1)", { ecmaVersion: 2024 })
testFail("/[\\q{a|b]/v", "Invalid regular expression: /[\\q{a|b]/: Invalid character in character class (1:1)", { ecmaVersion: 2024 })
testFail("/[\\q{a|b}]/u", "Invalid regular expression: /[\\q{a|b}]/: Invalid escape (1:1)", { ecmaVersion: 2024 })
// Unicode binary properties of strings
test("/\\p{Basic_Emoji}/v", {}, { ecmaVersion: 2024 })
testFail("/\\p{Basic_Emoji}/u", "Invalid regular expression: /\\p{Basic_Emoji}/: Invalid property name (1:1)", { ecmaVersion: 2024 })
test("/\\p{Basic_Emoji}/", {}, { ecmaVersion: 2024 }) // Non unicode binary properties of strings
// MayContainStrings
testFail("/\\P{Basic_Emoji}/v", "Invalid regular expression: /\\P{Basic_Emoji}/: Invalid property name (1:1)", { ecmaVersion: 2024 })
test("/\\p{ASCII}/v", {}, { ecmaVersion: 2024 })
test("/\\P{General_Category=Letter}/v", {}, { ecmaVersion: 2024 })
testFail("/[^\\p{Basic_Emoji}]/v", "Invalid regular expression: /[^\\p{Basic_Emoji}]/: Negated character class may contain strings (1:1)", { ecmaVersion: 2024 })
testFail("/[^[\\p{Basic_Emoji}]]/v", "Invalid regular expression: /[^[\\p{Basic_Emoji}]]/: Negated character class may contain strings (1:1)", { ecmaVersion: 2024 })
test("/[^\\d]/v", {}, { ecmaVersion: 2024 })
test("/[^\\D]/v", {}, { ecmaVersion: 2024 })
test("/[^\\s]/v", {}, { ecmaVersion: 2024 })
test("/[^\\S]/v", {}, { ecmaVersion: 2024 })
test("/[^\\w]/v", {}, { ecmaVersion: 2024 })
test("/[^\\W]/v", {}, { ecmaVersion: 2024 })
test("/[^\\p{ASCII}]/v", {}, { ecmaVersion: 2024 })
test("/[^\\p{General_Category=Letter}]/v", {}, { ecmaVersion: 2024 })
test("/[^[^\\p{ASCII}]]/v", {}, { ecmaVersion: 2024 })
test("/[\\p{Basic_Emoji}][^]/v", {}, { ecmaVersion: 2024 })
test("/[^[\\p{ASCII}]]/v", {}, { ecmaVersion: 2024 })
test("/[^\\q{a}]/v", {}, { ecmaVersion: 2024 })
test("/[^\\q{a|b}]/v", {}, { ecmaVersion: 2024 })
testFail("/[^\\q{}]/v", "Invalid regular expression: /[^\\q{}]/: Negated character class may contain strings (1:1)", { ecmaVersion: 2024 })
testFail("/[^\\q{ab}]/v", "Invalid regular expression: /[^\\q{ab}]/: Negated character class may contain strings (1:1)", { ecmaVersion: 2024 })
testFail("/[^\\q{a|bc}]/v", "Invalid regular expression: /[^\\q{a|bc}]/: Negated character class may contain strings (1:1)", { ecmaVersion: 2024 })
test("/[^\\q{a}\\q{b}]/v", {}, { ecmaVersion: 2024 })
testFail("/[^\\q{a}\\q{bc}]/v", "Invalid regular expression: /[^\\q{a}\\q{bc}]/: Negated character class may contain strings (1:1)", { ecmaVersion: 2024 })
test("/[^\\q{a}&&\\q{bc}]/v", {}, { ecmaVersion: 2024 })
test("/[^\\q{ab}&&\\q{c}]/v", {}, { ecmaVersion: 2024 })
testFail("/[^\\q{ab}&&\\q{cd}]/v", "Invalid regular expression: /[^\\q{ab}&&\\q{cd}]/: Negated character class may contain strings (1:1)", { ecmaVersion: 2024 })
test("/[^\\q{a}--\\q{bc}]/v", {}, { ecmaVersion: 2024 })
testFail("/[^\\q{ab}--\\q{c}]/v", "Invalid regular expression: /[^\\q{ab}--\\q{c}]/: Negated character class may contain strings (1:1)", { ecmaVersion: 2024 })
