use core;
use core:debug;

// No fancy syntax, makes debugging of core issues easier!

class Foo {
    Int a;
    Int b;

    Int foo() {
		a - b;
    }

    void set() {
		a = 10;
		b = 7;
    }
}

Int createFoo() {
	Foo z;
    Foo v = Foo();
    v.set;
	z = v;
	z.foo;
}

Int foo(Int p) {
    p - 2;
	// Comments after as well?
	// Works, right?
}

Int bar() {
    var z = 1; var v = 2 * 2;
    foo(z + v);
}

Int ifTest(Int v) {
    // Let's assume comments work!
	// Multiline as well!
    if (v == 1) {
       3;
    } else if (v == 2) {
       4;
    } else {
       5;
    }
}

Int ifTest2(Int v) {
    if ((Int z = v + 1) > 1) {
       z;
    } else {
       v - 1;
    }
}

Int ifTest3(Int v) {
	Int r = 10;
	if (v == 1)
		r = r + 10;
	r;
}

Int ifTest4(Int v) {
	Dbg a(10);
	Dbg b(20);
	if (v == 0)
		a.get;
	else
		b.get;
}

Int ifTest5(Int v) {
	7 + if (v == 3) 4; else 5; + 3;
}

Int assign(Int v) {
    Int z = v;
    if (z == 1) {
       z = 2;
    }
    z;
}

Int while(Int z) {
    Int r = 1;
    while (z > 0) {
        r = r * 2;
		z = z - 1;
    }
    r;
}

Int for(Int z) {
    Int r = 1;
	for (Int i = 0; i < z; i++) {
        r = r * 2;
    }
    r;
}

Int forError(Int z) {
	// For some reason, this did not work at some point in time!
	// It was because the stack was not properly aligned due to the bool variable in the for loop.
	throwError;
	Int r = 1;
	for (Int i = 0; i < z; i++) {
		r = r * 2;
	}
	r;
}

Dbg loopTarget() {
	Dbg(10);
}

// Earlier, the scoping was wrong in the for loop, so as long as this one does not leak memory, it is fine.
void forScope() {
	for (Int i = 0; i < loopTarget.get; i++) {
		// Nothing
	}

	Int z = 0;
	while (z < loopTarget.get) {
		z++;
	}
}

// Make sure we do not destroy any variables inside the loop when exiting the loop.
void forScopeVal() {
	for (Int i = 0; i < 10; i++) {
		DbgVal v(i);
	}

	Int z = 0;
	while (z < 10) {
		DbgVal v(z);
		z++;
	}
}

// Loop variants.
Int loop1() {
	Int r = 1;
	Int i = 0;

	while (i < 10) {
		r += r;
		i++;
	}

	r;
}

Int loop2() {
	Int r = 0;
	Int i = 0;

	do {
		r++;
		i++;
	} while (i < 10) {
		r += r;
	}

	r;
}

Int loop3() {
	Int r = 1;
	Int i = 0;

	do {
		r += r;
		i++;
	} while (i < 10);

	r;
}

Int loop4() {
	Int r = 1;
	do
		Int z = r * 2;
	while (z < 20)
		r += z;

	r;
}

Int loop5() {
	Int r = 1;
	do {
		Int z = r * 2;
	} while (z < 20) {
		r += z;
	}

	r;
}

void voidFn() {
    // Make sure we can return 'void'.
    3;
}

void emptyVoidFn() {}

Int testCtor() {
	Dbg b(20);
	b.get;
}

Int testIntCtor() {
	Int z(20);
	z;
}
