// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from DsamManager.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.dsam {
  public class DsamManager : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("dsam.DsamManager:1.0.0", null);

    public DsamManager(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public DsamManager(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new DsamManager StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new DsamManager(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public class DsamAttachedEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("dsam.DsamManager.DsamAttachedEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public Com.Raritan.Idl.dsam.DsamDevice.Info info = new Com.Raritan.Idl.dsam.DsamDevice.Info();
      public Com.Raritan.Idl.dsam.DsamDevice device = null;
    }

    public class DsamDetachedEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("dsam.DsamManager.DsamDetachedEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public Com.Raritan.Idl.dsam.DsamDevice.Info info = new Com.Raritan.Idl.dsam.DsamDevice.Info();
    }

    public class DsamControllerChangedEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("dsam.DsamManager.DsamControllerChangedEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public int dsamNumber = 0;
      public bool reset = false;
      public string resetReason = "";
    }

    public class GetDsamDevicesResult {
      public System.Collections.Generic.IDictionary<int, Com.Raritan.Idl.dsam.DsamDevice> _ret_;
    }

    public GetDsamDevicesResult getDsamDevices() {
      JsonObject _parameters = null;
      var _result = RpcCall("getDsamDevices", _parameters);
      var _ret = new GetDsamDevicesResult();
      _ret._ret_ = DictionaryHelper.Create(_result["_ret_"].AsJsonArray.Select(
        _value => new System.Collections.Generic.KeyValuePair<int, Com.Raritan.Idl.dsam.DsamDevice>(_value["key"], Com.Raritan.Idl.dsam.DsamDevice.StaticCast(ObjectProxy.Decode(_value["value"], agent)))));
      return _ret;
    }

    public AsyncRequest getDsamDevices(AsyncRpcResponse<GetDsamDevicesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getDsamDevices(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getDsamDevices(AsyncRpcResponse<GetDsamDevicesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getDsamDevices", _parameters,
        _result => {
          try {
            var _ret = new GetDsamDevicesResult();
            _ret._ret_ = DictionaryHelper.Create(_result["_ret_"].AsJsonArray.Select(
              _value => new System.Collections.Generic.KeyValuePair<int, Com.Raritan.Idl.dsam.DsamDevice>(_value["key"], Com.Raritan.Idl.dsam.DsamDevice.StaticCast(ObjectProxy.Decode(_value["value"], agent)))));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetFirmwareUpdateFileVersionResult {
      public Com.Raritan.Idl.dsam.DsamDevice.FirmwareVersion _ret_;
    }

    public GetFirmwareUpdateFileVersionResult getFirmwareUpdateFileVersion() {
      JsonObject _parameters = null;
      var _result = RpcCall("getFirmwareUpdateFileVersion", _parameters);
      var _ret = new GetFirmwareUpdateFileVersionResult();
      _ret._ret_ = Com.Raritan.Idl.dsam.DsamDevice.FirmwareVersion.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getFirmwareUpdateFileVersion(AsyncRpcResponse<GetFirmwareUpdateFileVersionResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getFirmwareUpdateFileVersion(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getFirmwareUpdateFileVersion(AsyncRpcResponse<GetFirmwareUpdateFileVersionResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getFirmwareUpdateFileVersion", _parameters,
        _result => {
          try {
            var _ret = new GetFirmwareUpdateFileVersionResult();
            _ret._ret_ = Com.Raritan.Idl.dsam.DsamDevice.FirmwareVersion.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
