% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unnest-longer.R
\name{unnest_longer}
\alias{unnest_longer}
\title{Unnest a list-column into rows}
\usage{
unnest_longer(
  data,
  col,
  values_to = NULL,
  indices_to = NULL,
  indices_include = NULL,
  keep_empty = FALSE,
  names_repair = "check_unique",
  simplify = TRUE,
  ptype = NULL,
  transform = NULL
)
}
\arguments{
\item{data}{A data frame.}

\item{col}{<\code{\link[=tidyr_tidy_select]{tidy-select}}> List-column(s) to unnest.

When selecting multiple columns, values from the same row will be recycled
to their common size.}

\item{values_to}{A string giving the column name (or names) to store the
unnested values in. If multiple columns are specified in \code{col}, this can
also be a glue string containing \code{"{col}"} to provide a template for the
column names. The default, \code{NULL}, gives the output columns the same names
as the input columns.}

\item{indices_to}{A string giving the column name (or names) to store the
inner names or positions (if not named) of the values. If multiple columns
are specified in \code{col}, this can also be a glue string containing \code{"{col}"}
to provide a template for the column names. The default, \code{NULL}, gives the
output columns the same names as \code{values_to}, but suffixed with \code{"_id"}.}

\item{indices_include}{A single logical value specifying whether or not to
add an index column. If any value has inner names, the index column will be
a character vector of those names, otherwise it will be an integer vector
of positions. If \code{NULL}, defaults to \code{TRUE} if any value has inner names
or if \code{indices_to} is provided.

If \code{indices_to} is provided, then \code{indices_include} can't be \code{FALSE}.}

\item{keep_empty}{By default, you get one row of output for each element
of the list that you are unchopping/unnesting. This means that if there's a
size-0 element (like \code{NULL} or an empty data frame or vector), then that
entire row will be dropped from the output. If you want to preserve all
rows, use \code{keep_empty = TRUE} to replace size-0 elements with a single row
of missing values.}

\item{names_repair}{Used to check that output data frame has valid
names. Must be one of the following options:
\itemize{
\item \verb{"minimal}": no name repair or checks, beyond basic existence,
\item \verb{"unique}": make sure names are unique and not empty,
\item \verb{"check_unique}": (the default), no name repair, but check they are unique,
\item \verb{"universal}": make the names unique and syntactic
\item a function: apply custom name repair.
\item \link{tidyr_legacy}: use the name repair from tidyr 0.8.
\item a formula: a purrr-style anonymous function (see \code{\link[rlang:as_function]{rlang::as_function()}})
}

See \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}} for more details on these terms and the
strategies used to enforce them.}

\item{simplify}{If \code{TRUE}, will attempt to simplify lists of
length-1 vectors to an atomic vector. Can also be a named list containing
\code{TRUE} or \code{FALSE} declaring whether or not to attempt to simplify a
particular column. If a named list is provided, the default for any
unspecified columns is \code{TRUE}.}

\item{ptype}{Optionally, a named list of prototypes declaring the
desired output type of each component. Alternatively, a single empty
prototype can be supplied, which will be applied to all components. Use
this argument if you want to check that each element has the type you
expect when simplifying.

If a \code{ptype} has been specified, but \code{simplify = FALSE} or simplification
isn't possible, then a \link[vctrs:list_of]{list-of} column will be returned
and each element will have type \code{ptype}.}

\item{transform}{Optionally, a named list of transformation
functions applied to each component. Alternatively, a single function can
be supplied, which will be applied to all components. Use this argument if
you want to transform or parse individual elements as they are extracted.

When both \code{ptype} and \code{transform} are supplied, the \code{transform} is applied
before the \code{ptype}.}
}
\description{
\code{unnest_longer()} turns each element of a list-column into a row. It
is most naturally suited to list-columns where the elements are unnamed
and the length of each element varies from row to row.

\code{unnest_longer()} generally preserves the number of columns of \code{x} while
modifying the number of rows.

Learn more in \code{vignette("rectangle")}.
}
\examples{
# `unnest_longer()` is useful when each component of the list should
# form a row
df <- tibble(
  x = 1:4,
  y = list(NULL, 1:3, 4:5, integer())
)
df |> unnest_longer(y)

# Note that empty values like `NULL` and `integer()` are dropped by
# default. If you'd like to keep them, set `keep_empty = TRUE`.
df |> unnest_longer(y, keep_empty = TRUE)

# If the inner vectors are named, the names are copied to an `_id` column
df <- tibble(
  x = 1:2,
  y = list(c(a = 1, b = 2), c(a = 10, b = 11, c = 12))
)
df |> unnest_longer(y)

# Multiple columns ----------------------------------------------------------
# If columns are aligned, you can unnest simultaneously
df <- tibble(
  x = 1:2,
  y = list(1:2, 3:4),
  z = list(5:6, 7:8)
)
df |>
  unnest_longer(c(y, z))

# This is important because sequential unnesting would generate the
# Cartesian product of the rows
df |>
  unnest_longer(y) |>
  unnest_longer(z)
}
\seealso{
Other rectangling: 
\code{\link{hoist}()},
\code{\link{unnest}()},
\code{\link{unnest_wider}()}
}
\concept{rectangling}
