% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkDirectoryExists.R
\name{checkDirectoryExists}
\alias{checkDirectoryExists}
\alias{check_directory_exists}
\alias{assertDirectoryExists}
\alias{assert_directory_exists}
\alias{testDirectoryExists}
\alias{test_directory_exists}
\alias{expect_directory_exists}
\alias{checkDirectory}
\alias{assertDirectory}
\alias{assert_directory}
\alias{testDirectory}
\alias{test_directory}
\alias{expect_directory}
\title{Check for existence and access rights of directories}
\usage{
checkDirectoryExists(x, access = "")

check_directory_exists(x, access = "")

assertDirectoryExists(x, access = "", .var.name = vname(x), add = NULL)

assert_directory_exists(x, access = "", .var.name = vname(x), add = NULL)

testDirectoryExists(x, access = "")

test_directory_exists(x, access = "")

expect_directory_exists(x, access = "", info = NULL, label = vname(x))

checkDirectory(x, access = "")

assertDirectory(x, access = "", .var.name = vname(x), add = NULL)

assert_directory(x, access = "", .var.name = vname(x), add = NULL)

testDirectory(x, access = "")

test_directory(x, access = "")

expect_directory(x, access = "", info = NULL, label = vname(x))
}
\arguments{
\item{x}{[\code{any}]\cr
Object to check.}

\item{access}{[\code{character(1)}]\cr
Single string containing possible characters \sQuote{r}, \sQuote{w} and \sQuote{x} to
force a check for read, write or execute access rights, respectively.
Write and executable rights are not checked on Windows.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}

\item{info}{[\code{character(1)}]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions 
 \code{assertDirectoryExists}/\code{assert_directory_exists} return 
 \code{x} invisibly, whereas
 \code{checkDirectoryExists}/\code{check_directory_exists} and 
 \code{testDirectoryExists}/\code{test_directory_exists} return 
 \code{TRUE}.
 If the check is not successful, 
 \code{assertDirectoryExists}/\code{assert_directory_exists}
 throws an error message, 
 \code{testDirectoryExists}/\code{test_directory_exists}
 returns \code{FALSE},
 and \code{checkDirectoryExists}/\code{check_directory_exists} 
 return a string with the error message.
 The function \code{expect_directory_exists} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check for existence and access rights of directories
}
\note{
The functions without the suffix \dQuote{exists} are deprecated and will be removed
from the package in a future version due to name clashes.
}
\examples{
# Is R's home directory readable?
testDirectory(R.home(), "r")

# Is R's home directory readable and writable?
testDirectory(R.home(), "rw")
}
\seealso{
Other filesystem: 
\code{\link{checkAccess}()},
\code{\link{checkFileExists}()},
\code{\link{checkPathForOutput}()}
}
\concept{filesystem}
