% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/car.R
\name{leveneTest_tidiers}
\alias{leveneTest_tidiers}
\alias{tidy.leveneTest}
\title{Tidy/glance a(n) leveneTest object}
\usage{
\method{tidy}{leveneTest}(x, ...)
}
\arguments{
\item{x}{An object of class \code{anova} created by a call to
\code{\link[car:leveneTest]{car::leveneTest()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Two exceptions here are:
\itemize{
\item \code{tidy()} methods will warn when supplied an \code{exponentiate} argument if
it will be ignored.
\item \code{augment()} methods will warn when supplied a \code{newdata} argument if it
will be ignored.
}}
}
\description{
For models that have only a single component, the \code{\link[=tidy]{tidy()}} and
\code{\link[=glance]{glance()}} methods are identical. Please see the documentation for both
of those methods.
}
\examples{
\dontshow{if (rlang::is_installed("car")) withAutoprint(\{ # examplesIf}

# load libraries for models and data
library(car)

data(Moore)

lt <- with(Moore, leveneTest(conformity, fcategory))

tidy(lt)
glance(lt)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[=glance]{glance()}}, \code{\link[car:leveneTest]{car::leveneTest()}}

Other car tidiers: 
\code{\link{durbinWatsonTest_tidiers}}
}
\concept{car tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{df}{Degrees of freedom used by this term in the model.}
  \item{p.value}{The two-sided p-value associated with the observed statistic.}
  \item{statistic}{The value of a T-statistic to use in a hypothesis that the regression term is non-zero.}
  \item{df.residual}{Residual degrees of freedom.}

}
