% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restructure.R
\name{restructure.brmsfit}
\alias{restructure.brmsfit}
\title{Restructure Old \code{brmsfit} Objects}
\usage{
\method{restructure}{brmsfit}(x, ...)
}
\arguments{
\item{x}{An object of class \code{brmsfit}.}

\item{...}{Currently ignored.}
}
\value{
A \code{brmsfit} object compatible with the latest version
  of \pkg{brms}.
}
\description{
Restructure old \code{brmsfit} objects to work with
the latest \pkg{brms} version. This function is called
internally when applying post-processing methods.
However, in order to avoid unnecessary run time caused
by the restructuring, I recommend explicitly calling
\code{restructure} once per model after updating \pkg{brms}.
}
\details{
If you are restructuring an old spline model (fitted with brms < 2.19.3) to
avoid prediction inconsistencies between machines (see GitHub issue #1465),
please make sure to \code{restructure} your model on the machine on which it
was originally fitted.
}
