[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/ebu/awesome-broadcasting)
[![GitHub license](https://img.shields.io/badge/license-GPL3-blue.svg)](https://raw.githubusercontent.com/Cuperino/QPrompt/master/COPYING)
[![GitHub release](https://img.shields.io/github/release/Cuperino/QPrompt.svg)](https://github.com/Cuperino/QPrompt/releases)
[![Translation status](https://l10n.cuperino.com/widget/qprompt-v2/qprompt-app/svg-badge.svg)](https://l10n.cuperino.com/engage/qprompt-v2/)
[![GitHub contributors](https://img.shields.io/github/contributors/Cuperino/QPrompt.svg)](https://github.com/Cuperino/QPrompt/graphs/contributors)
![GitHub commit activity](https://img.shields.io/github/commit-activity/m/Cuperino/QPrompt)
[![SourceForge](https://img.shields.io/sourceforge/dm/qprompt.svg)](https://sourceforge.net/projects/qprompt/)

QPrompt
=========

Personal teleprompter software for all video makers. Built with ease of use, productivity, and smooth performance in mind. QPrompt's runs on Linux, Windows, macOS, and Android.

QPrompt is written in C++ and QML, using the Qt and Kirigami frameworks to provide a fast and flexible interface that works for tablet and PC based teleprompters alike.

[![Download QPrompt](https://a.fsdn.com/con/app/sf-download-button)](https://sourceforge.net/projects/qprompt/files/latest/download)

Want the latest features? Get the latest development builds over at [Patreon](https://patreon.com/qpromptapp?utm_medium=clipboard_copy&utm_source=copyLink&utm_campaign=creatorshare_fan&utm_content=join_link). Alternatively, follow these instructions to [build QPrompt](https://github.com/Cuperino/QPrompt/blob/main/BUILD.md) yourself.

By becoming a [Patreon supporter](https://patreon.com/qpromptapp?utm_medium=clipboard_copy&utm_source=copyLink&utm_campaign=creatorshare_fan&utm_content=join_link) you get to vote on polls that determine where development should focus.

# Community Translations
Help more users access QPrompt by contributing translations to your native language. Visit [l10n.cuperino.com](https://l10n.cuperino.com/projects/qprompt-app/qprompt) to select a section of the project, find your language, and contribute translations. File an issue at [feedback.qprompt.com](https://github.com/Cuperino/QPrompt/issues/new/choose) if you can't find your language on the page and would like to contribute translations.

[![Translated languages](https://l10n.cuperino.com/widget/qprompt-v2/multi-auto.svg)](https://l10n.cuperino.com/engage/qprompt-v2/)

# Code Contributions

Code contributions are always welcome. Let's talk about what you'd like to do and I will help you get started.

For your contributions to make it into QPrompt, you must sign our [Contributor License Agreement](https://github.com/Cuperino/Signatures/blob/main/CLA.md). You will be prompted to digitally sign the agreement the moment you make your first Pull Request here on GitHub. The process is mostly automated to make things easy.

# Code of Conduct

By engaging in QPrompt's community, you agree with to follow the [Mozilla Community Participation Guidelines](https://www.mozilla.org/en-US/about/governance/policies/participation/). QPrompt is in no way affiliated wit Mozilla, but they have cool guidelines that represent the QPrompt project.

# Priorities

There's a large backlog of feature requests, and a few bug reports, most of which are things that take time to develop. I don't mean to Curb Your Enthusiasm, but before you ask how long will it take for X feature to make it into QPrompt, you should know how we organize our priorities:

1. Tech support. We help everyone who asks for help first, to the extent that we can.
2. The most recent bugs reports are then addressed.
3. Then code contributions are addressed to ensure they can make it into QPrompt and that they'll work well on the supported platforms.
4. I then move to work on the older bugs that people continue to ask about.
5. Then onto adding the new features that have been voted for by Patreon supporters.
6. If I don’t have the time to work on the voted issues, because they’d take more time than I can allot, but I have enough time to work on something small, I take on a smaller task from the queue that either has high demand, requires a skill that I would like to work with, can be added very quickly, or that has been requested by a Patreon supporter.
7. On occasions, I contribute to the upstream projects to which QPrompt depends on, fixing issues and writing detailed bug reports.
8. Periodically, time is also set aside to maintain the IT infrastructure, make new builds (which on average take 2 days to make), and update users following our social media, and our websites.

QPrompt's supporters, of which Patreons are a small part of, have a lot of influence over what I choose to work on. Supporters include code contributors, documentation writers, translators, people who I know use the software actively and provide occasional feedback, and beta testers.

# Copyright
Copyright © 2021-2025 [Javier O. Cordero Pérez](https://javiercordero.info)

# License
QPrompt is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, version 3 of the License.

QPrompt is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with QPrompt.  If not, see <https://www.gnu.org/licenses/>.

QPrompt translations are licensed under the [Creative Commons Attribution 4.0 International (CC BY 4.0)](https://creativecommons.org/licenses/by/4.0/)

# Pun Facts
QPrompt is short for Cue Prompter, something said to cue teleprompter operators. Teleprompters are sometimes referred to as "autocue". Also, QPrompt is built using the Qt framework. The Q is meant to reference all of these things and also the word "quick", because teleprompter operators must be quick to respond to what happens on set.

# Disclaimer
QPrompt, this app, is not related in any way to Q-Prompt Inc. nor is it to be confused with Qprompt, the Python library, or CuePrompter, the teleprompter software.
