/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.convert;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.turbine.util.Log;
import org.chefproject.service.UsageSessionService;
import org.chefproject.util.Sql;
import org.chefproject.util.StringUtil;
import org.chefproject.util.Validator;
import org.chefproject.util.Xml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AssignmentContextConverter
implements Runnable {
    private Hashtable m_attachments = new Hashtable();

    private void convertAssignments() {
        String sql = "select XML from ASSIGNMENT_ASSIGNMENT";
        List records = Sql.dbRead(sql);
        Iterator it = records.iterator();
        while (it.hasNext()) {
            String context = null;
            String id = null;
            try {
                int i;
                String xml = (String)it.next();
                Document doc = Xml.readDocumentFromString(xml);
                Element root = doc.getDocumentElement();
                context = StringUtil.trimToNull(root.getAttribute("context"));
                if (context != null) continue;
                id = StringUtil.trimToNull(root.getAttribute("id"));
                if (id == null) {
                    Log.info("chef", " ** assignment: id missing!");
                    continue;
                }
                String group = StringUtil.trimToNull(root.getAttribute("group"));
                if (group == null) {
                    Log.info("chef", " ** assignment: group missing for id: " + id);
                    continue;
                }
                context = group;
                root.setAttribute("context", context);
                Log.info("chef", " ** assignment: id: " + id + " group->context: " + context);
                String assignmentContent = StringUtil.trimToNull(root.getAttribute("assignmentcontent"));
                if (assignmentContent == null) {
                    Log.info("chef", " ** assignment: assignmentContent missing for id: " + id);
                    continue;
                }
                String newAssignmentContent = "/assignment/c/" + context + "/" + assignmentContent;
                root.setAttribute("assignmentcontent", newAssignmentContent);
                Log.info("chef", " ** assignment: assignmentcontent: " + assignmentContent + " now: " + newAssignmentContent);
                try {
                    int num;
                    String sNum = StringUtil.trimToNull(root.getAttribute("numberofattachments"));
                    if (sNum != null && (num = Integer.parseInt(sNum)) > 0) {
                        Vector<String> attachments = new Vector<String>();
                        i = 0;
                        while (i < num) {
                            String attachment = StringUtil.trimToNull(root.getAttribute("attachment" + i));
                            if (attachment != null) {
                                attachments.add(attachment);
                            }
                            ++i;
                        }
                        this.m_attachments.put(assignmentContent, attachments);
                    }
                }
                catch (Exception e) {
                    Log.info("chef", " ** assignment: exception doing attachments " + id + " " + e.toString());
                }
                Node properties = null;
                NodeList children = root.getChildNodes();
                int length = children.getLength();
                i = 0;
                while (i < length) {
                    Element element;
                    Node child = children.item(i);
                    if (child.getNodeType() == 1 && (element = (Element)child).getTagName().equals("properties")) {
                        properties = element;
                        break;
                    }
                    ++i;
                }
                String creator = StringUtil.trimToNull(root.getAttribute("creator"));
                if (creator != null && properties != null) {
                    Element propElement = doc.createElement("property");
                    properties.appendChild(propElement);
                    propElement.setAttribute("name", "CHEF:creator");
                    propElement.setAttribute("value", creator);
                }
                xml = Xml.writeDocumentToString(doc);
                String statement = "update ASSIGNMENT_ASSIGNMENT set XML = ? where ( ASSIGNMENT_ID = '" + Validator.escapeSql(id) + "' )";
                boolean ok = Sql.dbWrite(statement, xml);
                if (ok) {
                    Log.info("chef", " ** assignment: " + id + " record updated.");
                    continue;
                }
                Log.info("chef", " ** assignment: " + id + " ERROR updating record.");
            }
            catch (Exception e) {
                Log.warn("chef", " ** exception while converting: " + id + " : " + e);
            }
        }
    }

    private void convertContent() {
        String sql = "select XML from ASSIGNMENT_CONTENT";
        List records = Sql.dbRead(sql);
        Iterator it = records.iterator();
        while (it.hasNext()) {
            String context = null;
            String id = null;
            try {
                String xml = (String)it.next();
                Document doc = Xml.readDocumentFromString(xml);
                Element root = doc.getDocumentElement();
                context = StringUtil.trimToNull(root.getAttribute("context"));
                if (context != null) continue;
                id = StringUtil.trimToNull(root.getAttribute("id"));
                String reference = StringUtil.trimToNull(root.getAttribute("reference"));
                int pos1 = "/assignment/c/group-".length();
                int pos2 = reference.indexOf("/" + id);
                try {
                    context = reference.substring(pos1, pos2);
                }
                catch (Exception e) {
                    Log.info("chef", " ** assignment content: id: " + id + " reference: " + reference + " exception: " + e.toString());
                }
                Log.info("chef", " ** assignment content: id: " + id + " reference: " + reference + " context: " + context);
                Vector attachments = (Vector)this.m_attachments.get(id);
                if (attachments != null) {
                    root.setAttribute("numberofattachments", Integer.toString(attachments.size()));
                    int count = 0;
                    Iterator iAttachments = attachments.iterator();
                    while (iAttachments.hasNext()) {
                        String attachment = (String)iAttachments.next();
                        root.setAttribute("attachment" + count++, attachment);
                    }
                }
                Node properties = null;
                NodeList children = root.getChildNodes();
                int length = children.getLength();
                int i = 0;
                while (i < length) {
                    Element element;
                    Node child = children.item(i);
                    if (child.getNodeType() == 1 && (element = (Element)child).getTagName().equals("properties")) {
                        properties = element;
                        break;
                    }
                    ++i;
                }
                String creator = StringUtil.trimToNull(root.getAttribute("creator"));
                if (creator != null && properties != null) {
                    Element propElement = doc.createElement("property");
                    properties.appendChild(propElement);
                    propElement.setAttribute("name", "CHEF:creator");
                    propElement.setAttribute("value", creator);
                }
                root.setAttribute("context", context);
                xml = Xml.writeDocumentToString(doc);
                String statement = "update ASSIGNMENT_CONTENT set XML = ? where ( CONTENT_ID = '" + Validator.escapeSql(id) + "' )";
                boolean ok = Sql.dbWrite(statement, xml);
                if (ok) {
                    Log.info("chef", " ** assignment content: " + id + " record updated.");
                    continue;
                }
                Log.info("chef", " ** assignment content: " + id + " ERROR updating record.");
            }
            catch (Exception e) {
                Log.warn("chef", " ** exception while converting content: " + id + " : " + e);
            }
        }
    }

    private void convertSubmissions() {
        String sql = "select XML from ASSIGNMENT_SUBMISSION";
        List records = Sql.dbRead(sql);
        Iterator it = records.iterator();
        while (it.hasNext()) {
            String context = null;
            String id = null;
            try {
                String xml = (String)it.next();
                Document doc = Xml.readDocumentFromString(xml);
                Element root = doc.getDocumentElement();
                context = StringUtil.trimToNull(root.getAttribute("context"));
                if (context != null) continue;
                id = StringUtil.trimToNull(root.getAttribute("id"));
                String reference = StringUtil.trimToNull(root.getAttribute("reference"));
                int pos1 = "/assignment/s/group-".length();
                int pos2 = reference.indexOf("/" + id);
                try {
                    context = reference.substring(pos1, pos2);
                }
                catch (Exception e) {
                    Log.info("chef", " ** assignment submission: id: " + id + " reference: " + reference + " exception: " + e.toString());
                }
                Log.info("chef", " ** assignment submission: id: " + id + " reference: " + reference + " context: " + context);
                root.setAttribute("context", context);
                xml = Xml.writeDocumentToString(doc);
                String statement = "update ASSIGNMENT_SUBMISSION set XML = ? where ( SUBMISSION_ID = '" + Validator.escapeSql(id) + "' )";
                boolean ok = Sql.dbWrite(statement, xml);
                if (ok) {
                    Log.info("chef", " ** assignment submission: " + id + " record updated.");
                    continue;
                }
                Log.info("chef", " ** assignment submission: " + id + " ERROR updating record.");
            }
            catch (Exception e) {
                Log.warn("chef", " ** exception while converting submission: " + id + " : " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Log.info("chef", " ** Converting assignments for context **");
        UsageSessionService.loginThreadUser("admin");
        try {
            this.convertAssignments();
            this.convertContent();
            this.convertSubmissions();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            UsageSessionService.logoutThreadUser();
            throw throwable;
        }
        UsageSessionService.logoutThreadUser();
    }

    public static void convert() {
        AssignmentContextConverter converter = new AssignmentContextConverter();
        Thread thread = new Thread((Runnable)converter, "AssignmentContextConverter");
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

