; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -S -passes=inline %s | FileCheck %s

declare ptr @get_ptr()
declare void @capture(ptr)

define void @callee_no_capture(ptr noalias %p) {
; CHECK-LABEL: define void @callee_no_capture(
; CHECK-SAME: ptr noalias [[P:%.*]]) {
; CHECK-NEXT:    [[P2:%.*]] = call ptr @get_ptr()
; CHECK-NEXT:    [[V:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    store i32 [[V]], ptr [[P2]], align 4
; CHECK-NEXT:    ret void
;
  %p2 = call ptr @get_ptr()
  %v = load i32, ptr %p
  store i32 %v, ptr %p2
  ret void
}

define void @test_no_capture(ptr %p) {
; CHECK-LABEL: define void @test_no_capture(
; CHECK-SAME: ptr [[P:%.*]]) {
; CHECK-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META0:![0-9]+]])
; CHECK-NEXT:    [[P2_I:%.*]] = call ptr @get_ptr(), !noalias [[META0]]
; CHECK-NEXT:    [[V_I:%.*]] = load i32, ptr [[P]], align 4, !alias.scope [[META0]]
; CHECK-NEXT:    store i32 [[V_I]], ptr [[P2_I]], align 4, !noalias [[META0]]
; CHECK-NEXT:    ret void
;
  call void @callee_no_capture(ptr %p)
  ret void
}

define void @callee_capture(ptr noalias %p) {
; CHECK-LABEL: define void @callee_capture(
; CHECK-SAME: ptr noalias [[P:%.*]]) {
; CHECK-NEXT:    call void @capture(ptr [[P]])
; CHECK-NEXT:    [[P2:%.*]] = call ptr @get_ptr()
; CHECK-NEXT:    [[V:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    store i32 [[V]], ptr [[P2]], align 4
; CHECK-NEXT:    ret void
;
  call void @capture(ptr %p)
  %p2 = call ptr @get_ptr()
  %v = load i32, ptr %p
  store i32 %v, ptr %p2
  ret void
}

define void @test_capture(ptr %p) {
; CHECK-LABEL: define void @test_capture(
; CHECK-SAME: ptr [[P:%.*]]) {
; CHECK-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META3:![0-9]+]])
; CHECK-NEXT:    call void @capture(ptr [[P]])
; CHECK-NEXT:    [[P2_I:%.*]] = call ptr @get_ptr()
; CHECK-NEXT:    [[V_I:%.*]] = load i32, ptr [[P]], align 4, !alias.scope [[META3]]
; CHECK-NEXT:    store i32 [[V_I]], ptr [[P2_I]], align 4
; CHECK-NEXT:    ret void
;
  call void @callee_capture(ptr %p)
  ret void
}

define void @callee_addr_only_capture(ptr noalias %p) {
; CHECK-LABEL: define void @callee_addr_only_capture(
; CHECK-SAME: ptr noalias [[P:%.*]]) {
; CHECK-NEXT:    call void @capture(ptr captures(address) [[P]])
; CHECK-NEXT:    [[P2:%.*]] = call ptr @get_ptr()
; CHECK-NEXT:    [[V:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    store i32 [[V]], ptr [[P2]], align 4
; CHECK-NEXT:    ret void
;
  call void @capture(ptr captures(address) %p)
  %p2 = call ptr @get_ptr()
  %v = load i32, ptr %p
  store i32 %v, ptr %p2
  ret void
}

define void @test_addr_only_capture(ptr %p) {
; CHECK-LABEL: define void @test_addr_only_capture(
; CHECK-SAME: ptr [[P:%.*]]) {
; CHECK-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META6:![0-9]+]])
; CHECK-NEXT:    call void @capture(ptr captures(address) [[P]])
; CHECK-NEXT:    [[P2_I:%.*]] = call ptr @get_ptr(), !noalias [[META6]]
; CHECK-NEXT:    [[V_I:%.*]] = load i32, ptr [[P]], align 4, !alias.scope [[META6]]
; CHECK-NEXT:    store i32 [[V_I]], ptr [[P2_I]], align 4, !noalias [[META6]]
; CHECK-NEXT:    ret void
;
  call void @callee_addr_only_capture(ptr %p)
  ret void
}
;.
; CHECK: [[META0]] = !{[[META1:![0-9]+]]}
; CHECK: [[META1]] = distinct !{[[META1]], [[META2:![0-9]+]], !"callee_no_capture: %p"}
; CHECK: [[META2]] = distinct !{[[META2]], !"callee_no_capture"}
; CHECK: [[META3]] = !{[[META4:![0-9]+]]}
; CHECK: [[META4]] = distinct !{[[META4]], [[META5:![0-9]+]], !"callee_capture: %p"}
; CHECK: [[META5]] = distinct !{[[META5]], !"callee_capture"}
; CHECK: [[META6]] = !{[[META7:![0-9]+]]}
; CHECK: [[META7]] = distinct !{[[META7]], [[META8:![0-9]+]], !"callee_addr_only_capture: %p"}
; CHECK: [[META8]] = distinct !{[[META8]], !"callee_addr_only_capture"}
;.
