; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -passes=attributor -S < %s | FileCheck %s

; Global variables that reference themselves alongside a function that is called indirectly
; used to cause an infinite loop in the attributor. The recursive reference was continually
; pushed back into the workload, causing the attributor to hang indefinitely.

@glob1 = global { ptr, ptr } { ptr @glob1, ptr @fnc1 }
@glob2 = global { ptr, ptr } { ptr @glob3, ptr @fnc2 }
@glob3 = global { ptr, ptr } { ptr @glob2, ptr @fnc2 }

define internal void @fnc1() {
; CHECK-LABEL: define internal void @fnc1(
; CHECK-SAME: ) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    ret void
;
  ret void
}

define internal void @fnc2() {
; CHECK-LABEL: define internal void @fnc2(
; CHECK-SAME: ) #[[ATTR0]] {
; CHECK-NEXT:    ret void
;
  ret void
}

define dso_local void @indr_caller(ptr %0) {
; CHECK-LABEL: define dso_local void @indr_caller(
; CHECK-SAME: ptr nofree noundef nonnull captures(none) [[TMP0:%.*]]) {
; CHECK-NEXT:    call void [[TMP0]]()
; CHECK-NEXT:    ret void
;
  call void %0()
  ret void
}

define void @main() {
; CHECK-LABEL: define void @main() {
; CHECK-NEXT:    call void @indr_caller(ptr nofree noundef nonnull captures(none) @fnc1)
; CHECK-NEXT:    call void @indr_caller(ptr nofree noundef nonnull captures(none) @fnc2)
; CHECK-NEXT:    ret void
;
  call void @indr_caller(ptr @fnc1)
  call void @indr_caller(ptr @fnc2)
  ret void
}
