; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc --mtriple=loongarch64 --mattr=+lsx %s -o - | FileCheck %s

define void @load_trunc_2i64_to_2i32(ptr %ptr, ptr %dst) nounwind {
; CHECK-LABEL: load_trunc_2i64_to_2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vshuf4i.w $vr0, $vr0, 8
; CHECK-NEXT:    vstelm.d $vr0, $a1, 0, 0
; CHECK-NEXT:    ret
  %a = load <2 x i64>, ptr %ptr
  %trunc = trunc <2 x i64> %a to <2 x i32>
  store <2 x i32> %trunc, ptr %dst
  ret void
}

define void @load_trunc_2i64_to_2i16(ptr %ptr, ptr %dst) nounwind {
; CHECK-LABEL: load_trunc_2i64_to_2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    pcalau12i $a0, %pc_hi20(.LCPI1_0)
; CHECK-NEXT:    vld $vr1, $a0, %pc_lo12(.LCPI1_0)
; CHECK-NEXT:    vshuf.h $vr1, $vr0, $vr0
; CHECK-NEXT:    vstelm.w $vr1, $a1, 0, 0
; CHECK-NEXT:    ret
  %a = load <2 x i64>, ptr %ptr
  %trunc = trunc <2 x i64> %a to <2 x i16>
  store <2 x i16> %trunc, ptr %dst
  ret void
}

define void @load_trunc_2i64_to_2i8(ptr %ptr, ptr %dst) nounwind {
; CHECK-LABEL: load_trunc_2i64_to_2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    pcalau12i $a0, %pc_hi20(.LCPI2_0)
; CHECK-NEXT:    vld $vr1, $a0, %pc_lo12(.LCPI2_0)
; CHECK-NEXT:    vshuf.b $vr0, $vr0, $vr0, $vr1
; CHECK-NEXT:    vstelm.h $vr0, $a1, 0, 0
; CHECK-NEXT:    ret
  %a = load <2 x i64>, ptr %ptr
  %trunc = trunc <2 x i64> %a to <2 x i8>
  store <2 x i8> %trunc, ptr %dst
  ret void
}

define void @load_trunc_4i32_to_4i16(ptr %ptr, ptr %dst) nounwind {
; CHECK-LABEL: load_trunc_4i32_to_4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vpickev.h $vr0, $vr0, $vr0
; CHECK-NEXT:    vstelm.d $vr0, $a1, 0, 0
; CHECK-NEXT:    ret
  %a = load <4 x i32>, ptr %ptr
  %trunc = trunc <4 x i32> %a to <4 x i16>
  store <4 x i16> %trunc, ptr %dst
  ret void
}

define void @load_trunc_4i32_to_4i8(ptr %ptr, ptr %dst) nounwind {
; CHECK-LABEL: load_trunc_4i32_to_4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    pcalau12i $a0, %pc_hi20(.LCPI4_0)
; CHECK-NEXT:    vld $vr1, $a0, %pc_lo12(.LCPI4_0)
; CHECK-NEXT:    vshuf.b $vr0, $vr0, $vr0, $vr1
; CHECK-NEXT:    vstelm.w $vr0, $a1, 0, 0
; CHECK-NEXT:    ret
  %a = load <4 x i32>, ptr %ptr
  %trunc = trunc <4 x i32> %a to <4 x i8>
  store <4 x i8> %trunc, ptr %dst
  ret void
}

define void @load_trunc_8i16_to_8i8(ptr %ptr, ptr %dst) nounwind {
; CHECK-LABEL: load_trunc_8i16_to_8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vpickev.b $vr0, $vr0, $vr0
; CHECK-NEXT:    vstelm.d $vr0, $a1, 0, 0
; CHECK-NEXT:    ret
  %a = load <8 x i16>, ptr %ptr
  %trunc = trunc <8 x i16> %a to <8 x i8>
  store <8 x i8> %trunc, ptr %dst
  ret void
}

define void @load_trunc_2i32_to_2i16(ptr %ptr, ptr %dst) nounwind {
; CHECK-LABEL: load_trunc_2i32_to_2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ld.d $a0, $a0, 0
; CHECK-NEXT:    vinsgr2vr.d $vr0, $a0, 0
; CHECK-NEXT:    vshuf4i.h $vr0, $vr0, 8
; CHECK-NEXT:    vstelm.w $vr0, $a1, 0, 0
; CHECK-NEXT:    ret
  %a = load <2 x i32>, ptr %ptr
  %trunc = trunc <2 x i32> %a to <2 x i16>
  store <2 x i16> %trunc, ptr %dst
  ret void
}

define void @load_trunc_2i32_to_2i8(ptr %ptr, ptr %dst) nounwind {
; CHECK-LABEL: load_trunc_2i32_to_2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ld.d $a0, $a0, 0
; CHECK-NEXT:    pcalau12i $a2, %pc_hi20(.LCPI7_0)
; CHECK-NEXT:    vld $vr0, $a2, %pc_lo12(.LCPI7_0)
; CHECK-NEXT:    vinsgr2vr.d $vr1, $a0, 0
; CHECK-NEXT:    vshuf.b $vr0, $vr0, $vr1, $vr0
; CHECK-NEXT:    vstelm.h $vr0, $a1, 0, 0
; CHECK-NEXT:    ret
  %a = load <2 x i32>, ptr %ptr
  %trunc = trunc <2 x i32> %a to <2 x i8>
  store <2 x i8> %trunc, ptr %dst
  ret void
}

define void @load_trunc_4i16_to_4i8(ptr %ptr, ptr %dst) nounwind {
; CHECK-LABEL: load_trunc_4i16_to_4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ld.d $a0, $a0, 0
; CHECK-NEXT:    vinsgr2vr.d $vr0, $a0, 0
; CHECK-NEXT:    vpickev.b $vr0, $vr0, $vr0
; CHECK-NEXT:    vstelm.w $vr0, $a1, 0, 0
; CHECK-NEXT:    ret
  %a = load <4 x i16>, ptr %ptr
  %trunc = trunc <4 x i16> %a to <4 x i8>
  store <4 x i8> %trunc, ptr %dst
  ret void
}

define void @load_trunc_2i16_to_2i8(ptr %ptr, ptr %dst) nounwind {
; CHECK-LABEL: load_trunc_2i16_to_2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ld.w $a0, $a0, 0
; CHECK-NEXT:    vinsgr2vr.w $vr0, $a0, 0
; CHECK-NEXT:    vshuf4i.b $vr0, $vr0, 8
; CHECK-NEXT:    vstelm.h $vr0, $a1, 0, 0
; CHECK-NEXT:    ret
  %a = load <2 x i16>, ptr %ptr
  %trunc = trunc <2 x i16> %a to <2 x i8>
  store <2 x i8> %trunc, ptr %dst
  ret void
}


