; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=amdgcn -mcpu=gfx1010 -verify-machineinstrs < %s | FileCheck %s -check-prefix=GCN

define i32 @test(i32 %val, i32 %cond) {
; GCN-LABEL: test:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_xor_saveexec_b32 s4, -1
; GCN-NEXT:    buffer_store_dword v2, off, s[0:3], s32 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GCN-NEXT:    s_waitcnt_depctr 0xffe3
; GCN-NEXT:    s_mov_b32 exec_lo, s4
; GCN-NEXT:    s_or_saveexec_b32 s4, -1
; GCN-NEXT:    v_mov_b32_e32 v2, 0
; GCN-NEXT:    v_cndmask_b32_e64 v3, 0, v0, s4
; GCN-NEXT:    v_mov_b32_dpp v2, v3 row_xmask:1 row_mask:0xf bank_mask:0xf
; GCN-NEXT:    s_mov_b32 exec_lo, s4
; GCN-NEXT:    v_mov_b32_e32 v5, 0
; GCN-NEXT:    v_mov_b32_e32 v4, v2
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v1
; GCN-NEXT:    s_and_saveexec_b32 s4, vcc_lo
; GCN-NEXT:  ; %bb.1: ; %if
; GCN-NEXT:    s_or_saveexec_b32 s5, -1
; GCN-NEXT:    v_mov_b32_e32 v2, 0
; GCN-NEXT:    v_cndmask_b32_e64 v3, 0, v0, s5
; GCN-NEXT:    v_mov_b32_dpp v2, v3 row_xmask:1 row_mask:0xf bank_mask:0xf
; GCN-NEXT:    s_mov_b32 exec_lo, s5
; GCN-NEXT:    v_mov_b32_e32 v5, v2
; GCN-NEXT:  ; %bb.2: ; %end
; GCN-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GCN-NEXT:    v_add_nc_u32_e32 v0, v4, v5
; GCN-NEXT:    s_xor_saveexec_b32 s4, -1
; GCN-NEXT:    s_clause 0x1
; GCN-NEXT:    buffer_load_dword v2, off, s[0:3], s32
; GCN-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:4
; GCN-NEXT:    s_waitcnt_depctr 0xffe3
; GCN-NEXT:    s_mov_b32 exec_lo, s4
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_setpc_b64 s[30:31]
entry:
  ; %x = subgroup operation over all lanes.
  %x1 = call i32 @llvm.amdgcn.set.inactive.i32(i32 %val, i32 0)
  %x2 = call i32 @llvm.amdgcn.update.dpp.i32(i32 0, i32 %x1, i32 353, i32 15, i32 15, i1 false)
  %x3 = call i32 @llvm.amdgcn.strict.wwm.i32(i32 %x2)
  %cmp = icmp eq i32 %cond, 0
  br i1 %cmp, label %if, label %end

if:
  ; %y = subgroup operations over lanes satisfying %cond.
  %y1 = call i32 @llvm.amdgcn.set.inactive.i32(i32 %val, i32 0)
  %y2 = call i32 @llvm.amdgcn.update.dpp.i32(i32 0, i32 %y1, i32 353, i32 15, i32 15, i1 false)
  %y3 = call i32 @llvm.amdgcn.strict.wwm.i32(i32 %y2)
  br label %end

end:
  %y = phi i32 [0, %entry], [%y3, %if]
  %ret = add i32 %x3, %y
  ret i32 %ret
}

declare i32 @llvm.amdgcn.set.inactive.i32(i32, i32)
declare i32 @llvm.amdgcn.update.dpp.i32(i32, i32, i32 immarg, i32 immarg, i32 immarg, i1 immarg)
declare i32 @llvm.amdgcn.strict.wwm.i32(i32)
