; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -S -passes=instsimplify < %s | FileCheck %s

define i1 @lshr_or_ule(i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: define i1 @lshr_or_ule(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]], i32 [[Z:%.*]]) {
; CHECK-NEXT:    ret i1 true
;
  %op1 = lshr i32 %x, %y
  %op2 = or i32 %x, %z
  %cmp = icmp ule i32 %op1, %op2
  ret i1 %cmp
}

define i1 @lshr_or_uge_swapped(i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: define i1 @lshr_or_uge_swapped(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]], i32 [[Z:%.*]]) {
; CHECK-NEXT:    ret i1 true
;
  %op1 = lshr i32 %x, %y
  %op2 = or i32 %x, %z
  %cmp = icmp uge i32 %op2, %op1
  ret i1 %cmp
}

define i1 @lshr_or_ugt(i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: define i1 @lshr_or_ugt(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]], i32 [[Z:%.*]]) {
; CHECK-NEXT:    ret i1 false
;
  %op1 = lshr i32 %x, %y
  %op2 = or i32 %x, %z
  %cmp = icmp ugt i32 %op1, %op2
  ret i1 %cmp
}

define i1 @lshr_or_ult_wrong_pred(i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: define i1 @lshr_or_ult_wrong_pred(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]], i32 [[Z:%.*]]) {
; CHECK-NEXT:    [[OP1:%.*]] = lshr i32 [[X]], [[Y]]
; CHECK-NEXT:    [[OP2:%.*]] = or i32 [[X]], [[Z]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[OP1]], [[OP2]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %op1 = lshr i32 %x, %y
  %op2 = or i32 %x, %z
  %cmp = icmp ult i32 %op1, %op2
  ret i1 %cmp
}

define i1 @lshr_or_sle_wrong_pred(i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: define i1 @lshr_or_sle_wrong_pred(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]], i32 [[Z:%.*]]) {
; CHECK-NEXT:    [[OP1:%.*]] = lshr i32 [[X]], [[Y]]
; CHECK-NEXT:    [[OP2:%.*]] = or i32 [[X]], [[Z]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp sle i32 [[OP1]], [[OP2]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %op1 = lshr i32 %x, %y
  %op2 = or i32 %x, %z
  %cmp = icmp sle i32 %op1, %op2
  ret i1 %cmp
}

define i1 @lshr_or_swapped_ule(i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: define i1 @lshr_or_swapped_ule(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]], i32 [[Z:%.*]]) {
; CHECK-NEXT:    ret i1 true
;
  %op1 = lshr i32 %x, %y
  %op2 = or i32 %z, %x
  %cmp = icmp ule i32 %op1, %op2
  ret i1 %cmp
}

define i1 @lshr_or_ule_invalid_swapped(i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: define i1 @lshr_or_ule_invalid_swapped(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]], i32 [[Z:%.*]]) {
; CHECK-NEXT:    [[OP1:%.*]] = lshr i32 [[Y]], [[X]]
; CHECK-NEXT:    [[OP2:%.*]] = or i32 [[X]], [[Z]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ule i32 [[OP1]], [[OP2]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %op1 = lshr i32 %y, %x
  %op2 = or i32 %x, %z
  %cmp = icmp ule i32 %op1, %op2
  ret i1 %cmp
}

define i1 @and_uadd_sat_ule(i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: define i1 @and_uadd_sat_ule(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]], i32 [[Z:%.*]]) {
; CHECK-NEXT:    ret i1 true
;
  %op1 = and i32 %x, %y
  %op2 = call i32 @llvm.uadd.sat(i32 %x, i32 %z)
  %cmp = icmp ule i32 %op1, %op2
  ret i1 %cmp
}

define i1 @urem_or_ule(i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: define i1 @urem_or_ule(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]], i32 [[Z:%.*]]) {
; CHECK-NEXT:    ret i1 true
;
  %op1 = urem i32 %x, %y
  %op2 = or i32 %x, %z
  %cmp = icmp ule i32 %op1, %op2
  ret i1 %cmp
}

define i1 @urem_or_ule_invalid_swapped(i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: define i1 @urem_or_ule_invalid_swapped(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]], i32 [[Z:%.*]]) {
; CHECK-NEXT:    [[OP1:%.*]] = urem i32 [[Y]], [[X]]
; CHECK-NEXT:    [[OP2:%.*]] = or i32 [[X]], [[Z]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ule i32 [[OP1]], [[OP2]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %op1 = urem i32 %y, %x
  %op2 = or i32 %x, %z
  %cmp = icmp ule i32 %op1, %op2
  ret i1 %cmp
}

define i1 @udiv_or_ule(i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: define i1 @udiv_or_ule(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]], i32 [[Z:%.*]]) {
; CHECK-NEXT:    ret i1 true
;
  %op1 = udiv i32 %x, %y
  %op2 = or i32 %x, %z
  %cmp = icmp ule i32 %op1, %op2
  ret i1 %cmp
}

define i1 @udiv_or_ule_invalid_swapped(i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: define i1 @udiv_or_ule_invalid_swapped(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]], i32 [[Z:%.*]]) {
; CHECK-NEXT:    [[OP1:%.*]] = udiv i32 [[Y]], [[X]]
; CHECK-NEXT:    [[OP2:%.*]] = or i32 [[X]], [[Z]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ule i32 [[OP1]], [[OP2]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %op1 = udiv i32 %y, %x
  %op2 = or i32 %x, %z
  %cmp = icmp ule i32 %op1, %op2
  ret i1 %cmp
}

define i1 @usub_sat_uadd_sat_ule(i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: define i1 @usub_sat_uadd_sat_ule(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]], i32 [[Z:%.*]]) {
; CHECK-NEXT:    ret i1 true
;
  %op1 = call i32 @llvm.usub.sat(i32 %x, i32 %y)
  %op2 = call i32 @llvm.uadd.sat(i32 %x, i32 %z)
  %cmp = icmp ule i32 %op1, %op2
  ret i1 %cmp
}

define i1 @usub_sat_uadd_sat_ule_invalid_swapped(i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: define i1 @usub_sat_uadd_sat_ule_invalid_swapped(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]], i32 [[Z:%.*]]) {
; CHECK-NEXT:    [[OP1:%.*]] = call i32 @llvm.usub.sat.i32(i32 [[Y]], i32 [[X]])
; CHECK-NEXT:    [[OP2:%.*]] = call i32 @llvm.uadd.sat.i32(i32 [[X]], i32 [[Z]])
; CHECK-NEXT:    [[CMP:%.*]] = icmp ule i32 [[OP1]], [[OP2]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %op1 = call i32 @llvm.usub.sat(i32 %y, i32 %x)
  %op2 = call i32 @llvm.uadd.sat(i32 %x, i32 %z)
  %cmp = icmp ule i32 %op1, %op2
  ret i1 %cmp
}

define i1 @lshr_or_ule_no_common_op(i32 %x, i32 %y, i32 %z, i32 %w) {
; CHECK-LABEL: define i1 @lshr_or_ule_no_common_op(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]], i32 [[Z:%.*]], i32 [[W:%.*]]) {
; CHECK-NEXT:    [[OP1:%.*]] = lshr i32 [[X]], [[Y]]
; CHECK-NEXT:    [[OP2:%.*]] = or i32 [[W]], [[Z]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ule i32 [[OP1]], [[OP2]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %op1 = lshr i32 %x, %y
  %op2 = or i32 %w, %z
  %cmp = icmp ule i32 %op1, %op2
  ret i1 %cmp
}

define i1 @lshr_or_ule_nested(i32 %x, i32 %y, i32 %z, i32 %w) {
; CHECK-LABEL: define i1 @lshr_or_ule_nested(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]], i32 [[Z:%.*]], i32 [[W:%.*]]) {
; CHECK-NEXT:    [[OP1:%.*]] = lshr i32 [[X]], [[Y]]
; CHECK-NEXT:    [[OP2:%.*]] = or i32 [[X]], [[Z]]
; CHECK-NEXT:    [[OP3:%.*]] = or i32 [[OP2]], [[W]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ule i32 [[OP1]], [[OP3]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %op1 = lshr i32 %x, %y
  %op2 = or i32 %x, %z
  %op3 = or i32 %op2, %w
  %cmp = icmp ule i32 %op1, %op3
  ret i1 %cmp
}

define i1 @lshr_add_ule_non_monotonic(i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: define i1 @lshr_add_ule_non_monotonic(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]], i32 [[Z:%.*]]) {
; CHECK-NEXT:    [[OP1:%.*]] = lshr i32 [[X]], [[Y]]
; CHECK-NEXT:    [[OP2:%.*]] = add i32 [[X]], [[Z]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ule i32 [[OP1]], [[OP2]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %op1 = lshr i32 %x, %y
  %op2 = add i32 %x, %z
  %cmp = icmp ule i32 %op1, %op2
  ret i1 %cmp
}

define i1 @mul_nuw_nonzero_rhs_monotonic(i8 %x, i8 %c) {
; CHECK-LABEL: define i1 @mul_nuw_nonzero_rhs_monotonic(
; CHECK-SAME: i8 [[X:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[C_NONZERO:%.*]] = icmp ne i8 [[C]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_NONZERO]])
; CHECK-NEXT:    ret i1 true
;
  %c_nonzero = icmp ne i8 %c, 0
  call void @llvm.assume(i1 %c_nonzero)

  %prod = mul nuw i8 %x, %c
  %cmp = icmp uge i8 %prod, %x
  ret i1 %cmp
}

define i1 @mul_nuw_nonzero_rhs_commuted_monotonic(i8 %x, i8 %c) {
; CHECK-LABEL: define i1 @mul_nuw_nonzero_rhs_commuted_monotonic(
; CHECK-SAME: i8 [[X:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[C_NONZERO:%.*]] = icmp ne i8 [[C]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_NONZERO]])
; CHECK-NEXT:    ret i1 true
;
  %c_nonzero = icmp ne i8 %c, 0
  call void @llvm.assume(i1 %c_nonzero)

  %prod = mul nuw i8 %c, %x
  %cmp = icmp uge i8 %prod, %x
  ret i1 %cmp
}

define i1 @mul_nuw_nonzero_rhs_monotonic_inverse_predicate(i8 %x, i8 %c) {
; CHECK-LABEL: define i1 @mul_nuw_nonzero_rhs_monotonic_inverse_predicate(
; CHECK-SAME: i8 [[X:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[C_NONZERO:%.*]] = icmp ne i8 [[C]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_NONZERO]])
; CHECK-NEXT:    ret i1 false
;
  %c_nonzero = icmp ne i8 %c, 0
  call void @llvm.assume(i1 %c_nonzero)

  %prod = mul nuw i8 %x, %c
  %cmp = icmp ult i8 %prod, %x
  ret i1 %cmp
}

define i1 @mul_nuw_nonzero_lhs_monotonic(i8 %x, i8 %c) {
; CHECK-LABEL: define i1 @mul_nuw_nonzero_lhs_monotonic(
; CHECK-SAME: i8 [[X:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[C_NONZERO:%.*]] = icmp ne i8 [[X]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_NONZERO]])
; CHECK-NEXT:    ret i1 true
;
  %c_nonzero = icmp ne i8 %x, 0
  call void @llvm.assume(i1 %c_nonzero)

  %prod = mul nuw i8 %x, %c
  %cmp = icmp uge i8 %prod, %c
  ret i1 %cmp
}

define i1 @mul_nuw_nonzero_lhs_rhs_monotonic(i8 %x, i8 %c) {
; CHECK-LABEL: define i1 @mul_nuw_nonzero_lhs_rhs_monotonic(
; CHECK-SAME: i8 [[X:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[C_NONZERO:%.*]] = icmp ne i8 [[C]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_NONZERO]])
; CHECK-NEXT:    [[X_NONZERO:%.*]] = icmp ne i8 [[X]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[X_NONZERO]])
; CHECK-NEXT:    ret i1 true
;
  %c_nonzero = icmp ne i8 %c, 0
  call void @llvm.assume(i1 %c_nonzero)

  %x_nonzero = icmp ne i8 %x, 0
  call void @llvm.assume(i1 %x_nonzero)

  %prod = mul nuw i8 %x, %c
  %cmp = icmp uge i8 %prod, %x
  ret i1 %cmp
}


define i1 @negative_mul_non_nsw(i8 %x, i8 %c) {
; CHECK-LABEL: define i1 @negative_mul_non_nsw(
; CHECK-SAME: i8 [[X:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[C_NONZERO:%.*]] = icmp ne i8 [[C]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_NONZERO]])
; CHECK-NEXT:    [[X3:%.*]] = mul i8 [[X]], [[C]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp uge i8 [[X3]], [[X]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %c_nonzero = icmp ne i8 %c, 0
  call void @llvm.assume(i1 %c_nonzero)

  %prod = mul i8 %x, %c
  %cmp = icmp uge i8 %prod, %x
  ret i1 %cmp
}

define i1 @negative_mul_no_nonzero(i8 %x, i8 %c) {
; CHECK-LABEL: define i1 @negative_mul_no_nonzero(
; CHECK-SAME: i8 [[X:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[X3:%.*]] = mul nsw i8 [[X]], [[C]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp uge i8 [[X3]], [[X]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %prod = mul nsw i8 %x, %c
  %cmp = icmp uge i8 %prod, %x
  ret i1 %cmp
}

define i1 @negative_mul_lhs_maybe_zero(i8 %x, i8 %c) {
; CHECK-LABEL: define i1 @negative_mul_lhs_maybe_zero(
; CHECK-SAME: i8 [[X:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[C_NONZERO:%.*]] = icmp ne i8 [[C]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_NONZERO]])
; CHECK-NEXT:    [[X3:%.*]] = mul nuw i8 [[X]], [[C]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp uge i8 [[X3]], [[C]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %c_nonzero = icmp ne i8 %c, 0
  call void @llvm.assume(i1 %c_nonzero)

  %prod = mul nuw i8 %x, %c
  %cmp = icmp uge i8 %prod, %c
  ret i1 %cmp
}

define i1 @negative_mul_rhs_maybe_zero(i8 %x, i8 %c) {
; CHECK-LABEL: define i1 @negative_mul_rhs_maybe_zero(
; CHECK-SAME: i8 [[X:%.*]], i8 [[C:%.*]]) {
; CHECK-NEXT:    [[C_NONZERO:%.*]] = icmp ne i8 [[X]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_NONZERO]])
; CHECK-NEXT:    [[X3:%.*]] = mul nuw i8 [[X]], [[C]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp uge i8 [[X3]], [[X]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %c_nonzero = icmp ne i8 %x, 0
  call void @llvm.assume(i1 %c_nonzero)

  %prod = mul nuw i8 %x, %c
  %cmp = icmp uge i8 %prod, %x
  ret i1 %cmp
}
