; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=instcombine -S < %s | FileCheck %s

declare void @bar()
declare void @baz()

; Check that !noundef metadata is combined
define ptr @test_phi_combine_load_metadata(i1 %c, ptr dereferenceable(8) %p1, ptr dereferenceable(8) %p2) {
; CHECK-LABEL: @test_phi_combine_load_metadata(
; CHECK-NEXT:    br i1 [[C:%.*]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       t:
; CHECK-NEXT:    call void @bar()
; CHECK-NEXT:    br label [[CONT:%.*]]
; CHECK:       f:
; CHECK-NEXT:    call void @baz()
; CHECK-NEXT:    br label [[CONT]]
; CHECK:       cont:
; CHECK-NEXT:    [[RES_IN:%.*]] = phi ptr [ [[P1:%.*]], [[T]] ], [ [[P2:%.*]], [[F]] ]
; CHECK-NEXT:    [[RES:%.*]] = load ptr, ptr [[RES_IN]], align 8, !noundef !0
; CHECK-NEXT:    ret ptr [[RES]]
;
  br i1 %c, label %t, label %f
t:
  call void @bar()
  %v1 = load ptr, ptr %p1, align 8, !noundef !0
  br label %cont

f:
  call void @baz()
  %v2 = load ptr, ptr %p2, align 8, !noundef !0
  br label %cont

cont:
  %res = phi ptr [ %v1, %t ], [ %v2, %f ]
  ret ptr %res
}

; Check that !noundef metadata is not combined as a result of
; there is a load don't have a noundef metadata.
define ptr @test_phi_combine_load_metadata_negative(i1 %c, ptr dereferenceable(8) %p1, ptr dereferenceable(8) %p2) {
; CHECK-LABEL: @test_phi_combine_load_metadata_negative(
; CHECK-NEXT:    br i1 [[C:%.*]], label [[T:%.*]], label [[F:%.*]]
; CHECK:       t:
; CHECK-NEXT:    call void @bar()
; CHECK-NEXT:    br label [[CONT:%.*]]
; CHECK:       f:
; CHECK-NEXT:    call void @baz()
; CHECK-NEXT:    br label [[CONT]]
; CHECK:       cont:
; CHECK-NEXT:    [[RES_IN:%.*]] = phi ptr [ [[P1:%.*]], [[T]] ], [ [[P2:%.*]], [[F]] ]
; CHECK-NEXT:    [[RES:%.*]] = load ptr, ptr [[RES_IN]], align 8
; CHECK-NEXT:    ret ptr [[RES]]
;
  br i1 %c, label %t, label %f
t:
  call void @bar()
  %v1 = load ptr, ptr %p1, align 8, !noundef !0
  br label %cont

f:
  call void @baz()
  %v2 = load ptr, ptr %p2, align 8
  br label %cont

cont:
  %res = phi ptr [ %v1, %t ], [ %v2, %f ]
  ret ptr %res
}

!0 = !{}
