; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple arm64-apple-ios -mattr +cmpbr -verify-machineinstrs -o - < %s | FileCheck %s --check-prefix=CHECK-CMPBR
; RUN: llc -mtriple arm64-apple-ios -mattr -cmpbr -verify-machineinstrs -o - < %s | FileCheck %s --check-prefix=CHECK-NO-CMPBR

define void @cbgt_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: cbgt_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbgt w0, #10, LBB0_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB0_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cbgt_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, #11
; CHECK-NO-CMPBR-NEXT:    b.ge LBB0_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB0_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp sgt i32 %a, 10
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cblt_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: cblt_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cblt w0, #10, LBB1_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB1_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cblt_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, #9
; CHECK-NO-CMPBR-NEXT:    b.le LBB1_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB1_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp slt i32 %a, 10
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cbhi_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: cbhi_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbhi w0, #10, LBB2_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB2_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cbhi_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, #11
; CHECK-NO-CMPBR-NEXT:    b.hs LBB2_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB2_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp ugt i32 %a, 10
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cblo_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: cblo_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cblo w0, #10, LBB3_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB3_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cblo_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, #9
; CHECK-NO-CMPBR-NEXT:    b.ls LBB3_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB3_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp ult i32 %a, 10
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cbeq_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: cbeq_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbeq w0, #10, LBB4_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB4_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cbeq_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, #10
; CHECK-NO-CMPBR-NEXT:    b.eq LBB4_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB4_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp eq i32 %a, 10
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cbne_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: cbne_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbne w0, #10, LBB5_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB5_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cbne_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, #10
; CHECK-NO-CMPBR-NEXT:    b.ne LBB5_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB5_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp ne i32 %a, 10
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cbge_gt_dec_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: cbge_gt_dec_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbgt w0, #9, LBB6_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB6_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cbge_gt_dec_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, #10
; CHECK-NO-CMPBR-NEXT:    b.ge LBB6_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB6_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp sge i32 %a, 10
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cbhs_hi_dec_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: cbhs_hi_dec_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbhi w0, #9, LBB7_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB7_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cbhs_hi_dec_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, #10
; CHECK-NO-CMPBR-NEXT:    b.hs LBB7_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB7_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp uge i32 %a, 10
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cble_lt_inc_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: cble_lt_inc_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cblt w0, #11, LBB8_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB8_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cble_lt_inc_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, #10
; CHECK-NO-CMPBR-NEXT:    b.le LBB8_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB8_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp sle i32 %a, 10
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cbls_lo_inc_i32(i32 %a)  {
; CHECK-CMPBR-LABEL: cbls_lo_inc_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cblo w0, #11, LBB9_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB9_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cbls_lo_inc_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, #10
; CHECK-NO-CMPBR-NEXT:    b.ls LBB9_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB9_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp ule i32 %a, 10
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cbgt_i64(i64 %a)  {
; CHECK-CMPBR-LABEL: cbgt_i64:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbgt x0, #10, LBB10_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB10_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cbgt_i64:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp x0, #11
; CHECK-NO-CMPBR-NEXT:    b.ge LBB10_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB10_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp sgt i64 %a, 10
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cblt_i64(i64 %a)  {
; CHECK-CMPBR-LABEL: cblt_i64:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cblt x0, #10, LBB11_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB11_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cblt_i64:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp x0, #9
; CHECK-NO-CMPBR-NEXT:    b.le LBB11_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB11_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp slt i64 %a, 10
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cbhi_i64(i64 %a)  {
; CHECK-CMPBR-LABEL: cbhi_i64:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbhi x0, #10, LBB12_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB12_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cbhi_i64:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp x0, #11
; CHECK-NO-CMPBR-NEXT:    b.hs LBB12_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB12_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp ugt i64 %a, 10
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cblo_i64(i64 %a)  {
; CHECK-CMPBR-LABEL: cblo_i64:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cblo x0, #10, LBB13_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB13_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cblo_i64:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp x0, #9
; CHECK-NO-CMPBR-NEXT:    b.ls LBB13_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB13_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp ult i64 %a, 10
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cbeq_i64(i64 %a)  {
; CHECK-CMPBR-LABEL: cbeq_i64:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbeq x0, #10, LBB14_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB14_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cbeq_i64:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp x0, #10
; CHECK-NO-CMPBR-NEXT:    b.eq LBB14_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB14_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp eq i64 %a, 10
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cbne_i64(i64 %a)  {
; CHECK-CMPBR-LABEL: cbne_i64:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbne x0, #10, LBB15_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB15_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cbne_i64:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp x0, #10
; CHECK-NO-CMPBR-NEXT:    b.ne LBB15_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB15_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp ne i64 %a, 10
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cbge_gt_dec_i64(i64 %a)  {
; CHECK-CMPBR-LABEL: cbge_gt_dec_i64:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbgt x0, #9, LBB16_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB16_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cbge_gt_dec_i64:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp x0, #10
; CHECK-NO-CMPBR-NEXT:    b.ge LBB16_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB16_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp sge i64 %a, 10
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cbhs_hi_dec_i64(i64 %a)  {
; CHECK-CMPBR-LABEL: cbhs_hi_dec_i64:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbhi x0, #9, LBB17_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB17_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cbhs_hi_dec_i64:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp x0, #10
; CHECK-NO-CMPBR-NEXT:    b.hs LBB17_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB17_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp uge i64 %a, 10
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cble_lt_inc_i64(i64 %a)  {
; CHECK-CMPBR-LABEL: cble_lt_inc_i64:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cblt x0, #11, LBB18_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB18_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cble_lt_inc_i64:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp x0, #10
; CHECK-NO-CMPBR-NEXT:    b.le LBB18_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB18_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp sle i64 %a, 10
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cbls_lo_inc_i64(i64 %a)  {
; CHECK-CMPBR-LABEL: cbls_lo_inc_i64:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cblo x0, #11, LBB19_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB19_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cbls_lo_inc_i64:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp x0, #10
; CHECK-NO-CMPBR-NEXT:    b.ls LBB19_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB19_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp ule i64 %a, 10
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}
