; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 4
; RUN: opt "-passes=print<scalar-evolution>" -disable-output -S %s 2>&1 | FileCheck %s

; PR59777
define i2 @iv_nsw_poison(i2 %arg) {
; CHECK-LABEL: 'iv_nsw_poison'
; CHECK-NEXT:  Classifying expressions for: @iv_nsw_poison
; CHECK-NEXT:    %.07 = phi i2 [ 1, %bb ], [ %i, %bb1 ]
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%bb1> U: [1,-2) S: [1,-2) Exits: <<Unknown>> LoopDispositions: { %bb1: Computable }
; CHECK-NEXT:    %.0 = phi i2 [ 1, %bb ], [ %i2, %bb1 ]
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%bb1> U: [1,-2) S: [1,-2) Exits: <<Unknown>> LoopDispositions: { %bb1: Computable }
; CHECK-NEXT:    %i = add nsw i2 %.07, 1
; CHECK-NEXT:    --> {-2,+,1}<nuw><%bb1> U: [-2,0) S: [-2,0) Exits: <<Unknown>> LoopDispositions: { %bb1: Computable }
; CHECK-NEXT:    %i2 = add i2 %.0, 1
; CHECK-NEXT:    --> {-2,+,1}<nuw><%bb1> U: [-2,0) S: [-2,0) Exits: <<Unknown>> LoopDispositions: { %bb1: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @iv_nsw_poison
; CHECK-NEXT:  Loop %bb1: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %bb1: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %bb1: Unpredictable symbolic max backedge-taken count.
;
bb:
  br label %bb1

bb1:                                              ; preds = %bb1, %bb
  %.07 = phi i2 [ 1, %bb ], [ %i, %bb1 ]
  %.0 = phi i2 [ 1, %bb ], [ %i2, %bb1 ]
  %i = add nsw i2 %.07, 1
  %i2 = add i2 %.0, 1
  %.not.not = icmp ult i2 %.07, %arg
  br i1 %.not.not, label %common.ret, label %bb1

common.ret:                                       ; preds = %bb1
  ret i2 %i2
}

define i4 @iv_nsw_poison2(i4 %0, i4 %end, i4 %start) {
; CHECK-LABEL: 'iv_nsw_poison2'
; CHECK-NEXT:  Classifying expressions for: @iv_nsw_poison2
; CHECK-NEXT:    %iv.0 = phi i4 [ %start, %entry ], [ %iv.0.next, %loop ]
; CHECK-NEXT:    --> {%start,+,1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.1 = phi i4 [ %start, %entry ], [ %iv.1.next, %loop ]
; CHECK-NEXT:    --> {%start,+,1}<nsw><%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.0.next = add i4 %iv.0, 1
; CHECK-NEXT:    --> {(1 + %start),+,1}<nw><%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.1.next = add nsw i4 %iv.1, 1
; CHECK-NEXT:    --> {(1 + %start),+,1}<nw><%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @iv_nsw_poison2
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
;
entry:
  br label %loop

loop:
  %iv.0 = phi i4 [ %start, %entry ], [ %iv.0.next, %loop ]
  %iv.1 = phi i4 [ %start, %entry ], [ %iv.1.next, %loop ]
  %iv.0.next = add i4 %iv.0, 1
  %iv.1.next = add nsw i4 %iv.1, 1
  %.not.not = icmp ult i4 %iv.0, %end
  br i1 %.not.not, label %exit, label %loop

exit:
  ret i4 %iv.1.next
}

define i2 @iv_both_adds_nsw(i2 %arg) {
; CHECK-LABEL: 'iv_both_adds_nsw'
; CHECK-NEXT:  Classifying expressions for: @iv_both_adds_nsw
; CHECK-NEXT:    %iv.0 = phi i2 [ 1, %bb ], [ %iv.0.next, %loop ]
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%loop> U: [1,-2) S: [1,-2) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.1 = phi i2 [ 1, %bb ], [ %iv.1.next, %loop ]
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%loop> U: [1,-2) S: [1,-2) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.0.next = add nsw i2 %iv.0, 1
; CHECK-NEXT:    --> {-2,+,1}<nuw><%loop> U: [-2,0) S: [-2,0) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.1.next = add nsw i2 %iv.1, 1
; CHECK-NEXT:    --> {-2,+,1}<nuw><%loop> U: [-2,0) S: [-2,0) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @iv_both_adds_nsw
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
;
bb:
  br label %loop

loop:
  %iv.0 = phi i2 [ 1, %bb ], [ %iv.0.next, %loop ]
  %iv.1 = phi i2 [ 1, %bb ], [ %iv.1.next, %loop ]
  %iv.0.next = add nsw i2 %iv.0, 1
  %iv.1.next = add nsw i2 %iv.1, 1
  %.not.not = icmp ult i2 %iv.0, %arg
  br i1 %.not.not, label %exit, label %loop

exit:
  ret i2 %iv.1.next
}

define i4 @iv_both_adds_nsw_extra_use(i4 %arg) {
; CHECK-LABEL: 'iv_both_adds_nsw_extra_use'
; CHECK-NEXT:  Classifying expressions for: @iv_both_adds_nsw_extra_use
; CHECK-NEXT:    %iv.0 = phi i4 [ 1, %bb ], [ %iv.0.next, %loop ]
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%loop> U: [1,-8) S: [1,-8) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.1 = phi i4 [ 1, %bb ], [ %iv.1.next, %loop ]
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%loop> U: [1,-8) S: [1,-8) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.0.next = add nsw i4 %iv.0, 1
; CHECK-NEXT:    --> {2,+,1}<nuw><%loop> U: [2,0) S: [2,0) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.1.next = add nsw i4 %iv.1, 1
; CHECK-NEXT:    --> {2,+,1}<nuw><%loop> U: [2,0) S: [2,0) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @iv_both_adds_nsw_extra_use
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
;
bb:
  br label %loop

loop:
  %iv.0 = phi i4 [ 1, %bb ], [ %iv.0.next, %loop ]
  %iv.1 = phi i4 [ 1, %bb ], [ %iv.1.next, %loop ]
  %iv.0.next = add nsw i4 %iv.0, 1
  call void @use(i4 %iv.0.next)
  %iv.1.next = add nsw i4 %iv.1, 1
  call void @use(i4 %iv.1.next)
  %.not.not = icmp ult i4 %iv.0, %arg
  br i1 %.not.not, label %exit, label %loop

exit:
  ret i4 %iv.1.next
}

define i4 @iv_both_adds_nsw_extra_use_incs_reordered(i4 %arg) {
; CHECK-LABEL: 'iv_both_adds_nsw_extra_use_incs_reordered'
; CHECK-NEXT:  Classifying expressions for: @iv_both_adds_nsw_extra_use_incs_reordered
; CHECK-NEXT:    %iv.0 = phi i4 [ 1, %bb ], [ %iv.0.next, %loop ]
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%loop> U: [1,-8) S: [1,-8) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.1 = phi i4 [ 1, %bb ], [ %iv.1.next, %loop ]
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%loop> U: [1,-8) S: [1,-8) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.1.next = add nsw i4 %iv.1, 1
; CHECK-NEXT:    --> {2,+,1}<nuw><%loop> U: [2,0) S: [2,0) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.0.next = add nsw i4 %iv.0, 1
; CHECK-NEXT:    --> {2,+,1}<nuw><%loop> U: [2,0) S: [2,0) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @iv_both_adds_nsw_extra_use_incs_reordered
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
;
bb:
  br label %loop

loop:
  %iv.0 = phi i4 [ 1, %bb ], [ %iv.0.next, %loop ]
  %iv.1 = phi i4 [ 1, %bb ], [ %iv.1.next, %loop ]
  %iv.1.next = add nsw i4 %iv.1, 1
  call void @use(i4 %iv.1.next)
  %iv.0.next = add nsw i4 %iv.0, 1
  call void @use(i4 %iv.0.next)
  %.not.not = icmp ult i4 %iv.0, %arg
  br i1 %.not.not, label %exit, label %loop

exit:
  ret i4 %iv.1.next
}

define i4 @iv_nsw_poison_extra_use(i4 %0, i4 %end, i4 %start) {
; CHECK-LABEL: 'iv_nsw_poison_extra_use'
; CHECK-NEXT:  Classifying expressions for: @iv_nsw_poison_extra_use
; CHECK-NEXT:    %iv.0 = phi i4 [ %start, %entry ], [ %iv.0.next, %loop ]
; CHECK-NEXT:    --> {%start,+,1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.1 = phi i4 [ %start, %entry ], [ %iv.1.next, %loop ]
; CHECK-NEXT:    --> {%start,+,1}<nsw><%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.0.next = add i4 %iv.0, 1
; CHECK-NEXT:    --> {(1 + %start),+,1}<nw><%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.1.next = add nsw i4 %iv.1, 1
; CHECK-NEXT:    --> {(1 + %start),+,1}<nw><%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @iv_nsw_poison_extra_use
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
;
entry:
  br label %loop

loop:
  %iv.0 = phi i4 [ %start, %entry ], [ %iv.0.next, %loop ]
  %iv.1 = phi i4 [ %start, %entry ], [ %iv.1.next, %loop ]
  %iv.0.next = add i4 %iv.0, 1
  call void @use(i4 %iv.0.next)
  %iv.1.next = add nsw i4 %iv.1, 1
  %.not.not = icmp ult i4 %iv.0, %end
  br i1 %.not.not, label %exit, label %loop

exit:
  ret i4 %iv.1.next
}

declare void @use(i4)

define i2 @iv_nuw_poison(i2 %arg, i2 %start) {
; CHECK-LABEL: 'iv_nuw_poison'
; CHECK-NEXT:  Classifying expressions for: @iv_nuw_poison
; CHECK-NEXT:    %.07 = phi i2 [ %start, %bb ], [ %i, %bb1 ]
; CHECK-NEXT:    --> {%start,+,1}<nuw><%bb1> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %bb1: Computable }
; CHECK-NEXT:    %.0 = phi i2 [ %start, %bb ], [ %i2, %bb1 ]
; CHECK-NEXT:    --> {%start,+,1}<nuw><%bb1> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %bb1: Computable }
; CHECK-NEXT:    %i = add nuw i2 %.07, 1
; CHECK-NEXT:    --> {(1 + %start),+,1}<nw><%bb1> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %bb1: Computable }
; CHECK-NEXT:    %i2 = add i2 %.0, 1
; CHECK-NEXT:    --> {(1 + %start),+,1}<nw><%bb1> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %bb1: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @iv_nuw_poison
; CHECK-NEXT:  Loop %bb1: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %bb1: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %bb1: Unpredictable symbolic max backedge-taken count.
;
bb:
  br label %bb1

bb1:                                              ; preds = %bb1, %bb
  %.07 = phi i2 [ %start, %bb ], [ %i, %bb1 ]
  %.0 = phi i2 [ %start, %bb ], [ %i2, %bb1 ]
  %i = add nuw i2 %.07, 1
  %i2 = add i2 %.0, 1
  %.not.not = icmp ult i2 %.07, %arg
  br i1 %.not.not, label %common.ret, label %bb1

common.ret:                                       ; preds = %bb1
  ret i2 %i2
}

define i4 @iv_nuw_poison2(i4 %0, i4 %end, i4 %start) {
; CHECK-LABEL: 'iv_nuw_poison2'
; CHECK-NEXT:  Classifying expressions for: @iv_nuw_poison2
; CHECK-NEXT:    %iv.0 = phi i4 [ %start, %entry ], [ %iv.0.next, %loop ]
; CHECK-NEXT:    --> {%start,+,1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.1 = phi i4 [ %start, %entry ], [ %iv.1.next, %loop ]
; CHECK-NEXT:    --> {%start,+,1}<nuw><%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.0.next = add i4 %iv.0, 1
; CHECK-NEXT:    --> {(1 + %start),+,1}<nw><%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.1.next = add nuw i4 %iv.1, 1
; CHECK-NEXT:    --> {(1 + %start),+,1}<nw><%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @iv_nuw_poison2
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
;
entry:
  br label %loop

loop:
  %iv.0 = phi i4 [ %start, %entry ], [ %iv.0.next, %loop ]
  %iv.1 = phi i4 [ %start, %entry ], [ %iv.1.next, %loop ]
  %iv.0.next = add i4 %iv.0, 1
  %iv.1.next = add nuw i4 %iv.1, 1
  %.not.not = icmp ult i4 %iv.0, %end
  br i1 %.not.not, label %exit, label %loop

exit:
  ret i4 %iv.1.next
}

define i2 @iv_both_adds_nuw(i2 %arg, i2 %start) {
; CHECK-LABEL: 'iv_both_adds_nuw'
; CHECK-NEXT:  Classifying expressions for: @iv_both_adds_nuw
; CHECK-NEXT:    %iv.0 = phi i2 [ %start, %bb ], [ %iv.0.next, %loop ]
; CHECK-NEXT:    --> {%start,+,1}<nuw><%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.1 = phi i2 [ %start, %bb ], [ %iv.1.next, %loop ]
; CHECK-NEXT:    --> {%start,+,1}<nuw><%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.0.next = add nuw i2 %iv.0, 1
; CHECK-NEXT:    --> {(1 + %start),+,1}<nw><%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.1.next = add nuw i2 %iv.1, 1
; CHECK-NEXT:    --> {(1 + %start),+,1}<nw><%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @iv_both_adds_nuw
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
;
bb:
  br label %loop

loop:
  %iv.0 = phi i2 [ %start, %bb ], [ %iv.0.next, %loop ]
  %iv.1 = phi i2 [ %start, %bb ], [ %iv.1.next, %loop ]
  %iv.0.next = add nuw i2 %iv.0, 1
  %iv.1.next = add nuw i2 %iv.1, 1
  %.not.not = icmp ult i2 %iv.0, %arg
  br i1 %.not.not, label %exit, label %loop

exit:
  ret i2 %iv.1.next
}

define i4 @iv_both_adds_nuw_extra_use(i4 %arg, i4 %start) {
; CHECK-LABEL: 'iv_both_adds_nuw_extra_use'
; CHECK-NEXT:  Classifying expressions for: @iv_both_adds_nuw_extra_use
; CHECK-NEXT:    %iv.0 = phi i4 [ %start, %bb ], [ %iv.0.next, %loop ]
; CHECK-NEXT:    --> {%start,+,1}<nuw><%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.1 = phi i4 [ %start, %bb ], [ %iv.1.next, %loop ]
; CHECK-NEXT:    --> {%start,+,1}<nuw><%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.0.next = add nuw i4 %iv.0, 1
; CHECK-NEXT:    --> {(1 + %start),+,1}<nw><%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.1.next = add nuw i4 %iv.1, 1
; CHECK-NEXT:    --> {(1 + %start),+,1}<nw><%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @iv_both_adds_nuw_extra_use
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
;
bb:
  br label %loop

loop:
  %iv.0 = phi i4 [ %start, %bb ], [ %iv.0.next, %loop ]
  %iv.1 = phi i4 [ %start, %bb ], [ %iv.1.next, %loop ]
  %iv.0.next = add nuw i4 %iv.0, 1
  call void @use(i4 %iv.0.next)
  %iv.1.next = add nuw i4 %iv.1, 1
  call void @use(i4 %iv.1.next)
  %.not.not = icmp ult i4 %iv.0, %arg
  br i1 %.not.not, label %exit, label %loop

exit:
  ret i4 %iv.1.next
}

define i4 @iv_both_adds_nuw_extra_use_incs_reordered(i4 %arg, i4 %start) {
; CHECK-LABEL: 'iv_both_adds_nuw_extra_use_incs_reordered'
; CHECK-NEXT:  Classifying expressions for: @iv_both_adds_nuw_extra_use_incs_reordered
; CHECK-NEXT:    %iv.0 = phi i4 [ %start, %bb ], [ %iv.0.next, %loop ]
; CHECK-NEXT:    --> {%start,+,1}<nuw><%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.1 = phi i4 [ %start, %bb ], [ %iv.1.next, %loop ]
; CHECK-NEXT:    --> {%start,+,1}<nuw><%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.1.next = add nuw i4 %iv.1, 1
; CHECK-NEXT:    --> {(1 + %start),+,1}<nw><%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.0.next = add nuw i4 %iv.0, 1
; CHECK-NEXT:    --> {(1 + %start),+,1}<nw><%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @iv_both_adds_nuw_extra_use_incs_reordered
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
;
bb:
  br label %loop

loop:
  %iv.0 = phi i4 [ %start, %bb ], [ %iv.0.next, %loop ]
  %iv.1 = phi i4 [ %start, %bb ], [ %iv.1.next, %loop ]
  %iv.1.next = add nuw i4 %iv.1, 1
  call void @use(i4 %iv.1.next)
  %iv.0.next = add nuw i4 %iv.0, 1
  call void @use(i4 %iv.0.next)
  %.not.not = icmp ult i4 %iv.0, %arg
  br i1 %.not.not, label %exit, label %loop

exit:
  ret i4 %iv.1.next
}

define i4 @iv_nuw_poison_extra_use(i4 %0, i4 %end, i4 %start) {
; CHECK-LABEL: 'iv_nuw_poison_extra_use'
; CHECK-NEXT:  Classifying expressions for: @iv_nuw_poison_extra_use
; CHECK-NEXT:    %iv.0 = phi i4 [ %start, %entry ], [ %iv.0.next, %loop ]
; CHECK-NEXT:    --> {%start,+,1}<%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.1 = phi i4 [ %start, %entry ], [ %iv.1.next, %loop ]
; CHECK-NEXT:    --> {%start,+,1}<nuw><%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.0.next = add i4 %iv.0, 1
; CHECK-NEXT:    --> {(1 + %start),+,1}<nw><%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.1.next = add nuw i4 %iv.1, 1
; CHECK-NEXT:    --> {(1 + %start),+,1}<nw><%loop> U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @iv_nuw_poison_extra_use
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
;
entry:
  br label %loop

loop:
  %iv.0 = phi i4 [ %start, %entry ], [ %iv.0.next, %loop ]
  %iv.1 = phi i4 [ %start, %entry ], [ %iv.1.next, %loop ]
  %iv.0.next = add i4 %iv.0, 1
  call void @use(i4 %iv.0.next)
  %iv.1.next = add nuw i4 %iv.1, 1
  %.not.not = icmp ult i4 %iv.0, %end
  br i1 %.not.not, label %exit, label %loop

exit:
  ret i4 %iv.1.next
}
