; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal  -attributor-annotate-decl-cs  -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT
; RUN: opt -aa-pipeline=basic-aa -passes=attributor-cgscc -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,CGSCC

declare float @llvm.arithmetic.fence.f32(float)
declare float @extern(float)

; arg missing nofpclass
define nofpclass(nan) float @return_implies_arg(float %arg) {
; CHECK-LABEL: define nofpclass(nan) float @return_implies_arg
; CHECK-SAME: (float returned [[ARG:%.*]]) #[[ATTR1:[0-9]+]] {
; CHECK-NEXT:    ret float [[ARG]]
;
  ret float %arg
}

; return should get marked nofpclass(inf nan)
define internal float @callsite_implies_return() {
; CHECK-LABEL: define internal float @callsite_implies_return() {
; CHECK-NEXT:    [[VALUE:%.*]] = call float @extern(float noundef nofpclass(nan inf zero sub nnorm) 1.000000e+00)
; CHECK-NEXT:    ret float [[VALUE]]
;
  %value = call float @extern(float 1.0)
  ret float %value
}

; arg should get nofpclass(inf nan)
define float @nofpclass_callsite_arg_implies_arg(float %arg) {
; CHECK-LABEL: define float @nofpclass_callsite_arg_implies_arg
; CHECK-SAME: (float nofpclass(nan inf) [[ARG:%.*]]) {
; CHECK-NEXT:    [[CALL:%.*]] = call float @extern(float nofpclass(nan inf) [[ARG]])
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @extern(float nofpclass(inf nan) %arg)
  ret float %call
}

define float @nofpclass_earlier_call_implies_later_call_arg(float %arg) {
; CHECK-LABEL: define float @nofpclass_earlier_call_implies_later_call_arg
; CHECK-SAME: (float nofpclass(nan inf) [[ARG:%.*]]) {
; CHECK-NEXT:    [[CALL0:%.*]] = call float @extern(float nofpclass(nan inf) [[ARG]])
; CHECK-NEXT:    [[CALL1:%.*]] = call float @extern(float nofpclass(nan inf) [[ARG]])
; CHECK-NEXT:    [[ADD:%.*]] = fadd float [[CALL0]], [[CALL1]]
; CHECK-NEXT:    ret float [[ADD]]
;
  %call0 = call float @extern(float nofpclass(inf nan) %arg)
  %call1 = call float @extern(float %arg) ; nofpclass should be implied here
  %add = fadd float %call0, %call1
  ret float %add
}

define float @nnan_ninf_implies_arg_return(float %arg) {
; CHECK-LABEL: define nofpclass(nan inf) float @nnan_ninf_implies_arg_return
; CHECK-SAME: (float [[ARG:%.*]]) {
; CHECK-NEXT:    [[CALL:%.*]] = call nnan ninf nofpclass(nan inf) float @extern(float [[ARG]])
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call nnan ninf float @extern(float %arg)
  ret float %call
}

define float @callsite_returns_nofpclass_nan() {
; CHECK-LABEL: define nofpclass(nan inf) float @callsite_returns_nofpclass_nan() {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(nan inf) float @callsite_implies_return()
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call nofpclass(inf nan) float @callsite_implies_return()
  ret float %call
}


define float @nnan_implies_arg_return(float %arg) {
; CHECK-LABEL: define nofpclass(nan) float @nnan_implies_arg_return
; CHECK-SAME: (float [[ARG:%.*]]) {
; CHECK-NEXT:    [[CALL:%.*]] = call nnan nofpclass(nan) float @extern(float [[ARG]])
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call nnan float @extern(float %arg)
  ret float %call
}

define float @ninf_implies_arg_return(float %arg) {
; CHECK-LABEL: define nofpclass(inf) float @ninf_implies_arg_return
; CHECK-SAME: (float [[ARG:%.*]]) {
; CHECK-NEXT:    [[CALL:%.*]] = call ninf nofpclass(inf) float @extern(float [[ARG]])
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call ninf float @extern(float %arg)
  ret float %call
}

;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CGSCC: {{.*}}
; TUNIT: {{.*}}
