; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -verify-machineinstrs --show-mc-encoding -mtriple=x86_64-unknown-unknown -mattr=+avx512fp16,avx512vl    | FileCheck %s --check-prefixes=CHECK,HasVL
; RUN: llc < %s -verify-machineinstrs --show-mc-encoding -mtriple=x86_64-unknown-unknown -mattr=+avx512fp16    | FileCheck %s --check-prefixes=CHECK,NOVL

declare half @llvm.maxnum.f16(half, half)
declare <2 x half> @llvm.maxnum.v2f16(<2 x half>, <2 x half>)
declare <4 x half> @llvm.maxnum.v4f16(<4 x half>, <4 x half>)
declare <8 x half> @llvm.maxnum.v8f16(<8 x half>, <8 x half>)
declare <16 x half> @llvm.maxnum.v16f16(<16 x half>, <16 x half>)
declare <32 x half> @llvm.maxnum.v32f16(<32 x half>, <32 x half>)

define half @test_intrinsic_fmaxh(half %x, half %y) {
; HasVL-LABEL: test_intrinsic_fmaxh:
; HasVL:       # %bb.0:
; HasVL-NEXT:    vmaxsh %xmm0, %xmm1, %xmm2 # encoding: [0x62,0xf5,0x76,0x08,0x5f,0xd0]
; HasVL-NEXT:    vcmpunordsh %xmm0, %xmm0, %k1 # encoding: [0x62,0xf3,0x7e,0x08,0xc2,0xc8,0x03]
; HasVL-NEXT:    vmovsh %xmm1, %xmm0, %xmm2 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xd1]
; HasVL-NEXT:    vmovaps %xmm2, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf8,0x28,0xc2]
; HasVL-NEXT:    retq # encoding: [0xc3]
;
; NOVL-LABEL: test_intrinsic_fmaxh:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vmaxsh %xmm0, %xmm1, %xmm2 # encoding: [0x62,0xf5,0x76,0x08,0x5f,0xd0]
; NOVL-NEXT:    vcmpunordsh %xmm0, %xmm0, %k1 # encoding: [0x62,0xf3,0x7e,0x08,0xc2,0xc8,0x03]
; NOVL-NEXT:    vmovsh %xmm1, %xmm0, %xmm2 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xd1]
; NOVL-NEXT:    vmovaps %xmm2, %xmm0 # encoding: [0xc5,0xf8,0x28,0xc2]
; NOVL-NEXT:    retq # encoding: [0xc3]
  %z = call half @llvm.maxnum.f16(half %x, half %y) readnone
  ret half %z
}

define <2 x half> @test_intrinsic_fmax_v2f16(<2 x half> %x, <2 x half> %y) {
; HasVL-LABEL: test_intrinsic_fmax_v2f16:
; HasVL:       # %bb.0:
; HasVL-NEXT:    vmaxph %xmm0, %xmm1, %xmm2 # encoding: [0x62,0xf5,0x74,0x08,0x5f,0xd0]
; HasVL-NEXT:    vcmpunordph %xmm0, %xmm0, %k1 # encoding: [0x62,0xf3,0x7c,0x08,0xc2,0xc8,0x03]
; HasVL-NEXT:    vmovdqu16 %xmm1, %xmm2 {%k1} # encoding: [0x62,0xf1,0xff,0x09,0x6f,0xd1]
; HasVL-NEXT:    vmovdqa %xmm2, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf9,0x6f,0xc2]
; HasVL-NEXT:    retq # encoding: [0xc3]
;
; NOVL-LABEL: test_intrinsic_fmax_v2f16:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vpsrldq $14, %xmm0, %xmm2 # encoding: [0xc5,0xe9,0x73,0xd8,0x0e]
; NOVL-NEXT:    # xmm2 = xmm0[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; NOVL-NEXT:    vpsrldq $14, %xmm1, %xmm3 # encoding: [0xc5,0xe1,0x73,0xd9,0x0e]
; NOVL-NEXT:    # xmm3 = xmm1[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; NOVL-NEXT:    vmaxsh %xmm2, %xmm3, %xmm4 # encoding: [0x62,0xf5,0x66,0x08,0x5f,0xe2]
; NOVL-NEXT:    vcmpunordsh %xmm2, %xmm2, %k1 # encoding: [0x62,0xf3,0x6e,0x08,0xc2,0xca,0x03]
; NOVL-NEXT:    vmovsh %xmm3, %xmm0, %xmm4 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xe3]
; NOVL-NEXT:    vshufps $255, %xmm0, %xmm0, %xmm2 # encoding: [0xc5,0xf8,0xc6,0xd0,0xff]
; NOVL-NEXT:    # xmm2 = xmm0[3,3,3,3]
; NOVL-NEXT:    vpshufd $255, %xmm1, %xmm3 # encoding: [0xc5,0xf9,0x70,0xd9,0xff]
; NOVL-NEXT:    # xmm3 = xmm1[3,3,3,3]
; NOVL-NEXT:    vmaxsh %xmm2, %xmm3, %xmm5 # encoding: [0x62,0xf5,0x66,0x08,0x5f,0xea]
; NOVL-NEXT:    vcmpunordsh %xmm2, %xmm2, %k1 # encoding: [0x62,0xf3,0x6e,0x08,0xc2,0xca,0x03]
; NOVL-NEXT:    vmovsh %xmm3, %xmm0, %xmm5 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xeb]
; NOVL-NEXT:    vpunpcklwd %xmm4, %xmm5, %xmm2 # encoding: [0xc5,0xd1,0x61,0xd4]
; NOVL-NEXT:    # xmm2 = xmm5[0],xmm4[0],xmm5[1],xmm4[1],xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; NOVL-NEXT:    vpsrldq $10, %xmm0, %xmm3 # encoding: [0xc5,0xe1,0x73,0xd8,0x0a]
; NOVL-NEXT:    # xmm3 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; NOVL-NEXT:    vpsrldq $10, %xmm1, %xmm4 # encoding: [0xc5,0xd9,0x73,0xd9,0x0a]
; NOVL-NEXT:    # xmm4 = xmm1[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; NOVL-NEXT:    vmaxsh %xmm3, %xmm4, %xmm5 # encoding: [0x62,0xf5,0x5e,0x08,0x5f,0xeb]
; NOVL-NEXT:    vcmpunordsh %xmm3, %xmm3, %k1 # encoding: [0x62,0xf3,0x66,0x08,0xc2,0xcb,0x03]
; NOVL-NEXT:    vmovsh %xmm4, %xmm0, %xmm5 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xec]
; NOVL-NEXT:    vshufpd $1, %xmm0, %xmm0, %xmm3 # encoding: [0xc5,0xf9,0xc6,0xd8,0x01]
; NOVL-NEXT:    # xmm3 = xmm0[1,0]
; NOVL-NEXT:    vshufpd $1, %xmm1, %xmm1, %xmm4 # encoding: [0xc5,0xf1,0xc6,0xe1,0x01]
; NOVL-NEXT:    # xmm4 = xmm1[1,0]
; NOVL-NEXT:    vmaxsh %xmm3, %xmm4, %xmm6 # encoding: [0x62,0xf5,0x5e,0x08,0x5f,0xf3]
; NOVL-NEXT:    vcmpunordsh %xmm3, %xmm3, %k1 # encoding: [0x62,0xf3,0x66,0x08,0xc2,0xcb,0x03]
; NOVL-NEXT:    vmovsh %xmm4, %xmm0, %xmm6 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xf4]
; NOVL-NEXT:    vpunpcklwd %xmm5, %xmm6, %xmm3 # encoding: [0xc5,0xc9,0x61,0xdd]
; NOVL-NEXT:    # xmm3 = xmm6[0],xmm5[0],xmm6[1],xmm5[1],xmm6[2],xmm5[2],xmm6[3],xmm5[3]
; NOVL-NEXT:    vpunpckldq %xmm2, %xmm3, %xmm2 # encoding: [0xc5,0xe1,0x62,0xd2]
; NOVL-NEXT:    # xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; NOVL-NEXT:    vpsrlq $48, %xmm0, %xmm3 # encoding: [0xc5,0xe1,0x73,0xd0,0x30]
; NOVL-NEXT:    vpsrlq $48, %xmm1, %xmm4 # encoding: [0xc5,0xd9,0x73,0xd1,0x30]
; NOVL-NEXT:    vmaxsh %xmm3, %xmm4, %xmm5 # encoding: [0x62,0xf5,0x5e,0x08,0x5f,0xeb]
; NOVL-NEXT:    vcmpunordsh %xmm3, %xmm3, %k1 # encoding: [0x62,0xf3,0x66,0x08,0xc2,0xcb,0x03]
; NOVL-NEXT:    vmovsh %xmm4, %xmm0, %xmm5 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xec]
; NOVL-NEXT:    vmovshdup %xmm0, %xmm3 # encoding: [0xc5,0xfa,0x16,0xd8]
; NOVL-NEXT:    # xmm3 = xmm0[1,1,3,3]
; NOVL-NEXT:    vmovshdup %xmm1, %xmm4 # encoding: [0xc5,0xfa,0x16,0xe1]
; NOVL-NEXT:    # xmm4 = xmm1[1,1,3,3]
; NOVL-NEXT:    vmaxsh %xmm3, %xmm4, %xmm6 # encoding: [0x62,0xf5,0x5e,0x08,0x5f,0xf3]
; NOVL-NEXT:    vcmpunordsh %xmm3, %xmm3, %k1 # encoding: [0x62,0xf3,0x66,0x08,0xc2,0xcb,0x03]
; NOVL-NEXT:    vmovsh %xmm4, %xmm0, %xmm6 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xf4]
; NOVL-NEXT:    vpunpcklwd %xmm5, %xmm6, %xmm3 # encoding: [0xc5,0xc9,0x61,0xdd]
; NOVL-NEXT:    # xmm3 = xmm6[0],xmm5[0],xmm6[1],xmm5[1],xmm6[2],xmm5[2],xmm6[3],xmm5[3]
; NOVL-NEXT:    vmaxsh %xmm0, %xmm1, %xmm4 # encoding: [0x62,0xf5,0x76,0x08,0x5f,0xe0]
; NOVL-NEXT:    vcmpunordsh %xmm0, %xmm0, %k1 # encoding: [0x62,0xf3,0x7e,0x08,0xc2,0xc8,0x03]
; NOVL-NEXT:    vmovsh %xmm1, %xmm0, %xmm4 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xe1]
; NOVL-NEXT:    vpsrld $16, %xmm0, %xmm0 # encoding: [0xc5,0xf9,0x72,0xd0,0x10]
; NOVL-NEXT:    vpsrld $16, %xmm1, %xmm1 # encoding: [0xc5,0xf1,0x72,0xd1,0x10]
; NOVL-NEXT:    vmaxsh %xmm0, %xmm1, %xmm5 # encoding: [0x62,0xf5,0x76,0x08,0x5f,0xe8]
; NOVL-NEXT:    vcmpunordsh %xmm0, %xmm0, %k1 # encoding: [0x62,0xf3,0x7e,0x08,0xc2,0xc8,0x03]
; NOVL-NEXT:    vmovsh %xmm1, %xmm0, %xmm5 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xe9]
; NOVL-NEXT:    vpunpcklwd %xmm5, %xmm4, %xmm0 # encoding: [0xc5,0xd9,0x61,0xc5]
; NOVL-NEXT:    # xmm0 = xmm4[0],xmm5[0],xmm4[1],xmm5[1],xmm4[2],xmm5[2],xmm4[3],xmm5[3]
; NOVL-NEXT:    vpunpckldq %xmm3, %xmm0, %xmm0 # encoding: [0xc5,0xf9,0x62,0xc3]
; NOVL-NEXT:    # xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; NOVL-NEXT:    vpunpcklqdq %xmm2, %xmm0, %xmm0 # encoding: [0xc5,0xf9,0x6c,0xc2]
; NOVL-NEXT:    # xmm0 = xmm0[0],xmm2[0]
; NOVL-NEXT:    retq # encoding: [0xc3]
  %z = call <2 x half> @llvm.maxnum.v2f16(<2 x half> %x, <2 x half> %y) readnone
  ret <2 x half> %z
}

define <4 x half> @test_intrinsic_fmax_v4f16(<4 x half> %x, <4 x half> %y) {
; HasVL-LABEL: test_intrinsic_fmax_v4f16:
; HasVL:       # %bb.0:
; HasVL-NEXT:    vmaxph %xmm0, %xmm1, %xmm2 # encoding: [0x62,0xf5,0x74,0x08,0x5f,0xd0]
; HasVL-NEXT:    vcmpunordph %xmm0, %xmm0, %k1 # encoding: [0x62,0xf3,0x7c,0x08,0xc2,0xc8,0x03]
; HasVL-NEXT:    vmovdqu16 %xmm1, %xmm2 {%k1} # encoding: [0x62,0xf1,0xff,0x09,0x6f,0xd1]
; HasVL-NEXT:    vmovdqa %xmm2, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf9,0x6f,0xc2]
; HasVL-NEXT:    retq # encoding: [0xc3]
;
; NOVL-LABEL: test_intrinsic_fmax_v4f16:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vpsrldq $14, %xmm0, %xmm2 # encoding: [0xc5,0xe9,0x73,0xd8,0x0e]
; NOVL-NEXT:    # xmm2 = xmm0[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; NOVL-NEXT:    vpsrldq $14, %xmm1, %xmm3 # encoding: [0xc5,0xe1,0x73,0xd9,0x0e]
; NOVL-NEXT:    # xmm3 = xmm1[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; NOVL-NEXT:    vmaxsh %xmm2, %xmm3, %xmm4 # encoding: [0x62,0xf5,0x66,0x08,0x5f,0xe2]
; NOVL-NEXT:    vcmpunordsh %xmm2, %xmm2, %k1 # encoding: [0x62,0xf3,0x6e,0x08,0xc2,0xca,0x03]
; NOVL-NEXT:    vmovsh %xmm3, %xmm0, %xmm4 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xe3]
; NOVL-NEXT:    vshufps $255, %xmm0, %xmm0, %xmm2 # encoding: [0xc5,0xf8,0xc6,0xd0,0xff]
; NOVL-NEXT:    # xmm2 = xmm0[3,3,3,3]
; NOVL-NEXT:    vpshufd $255, %xmm1, %xmm3 # encoding: [0xc5,0xf9,0x70,0xd9,0xff]
; NOVL-NEXT:    # xmm3 = xmm1[3,3,3,3]
; NOVL-NEXT:    vmaxsh %xmm2, %xmm3, %xmm5 # encoding: [0x62,0xf5,0x66,0x08,0x5f,0xea]
; NOVL-NEXT:    vcmpunordsh %xmm2, %xmm2, %k1 # encoding: [0x62,0xf3,0x6e,0x08,0xc2,0xca,0x03]
; NOVL-NEXT:    vmovsh %xmm3, %xmm0, %xmm5 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xeb]
; NOVL-NEXT:    vpunpcklwd %xmm4, %xmm5, %xmm2 # encoding: [0xc5,0xd1,0x61,0xd4]
; NOVL-NEXT:    # xmm2 = xmm5[0],xmm4[0],xmm5[1],xmm4[1],xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; NOVL-NEXT:    vpsrldq $10, %xmm0, %xmm3 # encoding: [0xc5,0xe1,0x73,0xd8,0x0a]
; NOVL-NEXT:    # xmm3 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; NOVL-NEXT:    vpsrldq $10, %xmm1, %xmm4 # encoding: [0xc5,0xd9,0x73,0xd9,0x0a]
; NOVL-NEXT:    # xmm4 = xmm1[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; NOVL-NEXT:    vmaxsh %xmm3, %xmm4, %xmm5 # encoding: [0x62,0xf5,0x5e,0x08,0x5f,0xeb]
; NOVL-NEXT:    vcmpunordsh %xmm3, %xmm3, %k1 # encoding: [0x62,0xf3,0x66,0x08,0xc2,0xcb,0x03]
; NOVL-NEXT:    vmovsh %xmm4, %xmm0, %xmm5 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xec]
; NOVL-NEXT:    vshufpd $1, %xmm0, %xmm0, %xmm3 # encoding: [0xc5,0xf9,0xc6,0xd8,0x01]
; NOVL-NEXT:    # xmm3 = xmm0[1,0]
; NOVL-NEXT:    vshufpd $1, %xmm1, %xmm1, %xmm4 # encoding: [0xc5,0xf1,0xc6,0xe1,0x01]
; NOVL-NEXT:    # xmm4 = xmm1[1,0]
; NOVL-NEXT:    vmaxsh %xmm3, %xmm4, %xmm6 # encoding: [0x62,0xf5,0x5e,0x08,0x5f,0xf3]
; NOVL-NEXT:    vcmpunordsh %xmm3, %xmm3, %k1 # encoding: [0x62,0xf3,0x66,0x08,0xc2,0xcb,0x03]
; NOVL-NEXT:    vmovsh %xmm4, %xmm0, %xmm6 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xf4]
; NOVL-NEXT:    vpunpcklwd %xmm5, %xmm6, %xmm3 # encoding: [0xc5,0xc9,0x61,0xdd]
; NOVL-NEXT:    # xmm3 = xmm6[0],xmm5[0],xmm6[1],xmm5[1],xmm6[2],xmm5[2],xmm6[3],xmm5[3]
; NOVL-NEXT:    vpunpckldq %xmm2, %xmm3, %xmm2 # encoding: [0xc5,0xe1,0x62,0xd2]
; NOVL-NEXT:    # xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; NOVL-NEXT:    vpsrlq $48, %xmm0, %xmm3 # encoding: [0xc5,0xe1,0x73,0xd0,0x30]
; NOVL-NEXT:    vpsrlq $48, %xmm1, %xmm4 # encoding: [0xc5,0xd9,0x73,0xd1,0x30]
; NOVL-NEXT:    vmaxsh %xmm3, %xmm4, %xmm5 # encoding: [0x62,0xf5,0x5e,0x08,0x5f,0xeb]
; NOVL-NEXT:    vcmpunordsh %xmm3, %xmm3, %k1 # encoding: [0x62,0xf3,0x66,0x08,0xc2,0xcb,0x03]
; NOVL-NEXT:    vmovsh %xmm4, %xmm0, %xmm5 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xec]
; NOVL-NEXT:    vmovshdup %xmm0, %xmm3 # encoding: [0xc5,0xfa,0x16,0xd8]
; NOVL-NEXT:    # xmm3 = xmm0[1,1,3,3]
; NOVL-NEXT:    vmovshdup %xmm1, %xmm4 # encoding: [0xc5,0xfa,0x16,0xe1]
; NOVL-NEXT:    # xmm4 = xmm1[1,1,3,3]
; NOVL-NEXT:    vmaxsh %xmm3, %xmm4, %xmm6 # encoding: [0x62,0xf5,0x5e,0x08,0x5f,0xf3]
; NOVL-NEXT:    vcmpunordsh %xmm3, %xmm3, %k1 # encoding: [0x62,0xf3,0x66,0x08,0xc2,0xcb,0x03]
; NOVL-NEXT:    vmovsh %xmm4, %xmm0, %xmm6 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xf4]
; NOVL-NEXT:    vpunpcklwd %xmm5, %xmm6, %xmm3 # encoding: [0xc5,0xc9,0x61,0xdd]
; NOVL-NEXT:    # xmm3 = xmm6[0],xmm5[0],xmm6[1],xmm5[1],xmm6[2],xmm5[2],xmm6[3],xmm5[3]
; NOVL-NEXT:    vmaxsh %xmm0, %xmm1, %xmm4 # encoding: [0x62,0xf5,0x76,0x08,0x5f,0xe0]
; NOVL-NEXT:    vcmpunordsh %xmm0, %xmm0, %k1 # encoding: [0x62,0xf3,0x7e,0x08,0xc2,0xc8,0x03]
; NOVL-NEXT:    vmovsh %xmm1, %xmm0, %xmm4 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xe1]
; NOVL-NEXT:    vpsrld $16, %xmm0, %xmm0 # encoding: [0xc5,0xf9,0x72,0xd0,0x10]
; NOVL-NEXT:    vpsrld $16, %xmm1, %xmm1 # encoding: [0xc5,0xf1,0x72,0xd1,0x10]
; NOVL-NEXT:    vmaxsh %xmm0, %xmm1, %xmm5 # encoding: [0x62,0xf5,0x76,0x08,0x5f,0xe8]
; NOVL-NEXT:    vcmpunordsh %xmm0, %xmm0, %k1 # encoding: [0x62,0xf3,0x7e,0x08,0xc2,0xc8,0x03]
; NOVL-NEXT:    vmovsh %xmm1, %xmm0, %xmm5 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xe9]
; NOVL-NEXT:    vpunpcklwd %xmm5, %xmm4, %xmm0 # encoding: [0xc5,0xd9,0x61,0xc5]
; NOVL-NEXT:    # xmm0 = xmm4[0],xmm5[0],xmm4[1],xmm5[1],xmm4[2],xmm5[2],xmm4[3],xmm5[3]
; NOVL-NEXT:    vpunpckldq %xmm3, %xmm0, %xmm0 # encoding: [0xc5,0xf9,0x62,0xc3]
; NOVL-NEXT:    # xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; NOVL-NEXT:    vpunpcklqdq %xmm2, %xmm0, %xmm0 # encoding: [0xc5,0xf9,0x6c,0xc2]
; NOVL-NEXT:    # xmm0 = xmm0[0],xmm2[0]
; NOVL-NEXT:    retq # encoding: [0xc3]
  %z = call <4 x half> @llvm.maxnum.v4f16(<4 x half> %x, <4 x half> %y) readnone
  ret <4 x half> %z
}

define <8 x half> @test_intrinsic_fmax_v8f16(<8 x half> %x, <8 x half> %y) {
; HasVL-LABEL: test_intrinsic_fmax_v8f16:
; HasVL:       # %bb.0:
; HasVL-NEXT:    vmaxph %xmm0, %xmm1, %xmm2 # encoding: [0x62,0xf5,0x74,0x08,0x5f,0xd0]
; HasVL-NEXT:    vcmpunordph %xmm0, %xmm0, %k1 # encoding: [0x62,0xf3,0x7c,0x08,0xc2,0xc8,0x03]
; HasVL-NEXT:    vmovdqu16 %xmm1, %xmm2 {%k1} # encoding: [0x62,0xf1,0xff,0x09,0x6f,0xd1]
; HasVL-NEXT:    vmovdqa %xmm2, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf9,0x6f,0xc2]
; HasVL-NEXT:    retq # encoding: [0xc3]
;
; NOVL-LABEL: test_intrinsic_fmax_v8f16:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vpsrldq $14, %xmm0, %xmm2 # encoding: [0xc5,0xe9,0x73,0xd8,0x0e]
; NOVL-NEXT:    # xmm2 = xmm0[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; NOVL-NEXT:    vpsrldq $14, %xmm1, %xmm3 # encoding: [0xc5,0xe1,0x73,0xd9,0x0e]
; NOVL-NEXT:    # xmm3 = xmm1[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; NOVL-NEXT:    vmaxsh %xmm2, %xmm3, %xmm4 # encoding: [0x62,0xf5,0x66,0x08,0x5f,0xe2]
; NOVL-NEXT:    vcmpunordsh %xmm2, %xmm2, %k1 # encoding: [0x62,0xf3,0x6e,0x08,0xc2,0xca,0x03]
; NOVL-NEXT:    vmovsh %xmm3, %xmm0, %xmm4 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xe3]
; NOVL-NEXT:    vshufps $255, %xmm0, %xmm0, %xmm2 # encoding: [0xc5,0xf8,0xc6,0xd0,0xff]
; NOVL-NEXT:    # xmm2 = xmm0[3,3,3,3]
; NOVL-NEXT:    vpshufd $255, %xmm1, %xmm3 # encoding: [0xc5,0xf9,0x70,0xd9,0xff]
; NOVL-NEXT:    # xmm3 = xmm1[3,3,3,3]
; NOVL-NEXT:    vmaxsh %xmm2, %xmm3, %xmm5 # encoding: [0x62,0xf5,0x66,0x08,0x5f,0xea]
; NOVL-NEXT:    vcmpunordsh %xmm2, %xmm2, %k1 # encoding: [0x62,0xf3,0x6e,0x08,0xc2,0xca,0x03]
; NOVL-NEXT:    vmovsh %xmm3, %xmm0, %xmm5 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xeb]
; NOVL-NEXT:    vpunpcklwd %xmm4, %xmm5, %xmm2 # encoding: [0xc5,0xd1,0x61,0xd4]
; NOVL-NEXT:    # xmm2 = xmm5[0],xmm4[0],xmm5[1],xmm4[1],xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; NOVL-NEXT:    vpsrldq $10, %xmm0, %xmm3 # encoding: [0xc5,0xe1,0x73,0xd8,0x0a]
; NOVL-NEXT:    # xmm3 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; NOVL-NEXT:    vpsrldq $10, %xmm1, %xmm4 # encoding: [0xc5,0xd9,0x73,0xd9,0x0a]
; NOVL-NEXT:    # xmm4 = xmm1[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; NOVL-NEXT:    vmaxsh %xmm3, %xmm4, %xmm5 # encoding: [0x62,0xf5,0x5e,0x08,0x5f,0xeb]
; NOVL-NEXT:    vcmpunordsh %xmm3, %xmm3, %k1 # encoding: [0x62,0xf3,0x66,0x08,0xc2,0xcb,0x03]
; NOVL-NEXT:    vmovsh %xmm4, %xmm0, %xmm5 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xec]
; NOVL-NEXT:    vshufpd $1, %xmm0, %xmm0, %xmm3 # encoding: [0xc5,0xf9,0xc6,0xd8,0x01]
; NOVL-NEXT:    # xmm3 = xmm0[1,0]
; NOVL-NEXT:    vshufpd $1, %xmm1, %xmm1, %xmm4 # encoding: [0xc5,0xf1,0xc6,0xe1,0x01]
; NOVL-NEXT:    # xmm4 = xmm1[1,0]
; NOVL-NEXT:    vmaxsh %xmm3, %xmm4, %xmm6 # encoding: [0x62,0xf5,0x5e,0x08,0x5f,0xf3]
; NOVL-NEXT:    vcmpunordsh %xmm3, %xmm3, %k1 # encoding: [0x62,0xf3,0x66,0x08,0xc2,0xcb,0x03]
; NOVL-NEXT:    vmovsh %xmm4, %xmm0, %xmm6 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xf4]
; NOVL-NEXT:    vpunpcklwd %xmm5, %xmm6, %xmm3 # encoding: [0xc5,0xc9,0x61,0xdd]
; NOVL-NEXT:    # xmm3 = xmm6[0],xmm5[0],xmm6[1],xmm5[1],xmm6[2],xmm5[2],xmm6[3],xmm5[3]
; NOVL-NEXT:    vpunpckldq %xmm2, %xmm3, %xmm2 # encoding: [0xc5,0xe1,0x62,0xd2]
; NOVL-NEXT:    # xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; NOVL-NEXT:    vpsrlq $48, %xmm0, %xmm3 # encoding: [0xc5,0xe1,0x73,0xd0,0x30]
; NOVL-NEXT:    vpsrlq $48, %xmm1, %xmm4 # encoding: [0xc5,0xd9,0x73,0xd1,0x30]
; NOVL-NEXT:    vmaxsh %xmm3, %xmm4, %xmm5 # encoding: [0x62,0xf5,0x5e,0x08,0x5f,0xeb]
; NOVL-NEXT:    vcmpunordsh %xmm3, %xmm3, %k1 # encoding: [0x62,0xf3,0x66,0x08,0xc2,0xcb,0x03]
; NOVL-NEXT:    vmovsh %xmm4, %xmm0, %xmm5 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xec]
; NOVL-NEXT:    vmovshdup %xmm0, %xmm3 # encoding: [0xc5,0xfa,0x16,0xd8]
; NOVL-NEXT:    # xmm3 = xmm0[1,1,3,3]
; NOVL-NEXT:    vmovshdup %xmm1, %xmm4 # encoding: [0xc5,0xfa,0x16,0xe1]
; NOVL-NEXT:    # xmm4 = xmm1[1,1,3,3]
; NOVL-NEXT:    vmaxsh %xmm3, %xmm4, %xmm6 # encoding: [0x62,0xf5,0x5e,0x08,0x5f,0xf3]
; NOVL-NEXT:    vcmpunordsh %xmm3, %xmm3, %k1 # encoding: [0x62,0xf3,0x66,0x08,0xc2,0xcb,0x03]
; NOVL-NEXT:    vmovsh %xmm4, %xmm0, %xmm6 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xf4]
; NOVL-NEXT:    vpunpcklwd %xmm5, %xmm6, %xmm3 # encoding: [0xc5,0xc9,0x61,0xdd]
; NOVL-NEXT:    # xmm3 = xmm6[0],xmm5[0],xmm6[1],xmm5[1],xmm6[2],xmm5[2],xmm6[3],xmm5[3]
; NOVL-NEXT:    vmaxsh %xmm0, %xmm1, %xmm4 # encoding: [0x62,0xf5,0x76,0x08,0x5f,0xe0]
; NOVL-NEXT:    vcmpunordsh %xmm0, %xmm0, %k1 # encoding: [0x62,0xf3,0x7e,0x08,0xc2,0xc8,0x03]
; NOVL-NEXT:    vmovsh %xmm1, %xmm0, %xmm4 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xe1]
; NOVL-NEXT:    vpsrld $16, %xmm0, %xmm0 # encoding: [0xc5,0xf9,0x72,0xd0,0x10]
; NOVL-NEXT:    vpsrld $16, %xmm1, %xmm1 # encoding: [0xc5,0xf1,0x72,0xd1,0x10]
; NOVL-NEXT:    vmaxsh %xmm0, %xmm1, %xmm5 # encoding: [0x62,0xf5,0x76,0x08,0x5f,0xe8]
; NOVL-NEXT:    vcmpunordsh %xmm0, %xmm0, %k1 # encoding: [0x62,0xf3,0x7e,0x08,0xc2,0xc8,0x03]
; NOVL-NEXT:    vmovsh %xmm1, %xmm0, %xmm5 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xe9]
; NOVL-NEXT:    vpunpcklwd %xmm5, %xmm4, %xmm0 # encoding: [0xc5,0xd9,0x61,0xc5]
; NOVL-NEXT:    # xmm0 = xmm4[0],xmm5[0],xmm4[1],xmm5[1],xmm4[2],xmm5[2],xmm4[3],xmm5[3]
; NOVL-NEXT:    vpunpckldq %xmm3, %xmm0, %xmm0 # encoding: [0xc5,0xf9,0x62,0xc3]
; NOVL-NEXT:    # xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; NOVL-NEXT:    vpunpcklqdq %xmm2, %xmm0, %xmm0 # encoding: [0xc5,0xf9,0x6c,0xc2]
; NOVL-NEXT:    # xmm0 = xmm0[0],xmm2[0]
; NOVL-NEXT:    retq # encoding: [0xc3]
  %z = call <8 x half> @llvm.maxnum.v8f16(<8 x half> %x, <8 x half> %y) readnone
  ret <8 x half> %z
}

define <16 x half> @test_intrinsic_fmax_v16f16(<16 x half> %x, <16 x half> %y) {
; HasVL-LABEL: test_intrinsic_fmax_v16f16:
; HasVL:       # %bb.0:
; HasVL-NEXT:    vmaxph %ymm0, %ymm1, %ymm2 # encoding: [0x62,0xf5,0x74,0x28,0x5f,0xd0]
; HasVL-NEXT:    vcmpunordph %ymm0, %ymm0, %k1 # encoding: [0x62,0xf3,0x7c,0x28,0xc2,0xc8,0x03]
; HasVL-NEXT:    vmovdqu16 %ymm1, %ymm2 {%k1} # encoding: [0x62,0xf1,0xff,0x29,0x6f,0xd1]
; HasVL-NEXT:    vmovdqa %ymm2, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfd,0x6f,0xc2]
; HasVL-NEXT:    retq # encoding: [0xc3]
;
; NOVL-LABEL: test_intrinsic_fmax_v16f16:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vextracti128 $1, %ymm0, %xmm2 # encoding: [0xc4,0xe3,0x7d,0x39,0xc2,0x01]
; NOVL-NEXT:    vpsrldq $14, %xmm2, %xmm4 # encoding: [0xc5,0xd9,0x73,0xda,0x0e]
; NOVL-NEXT:    # xmm4 = xmm2[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; NOVL-NEXT:    vextracti128 $1, %ymm1, %xmm3 # encoding: [0xc4,0xe3,0x7d,0x39,0xcb,0x01]
; NOVL-NEXT:    vpsrldq $14, %xmm3, %xmm5 # encoding: [0xc5,0xd1,0x73,0xdb,0x0e]
; NOVL-NEXT:    # xmm5 = xmm3[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; NOVL-NEXT:    vmaxsh %xmm4, %xmm5, %xmm6 # encoding: [0x62,0xf5,0x56,0x08,0x5f,0xf4]
; NOVL-NEXT:    vcmpunordsh %xmm4, %xmm4, %k1 # encoding: [0x62,0xf3,0x5e,0x08,0xc2,0xcc,0x03]
; NOVL-NEXT:    vmovsh %xmm5, %xmm0, %xmm6 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xf5]
; NOVL-NEXT:    vpshufd $255, %xmm2, %xmm4 # encoding: [0xc5,0xf9,0x70,0xe2,0xff]
; NOVL-NEXT:    # xmm4 = xmm2[3,3,3,3]
; NOVL-NEXT:    vpshufd $255, %xmm3, %xmm5 # encoding: [0xc5,0xf9,0x70,0xeb,0xff]
; NOVL-NEXT:    # xmm5 = xmm3[3,3,3,3]
; NOVL-NEXT:    vmaxsh %xmm4, %xmm5, %xmm7 # encoding: [0x62,0xf5,0x56,0x08,0x5f,0xfc]
; NOVL-NEXT:    vcmpunordsh %xmm4, %xmm4, %k1 # encoding: [0x62,0xf3,0x5e,0x08,0xc2,0xcc,0x03]
; NOVL-NEXT:    vmovsh %xmm5, %xmm0, %xmm7 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xfd]
; NOVL-NEXT:    vpunpcklwd %xmm6, %xmm7, %xmm4 # encoding: [0xc5,0xc1,0x61,0xe6]
; NOVL-NEXT:    # xmm4 = xmm7[0],xmm6[0],xmm7[1],xmm6[1],xmm7[2],xmm6[2],xmm7[3],xmm6[3]
; NOVL-NEXT:    vpsrldq $10, %xmm2, %xmm5 # encoding: [0xc5,0xd1,0x73,0xda,0x0a]
; NOVL-NEXT:    # xmm5 = xmm2[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; NOVL-NEXT:    vpsrldq $10, %xmm3, %xmm6 # encoding: [0xc5,0xc9,0x73,0xdb,0x0a]
; NOVL-NEXT:    # xmm6 = xmm3[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; NOVL-NEXT:    vmaxsh %xmm5, %xmm6, %xmm7 # encoding: [0x62,0xf5,0x4e,0x08,0x5f,0xfd]
; NOVL-NEXT:    vcmpunordsh %xmm5, %xmm5, %k1 # encoding: [0x62,0xf3,0x56,0x08,0xc2,0xcd,0x03]
; NOVL-NEXT:    vmovsh %xmm6, %xmm0, %xmm7 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xfe]
; NOVL-NEXT:    vshufpd $1, %xmm2, %xmm2, %xmm5 # encoding: [0xc5,0xe9,0xc6,0xea,0x01]
; NOVL-NEXT:    # xmm5 = xmm2[1,0]
; NOVL-NEXT:    vshufpd $1, %xmm3, %xmm3, %xmm6 # encoding: [0xc5,0xe1,0xc6,0xf3,0x01]
; NOVL-NEXT:    # xmm6 = xmm3[1,0]
; NOVL-NEXT:    vmaxsh %xmm5, %xmm6, %xmm8 # encoding: [0x62,0x75,0x4e,0x08,0x5f,0xc5]
; NOVL-NEXT:    vcmpunordsh %xmm5, %xmm5, %k1 # encoding: [0x62,0xf3,0x56,0x08,0xc2,0xcd,0x03]
; NOVL-NEXT:    vmovsh %xmm6, %xmm0, %xmm8 {%k1} # encoding: [0x62,0x75,0x7e,0x09,0x10,0xc6]
; NOVL-NEXT:    vpunpcklwd %xmm7, %xmm8, %xmm5 # encoding: [0xc5,0xb9,0x61,0xef]
; NOVL-NEXT:    # xmm5 = xmm8[0],xmm7[0],xmm8[1],xmm7[1],xmm8[2],xmm7[2],xmm8[3],xmm7[3]
; NOVL-NEXT:    vpunpckldq %xmm4, %xmm5, %xmm4 # encoding: [0xc5,0xd1,0x62,0xe4]
; NOVL-NEXT:    # xmm4 = xmm5[0],xmm4[0],xmm5[1],xmm4[1]
; NOVL-NEXT:    vpsrldq $14, %xmm0, %xmm5 # encoding: [0xc5,0xd1,0x73,0xd8,0x0e]
; NOVL-NEXT:    # xmm5 = xmm0[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; NOVL-NEXT:    vpsrldq $14, %xmm1, %xmm6 # encoding: [0xc5,0xc9,0x73,0xd9,0x0e]
; NOVL-NEXT:    # xmm6 = xmm1[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; NOVL-NEXT:    vmaxsh %xmm5, %xmm6, %xmm7 # encoding: [0x62,0xf5,0x4e,0x08,0x5f,0xfd]
; NOVL-NEXT:    vcmpunordsh %xmm5, %xmm5, %k1 # encoding: [0x62,0xf3,0x56,0x08,0xc2,0xcd,0x03]
; NOVL-NEXT:    vmovsh %xmm6, %xmm0, %xmm7 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xfe]
; NOVL-NEXT:    vshufps $255, %xmm0, %xmm0, %xmm5 # encoding: [0xc5,0xf8,0xc6,0xe8,0xff]
; NOVL-NEXT:    # xmm5 = xmm0[3,3,3,3]
; NOVL-NEXT:    vpshufd $255, %xmm1, %xmm6 # encoding: [0xc5,0xf9,0x70,0xf1,0xff]
; NOVL-NEXT:    # xmm6 = xmm1[3,3,3,3]
; NOVL-NEXT:    vmaxsh %xmm5, %xmm6, %xmm8 # encoding: [0x62,0x75,0x4e,0x08,0x5f,0xc5]
; NOVL-NEXT:    vcmpunordsh %xmm5, %xmm5, %k1 # encoding: [0x62,0xf3,0x56,0x08,0xc2,0xcd,0x03]
; NOVL-NEXT:    vmovsh %xmm6, %xmm0, %xmm8 {%k1} # encoding: [0x62,0x75,0x7e,0x09,0x10,0xc6]
; NOVL-NEXT:    vpunpcklwd %xmm7, %xmm8, %xmm5 # encoding: [0xc5,0xb9,0x61,0xef]
; NOVL-NEXT:    # xmm5 = xmm8[0],xmm7[0],xmm8[1],xmm7[1],xmm8[2],xmm7[2],xmm8[3],xmm7[3]
; NOVL-NEXT:    vpsrldq $10, %xmm0, %xmm6 # encoding: [0xc5,0xc9,0x73,0xd8,0x0a]
; NOVL-NEXT:    # xmm6 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; NOVL-NEXT:    vpsrldq $10, %xmm1, %xmm7 # encoding: [0xc5,0xc1,0x73,0xd9,0x0a]
; NOVL-NEXT:    # xmm7 = xmm1[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; NOVL-NEXT:    vmaxsh %xmm6, %xmm7, %xmm8 # encoding: [0x62,0x75,0x46,0x08,0x5f,0xc6]
; NOVL-NEXT:    vcmpunordsh %xmm6, %xmm6, %k1 # encoding: [0x62,0xf3,0x4e,0x08,0xc2,0xce,0x03]
; NOVL-NEXT:    vmovsh %xmm7, %xmm0, %xmm8 {%k1} # encoding: [0x62,0x75,0x7e,0x09,0x10,0xc7]
; NOVL-NEXT:    vshufpd $1, %xmm0, %xmm0, %xmm6 # encoding: [0xc5,0xf9,0xc6,0xf0,0x01]
; NOVL-NEXT:    # xmm6 = xmm0[1,0]
; NOVL-NEXT:    vshufpd $1, %xmm1, %xmm1, %xmm7 # encoding: [0xc5,0xf1,0xc6,0xf9,0x01]
; NOVL-NEXT:    # xmm7 = xmm1[1,0]
; NOVL-NEXT:    vmaxsh %xmm6, %xmm7, %xmm9 # encoding: [0x62,0x75,0x46,0x08,0x5f,0xce]
; NOVL-NEXT:    vcmpunordsh %xmm6, %xmm6, %k1 # encoding: [0x62,0xf3,0x4e,0x08,0xc2,0xce,0x03]
; NOVL-NEXT:    vmovsh %xmm7, %xmm0, %xmm9 {%k1} # encoding: [0x62,0x75,0x7e,0x09,0x10,0xcf]
; NOVL-NEXT:    vpunpcklwd %xmm8, %xmm9, %xmm6 # encoding: [0xc4,0xc1,0x31,0x61,0xf0]
; NOVL-NEXT:    # xmm6 = xmm9[0],xmm8[0],xmm9[1],xmm8[1],xmm9[2],xmm8[2],xmm9[3],xmm8[3]
; NOVL-NEXT:    vpunpckldq %xmm5, %xmm6, %xmm5 # encoding: [0xc5,0xc9,0x62,0xed]
; NOVL-NEXT:    # xmm5 = xmm6[0],xmm5[0],xmm6[1],xmm5[1]
; NOVL-NEXT:    vinserti128 $1, %xmm4, %ymm5, %ymm4 # encoding: [0xc4,0xe3,0x55,0x38,0xe4,0x01]
; NOVL-NEXT:    vpsrlq $48, %xmm2, %xmm5 # encoding: [0xc5,0xd1,0x73,0xd2,0x30]
; NOVL-NEXT:    vpsrlq $48, %xmm3, %xmm6 # encoding: [0xc5,0xc9,0x73,0xd3,0x30]
; NOVL-NEXT:    vmaxsh %xmm5, %xmm6, %xmm7 # encoding: [0x62,0xf5,0x4e,0x08,0x5f,0xfd]
; NOVL-NEXT:    vcmpunordsh %xmm5, %xmm5, %k1 # encoding: [0x62,0xf3,0x56,0x08,0xc2,0xcd,0x03]
; NOVL-NEXT:    vmovsh %xmm6, %xmm0, %xmm7 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xfe]
; NOVL-NEXT:    vmovshdup %xmm2, %xmm5 # encoding: [0xc5,0xfa,0x16,0xea]
; NOVL-NEXT:    # xmm5 = xmm2[1,1,3,3]
; NOVL-NEXT:    vmovshdup %xmm3, %xmm6 # encoding: [0xc5,0xfa,0x16,0xf3]
; NOVL-NEXT:    # xmm6 = xmm3[1,1,3,3]
; NOVL-NEXT:    vmaxsh %xmm5, %xmm6, %xmm8 # encoding: [0x62,0x75,0x4e,0x08,0x5f,0xc5]
; NOVL-NEXT:    vcmpunordsh %xmm5, %xmm5, %k1 # encoding: [0x62,0xf3,0x56,0x08,0xc2,0xcd,0x03]
; NOVL-NEXT:    vmovsh %xmm6, %xmm0, %xmm8 {%k1} # encoding: [0x62,0x75,0x7e,0x09,0x10,0xc6]
; NOVL-NEXT:    vpunpcklwd %xmm7, %xmm8, %xmm5 # encoding: [0xc5,0xb9,0x61,0xef]
; NOVL-NEXT:    # xmm5 = xmm8[0],xmm7[0],xmm8[1],xmm7[1],xmm8[2],xmm7[2],xmm8[3],xmm7[3]
; NOVL-NEXT:    vmaxsh %xmm2, %xmm3, %xmm6 # encoding: [0x62,0xf5,0x66,0x08,0x5f,0xf2]
; NOVL-NEXT:    vcmpunordsh %xmm2, %xmm2, %k1 # encoding: [0x62,0xf3,0x6e,0x08,0xc2,0xca,0x03]
; NOVL-NEXT:    vmovsh %xmm3, %xmm0, %xmm6 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xf3]
; NOVL-NEXT:    vpsrld $16, %xmm2, %xmm2 # encoding: [0xc5,0xe9,0x72,0xd2,0x10]
; NOVL-NEXT:    vpsrld $16, %xmm3, %xmm3 # encoding: [0xc5,0xe1,0x72,0xd3,0x10]
; NOVL-NEXT:    vmaxsh %xmm2, %xmm3, %xmm7 # encoding: [0x62,0xf5,0x66,0x08,0x5f,0xfa]
; NOVL-NEXT:    vcmpunordsh %xmm2, %xmm2, %k1 # encoding: [0x62,0xf3,0x6e,0x08,0xc2,0xca,0x03]
; NOVL-NEXT:    vmovsh %xmm3, %xmm0, %xmm7 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xfb]
; NOVL-NEXT:    vpunpcklwd %xmm7, %xmm6, %xmm2 # encoding: [0xc5,0xc9,0x61,0xd7]
; NOVL-NEXT:    # xmm2 = xmm6[0],xmm7[0],xmm6[1],xmm7[1],xmm6[2],xmm7[2],xmm6[3],xmm7[3]
; NOVL-NEXT:    vpunpckldq %xmm5, %xmm2, %xmm2 # encoding: [0xc5,0xe9,0x62,0xd5]
; NOVL-NEXT:    # xmm2 = xmm2[0],xmm5[0],xmm2[1],xmm5[1]
; NOVL-NEXT:    vpsrlq $48, %xmm0, %xmm3 # encoding: [0xc5,0xe1,0x73,0xd0,0x30]
; NOVL-NEXT:    vpsrlq $48, %xmm1, %xmm5 # encoding: [0xc5,0xd1,0x73,0xd1,0x30]
; NOVL-NEXT:    vmaxsh %xmm3, %xmm5, %xmm6 # encoding: [0x62,0xf5,0x56,0x08,0x5f,0xf3]
; NOVL-NEXT:    vcmpunordsh %xmm3, %xmm3, %k1 # encoding: [0x62,0xf3,0x66,0x08,0xc2,0xcb,0x03]
; NOVL-NEXT:    vmovsh %xmm5, %xmm0, %xmm6 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xf5]
; NOVL-NEXT:    vmovshdup %xmm0, %xmm3 # encoding: [0xc5,0xfa,0x16,0xd8]
; NOVL-NEXT:    # xmm3 = xmm0[1,1,3,3]
; NOVL-NEXT:    vmovshdup %xmm1, %xmm5 # encoding: [0xc5,0xfa,0x16,0xe9]
; NOVL-NEXT:    # xmm5 = xmm1[1,1,3,3]
; NOVL-NEXT:    vmaxsh %xmm3, %xmm5, %xmm7 # encoding: [0x62,0xf5,0x56,0x08,0x5f,0xfb]
; NOVL-NEXT:    vcmpunordsh %xmm3, %xmm3, %k1 # encoding: [0x62,0xf3,0x66,0x08,0xc2,0xcb,0x03]
; NOVL-NEXT:    vmovsh %xmm5, %xmm0, %xmm7 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xfd]
; NOVL-NEXT:    vpunpcklwd %xmm6, %xmm7, %xmm3 # encoding: [0xc5,0xc1,0x61,0xde]
; NOVL-NEXT:    # xmm3 = xmm7[0],xmm6[0],xmm7[1],xmm6[1],xmm7[2],xmm6[2],xmm7[3],xmm6[3]
; NOVL-NEXT:    vmaxsh %xmm0, %xmm1, %xmm5 # encoding: [0x62,0xf5,0x76,0x08,0x5f,0xe8]
; NOVL-NEXT:    vcmpunordsh %xmm0, %xmm0, %k1 # encoding: [0x62,0xf3,0x7e,0x08,0xc2,0xc8,0x03]
; NOVL-NEXT:    vmovsh %xmm1, %xmm0, %xmm5 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xe9]
; NOVL-NEXT:    vpsrld $16, %xmm0, %xmm0 # encoding: [0xc5,0xf9,0x72,0xd0,0x10]
; NOVL-NEXT:    vpsrld $16, %xmm1, %xmm1 # encoding: [0xc5,0xf1,0x72,0xd1,0x10]
; NOVL-NEXT:    vmaxsh %xmm0, %xmm1, %xmm6 # encoding: [0x62,0xf5,0x76,0x08,0x5f,0xf0]
; NOVL-NEXT:    vcmpunordsh %xmm0, %xmm0, %k1 # encoding: [0x62,0xf3,0x7e,0x08,0xc2,0xc8,0x03]
; NOVL-NEXT:    vmovsh %xmm1, %xmm0, %xmm6 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xf1]
; NOVL-NEXT:    vpunpcklwd %xmm6, %xmm5, %xmm0 # encoding: [0xc5,0xd1,0x61,0xc6]
; NOVL-NEXT:    # xmm0 = xmm5[0],xmm6[0],xmm5[1],xmm6[1],xmm5[2],xmm6[2],xmm5[3],xmm6[3]
; NOVL-NEXT:    vpunpckldq %xmm3, %xmm0, %xmm0 # encoding: [0xc5,0xf9,0x62,0xc3]
; NOVL-NEXT:    # xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; NOVL-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0 # encoding: [0xc4,0xe3,0x7d,0x38,0xc2,0x01]
; NOVL-NEXT:    vpunpcklqdq %ymm4, %ymm0, %ymm0 # encoding: [0xc5,0xfd,0x6c,0xc4]
; NOVL-NEXT:    # ymm0 = ymm0[0],ymm4[0],ymm0[2],ymm4[2]
; NOVL-NEXT:    retq # encoding: [0xc3]
  %z = call <16 x half> @llvm.maxnum.v16f16(<16 x half> %x, <16 x half> %y) readnone
  ret <16 x half> %z
}

define <32 x half> @test_intrinsic_fmax_v32f16(<32 x half> %x, <32 x half> %y) {
; CHECK-LABEL: test_intrinsic_fmax_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmaxph %zmm0, %zmm1, %zmm2 # encoding: [0x62,0xf5,0x74,0x48,0x5f,0xd0]
; CHECK-NEXT:    vcmpunordph %zmm0, %zmm0, %k1 # encoding: [0x62,0xf3,0x7c,0x48,0xc2,0xc8,0x03]
; CHECK-NEXT:    vmovdqu16 %zmm1, %zmm2 {%k1} # encoding: [0x62,0xf1,0xff,0x49,0x6f,0xd1]
; CHECK-NEXT:    vmovdqa64 %zmm2, %zmm0 # encoding: [0x62,0xf1,0xfd,0x48,0x6f,0xc2]
; CHECK-NEXT:    retq # encoding: [0xc3]
  %z = call <32 x half> @llvm.maxnum.v32f16(<32 x half> %x, <32 x half> %y) readnone
  ret <32 x half> %z
}

define <4 x half> @maxnum_intrinsic_nnan_fmf_f432(<4 x half> %a, <4 x half> %b) {
; HasVL-LABEL: maxnum_intrinsic_nnan_fmf_f432:
; HasVL:       # %bb.0:
; HasVL-NEXT:    vmaxph %xmm1, %xmm0, %xmm0 # encoding: [0x62,0xf5,0x7c,0x08,0x5f,0xc1]
; HasVL-NEXT:    retq # encoding: [0xc3]
;
; NOVL-LABEL: maxnum_intrinsic_nnan_fmf_f432:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vpsrldq $14, %xmm0, %xmm2 # encoding: [0xc5,0xe9,0x73,0xd8,0x0e]
; NOVL-NEXT:    # xmm2 = xmm0[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; NOVL-NEXT:    vpsrldq $14, %xmm1, %xmm3 # encoding: [0xc5,0xe1,0x73,0xd9,0x0e]
; NOVL-NEXT:    # xmm3 = xmm1[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; NOVL-NEXT:    vcmpltsh %xmm2, %xmm3, %k1 # encoding: [0x62,0xf3,0x66,0x08,0xc2,0xca,0x01]
; NOVL-NEXT:    vmovsh %xmm2, %xmm0, %xmm3 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xda]
; NOVL-NEXT:    vshufps $255, %xmm0, %xmm0, %xmm2 # encoding: [0xc5,0xf8,0xc6,0xd0,0xff]
; NOVL-NEXT:    # xmm2 = xmm0[3,3,3,3]
; NOVL-NEXT:    vpshufd $255, %xmm1, %xmm4 # encoding: [0xc5,0xf9,0x70,0xe1,0xff]
; NOVL-NEXT:    # xmm4 = xmm1[3,3,3,3]
; NOVL-NEXT:    vcmpltsh %xmm2, %xmm4, %k1 # encoding: [0x62,0xf3,0x5e,0x08,0xc2,0xca,0x01]
; NOVL-NEXT:    vmovsh %xmm2, %xmm0, %xmm4 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xe2]
; NOVL-NEXT:    vpunpcklwd %xmm3, %xmm4, %xmm2 # encoding: [0xc5,0xd9,0x61,0xd3]
; NOVL-NEXT:    # xmm2 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; NOVL-NEXT:    vpsrldq $10, %xmm0, %xmm3 # encoding: [0xc5,0xe1,0x73,0xd8,0x0a]
; NOVL-NEXT:    # xmm3 = xmm0[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; NOVL-NEXT:    vpsrldq $10, %xmm1, %xmm4 # encoding: [0xc5,0xd9,0x73,0xd9,0x0a]
; NOVL-NEXT:    # xmm4 = xmm1[10,11,12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; NOVL-NEXT:    vcmpltsh %xmm3, %xmm4, %k1 # encoding: [0x62,0xf3,0x5e,0x08,0xc2,0xcb,0x01]
; NOVL-NEXT:    vmovsh %xmm3, %xmm0, %xmm4 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xe3]
; NOVL-NEXT:    vshufpd $1, %xmm0, %xmm0, %xmm3 # encoding: [0xc5,0xf9,0xc6,0xd8,0x01]
; NOVL-NEXT:    # xmm3 = xmm0[1,0]
; NOVL-NEXT:    vshufpd $1, %xmm1, %xmm1, %xmm5 # encoding: [0xc5,0xf1,0xc6,0xe9,0x01]
; NOVL-NEXT:    # xmm5 = xmm1[1,0]
; NOVL-NEXT:    vcmpltsh %xmm3, %xmm5, %k1 # encoding: [0x62,0xf3,0x56,0x08,0xc2,0xcb,0x01]
; NOVL-NEXT:    vmovsh %xmm3, %xmm0, %xmm5 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xeb]
; NOVL-NEXT:    vpunpcklwd %xmm4, %xmm5, %xmm3 # encoding: [0xc5,0xd1,0x61,0xdc]
; NOVL-NEXT:    # xmm3 = xmm5[0],xmm4[0],xmm5[1],xmm4[1],xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; NOVL-NEXT:    vpunpckldq %xmm2, %xmm3, %xmm2 # encoding: [0xc5,0xe1,0x62,0xd2]
; NOVL-NEXT:    # xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; NOVL-NEXT:    vpsrlq $48, %xmm0, %xmm3 # encoding: [0xc5,0xe1,0x73,0xd0,0x30]
; NOVL-NEXT:    vpsrlq $48, %xmm1, %xmm4 # encoding: [0xc5,0xd9,0x73,0xd1,0x30]
; NOVL-NEXT:    vcmpltsh %xmm3, %xmm4, %k1 # encoding: [0x62,0xf3,0x5e,0x08,0xc2,0xcb,0x01]
; NOVL-NEXT:    vmovsh %xmm3, %xmm0, %xmm4 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xe3]
; NOVL-NEXT:    vmovshdup %xmm0, %xmm3 # encoding: [0xc5,0xfa,0x16,0xd8]
; NOVL-NEXT:    # xmm3 = xmm0[1,1,3,3]
; NOVL-NEXT:    vmovshdup %xmm1, %xmm5 # encoding: [0xc5,0xfa,0x16,0xe9]
; NOVL-NEXT:    # xmm5 = xmm1[1,1,3,3]
; NOVL-NEXT:    vcmpltsh %xmm3, %xmm5, %k1 # encoding: [0x62,0xf3,0x56,0x08,0xc2,0xcb,0x01]
; NOVL-NEXT:    vmovsh %xmm3, %xmm0, %xmm5 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xeb]
; NOVL-NEXT:    vpunpcklwd %xmm4, %xmm5, %xmm3 # encoding: [0xc5,0xd1,0x61,0xdc]
; NOVL-NEXT:    # xmm3 = xmm5[0],xmm4[0],xmm5[1],xmm4[1],xmm5[2],xmm4[2],xmm5[3],xmm4[3]
; NOVL-NEXT:    vcmpltsh %xmm0, %xmm1, %k1 # encoding: [0x62,0xf3,0x76,0x08,0xc2,0xc8,0x01]
; NOVL-NEXT:    vpsrld $16, %xmm1, %xmm4 # encoding: [0xc5,0xd9,0x72,0xd1,0x10]
; NOVL-NEXT:    vmovsh %xmm0, %xmm0, %xmm1 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xc8]
; NOVL-NEXT:    vpsrld $16, %xmm0, %xmm0 # encoding: [0xc5,0xf9,0x72,0xd0,0x10]
; NOVL-NEXT:    vcmpltsh %xmm0, %xmm4, %k1 # encoding: [0x62,0xf3,0x5e,0x08,0xc2,0xc8,0x01]
; NOVL-NEXT:    vmovsh %xmm0, %xmm0, %xmm4 {%k1} # encoding: [0x62,0xf5,0x7e,0x09,0x10,0xe0]
; NOVL-NEXT:    vpunpcklwd %xmm4, %xmm1, %xmm0 # encoding: [0xc5,0xf1,0x61,0xc4]
; NOVL-NEXT:    # xmm0 = xmm1[0],xmm4[0],xmm1[1],xmm4[1],xmm1[2],xmm4[2],xmm1[3],xmm4[3]
; NOVL-NEXT:    vpunpckldq %xmm3, %xmm0, %xmm0 # encoding: [0xc5,0xf9,0x62,0xc3]
; NOVL-NEXT:    # xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; NOVL-NEXT:    vpunpcklqdq %xmm2, %xmm0, %xmm0 # encoding: [0xc5,0xf9,0x6c,0xc2]
; NOVL-NEXT:    # xmm0 = xmm0[0],xmm2[0]
; NOVL-NEXT:    retq # encoding: [0xc3]
  %r = tail call nnan <4 x half> @llvm.maxnum.v4f16(<4 x half> %a, <4 x half> %b)
  ret <4 x half> %r
}

define half @maxnum_intrinsic_nnan_attr_f16(half %a, half %b) #0 {
; CHECK-LABEL: maxnum_intrinsic_nnan_attr_f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmaxsh %xmm1, %xmm0, %xmm0 # encoding: [0x62,0xf5,0x7e,0x08,0x5f,0xc1]
; CHECK-NEXT:    retq # encoding: [0xc3]
  %r = tail call half @llvm.maxnum.f16(half %a, half %b)
  ret half %r
}

define half @test_maxnum_const_op1(half %x) {
; CHECK-LABEL: test_maxnum_const_op1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmaxsh {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0 # encoding: [0x62,0xf5,0x7e,0x08,0x5f,0x05,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 6, value: {{\.?LCPI[0-9]+_[0-9]+}}, kind: reloc_riprel_4byte
; CHECK-NEXT:    retq # encoding: [0xc3]
  %r = call half @llvm.maxnum.f16(half 1.0, half %x)
  ret half %r
}

define half @test_maxnum_const_op2(half %x) {
; CHECK-LABEL: test_maxnum_const_op2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmaxsh {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0 # encoding: [0x62,0xf5,0x7e,0x08,0x5f,0x05,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 6, value: {{\.?LCPI[0-9]+_[0-9]+}}, kind: reloc_riprel_4byte
; CHECK-NEXT:    retq # encoding: [0xc3]
  %r = call half @llvm.maxnum.f16(half %x, half 1.0)
  ret half %r
}

define half @test_maxnum_const_nan(half %x) {
; CHECK-LABEL: test_maxnum_const_nan:
; CHECK:       # %bb.0:
; CHECK-NEXT:    retq # encoding: [0xc3]
  %r = call half @llvm.maxnum.f16(half %x, half 0x7fff000000000000)
  ret half %r
}

attributes #0 = { "no-nans-fp-math"="true" "no-signed-zeros-fp-math"="true"}
