; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

; (x&z) ^ (y&z) -> (x^y)&z
define i32 @test1(i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:    [[T61:%.*]] = xor i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[T7:%.*]] = and i32 [[Z:%.*]], [[T61]]
; CHECK-NEXT:    ret i32 [[T7]]
;
  %t3 = and i32 %z, %x
  %t6 = and i32 %z, %y
  %t7 = xor i32 %t3, %t6
  ret i32 %t7
}

; (x & y) ^ (x|y) -> x^y
define i32 @test2(i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    [[T7:%.*]] = xor i32 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    ret i32 [[T7]]
;
  %t3 = and i32 %y, %x
  %t6 = or i32 %y, %x
  %t7 = xor i32 %t3, %t6
  ret i32 %t7
}

define i32 @PR38781(i32 %a, i32 %b) {
; CHECK-LABEL: @PR38781(
; CHECK-NEXT:    [[TMP1:%.*]] = or i32 [[B:%.*]], [[A:%.*]]
; CHECK-NEXT:    [[AND2:%.*]] = icmp sgt i32 [[TMP1]], -1
; CHECK-NEXT:    [[AND:%.*]] = zext i1 [[AND2]] to i32
; CHECK-NEXT:    ret i32 [[AND]]
;
  %a.lobit = lshr i32 %a, 31
  %a.lobit.not = xor i32 %a.lobit, 1
  %b.lobit = lshr i32 %b, 31
  %b.lobit.not = xor i32 %b.lobit, 1
  %and = and i32 %b.lobit.not, %a.lobit.not
  ret i32 %and
}

; (a ^ 4) & (a ^ ~4) -> 0
define i32 @PR75692_1(i32 %x) {
; CHECK-LABEL: @PR75692_1(
; CHECK-NEXT:    ret i32 0
;
  %t2 = xor i32 %x, 4
  %t3 = xor i32 %x, -5
  %t4 = and i32 %t2, %t3
  ret i32 %t4
}

; (a ^ 4) & (a ^ 3) is not zero
define i32 @PR75692_2(i32 %x) {
; CHECK-LABEL: @PR75692_2(
; CHECK-NEXT:    [[T2:%.*]] = xor i32 [[X:%.*]], 4
; CHECK-NEXT:    [[T3:%.*]] = xor i32 [[X]], -4
; CHECK-NEXT:    [[T4:%.*]] = and i32 [[T2]], [[T3]]
; CHECK-NEXT:    ret i32 [[T4]]
;
  %t2 = xor i32 %x, 4
  %t3 = xor i32 %x, -4
  %t4 = and i32 %t2, %t3
  ret i32 %t4
}

; (a ^ 4) & (b ^ ~4) is not zero, since a != b is possible
define i32 @PR75692_3(i32 %x, i32 %y) {
; CHECK-LABEL: @PR75692_3(
; CHECK-NEXT:    [[T2:%.*]] = xor i32 [[X:%.*]], 4
; CHECK-NEXT:    [[T3:%.*]] = xor i32 [[Y:%.*]], -5
; CHECK-NEXT:    [[T4:%.*]] = and i32 [[T2]], [[T3]]
; CHECK-NEXT:    ret i32 [[T4]]
;
  %t2 = xor i32 %x, 4
  %t3 = xor i32 %y, -5
  %t4 = and i32 %t2, %t3
  ret i32 %t4
}
