; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt %s -S -mattr=+avx512f -passes=msan 2>&1 | FileCheck %s
;
; Forked from llvm/test/CodeGen/X86/avx512fp16-arith-vl-intrinsics.ll
;
; Handled suboptimally (visitInstruction):
; - llvm.x86.avx512fp16.mask.vcvtpd2ph.128
; - llvm.x86.avx512fp16.mask.vcvtpd2ph.256
; - llvm.x86.avx512fp16.mask.vcvtph2pd.128
; - llvm.x86.avx512fp16.mask.vcvtph2pd.256
; - llvm.x86.avx512fp16.mask.vcvtph2psx.128
; - llvm.x86.avx512fp16.mask.vcvtph2psx.256
; - llvm.x86.avx512fp16.mask.vcvtph2udq.128
; - llvm.x86.avx512fp16.mask.vcvtph2udq.256
; - llvm.x86.avx512fp16.mask.vcvtps2phx.128
; - llvm.x86.avx512fp16.mask.vcvtps2phx.256
; - llvm.x86.avx512fp16.mask.vcvttph2dq.128
; - llvm.x86.avx512fp16.mask.vcvttph2dq.256
; - llvm.x86.avx512fp16.mask.vcvttph2udq.128
; - llvm.x86.avx512fp16.mask.vcvttph2udq.256
;
; Handled heuristically:
; - llvm.x86.avx512fp16.max.ph.128
; - llvm.x86.avx512fp16.max.ph.256
; - llvm.x86.avx512fp16.min.ph.128
; - llvm.x86.avx512fp16.min.ph.256

target datalayout = "e-m:o-p270:32:32-p271:32:32-p272:64:64-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

define <16 x half> @test_int_x86_avx512fp16_add_ph_256(<16 x half> %x1, <16 x half> %x2) #0 {
; CHECK-LABEL: define <16 x half> @test_int_x86_avx512fp16_add_ph_256(
; CHECK-SAME: <16 x half> [[X1:%.*]], <16 x half> [[X2:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <16 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <16 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <16 x i16> [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[RES:%.*]] = fadd <16 x half> [[X1]], [[X2]]
; CHECK-NEXT:    store <16 x i16> [[_MSPROP]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <16 x half> [[RES]]
;
  %res = fadd <16 x half> %x1, %x2
  ret <16 x half> %res
}

define <16 x half> @test_int_x86_avx512fp16_mask_add_ph_256(<16 x half> %x1, <16 x half> %x2, <16 x half> %src, i16 %mask, ptr %ptr) #0 {
; CHECK-LABEL: define <16 x half> @test_int_x86_avx512fp16_mask_add_ph_256(
; CHECK-SAME: <16 x half> [[X1:%.*]], <16 x half> [[X2:%.*]], <16 x half> [[SRC:%.*]], i16 [[MASK:%.*]], ptr [[PTR:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i16, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 96) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 104) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <16 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP4:%.*]] = load <16 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    [[TMP5:%.*]] = load <16 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 64) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast i16 [[TMP1]] to <16 x i1>
; CHECK-NEXT:    [[MSK:%.*]] = bitcast i16 [[MASK]] to <16 x i1>
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB7:.*]], label %[[BB8:.*]], !prof [[PROF1:![0-9]+]]
; CHECK:       [[BB7]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4:[0-9]+]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB8]]:
; CHECK-NEXT:    [[VAL:%.*]] = load <16 x half>, ptr [[PTR]], align 32
; CHECK-NEXT:    [[TMP9:%.*]] = ptrtoint ptr [[PTR]] to i64
; CHECK-NEXT:    [[TMP10:%.*]] = xor i64 [[TMP9]], 87960930222080
; CHECK-NEXT:    [[TMP11:%.*]] = inttoptr i64 [[TMP10]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load <16 x i16>, ptr [[TMP11]], align 32
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <16 x i16> [[TMP3]], [[TMP4]]
; CHECK-NEXT:    [[RES0:%.*]] = fadd <16 x half> [[X1]], [[X2]]
; CHECK-NEXT:    [[TMP12:%.*]] = select <16 x i1> [[MSK]], <16 x i16> [[_MSPROP]], <16 x i16> [[TMP5]]
; CHECK-NEXT:    [[TMP13:%.*]] = bitcast <16 x half> [[RES0]] to <16 x i16>
; CHECK-NEXT:    [[TMP14:%.*]] = bitcast <16 x half> [[SRC]] to <16 x i16>
; CHECK-NEXT:    [[TMP15:%.*]] = xor <16 x i16> [[TMP13]], [[TMP14]]
; CHECK-NEXT:    [[TMP16:%.*]] = or <16 x i16> [[TMP15]], [[_MSPROP]]
; CHECK-NEXT:    [[TMP17:%.*]] = or <16 x i16> [[TMP16]], [[TMP5]]
; CHECK-NEXT:    [[_MSPROP_SELECT:%.*]] = select <16 x i1> [[TMP6]], <16 x i16> [[TMP17]], <16 x i16> [[TMP12]]
; CHECK-NEXT:    [[RES1:%.*]] = select <16 x i1> [[MSK]], <16 x half> [[RES0]], <16 x half> [[SRC]]
; CHECK-NEXT:    [[_MSPROP1:%.*]] = or <16 x i16> [[TMP3]], [[_MSLD]]
; CHECK-NEXT:    [[T3:%.*]] = fadd <16 x half> [[X1]], [[VAL]]
; CHECK-NEXT:    [[TMP18:%.*]] = select <16 x i1> [[MSK]], <16 x i16> [[_MSPROP1]], <16 x i16> [[TMP5]]
; CHECK-NEXT:    [[TMP19:%.*]] = bitcast <16 x half> [[T3]] to <16 x i16>
; CHECK-NEXT:    [[TMP20:%.*]] = bitcast <16 x half> [[SRC]] to <16 x i16>
; CHECK-NEXT:    [[TMP21:%.*]] = xor <16 x i16> [[TMP19]], [[TMP20]]
; CHECK-NEXT:    [[TMP22:%.*]] = or <16 x i16> [[TMP21]], [[_MSPROP1]]
; CHECK-NEXT:    [[TMP23:%.*]] = or <16 x i16> [[TMP22]], [[TMP5]]
; CHECK-NEXT:    [[_MSPROP_SELECT2:%.*]] = select <16 x i1> [[TMP6]], <16 x i16> [[TMP23]], <16 x i16> [[TMP18]]
; CHECK-NEXT:    [[RES2:%.*]] = select <16 x i1> [[MSK]], <16 x half> [[T3]], <16 x half> [[SRC]]
; CHECK-NEXT:    [[_MSPROP3:%.*]] = or <16 x i16> [[_MSPROP_SELECT]], [[_MSPROP_SELECT2]]
; CHECK-NEXT:    [[RES:%.*]] = fadd <16 x half> [[RES1]], [[RES2]]
; CHECK-NEXT:    store <16 x i16> [[_MSPROP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <16 x half> [[RES]]
;
  %msk = bitcast i16 %mask to <16 x i1>
  %val = load <16 x half>, ptr %ptr
  %res0 = fadd <16 x half> %x1, %x2
  %res1 = select <16 x i1> %msk, <16 x half> %res0, <16 x half> %src
  %t3 = fadd <16 x half> %x1, %val
  %res2 = select <16 x i1> %msk, <16 x half> %t3, <16 x half> %src
  %res   =  fadd <16 x half> %res1 , %res2
  ret <16 x half> %res
}

define <16 x half> @test_int_x86_avx512fp16_maskz_add_ph_256(<16 x half> %x1, <16 x half> %x2, i16 %mask, ptr %ptr) #0 {
; CHECK-LABEL: define <16 x half> @test_int_x86_avx512fp16_maskz_add_ph_256(
; CHECK-SAME: <16 x half> [[X1:%.*]], <16 x half> [[X2:%.*]], i16 [[MASK:%.*]], ptr [[PTR:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i16, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 64) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <16 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <16 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast i16 [[TMP1]] to <16 x i1>
; CHECK-NEXT:    [[MSK:%.*]] = bitcast i16 [[MASK]] to <16 x i1>
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <16 x i16> [[TMP2]], [[TMP3]]
; CHECK-NEXT:    [[RES0:%.*]] = fadd <16 x half> [[X1]], [[X2]]
; CHECK-NEXT:    [[TMP5:%.*]] = select <16 x i1> [[MSK]], <16 x i16> [[_MSPROP]], <16 x i16> zeroinitializer
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast <16 x half> [[RES0]] to <16 x i16>
; CHECK-NEXT:    [[TMP7:%.*]] = xor <16 x i16> [[TMP6]], zeroinitializer
; CHECK-NEXT:    [[TMP8:%.*]] = or <16 x i16> [[TMP7]], [[_MSPROP]]
; CHECK-NEXT:    [[TMP9:%.*]] = or <16 x i16> [[TMP8]], zeroinitializer
; CHECK-NEXT:    [[_MSPROP_SELECT:%.*]] = select <16 x i1> [[TMP4]], <16 x i16> [[TMP9]], <16 x i16> [[TMP5]]
; CHECK-NEXT:    [[RES1:%.*]] = select <16 x i1> [[MSK]], <16 x half> [[RES0]], <16 x half> zeroinitializer
; CHECK-NEXT:    store <16 x i16> [[_MSPROP_SELECT]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <16 x half> [[RES1]]
;
  %msk = bitcast i16 %mask to <16 x i1>
  %res0 = fadd <16 x half> %x1, %x2
  %res1 = select <16 x i1> %msk, <16 x half> %res0, <16 x half> zeroinitializer
  ret <16 x half> %res1
}

define <8 x half> @test_int_x86_avx512fp16_add_ph_128(<8 x half> %x1, <8 x half> %x2) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512fp16_add_ph_128(
; CHECK-SAME: <8 x half> [[X1:%.*]], <8 x half> [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <8 x i16> [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[RES:%.*]] = fadd <8 x half> [[X1]], [[X2]]
; CHECK-NEXT:    store <8 x i16> [[_MSPROP]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %res = fadd <8 x half> %x1, %x2
  ret <8 x half> %res
}

define <8 x half> @test_int_x86_avx512fp16_mask_add_ph_128(<8 x half> %x1, <8 x half> %x2, <8 x half> %src, i8 %mask, ptr %ptr) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512fp16_mask_add_ph_128(
; CHECK-SAME: <8 x half> [[X1:%.*]], <8 x half> [[X2:%.*]], <8 x half> [[SRC:%.*]], i8 [[MASK:%.*]], ptr [[PTR:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 48) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 56) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP4:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP5:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast i8 [[TMP1]] to <8 x i1>
; CHECK-NEXT:    [[MSK:%.*]] = bitcast i8 [[MASK]] to <8 x i1>
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB7:.*]], label %[[BB8:.*]], !prof [[PROF1]]
; CHECK:       [[BB7]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB8]]:
; CHECK-NEXT:    [[VAL:%.*]] = load <8 x half>, ptr [[PTR]], align 16
; CHECK-NEXT:    [[TMP9:%.*]] = ptrtoint ptr [[PTR]] to i64
; CHECK-NEXT:    [[TMP10:%.*]] = xor i64 [[TMP9]], 87960930222080
; CHECK-NEXT:    [[TMP11:%.*]] = inttoptr i64 [[TMP10]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load <8 x i16>, ptr [[TMP11]], align 16
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <8 x i16> [[TMP3]], [[TMP4]]
; CHECK-NEXT:    [[RES0:%.*]] = fadd <8 x half> [[X1]], [[X2]]
; CHECK-NEXT:    [[TMP12:%.*]] = select <8 x i1> [[MSK]], <8 x i16> [[_MSPROP]], <8 x i16> [[TMP5]]
; CHECK-NEXT:    [[TMP13:%.*]] = bitcast <8 x half> [[RES0]] to <8 x i16>
; CHECK-NEXT:    [[TMP14:%.*]] = bitcast <8 x half> [[SRC]] to <8 x i16>
; CHECK-NEXT:    [[TMP15:%.*]] = xor <8 x i16> [[TMP13]], [[TMP14]]
; CHECK-NEXT:    [[TMP16:%.*]] = or <8 x i16> [[TMP15]], [[_MSPROP]]
; CHECK-NEXT:    [[TMP17:%.*]] = or <8 x i16> [[TMP16]], [[TMP5]]
; CHECK-NEXT:    [[_MSPROP_SELECT:%.*]] = select <8 x i1> [[TMP6]], <8 x i16> [[TMP17]], <8 x i16> [[TMP12]]
; CHECK-NEXT:    [[RES1:%.*]] = select <8 x i1> [[MSK]], <8 x half> [[RES0]], <8 x half> [[SRC]]
; CHECK-NEXT:    [[_MSPROP1:%.*]] = or <8 x i16> [[TMP3]], [[_MSLD]]
; CHECK-NEXT:    [[T3:%.*]] = fadd <8 x half> [[X1]], [[VAL]]
; CHECK-NEXT:    [[TMP18:%.*]] = select <8 x i1> [[MSK]], <8 x i16> [[_MSPROP1]], <8 x i16> [[TMP5]]
; CHECK-NEXT:    [[TMP19:%.*]] = bitcast <8 x half> [[T3]] to <8 x i16>
; CHECK-NEXT:    [[TMP20:%.*]] = bitcast <8 x half> [[SRC]] to <8 x i16>
; CHECK-NEXT:    [[TMP21:%.*]] = xor <8 x i16> [[TMP19]], [[TMP20]]
; CHECK-NEXT:    [[TMP22:%.*]] = or <8 x i16> [[TMP21]], [[_MSPROP1]]
; CHECK-NEXT:    [[TMP23:%.*]] = or <8 x i16> [[TMP22]], [[TMP5]]
; CHECK-NEXT:    [[_MSPROP_SELECT2:%.*]] = select <8 x i1> [[TMP6]], <8 x i16> [[TMP23]], <8 x i16> [[TMP18]]
; CHECK-NEXT:    [[RES2:%.*]] = select <8 x i1> [[MSK]], <8 x half> [[T3]], <8 x half> [[SRC]]
; CHECK-NEXT:    [[_MSPROP3:%.*]] = or <8 x i16> [[_MSPROP_SELECT]], [[_MSPROP_SELECT2]]
; CHECK-NEXT:    [[RES:%.*]] = fadd <8 x half> [[RES1]], [[RES2]]
; CHECK-NEXT:    store <8 x i16> [[_MSPROP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %msk = bitcast i8 %mask to <8 x i1>
  %val = load <8 x half>, ptr %ptr
  %res0 = fadd <8 x half> %x1, %x2
  %res1 = select <8 x i1> %msk, <8 x half> %res0, <8 x half> %src
  %t3 = fadd <8 x half> %x1, %val
  %res2 = select <8 x i1> %msk, <8 x half> %t3, <8 x half> %src
  %res   =  fadd <8 x half> %res1 , %res2
  ret <8 x half> %res
}

define <8 x half> @test_int_x86_avx512fp16_maskz_add_ph_128(<8 x half> %x1, <8 x half> %x2, i8 %mask, ptr %ptr) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512fp16_maskz_add_ph_128(
; CHECK-SAME: <8 x half> [[X1:%.*]], <8 x half> [[X2:%.*]], i8 [[MASK:%.*]], ptr [[PTR:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast i8 [[TMP1]] to <8 x i1>
; CHECK-NEXT:    [[MSK:%.*]] = bitcast i8 [[MASK]] to <8 x i1>
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <8 x i16> [[TMP2]], [[TMP3]]
; CHECK-NEXT:    [[RES0:%.*]] = fadd <8 x half> [[X1]], [[X2]]
; CHECK-NEXT:    [[TMP5:%.*]] = select <8 x i1> [[MSK]], <8 x i16> [[_MSPROP]], <8 x i16> zeroinitializer
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast <8 x half> [[RES0]] to <8 x i16>
; CHECK-NEXT:    [[TMP7:%.*]] = xor <8 x i16> [[TMP6]], zeroinitializer
; CHECK-NEXT:    [[TMP8:%.*]] = or <8 x i16> [[TMP7]], [[_MSPROP]]
; CHECK-NEXT:    [[TMP9:%.*]] = or <8 x i16> [[TMP8]], zeroinitializer
; CHECK-NEXT:    [[_MSPROP_SELECT:%.*]] = select <8 x i1> [[TMP4]], <8 x i16> [[TMP9]], <8 x i16> [[TMP5]]
; CHECK-NEXT:    [[RES1:%.*]] = select <8 x i1> [[MSK]], <8 x half> [[RES0]], <8 x half> zeroinitializer
; CHECK-NEXT:    store <8 x i16> [[_MSPROP_SELECT]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES1]]
;
  %msk = bitcast i8 %mask to <8 x i1>
  %res0 = fadd <8 x half> %x1, %x2
  %res1 = select <8 x i1> %msk, <8 x half> %res0, <8 x half> zeroinitializer
  ret <8 x half> %res1
}

define <16 x half> @test_int_x86_avx512fp16_sub_ph_256(<16 x half> %x1, <16 x half> %x2) #0 {
; CHECK-LABEL: define <16 x half> @test_int_x86_avx512fp16_sub_ph_256(
; CHECK-SAME: <16 x half> [[X1:%.*]], <16 x half> [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <16 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <16 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <16 x i16> [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[RES:%.*]] = fsub <16 x half> [[X1]], [[X2]]
; CHECK-NEXT:    store <16 x i16> [[_MSPROP]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <16 x half> [[RES]]
;
  %res = fsub <16 x half> %x1, %x2
  ret <16 x half> %res
}

define <16 x half> @test_int_x86_avx512fp16_mask_sub_ph_256(<16 x half> %x1, <16 x half> %x2, <16 x half> %src, i16 %mask, ptr %ptr) #0 {
; CHECK-LABEL: define <16 x half> @test_int_x86_avx512fp16_mask_sub_ph_256(
; CHECK-SAME: <16 x half> [[X1:%.*]], <16 x half> [[X2:%.*]], <16 x half> [[SRC:%.*]], i16 [[MASK:%.*]], ptr [[PTR:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i16, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 96) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 104) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <16 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP4:%.*]] = load <16 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    [[TMP5:%.*]] = load <16 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 64) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast i16 [[TMP1]] to <16 x i1>
; CHECK-NEXT:    [[MSK:%.*]] = bitcast i16 [[MASK]] to <16 x i1>
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB7:.*]], label %[[BB8:.*]], !prof [[PROF1]]
; CHECK:       [[BB7]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB8]]:
; CHECK-NEXT:    [[VAL:%.*]] = load <16 x half>, ptr [[PTR]], align 32
; CHECK-NEXT:    [[TMP9:%.*]] = ptrtoint ptr [[PTR]] to i64
; CHECK-NEXT:    [[TMP10:%.*]] = xor i64 [[TMP9]], 87960930222080
; CHECK-NEXT:    [[TMP11:%.*]] = inttoptr i64 [[TMP10]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load <16 x i16>, ptr [[TMP11]], align 32
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <16 x i16> [[TMP3]], [[TMP4]]
; CHECK-NEXT:    [[RES0:%.*]] = fsub <16 x half> [[X1]], [[X2]]
; CHECK-NEXT:    [[TMP12:%.*]] = select <16 x i1> [[MSK]], <16 x i16> [[_MSPROP]], <16 x i16> [[TMP5]]
; CHECK-NEXT:    [[TMP13:%.*]] = bitcast <16 x half> [[RES0]] to <16 x i16>
; CHECK-NEXT:    [[TMP14:%.*]] = bitcast <16 x half> [[SRC]] to <16 x i16>
; CHECK-NEXT:    [[TMP15:%.*]] = xor <16 x i16> [[TMP13]], [[TMP14]]
; CHECK-NEXT:    [[TMP16:%.*]] = or <16 x i16> [[TMP15]], [[_MSPROP]]
; CHECK-NEXT:    [[TMP17:%.*]] = or <16 x i16> [[TMP16]], [[TMP5]]
; CHECK-NEXT:    [[_MSPROP_SELECT:%.*]] = select <16 x i1> [[TMP6]], <16 x i16> [[TMP17]], <16 x i16> [[TMP12]]
; CHECK-NEXT:    [[RES1:%.*]] = select <16 x i1> [[MSK]], <16 x half> [[RES0]], <16 x half> [[SRC]]
; CHECK-NEXT:    [[_MSPROP1:%.*]] = or <16 x i16> [[TMP3]], [[_MSLD]]
; CHECK-NEXT:    [[T3:%.*]] = fsub <16 x half> [[X1]], [[VAL]]
; CHECK-NEXT:    [[TMP18:%.*]] = select <16 x i1> [[MSK]], <16 x i16> [[_MSPROP1]], <16 x i16> [[TMP5]]
; CHECK-NEXT:    [[TMP19:%.*]] = bitcast <16 x half> [[T3]] to <16 x i16>
; CHECK-NEXT:    [[TMP20:%.*]] = bitcast <16 x half> [[SRC]] to <16 x i16>
; CHECK-NEXT:    [[TMP21:%.*]] = xor <16 x i16> [[TMP19]], [[TMP20]]
; CHECK-NEXT:    [[TMP22:%.*]] = or <16 x i16> [[TMP21]], [[_MSPROP1]]
; CHECK-NEXT:    [[TMP23:%.*]] = or <16 x i16> [[TMP22]], [[TMP5]]
; CHECK-NEXT:    [[_MSPROP_SELECT2:%.*]] = select <16 x i1> [[TMP6]], <16 x i16> [[TMP23]], <16 x i16> [[TMP18]]
; CHECK-NEXT:    [[RES2:%.*]] = select <16 x i1> [[MSK]], <16 x half> [[T3]], <16 x half> [[SRC]]
; CHECK-NEXT:    [[_MSPROP3:%.*]] = or <16 x i16> [[_MSPROP_SELECT]], [[_MSPROP_SELECT2]]
; CHECK-NEXT:    [[RES:%.*]] = fsub <16 x half> [[RES1]], [[RES2]]
; CHECK-NEXT:    store <16 x i16> [[_MSPROP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <16 x half> [[RES]]
;
  %msk = bitcast i16 %mask to <16 x i1>
  %val = load <16 x half>, ptr %ptr
  %res0 = fsub <16 x half> %x1, %x2
  %res1 = select <16 x i1> %msk, <16 x half> %res0, <16 x half> %src
  %t3 = fsub <16 x half> %x1, %val
  %res2 = select <16 x i1> %msk, <16 x half> %t3, <16 x half> %src
  %res   =  fsub <16 x half> %res1 , %res2
  ret <16 x half> %res
}

define <16 x half> @test_int_x86_avx512fp16_maskz_sub_ph_256(<16 x half> %x1, <16 x half> %x2, i16 %mask, ptr %ptr) #0 {
; CHECK-LABEL: define <16 x half> @test_int_x86_avx512fp16_maskz_sub_ph_256(
; CHECK-SAME: <16 x half> [[X1:%.*]], <16 x half> [[X2:%.*]], i16 [[MASK:%.*]], ptr [[PTR:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i16, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 64) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <16 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <16 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast i16 [[TMP1]] to <16 x i1>
; CHECK-NEXT:    [[MSK:%.*]] = bitcast i16 [[MASK]] to <16 x i1>
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <16 x i16> [[TMP2]], [[TMP3]]
; CHECK-NEXT:    [[RES0:%.*]] = fsub <16 x half> [[X1]], [[X2]]
; CHECK-NEXT:    [[TMP5:%.*]] = select <16 x i1> [[MSK]], <16 x i16> [[_MSPROP]], <16 x i16> zeroinitializer
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast <16 x half> [[RES0]] to <16 x i16>
; CHECK-NEXT:    [[TMP7:%.*]] = xor <16 x i16> [[TMP6]], zeroinitializer
; CHECK-NEXT:    [[TMP8:%.*]] = or <16 x i16> [[TMP7]], [[_MSPROP]]
; CHECK-NEXT:    [[TMP9:%.*]] = or <16 x i16> [[TMP8]], zeroinitializer
; CHECK-NEXT:    [[_MSPROP_SELECT:%.*]] = select <16 x i1> [[TMP4]], <16 x i16> [[TMP9]], <16 x i16> [[TMP5]]
; CHECK-NEXT:    [[RES1:%.*]] = select <16 x i1> [[MSK]], <16 x half> [[RES0]], <16 x half> zeroinitializer
; CHECK-NEXT:    store <16 x i16> [[_MSPROP_SELECT]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <16 x half> [[RES1]]
;
  %msk = bitcast i16 %mask to <16 x i1>
  %res0 = fsub <16 x half> %x1, %x2
  %res1 = select <16 x i1> %msk, <16 x half> %res0, <16 x half> zeroinitializer
  ret <16 x half> %res1
}

define <8 x half> @test_int_x86_avx512fp16_sub_ph_128(<8 x half> %x1, <8 x half> %x2) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512fp16_sub_ph_128(
; CHECK-SAME: <8 x half> [[X1:%.*]], <8 x half> [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <8 x i16> [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[RES:%.*]] = fsub <8 x half> [[X1]], [[X2]]
; CHECK-NEXT:    store <8 x i16> [[_MSPROP]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %res = fsub <8 x half> %x1, %x2
  ret <8 x half> %res
}

define <8 x half> @test_int_x86_avx512fp16_mask_sub_ph_128(<8 x half> %x1, <8 x half> %x2, <8 x half> %src, i8 %mask, ptr %ptr) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512fp16_mask_sub_ph_128(
; CHECK-SAME: <8 x half> [[X1:%.*]], <8 x half> [[X2:%.*]], <8 x half> [[SRC:%.*]], i8 [[MASK:%.*]], ptr [[PTR:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 48) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 56) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP4:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP5:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast i8 [[TMP1]] to <8 x i1>
; CHECK-NEXT:    [[MSK:%.*]] = bitcast i8 [[MASK]] to <8 x i1>
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB7:.*]], label %[[BB8:.*]], !prof [[PROF1]]
; CHECK:       [[BB7]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB8]]:
; CHECK-NEXT:    [[VAL:%.*]] = load <8 x half>, ptr [[PTR]], align 16
; CHECK-NEXT:    [[TMP9:%.*]] = ptrtoint ptr [[PTR]] to i64
; CHECK-NEXT:    [[TMP10:%.*]] = xor i64 [[TMP9]], 87960930222080
; CHECK-NEXT:    [[TMP11:%.*]] = inttoptr i64 [[TMP10]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load <8 x i16>, ptr [[TMP11]], align 16
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <8 x i16> [[TMP3]], [[TMP4]]
; CHECK-NEXT:    [[RES0:%.*]] = fsub <8 x half> [[X1]], [[X2]]
; CHECK-NEXT:    [[TMP12:%.*]] = select <8 x i1> [[MSK]], <8 x i16> [[_MSPROP]], <8 x i16> [[TMP5]]
; CHECK-NEXT:    [[TMP13:%.*]] = bitcast <8 x half> [[RES0]] to <8 x i16>
; CHECK-NEXT:    [[TMP14:%.*]] = bitcast <8 x half> [[SRC]] to <8 x i16>
; CHECK-NEXT:    [[TMP15:%.*]] = xor <8 x i16> [[TMP13]], [[TMP14]]
; CHECK-NEXT:    [[TMP16:%.*]] = or <8 x i16> [[TMP15]], [[_MSPROP]]
; CHECK-NEXT:    [[TMP17:%.*]] = or <8 x i16> [[TMP16]], [[TMP5]]
; CHECK-NEXT:    [[_MSPROP_SELECT:%.*]] = select <8 x i1> [[TMP6]], <8 x i16> [[TMP17]], <8 x i16> [[TMP12]]
; CHECK-NEXT:    [[RES1:%.*]] = select <8 x i1> [[MSK]], <8 x half> [[RES0]], <8 x half> [[SRC]]
; CHECK-NEXT:    [[_MSPROP1:%.*]] = or <8 x i16> [[TMP3]], [[_MSLD]]
; CHECK-NEXT:    [[T3:%.*]] = fsub <8 x half> [[X1]], [[VAL]]
; CHECK-NEXT:    [[TMP18:%.*]] = select <8 x i1> [[MSK]], <8 x i16> [[_MSPROP1]], <8 x i16> [[TMP5]]
; CHECK-NEXT:    [[TMP19:%.*]] = bitcast <8 x half> [[T3]] to <8 x i16>
; CHECK-NEXT:    [[TMP20:%.*]] = bitcast <8 x half> [[SRC]] to <8 x i16>
; CHECK-NEXT:    [[TMP21:%.*]] = xor <8 x i16> [[TMP19]], [[TMP20]]
; CHECK-NEXT:    [[TMP22:%.*]] = or <8 x i16> [[TMP21]], [[_MSPROP1]]
; CHECK-NEXT:    [[TMP23:%.*]] = or <8 x i16> [[TMP22]], [[TMP5]]
; CHECK-NEXT:    [[_MSPROP_SELECT2:%.*]] = select <8 x i1> [[TMP6]], <8 x i16> [[TMP23]], <8 x i16> [[TMP18]]
; CHECK-NEXT:    [[RES2:%.*]] = select <8 x i1> [[MSK]], <8 x half> [[T3]], <8 x half> [[SRC]]
; CHECK-NEXT:    [[_MSPROP3:%.*]] = or <8 x i16> [[_MSPROP_SELECT]], [[_MSPROP_SELECT2]]
; CHECK-NEXT:    [[RES:%.*]] = fsub <8 x half> [[RES1]], [[RES2]]
; CHECK-NEXT:    store <8 x i16> [[_MSPROP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %msk = bitcast i8 %mask to <8 x i1>
  %val = load <8 x half>, ptr %ptr
  %res0 = fsub <8 x half> %x1, %x2
  %res1 = select <8 x i1> %msk, <8 x half> %res0, <8 x half> %src
  %t3 = fsub <8 x half> %x1, %val
  %res2 = select <8 x i1> %msk, <8 x half> %t3, <8 x half> %src
  %res   =  fsub <8 x half> %res1 , %res2
  ret <8 x half> %res
}

define <8 x half> @test_int_x86_avx512fp16_maskz_sub_ph_128(<8 x half> %x1, <8 x half> %x2, i8 %mask, ptr %ptr) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512fp16_maskz_sub_ph_128(
; CHECK-SAME: <8 x half> [[X1:%.*]], <8 x half> [[X2:%.*]], i8 [[MASK:%.*]], ptr [[PTR:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast i8 [[TMP1]] to <8 x i1>
; CHECK-NEXT:    [[MSK:%.*]] = bitcast i8 [[MASK]] to <8 x i1>
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <8 x i16> [[TMP2]], [[TMP3]]
; CHECK-NEXT:    [[RES0:%.*]] = fsub <8 x half> [[X1]], [[X2]]
; CHECK-NEXT:    [[TMP5:%.*]] = select <8 x i1> [[MSK]], <8 x i16> [[_MSPROP]], <8 x i16> zeroinitializer
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast <8 x half> [[RES0]] to <8 x i16>
; CHECK-NEXT:    [[TMP7:%.*]] = xor <8 x i16> [[TMP6]], zeroinitializer
; CHECK-NEXT:    [[TMP8:%.*]] = or <8 x i16> [[TMP7]], [[_MSPROP]]
; CHECK-NEXT:    [[TMP9:%.*]] = or <8 x i16> [[TMP8]], zeroinitializer
; CHECK-NEXT:    [[_MSPROP_SELECT:%.*]] = select <8 x i1> [[TMP4]], <8 x i16> [[TMP9]], <8 x i16> [[TMP5]]
; CHECK-NEXT:    [[RES1:%.*]] = select <8 x i1> [[MSK]], <8 x half> [[RES0]], <8 x half> zeroinitializer
; CHECK-NEXT:    store <8 x i16> [[_MSPROP_SELECT]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES1]]
;
  %msk = bitcast i8 %mask to <8 x i1>
  %res0 = fsub <8 x half> %x1, %x2
  %res1 = select <8 x i1> %msk, <8 x half> %res0, <8 x half> zeroinitializer
  ret <8 x half> %res1
}

define <16 x half> @test_int_x86_avx512fp16_mul_ph_256(<16 x half> %x1, <16 x half> %x2) #0 {
; CHECK-LABEL: define <16 x half> @test_int_x86_avx512fp16_mul_ph_256(
; CHECK-SAME: <16 x half> [[X1:%.*]], <16 x half> [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <16 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <16 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <16 x i16> [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[RES:%.*]] = fmul <16 x half> [[X1]], [[X2]]
; CHECK-NEXT:    store <16 x i16> [[_MSPROP]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <16 x half> [[RES]]
;
  %res = fmul <16 x half> %x1, %x2
  ret <16 x half> %res
}

define <16 x half> @test_int_x86_avx512fp16_mask_mul_ph_256(<16 x half> %x1, <16 x half> %x2, <16 x half> %src, i16 %mask, ptr %ptr) #0 {
; CHECK-LABEL: define <16 x half> @test_int_x86_avx512fp16_mask_mul_ph_256(
; CHECK-SAME: <16 x half> [[X1:%.*]], <16 x half> [[X2:%.*]], <16 x half> [[SRC:%.*]], i16 [[MASK:%.*]], ptr [[PTR:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i16, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 96) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 104) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <16 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP4:%.*]] = load <16 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    [[TMP5:%.*]] = load <16 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 64) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast i16 [[TMP1]] to <16 x i1>
; CHECK-NEXT:    [[MSK:%.*]] = bitcast i16 [[MASK]] to <16 x i1>
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB7:.*]], label %[[BB8:.*]], !prof [[PROF1]]
; CHECK:       [[BB7]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB8]]:
; CHECK-NEXT:    [[VAL:%.*]] = load <16 x half>, ptr [[PTR]], align 32
; CHECK-NEXT:    [[TMP9:%.*]] = ptrtoint ptr [[PTR]] to i64
; CHECK-NEXT:    [[TMP10:%.*]] = xor i64 [[TMP9]], 87960930222080
; CHECK-NEXT:    [[TMP11:%.*]] = inttoptr i64 [[TMP10]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load <16 x i16>, ptr [[TMP11]], align 32
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <16 x i16> [[TMP3]], [[TMP4]]
; CHECK-NEXT:    [[RES0:%.*]] = fmul <16 x half> [[X1]], [[X2]]
; CHECK-NEXT:    [[TMP12:%.*]] = select <16 x i1> [[MSK]], <16 x i16> [[_MSPROP]], <16 x i16> [[TMP5]]
; CHECK-NEXT:    [[TMP13:%.*]] = bitcast <16 x half> [[RES0]] to <16 x i16>
; CHECK-NEXT:    [[TMP14:%.*]] = bitcast <16 x half> [[SRC]] to <16 x i16>
; CHECK-NEXT:    [[TMP15:%.*]] = xor <16 x i16> [[TMP13]], [[TMP14]]
; CHECK-NEXT:    [[TMP16:%.*]] = or <16 x i16> [[TMP15]], [[_MSPROP]]
; CHECK-NEXT:    [[TMP17:%.*]] = or <16 x i16> [[TMP16]], [[TMP5]]
; CHECK-NEXT:    [[_MSPROP_SELECT:%.*]] = select <16 x i1> [[TMP6]], <16 x i16> [[TMP17]], <16 x i16> [[TMP12]]
; CHECK-NEXT:    [[RES1:%.*]] = select <16 x i1> [[MSK]], <16 x half> [[RES0]], <16 x half> [[SRC]]
; CHECK-NEXT:    [[_MSPROP1:%.*]] = or <16 x i16> [[TMP3]], [[_MSLD]]
; CHECK-NEXT:    [[T3:%.*]] = fmul <16 x half> [[X1]], [[VAL]]
; CHECK-NEXT:    [[TMP18:%.*]] = select <16 x i1> [[MSK]], <16 x i16> [[_MSPROP1]], <16 x i16> [[TMP5]]
; CHECK-NEXT:    [[TMP19:%.*]] = bitcast <16 x half> [[T3]] to <16 x i16>
; CHECK-NEXT:    [[TMP20:%.*]] = bitcast <16 x half> [[SRC]] to <16 x i16>
; CHECK-NEXT:    [[TMP21:%.*]] = xor <16 x i16> [[TMP19]], [[TMP20]]
; CHECK-NEXT:    [[TMP22:%.*]] = or <16 x i16> [[TMP21]], [[_MSPROP1]]
; CHECK-NEXT:    [[TMP23:%.*]] = or <16 x i16> [[TMP22]], [[TMP5]]
; CHECK-NEXT:    [[_MSPROP_SELECT2:%.*]] = select <16 x i1> [[TMP6]], <16 x i16> [[TMP23]], <16 x i16> [[TMP18]]
; CHECK-NEXT:    [[RES2:%.*]] = select <16 x i1> [[MSK]], <16 x half> [[T3]], <16 x half> [[SRC]]
; CHECK-NEXT:    [[_MSPROP3:%.*]] = or <16 x i16> [[_MSPROP_SELECT]], [[_MSPROP_SELECT2]]
; CHECK-NEXT:    [[RES:%.*]] = fmul <16 x half> [[RES1]], [[RES2]]
; CHECK-NEXT:    store <16 x i16> [[_MSPROP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <16 x half> [[RES]]
;
  %msk = bitcast i16 %mask to <16 x i1>
  %val = load <16 x half>, ptr %ptr
  %res0 = fmul <16 x half> %x1, %x2
  %res1 = select <16 x i1> %msk, <16 x half> %res0, <16 x half> %src
  %t3 = fmul <16 x half> %x1, %val
  %res2 = select <16 x i1> %msk, <16 x half> %t3, <16 x half> %src
  %res   =  fmul <16 x half> %res1 , %res2
  ret <16 x half> %res
}

define <16 x half> @test_int_x86_avx512fp16_maskz_mul_ph_256(<16 x half> %x1, <16 x half> %x2, i16 %mask, ptr %ptr) #0 {
; CHECK-LABEL: define <16 x half> @test_int_x86_avx512fp16_maskz_mul_ph_256(
; CHECK-SAME: <16 x half> [[X1:%.*]], <16 x half> [[X2:%.*]], i16 [[MASK:%.*]], ptr [[PTR:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i16, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 64) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <16 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <16 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast i16 [[TMP1]] to <16 x i1>
; CHECK-NEXT:    [[MSK:%.*]] = bitcast i16 [[MASK]] to <16 x i1>
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <16 x i16> [[TMP2]], [[TMP3]]
; CHECK-NEXT:    [[RES0:%.*]] = fmul <16 x half> [[X1]], [[X2]]
; CHECK-NEXT:    [[TMP5:%.*]] = select <16 x i1> [[MSK]], <16 x i16> [[_MSPROP]], <16 x i16> zeroinitializer
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast <16 x half> [[RES0]] to <16 x i16>
; CHECK-NEXT:    [[TMP7:%.*]] = xor <16 x i16> [[TMP6]], zeroinitializer
; CHECK-NEXT:    [[TMP8:%.*]] = or <16 x i16> [[TMP7]], [[_MSPROP]]
; CHECK-NEXT:    [[TMP9:%.*]] = or <16 x i16> [[TMP8]], zeroinitializer
; CHECK-NEXT:    [[_MSPROP_SELECT:%.*]] = select <16 x i1> [[TMP4]], <16 x i16> [[TMP9]], <16 x i16> [[TMP5]]
; CHECK-NEXT:    [[RES1:%.*]] = select <16 x i1> [[MSK]], <16 x half> [[RES0]], <16 x half> zeroinitializer
; CHECK-NEXT:    store <16 x i16> [[_MSPROP_SELECT]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <16 x half> [[RES1]]
;
  %msk = bitcast i16 %mask to <16 x i1>
  %res0 = fmul <16 x half> %x1, %x2
  %res1 = select <16 x i1> %msk, <16 x half> %res0, <16 x half> zeroinitializer
  ret <16 x half> %res1
}

define <8 x half> @test_int_x86_avx512fp16_mul_ph_128(<8 x half> %x1, <8 x half> %x2) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512fp16_mul_ph_128(
; CHECK-SAME: <8 x half> [[X1:%.*]], <8 x half> [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <8 x i16> [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[RES:%.*]] = fmul <8 x half> [[X1]], [[X2]]
; CHECK-NEXT:    store <8 x i16> [[_MSPROP]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %res = fmul <8 x half> %x1, %x2
  ret <8 x half> %res
}

define <8 x half> @test_int_x86_avx512fp16_mask_mul_ph_128(<8 x half> %x1, <8 x half> %x2, <8 x half> %src, i8 %mask, ptr %ptr) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512fp16_mask_mul_ph_128(
; CHECK-SAME: <8 x half> [[X1:%.*]], <8 x half> [[X2:%.*]], <8 x half> [[SRC:%.*]], i8 [[MASK:%.*]], ptr [[PTR:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 48) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 56) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP4:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP5:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast i8 [[TMP1]] to <8 x i1>
; CHECK-NEXT:    [[MSK:%.*]] = bitcast i8 [[MASK]] to <8 x i1>
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB7:.*]], label %[[BB8:.*]], !prof [[PROF1]]
; CHECK:       [[BB7]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB8]]:
; CHECK-NEXT:    [[VAL:%.*]] = load <8 x half>, ptr [[PTR]], align 16
; CHECK-NEXT:    [[TMP9:%.*]] = ptrtoint ptr [[PTR]] to i64
; CHECK-NEXT:    [[TMP10:%.*]] = xor i64 [[TMP9]], 87960930222080
; CHECK-NEXT:    [[TMP11:%.*]] = inttoptr i64 [[TMP10]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load <8 x i16>, ptr [[TMP11]], align 16
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <8 x i16> [[TMP3]], [[TMP4]]
; CHECK-NEXT:    [[RES0:%.*]] = fmul <8 x half> [[X1]], [[X2]]
; CHECK-NEXT:    [[TMP12:%.*]] = select <8 x i1> [[MSK]], <8 x i16> [[_MSPROP]], <8 x i16> [[TMP5]]
; CHECK-NEXT:    [[TMP13:%.*]] = bitcast <8 x half> [[RES0]] to <8 x i16>
; CHECK-NEXT:    [[TMP14:%.*]] = bitcast <8 x half> [[SRC]] to <8 x i16>
; CHECK-NEXT:    [[TMP15:%.*]] = xor <8 x i16> [[TMP13]], [[TMP14]]
; CHECK-NEXT:    [[TMP16:%.*]] = or <8 x i16> [[TMP15]], [[_MSPROP]]
; CHECK-NEXT:    [[TMP17:%.*]] = or <8 x i16> [[TMP16]], [[TMP5]]
; CHECK-NEXT:    [[_MSPROP_SELECT:%.*]] = select <8 x i1> [[TMP6]], <8 x i16> [[TMP17]], <8 x i16> [[TMP12]]
; CHECK-NEXT:    [[RES1:%.*]] = select <8 x i1> [[MSK]], <8 x half> [[RES0]], <8 x half> [[SRC]]
; CHECK-NEXT:    [[_MSPROP1:%.*]] = or <8 x i16> [[TMP3]], [[_MSLD]]
; CHECK-NEXT:    [[T3:%.*]] = fmul <8 x half> [[X1]], [[VAL]]
; CHECK-NEXT:    [[TMP18:%.*]] = select <8 x i1> [[MSK]], <8 x i16> [[_MSPROP1]], <8 x i16> [[TMP5]]
; CHECK-NEXT:    [[TMP19:%.*]] = bitcast <8 x half> [[T3]] to <8 x i16>
; CHECK-NEXT:    [[TMP20:%.*]] = bitcast <8 x half> [[SRC]] to <8 x i16>
; CHECK-NEXT:    [[TMP21:%.*]] = xor <8 x i16> [[TMP19]], [[TMP20]]
; CHECK-NEXT:    [[TMP22:%.*]] = or <8 x i16> [[TMP21]], [[_MSPROP1]]
; CHECK-NEXT:    [[TMP23:%.*]] = or <8 x i16> [[TMP22]], [[TMP5]]
; CHECK-NEXT:    [[_MSPROP_SELECT2:%.*]] = select <8 x i1> [[TMP6]], <8 x i16> [[TMP23]], <8 x i16> [[TMP18]]
; CHECK-NEXT:    [[RES2:%.*]] = select <8 x i1> [[MSK]], <8 x half> [[T3]], <8 x half> [[SRC]]
; CHECK-NEXT:    [[_MSPROP3:%.*]] = or <8 x i16> [[_MSPROP_SELECT]], [[_MSPROP_SELECT2]]
; CHECK-NEXT:    [[RES:%.*]] = fmul <8 x half> [[RES1]], [[RES2]]
; CHECK-NEXT:    store <8 x i16> [[_MSPROP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %msk = bitcast i8 %mask to <8 x i1>
  %val = load <8 x half>, ptr %ptr
  %res0 = fmul <8 x half> %x1, %x2
  %res1 = select <8 x i1> %msk, <8 x half> %res0, <8 x half> %src
  %t3 = fmul <8 x half> %x1, %val
  %res2 = select <8 x i1> %msk, <8 x half> %t3, <8 x half> %src
  %res   =  fmul <8 x half> %res1 , %res2
  ret <8 x half> %res
}

define <8 x half> @test_int_x86_avx512fp16_maskz_mul_ph_128(<8 x half> %x1, <8 x half> %x2, i8 %mask, ptr %ptr) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512fp16_maskz_mul_ph_128(
; CHECK-SAME: <8 x half> [[X1:%.*]], <8 x half> [[X2:%.*]], i8 [[MASK:%.*]], ptr [[PTR:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast i8 [[TMP1]] to <8 x i1>
; CHECK-NEXT:    [[MSK:%.*]] = bitcast i8 [[MASK]] to <8 x i1>
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <8 x i16> [[TMP2]], [[TMP3]]
; CHECK-NEXT:    [[RES0:%.*]] = fmul <8 x half> [[X1]], [[X2]]
; CHECK-NEXT:    [[TMP5:%.*]] = select <8 x i1> [[MSK]], <8 x i16> [[_MSPROP]], <8 x i16> zeroinitializer
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast <8 x half> [[RES0]] to <8 x i16>
; CHECK-NEXT:    [[TMP7:%.*]] = xor <8 x i16> [[TMP6]], zeroinitializer
; CHECK-NEXT:    [[TMP8:%.*]] = or <8 x i16> [[TMP7]], [[_MSPROP]]
; CHECK-NEXT:    [[TMP9:%.*]] = or <8 x i16> [[TMP8]], zeroinitializer
; CHECK-NEXT:    [[_MSPROP_SELECT:%.*]] = select <8 x i1> [[TMP4]], <8 x i16> [[TMP9]], <8 x i16> [[TMP5]]
; CHECK-NEXT:    [[RES1:%.*]] = select <8 x i1> [[MSK]], <8 x half> [[RES0]], <8 x half> zeroinitializer
; CHECK-NEXT:    store <8 x i16> [[_MSPROP_SELECT]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES1]]
;
  %msk = bitcast i8 %mask to <8 x i1>
  %res0 = fmul <8 x half> %x1, %x2
  %res1 = select <8 x i1> %msk, <8 x half> %res0, <8 x half> zeroinitializer
  ret <8 x half> %res1
}

define <16 x half> @test_int_x86_avx512fp16_div_ph_256(<16 x half> %x1, <16 x half> %x2) #0 {
; CHECK-LABEL: define <16 x half> @test_int_x86_avx512fp16_div_ph_256(
; CHECK-SAME: <16 x half> [[X1:%.*]], <16 x half> [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <16 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <16 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <16 x i16> [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[RES:%.*]] = fdiv <16 x half> [[X1]], [[X2]]
; CHECK-NEXT:    store <16 x i16> [[_MSPROP]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <16 x half> [[RES]]
;
  %res = fdiv <16 x half> %x1, %x2
  ret <16 x half> %res
}

define <16 x half> @test_int_x86_avx512fp16_div_ph_256_fast(<16 x half> %x1, <16 x half> %x2) #0 {
; CHECK-LABEL: define <16 x half> @test_int_x86_avx512fp16_div_ph_256_fast(
; CHECK-SAME: <16 x half> [[X1:%.*]], <16 x half> [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <16 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <16 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <16 x i16> [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[RES:%.*]] = fdiv fast <16 x half> [[X1]], [[X2]]
; CHECK-NEXT:    store <16 x i16> [[_MSPROP]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <16 x half> [[RES]]
;
  %res = fdiv fast <16 x half> %x1, %x2
  ret <16 x half> %res
}

define <16 x half> @test_int_x86_avx512fp16_mask_div_ph_256(<16 x half> %x1, <16 x half> %x2, <16 x half> %src, i16 %mask, ptr %ptr) #0 {
; CHECK-LABEL: define <16 x half> @test_int_x86_avx512fp16_mask_div_ph_256(
; CHECK-SAME: <16 x half> [[X1:%.*]], <16 x half> [[X2:%.*]], <16 x half> [[SRC:%.*]], i16 [[MASK:%.*]], ptr [[PTR:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i16, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 96) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 104) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <16 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP4:%.*]] = load <16 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    [[TMP5:%.*]] = load <16 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 64) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast i16 [[TMP1]] to <16 x i1>
; CHECK-NEXT:    [[MSK:%.*]] = bitcast i16 [[MASK]] to <16 x i1>
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB7:.*]], label %[[BB8:.*]], !prof [[PROF1]]
; CHECK:       [[BB7]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB8]]:
; CHECK-NEXT:    [[VAL:%.*]] = load <16 x half>, ptr [[PTR]], align 32
; CHECK-NEXT:    [[TMP9:%.*]] = ptrtoint ptr [[PTR]] to i64
; CHECK-NEXT:    [[TMP10:%.*]] = xor i64 [[TMP9]], 87960930222080
; CHECK-NEXT:    [[TMP11:%.*]] = inttoptr i64 [[TMP10]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load <16 x i16>, ptr [[TMP11]], align 32
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <16 x i16> [[TMP3]], [[TMP4]]
; CHECK-NEXT:    [[RES0:%.*]] = fdiv <16 x half> [[X1]], [[X2]]
; CHECK-NEXT:    [[TMP12:%.*]] = select <16 x i1> [[MSK]], <16 x i16> [[_MSPROP]], <16 x i16> [[TMP5]]
; CHECK-NEXT:    [[TMP13:%.*]] = bitcast <16 x half> [[RES0]] to <16 x i16>
; CHECK-NEXT:    [[TMP14:%.*]] = bitcast <16 x half> [[SRC]] to <16 x i16>
; CHECK-NEXT:    [[TMP15:%.*]] = xor <16 x i16> [[TMP13]], [[TMP14]]
; CHECK-NEXT:    [[TMP16:%.*]] = or <16 x i16> [[TMP15]], [[_MSPROP]]
; CHECK-NEXT:    [[TMP17:%.*]] = or <16 x i16> [[TMP16]], [[TMP5]]
; CHECK-NEXT:    [[_MSPROP_SELECT:%.*]] = select <16 x i1> [[TMP6]], <16 x i16> [[TMP17]], <16 x i16> [[TMP12]]
; CHECK-NEXT:    [[RES1:%.*]] = select <16 x i1> [[MSK]], <16 x half> [[RES0]], <16 x half> [[SRC]]
; CHECK-NEXT:    [[_MSPROP1:%.*]] = or <16 x i16> [[TMP3]], [[_MSLD]]
; CHECK-NEXT:    [[T3:%.*]] = fdiv <16 x half> [[X1]], [[VAL]]
; CHECK-NEXT:    [[TMP18:%.*]] = select <16 x i1> [[MSK]], <16 x i16> [[_MSPROP1]], <16 x i16> [[TMP5]]
; CHECK-NEXT:    [[TMP19:%.*]] = bitcast <16 x half> [[T3]] to <16 x i16>
; CHECK-NEXT:    [[TMP20:%.*]] = bitcast <16 x half> [[SRC]] to <16 x i16>
; CHECK-NEXT:    [[TMP21:%.*]] = xor <16 x i16> [[TMP19]], [[TMP20]]
; CHECK-NEXT:    [[TMP22:%.*]] = or <16 x i16> [[TMP21]], [[_MSPROP1]]
; CHECK-NEXT:    [[TMP23:%.*]] = or <16 x i16> [[TMP22]], [[TMP5]]
; CHECK-NEXT:    [[_MSPROP_SELECT2:%.*]] = select <16 x i1> [[TMP6]], <16 x i16> [[TMP23]], <16 x i16> [[TMP18]]
; CHECK-NEXT:    [[RES2:%.*]] = select <16 x i1> [[MSK]], <16 x half> [[T3]], <16 x half> [[SRC]]
; CHECK-NEXT:    [[_MSPROP3:%.*]] = or <16 x i16> [[_MSPROP_SELECT]], [[_MSPROP_SELECT2]]
; CHECK-NEXT:    [[RES:%.*]] = fdiv <16 x half> [[RES1]], [[RES2]]
; CHECK-NEXT:    store <16 x i16> [[_MSPROP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <16 x half> [[RES]]
;
  %msk = bitcast i16 %mask to <16 x i1>
  %val = load <16 x half>, ptr %ptr
  %res0 = fdiv <16 x half> %x1, %x2
  %res1 = select <16 x i1> %msk, <16 x half> %res0, <16 x half> %src
  %t3 = fdiv <16 x half> %x1, %val
  %res2 = select <16 x i1> %msk, <16 x half> %t3, <16 x half> %src
  %res   =  fdiv <16 x half> %res1 , %res2
  ret <16 x half> %res
}

define <16 x half> @test_int_x86_avx512fp16_maskz_div_ph_256(<16 x half> %x1, <16 x half> %x2, i16 %mask, ptr %ptr) #0 {
; CHECK-LABEL: define <16 x half> @test_int_x86_avx512fp16_maskz_div_ph_256(
; CHECK-SAME: <16 x half> [[X1:%.*]], <16 x half> [[X2:%.*]], i16 [[MASK:%.*]], ptr [[PTR:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i16, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 64) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <16 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <16 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast i16 [[TMP1]] to <16 x i1>
; CHECK-NEXT:    [[MSK:%.*]] = bitcast i16 [[MASK]] to <16 x i1>
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <16 x i16> [[TMP2]], [[TMP3]]
; CHECK-NEXT:    [[RES0:%.*]] = fdiv <16 x half> [[X1]], [[X2]]
; CHECK-NEXT:    [[TMP5:%.*]] = select <16 x i1> [[MSK]], <16 x i16> [[_MSPROP]], <16 x i16> zeroinitializer
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast <16 x half> [[RES0]] to <16 x i16>
; CHECK-NEXT:    [[TMP7:%.*]] = xor <16 x i16> [[TMP6]], zeroinitializer
; CHECK-NEXT:    [[TMP8:%.*]] = or <16 x i16> [[TMP7]], [[_MSPROP]]
; CHECK-NEXT:    [[TMP9:%.*]] = or <16 x i16> [[TMP8]], zeroinitializer
; CHECK-NEXT:    [[_MSPROP_SELECT:%.*]] = select <16 x i1> [[TMP4]], <16 x i16> [[TMP9]], <16 x i16> [[TMP5]]
; CHECK-NEXT:    [[RES1:%.*]] = select <16 x i1> [[MSK]], <16 x half> [[RES0]], <16 x half> zeroinitializer
; CHECK-NEXT:    store <16 x i16> [[_MSPROP_SELECT]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <16 x half> [[RES1]]
;
  %msk = bitcast i16 %mask to <16 x i1>
  %res0 = fdiv <16 x half> %x1, %x2
  %res1 = select <16 x i1> %msk, <16 x half> %res0, <16 x half> zeroinitializer
  ret <16 x half> %res1
}

define <8 x half> @test_int_x86_avx512fp16_div_ph_128(<8 x half> %x1, <8 x half> %x2) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512fp16_div_ph_128(
; CHECK-SAME: <8 x half> [[X1:%.*]], <8 x half> [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <8 x i16> [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[RES:%.*]] = fdiv <8 x half> [[X1]], [[X2]]
; CHECK-NEXT:    store <8 x i16> [[_MSPROP]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %res = fdiv <8 x half> %x1, %x2
  ret <8 x half> %res
}

define <8 x half> @test_int_x86_avx512fp16_div_ph_128_fast(<8 x half> %x1, <8 x half> %x2) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512fp16_div_ph_128_fast(
; CHECK-SAME: <8 x half> [[X1:%.*]], <8 x half> [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <8 x i16> [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[RES:%.*]] = fdiv fast <8 x half> [[X1]], [[X2]]
; CHECK-NEXT:    store <8 x i16> [[_MSPROP]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %res = fdiv fast <8 x half> %x1, %x2
  ret <8 x half> %res
}

define <8 x half> @test_int_x86_avx512fp16_mask_div_ph_128(<8 x half> %x1, <8 x half> %x2, <8 x half> %src, i8 %mask, ptr %ptr) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512fp16_mask_div_ph_128(
; CHECK-SAME: <8 x half> [[X1:%.*]], <8 x half> [[X2:%.*]], <8 x half> [[SRC:%.*]], i8 [[MASK:%.*]], ptr [[PTR:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 48) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 56) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP4:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP5:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast i8 [[TMP1]] to <8 x i1>
; CHECK-NEXT:    [[MSK:%.*]] = bitcast i8 [[MASK]] to <8 x i1>
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB7:.*]], label %[[BB8:.*]], !prof [[PROF1]]
; CHECK:       [[BB7]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB8]]:
; CHECK-NEXT:    [[VAL:%.*]] = load <8 x half>, ptr [[PTR]], align 16
; CHECK-NEXT:    [[TMP9:%.*]] = ptrtoint ptr [[PTR]] to i64
; CHECK-NEXT:    [[TMP10:%.*]] = xor i64 [[TMP9]], 87960930222080
; CHECK-NEXT:    [[TMP11:%.*]] = inttoptr i64 [[TMP10]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load <8 x i16>, ptr [[TMP11]], align 16
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <8 x i16> [[TMP3]], [[TMP4]]
; CHECK-NEXT:    [[RES0:%.*]] = fdiv <8 x half> [[X1]], [[X2]]
; CHECK-NEXT:    [[TMP12:%.*]] = select <8 x i1> [[MSK]], <8 x i16> [[_MSPROP]], <8 x i16> [[TMP5]]
; CHECK-NEXT:    [[TMP13:%.*]] = bitcast <8 x half> [[RES0]] to <8 x i16>
; CHECK-NEXT:    [[TMP14:%.*]] = bitcast <8 x half> [[SRC]] to <8 x i16>
; CHECK-NEXT:    [[TMP15:%.*]] = xor <8 x i16> [[TMP13]], [[TMP14]]
; CHECK-NEXT:    [[TMP16:%.*]] = or <8 x i16> [[TMP15]], [[_MSPROP]]
; CHECK-NEXT:    [[TMP17:%.*]] = or <8 x i16> [[TMP16]], [[TMP5]]
; CHECK-NEXT:    [[_MSPROP_SELECT:%.*]] = select <8 x i1> [[TMP6]], <8 x i16> [[TMP17]], <8 x i16> [[TMP12]]
; CHECK-NEXT:    [[RES1:%.*]] = select <8 x i1> [[MSK]], <8 x half> [[RES0]], <8 x half> [[SRC]]
; CHECK-NEXT:    [[_MSPROP1:%.*]] = or <8 x i16> [[TMP3]], [[_MSLD]]
; CHECK-NEXT:    [[T3:%.*]] = fdiv <8 x half> [[X1]], [[VAL]]
; CHECK-NEXT:    [[TMP18:%.*]] = select <8 x i1> [[MSK]], <8 x i16> [[_MSPROP1]], <8 x i16> [[TMP5]]
; CHECK-NEXT:    [[TMP19:%.*]] = bitcast <8 x half> [[T3]] to <8 x i16>
; CHECK-NEXT:    [[TMP20:%.*]] = bitcast <8 x half> [[SRC]] to <8 x i16>
; CHECK-NEXT:    [[TMP21:%.*]] = xor <8 x i16> [[TMP19]], [[TMP20]]
; CHECK-NEXT:    [[TMP22:%.*]] = or <8 x i16> [[TMP21]], [[_MSPROP1]]
; CHECK-NEXT:    [[TMP23:%.*]] = or <8 x i16> [[TMP22]], [[TMP5]]
; CHECK-NEXT:    [[_MSPROP_SELECT2:%.*]] = select <8 x i1> [[TMP6]], <8 x i16> [[TMP23]], <8 x i16> [[TMP18]]
; CHECK-NEXT:    [[RES2:%.*]] = select <8 x i1> [[MSK]], <8 x half> [[T3]], <8 x half> [[SRC]]
; CHECK-NEXT:    [[_MSPROP3:%.*]] = or <8 x i16> [[_MSPROP_SELECT]], [[_MSPROP_SELECT2]]
; CHECK-NEXT:    [[RES:%.*]] = fdiv <8 x half> [[RES1]], [[RES2]]
; CHECK-NEXT:    store <8 x i16> [[_MSPROP3]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %msk = bitcast i8 %mask to <8 x i1>
  %val = load <8 x half>, ptr %ptr
  %res0 = fdiv <8 x half> %x1, %x2
  %res1 = select <8 x i1> %msk, <8 x half> %res0, <8 x half> %src
  %t3 = fdiv <8 x half> %x1, %val
  %res2 = select <8 x i1> %msk, <8 x half> %t3, <8 x half> %src
  %res   =  fdiv <8 x half> %res1 , %res2
  ret <8 x half> %res
}

define <8 x half> @test_int_x86_avx512fp16_maskz_div_ph_128(<8 x half> %x1, <8 x half> %x2, i8 %mask, ptr %ptr) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512fp16_maskz_div_ph_128(
; CHECK-SAME: <8 x half> [[X1:%.*]], <8 x half> [[X2:%.*]], i8 [[MASK:%.*]], ptr [[PTR:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast i8 [[TMP1]] to <8 x i1>
; CHECK-NEXT:    [[MSK:%.*]] = bitcast i8 [[MASK]] to <8 x i1>
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <8 x i16> [[TMP2]], [[TMP3]]
; CHECK-NEXT:    [[RES0:%.*]] = fdiv <8 x half> [[X1]], [[X2]]
; CHECK-NEXT:    [[TMP5:%.*]] = select <8 x i1> [[MSK]], <8 x i16> [[_MSPROP]], <8 x i16> zeroinitializer
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast <8 x half> [[RES0]] to <8 x i16>
; CHECK-NEXT:    [[TMP7:%.*]] = xor <8 x i16> [[TMP6]], zeroinitializer
; CHECK-NEXT:    [[TMP8:%.*]] = or <8 x i16> [[TMP7]], [[_MSPROP]]
; CHECK-NEXT:    [[TMP9:%.*]] = or <8 x i16> [[TMP8]], zeroinitializer
; CHECK-NEXT:    [[_MSPROP_SELECT:%.*]] = select <8 x i1> [[TMP4]], <8 x i16> [[TMP9]], <8 x i16> [[TMP5]]
; CHECK-NEXT:    [[RES1:%.*]] = select <8 x i1> [[MSK]], <8 x half> [[RES0]], <8 x half> zeroinitializer
; CHECK-NEXT:    store <8 x i16> [[_MSPROP_SELECT]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES1]]
;
  %msk = bitcast i8 %mask to <8 x i1>
  %res0 = fdiv <8 x half> %x1, %x2
  %res1 = select <8 x i1> %msk, <8 x half> %res0, <8 x half> zeroinitializer
  ret <8 x half> %res1
}

define <16 x half> @test_min_ph_256(<16 x half> %x1, <16 x half> %x2) #0 {
; CHECK-LABEL: define <16 x half> @test_min_ph_256(
; CHECK-SAME: <16 x half> [[X1:%.*]], <16 x half> [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <16 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <16 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <16 x i16> [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[TMP3:%.*]] = trunc <16 x i16> [[_MSPROP]] to <16 x i1>
; CHECK-NEXT:    [[RES0:%.*]] = fcmp olt <16 x half> [[X1]], [[X2]]
; CHECK-NEXT:    [[TMP4:%.*]] = select <16 x i1> [[RES0]], <16 x i16> [[TMP1]], <16 x i16> [[TMP2]]
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <16 x half> [[X1]] to <16 x i16>
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast <16 x half> [[X2]] to <16 x i16>
; CHECK-NEXT:    [[TMP7:%.*]] = xor <16 x i16> [[TMP5]], [[TMP6]]
; CHECK-NEXT:    [[TMP8:%.*]] = or <16 x i16> [[TMP7]], [[TMP1]]
; CHECK-NEXT:    [[TMP9:%.*]] = or <16 x i16> [[TMP8]], [[TMP2]]
; CHECK-NEXT:    [[_MSPROP_SELECT:%.*]] = select <16 x i1> [[TMP3]], <16 x i16> [[TMP9]], <16 x i16> [[TMP4]]
; CHECK-NEXT:    [[RES1:%.*]] = select <16 x i1> [[RES0]], <16 x half> [[X1]], <16 x half> [[X2]]
; CHECK-NEXT:    store <16 x i16> [[_MSPROP_SELECT]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <16 x half> [[RES1]]
;
  %res0 = fcmp olt <16 x half> %x1, %x2
  %res1 = select <16 x i1> %res0, <16 x half> %x1, <16 x half> %x2
  ret  <16 x half> %res1
}

define <16 x half> @test_max_ph_256(<16 x half> %x1, <16 x half> %x2) #0 {
; CHECK-LABEL: define <16 x half> @test_max_ph_256(
; CHECK-SAME: <16 x half> [[X1:%.*]], <16 x half> [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <16 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <16 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <16 x i16> [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[TMP3:%.*]] = trunc <16 x i16> [[_MSPROP]] to <16 x i1>
; CHECK-NEXT:    [[RES0:%.*]] = fcmp ogt <16 x half> [[X1]], [[X2]]
; CHECK-NEXT:    [[TMP4:%.*]] = select <16 x i1> [[RES0]], <16 x i16> [[TMP1]], <16 x i16> [[TMP2]]
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <16 x half> [[X1]] to <16 x i16>
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast <16 x half> [[X2]] to <16 x i16>
; CHECK-NEXT:    [[TMP7:%.*]] = xor <16 x i16> [[TMP5]], [[TMP6]]
; CHECK-NEXT:    [[TMP8:%.*]] = or <16 x i16> [[TMP7]], [[TMP1]]
; CHECK-NEXT:    [[TMP9:%.*]] = or <16 x i16> [[TMP8]], [[TMP2]]
; CHECK-NEXT:    [[_MSPROP_SELECT:%.*]] = select <16 x i1> [[TMP3]], <16 x i16> [[TMP9]], <16 x i16> [[TMP4]]
; CHECK-NEXT:    [[RES1:%.*]] = select <16 x i1> [[RES0]], <16 x half> [[X1]], <16 x half> [[X2]]
; CHECK-NEXT:    store <16 x i16> [[_MSPROP_SELECT]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <16 x half> [[RES1]]
;
  %res0 = fcmp ogt <16 x half> %x1, %x2
  %res1 = select <16 x i1> %res0, <16 x half> %x1, <16 x half> %x2
  ret  <16 x half> %res1
}

define <8 x half> @test_min_ph_128(<8 x half> %x1, <8 x half> %x2) #0 {
; CHECK-LABEL: define <8 x half> @test_min_ph_128(
; CHECK-SAME: <8 x half> [[X1:%.*]], <8 x half> [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <8 x i16> [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[TMP3:%.*]] = trunc <8 x i16> [[_MSPROP]] to <8 x i1>
; CHECK-NEXT:    [[RES0:%.*]] = fcmp olt <8 x half> [[X1]], [[X2]]
; CHECK-NEXT:    [[TMP4:%.*]] = select <8 x i1> [[RES0]], <8 x i16> [[TMP1]], <8 x i16> [[TMP2]]
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x half> [[X1]] to <8 x i16>
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast <8 x half> [[X2]] to <8 x i16>
; CHECK-NEXT:    [[TMP7:%.*]] = xor <8 x i16> [[TMP5]], [[TMP6]]
; CHECK-NEXT:    [[TMP8:%.*]] = or <8 x i16> [[TMP7]], [[TMP1]]
; CHECK-NEXT:    [[TMP9:%.*]] = or <8 x i16> [[TMP8]], [[TMP2]]
; CHECK-NEXT:    [[_MSPROP_SELECT:%.*]] = select <8 x i1> [[TMP3]], <8 x i16> [[TMP9]], <8 x i16> [[TMP4]]
; CHECK-NEXT:    [[RES1:%.*]] = select <8 x i1> [[RES0]], <8 x half> [[X1]], <8 x half> [[X2]]
; CHECK-NEXT:    store <8 x i16> [[_MSPROP_SELECT]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES1]]
;
  %res0 = fcmp olt <8 x half> %x1, %x2
  %res1 = select <8 x i1> %res0, <8 x half> %x1, <8 x half> %x2
  ret  <8 x half> %res1
}

define <8 x half> @test_max_ph_128(<8 x half> %x1, <8 x half> %x2) #0 {
; CHECK-LABEL: define <8 x half> @test_max_ph_128(
; CHECK-SAME: <8 x half> [[X1:%.*]], <8 x half> [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <8 x i16> [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[TMP3:%.*]] = trunc <8 x i16> [[_MSPROP]] to <8 x i1>
; CHECK-NEXT:    [[RES0:%.*]] = fcmp ogt <8 x half> [[X1]], [[X2]]
; CHECK-NEXT:    [[TMP4:%.*]] = select <8 x i1> [[RES0]], <8 x i16> [[TMP1]], <8 x i16> [[TMP2]]
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x half> [[X1]] to <8 x i16>
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast <8 x half> [[X2]] to <8 x i16>
; CHECK-NEXT:    [[TMP7:%.*]] = xor <8 x i16> [[TMP5]], [[TMP6]]
; CHECK-NEXT:    [[TMP8:%.*]] = or <8 x i16> [[TMP7]], [[TMP1]]
; CHECK-NEXT:    [[TMP9:%.*]] = or <8 x i16> [[TMP8]], [[TMP2]]
; CHECK-NEXT:    [[_MSPROP_SELECT:%.*]] = select <8 x i1> [[TMP3]], <8 x i16> [[TMP9]], <8 x i16> [[TMP4]]
; CHECK-NEXT:    [[RES1:%.*]] = select <8 x i1> [[RES0]], <8 x half> [[X1]], <8 x half> [[X2]]
; CHECK-NEXT:    store <8 x i16> [[_MSPROP_SELECT]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES1]]
;
  %res0 = fcmp ogt <8 x half> %x1, %x2
  %res1 = select <8 x i1> %res0, <8 x half> %x1, <8 x half> %x2
  ret  <8 x half> %res1
}

declare <8 x half> @llvm.x86.avx512fp16.max.ph.128(<8 x half>, <8 x half>)
declare <16 x half> @llvm.x86.avx512fp16.max.ph.256(<16 x half>, <16 x half>)

define <8 x half> @test_max_ph_128_2(<8 x half> %x1, <8 x half> %x2) #0 {
; CHECK-LABEL: define <8 x half> @test_max_ph_128_2(
; CHECK-SAME: <8 x half> [[X1:%.*]], <8 x half> [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <8 x i16> [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[RES0:%.*]] = call <8 x half> @llvm.x86.avx512fp16.max.ph.128(<8 x half> [[X1]], <8 x half> [[X2]])
; CHECK-NEXT:    store <8 x i16> [[_MSPROP]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES0]]
;
  %res0 = call <8 x half> @llvm.x86.avx512fp16.max.ph.128(<8 x half> %x1, <8 x half> %x2)
  ret  <8 x half> %res0
}

define <16 x half> @test_max_ph_256_2(<16 x half> %x1, <16 x half> %x2) #0 {
; CHECK-LABEL: define <16 x half> @test_max_ph_256_2(
; CHECK-SAME: <16 x half> [[X1:%.*]], <16 x half> [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <16 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <16 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <16 x i16> [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[RES0:%.*]] = call <16 x half> @llvm.x86.avx512fp16.max.ph.256(<16 x half> [[X1]], <16 x half> [[X2]])
; CHECK-NEXT:    store <16 x i16> [[_MSPROP]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <16 x half> [[RES0]]
;
  %res0 = call <16 x half> @llvm.x86.avx512fp16.max.ph.256(<16 x half> %x1, <16 x half> %x2)
  ret  <16 x half> %res0
}

declare <8 x half> @llvm.x86.avx512fp16.min.ph.128(<8 x half>, <8 x half>)
declare <16 x half> @llvm.x86.avx512fp16.min.ph.256(<16 x half>, <16 x half>)

define <8 x half> @test_min_ph_128_2(<8 x half> %x1, <8 x half> %x2) #0 {
; CHECK-LABEL: define <8 x half> @test_min_ph_128_2(
; CHECK-SAME: <8 x half> [[X1:%.*]], <8 x half> [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <8 x i16> [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[RES0:%.*]] = call <8 x half> @llvm.x86.avx512fp16.min.ph.128(<8 x half> [[X1]], <8 x half> [[X2]])
; CHECK-NEXT:    store <8 x i16> [[_MSPROP]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES0]]
;
  %res0 = call <8 x half> @llvm.x86.avx512fp16.min.ph.128(<8 x half> %x1, <8 x half> %x2)
  ret  <8 x half> %res0
}

define <16 x half> @test_min_ph_256_2(<16 x half> %x1, <16 x half> %x2) #0 {
; CHECK-LABEL: define <16 x half> @test_min_ph_256_2(
; CHECK-SAME: <16 x half> [[X1:%.*]], <16 x half> [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <16 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <16 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <16 x i16> [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[RES0:%.*]] = call <16 x half> @llvm.x86.avx512fp16.min.ph.256(<16 x half> [[X1]], <16 x half> [[X2]])
; CHECK-NEXT:    store <16 x i16> [[_MSPROP]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <16 x half> [[RES0]]
;
  %res0 = call <16 x half> @llvm.x86.avx512fp16.min.ph.256(<16 x half> %x1, <16 x half> %x2)
  ret  <16 x half> %res0
}

declare <4 x double> @llvm.x86.avx512fp16.mask.vcvtph2pd.256(<8 x half>, <4 x double>, i8)

define <4 x double> @test_int_x86_avx512_mask_vcvt_ph2pd_256(<8 x half> %x0, <4 x double> %x1, i8 %x2) #0 {
; CHECK-LABEL: define <4 x double> @test_int_x86_avx512_mask_vcvt_ph2pd_256(
; CHECK-SAME: <8 x half> [[X0:%.*]], <4 x double> [[X1:%.*]], i8 [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <4 x i64>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 48) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP4]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <4 x i64> [[TMP2]] to i256
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i256 [[TMP5]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i8 [[TMP3]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR3]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES:%.*]] = call <4 x double> @llvm.x86.avx512fp16.mask.vcvtph2pd.256(<8 x half> [[X0]], <4 x double> [[X1]], i8 [[X2]])
; CHECK-NEXT:    store <4 x i64> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x double> [[RES]]
;
  %res = call <4 x double> @llvm.x86.avx512fp16.mask.vcvtph2pd.256(<8 x half> %x0, <4 x double> %x1, i8 %x2)
  ret <4 x double> %res
}

define <4 x double> @test_int_x86_avx512_mask_vcvt_ph2pd_256_nomask(<8 x half> %x0, <4 x double> %x1) #0 {
; CHECK-LABEL: define <4 x double> @test_int_x86_avx512_mask_vcvt_ph2pd_256_nomask(
; CHECK-SAME: <8 x half> [[X0:%.*]], <4 x double> [[X1:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <4 x i64>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP3]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <4 x i64> [[TMP2]] to i256
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i256 [[TMP4]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    br i1 [[_MSOR]], label %[[BB5:.*]], label %[[BB6:.*]], !prof [[PROF1]]
; CHECK:       [[BB5]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB6]]:
; CHECK-NEXT:    [[RES:%.*]] = call <4 x double> @llvm.x86.avx512fp16.mask.vcvtph2pd.256(<8 x half> [[X0]], <4 x double> [[X1]], i8 -1)
; CHECK-NEXT:    store <4 x i64> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x double> [[RES]]
;
  %res = call <4 x double> @llvm.x86.avx512fp16.mask.vcvtph2pd.256(<8 x half> %x0, <4 x double> %x1, i8 -1)
  ret <4 x double> %res
}

declare <2 x double> @llvm.x86.avx512fp16.mask.vcvtph2pd.128(<8 x half>, <2 x double>, i8)

define <2 x double> @test_int_x86_avx512_mask_vcvt_ph2pd_128(<8 x half> %x0, <2 x double> %x1, i8 %x2) #0 {
; CHECK-LABEL: define <2 x double> @test_int_x86_avx512_mask_vcvt_ph2pd_128(
; CHECK-SAME: <8 x half> [[X0:%.*]], <2 x double> [[X1:%.*]], i8 [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <2 x i64>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP4]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <2 x i64> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP5]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i8 [[TMP3]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR3]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES:%.*]] = call <2 x double> @llvm.x86.avx512fp16.mask.vcvtph2pd.128(<8 x half> [[X0]], <2 x double> [[X1]], i8 [[X2]])
; CHECK-NEXT:    store <2 x i64> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x double> [[RES]]
;
  %res = call <2 x double> @llvm.x86.avx512fp16.mask.vcvtph2pd.128(<8 x half> %x0, <2 x double> %x1, i8 %x2)
  ret <2 x double> %res
}

define <2 x double> @test_int_x86_avx512_mask_vcvt_ph2pd_128_nomask(<8 x half> %x0, <2 x double> %x1) #0 {
; CHECK-LABEL: define <2 x double> @test_int_x86_avx512_mask_vcvt_ph2pd_128_nomask(
; CHECK-SAME: <8 x half> [[X0:%.*]], <2 x double> [[X1:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <2 x i64>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP3]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <2 x i64> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP4]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    br i1 [[_MSOR]], label %[[BB5:.*]], label %[[BB6:.*]], !prof [[PROF1]]
; CHECK:       [[BB5]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB6]]:
; CHECK-NEXT:    [[RES:%.*]] = call <2 x double> @llvm.x86.avx512fp16.mask.vcvtph2pd.128(<8 x half> [[X0]], <2 x double> [[X1]], i8 -1)
; CHECK-NEXT:    store <2 x i64> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <2 x double> [[RES]]
;
  %res = call <2 x double> @llvm.x86.avx512fp16.mask.vcvtph2pd.128(<8 x half> %x0, <2 x double> %x1, i8 -1)
  ret <2 x double> %res
}

declare <8 x half> @llvm.x86.avx512fp16.mask.vcvtpd2ph.256(<4 x double>, <8 x half>, i8)

define <8 x half> @test_int_x86_avx512_mask_vcvt_pd2ph_256(<4 x double> %x0, <8 x half> %x1, i8 %x2) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512_mask_vcvt_pd2ph_256(
; CHECK-SAME: <4 x double> [[X0:%.*]], <8 x half> [[X1:%.*]], i8 [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 48) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <4 x i64> [[TMP1]] to i256
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i256 [[TMP4]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP5]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i8 [[TMP3]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR3]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.vcvtpd2ph.256(<4 x double> [[X0]], <8 x half> [[X1]], i8 [[X2]])
; CHECK-NEXT:    store <8 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %res = call <8 x half> @llvm.x86.avx512fp16.mask.vcvtpd2ph.256(<4 x double> %x0, <8 x half> %x1, i8 %x2)
  ret <8 x half> %res
}

define <8 x half> @test_int_x86_avx512_mask_vcvt_pd2ph_256_load(ptr %px0, <8 x half> %x1, i8 %x2) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512_mask_vcvt_pd2ph_256_load(
; CHECK-SAME: ptr [[PX0:%.*]], <8 x half> [[X1:%.*]], i8 [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 8) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 24) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP1]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB4:.*]], label %[[BB5:.*]], !prof [[PROF1]]
; CHECK:       [[BB4]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB5]]:
; CHECK-NEXT:    [[X0:%.*]] = load <4 x double>, ptr [[PX0]], align 32
; CHECK-NEXT:    [[TMP6:%.*]] = ptrtoint ptr [[PX0]] to i64
; CHECK-NEXT:    [[TMP7:%.*]] = xor i64 [[TMP6]], 87960930222080
; CHECK-NEXT:    [[TMP8:%.*]] = inttoptr i64 [[TMP7]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load <4 x i64>, ptr [[TMP8]], align 32
; CHECK-NEXT:    [[TMP9:%.*]] = bitcast <4 x i64> [[_MSLD]] to i256
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i256 [[TMP9]], 0
; CHECK-NEXT:    [[TMP10:%.*]] = bitcast <8 x i16> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i128 [[TMP10]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP1]], [[_MSCMP2]]
; CHECK-NEXT:    [[_MSCMP3:%.*]] = icmp ne i8 [[TMP3]], 0
; CHECK-NEXT:    [[_MSOR4:%.*]] = or i1 [[_MSOR]], [[_MSCMP3]]
; CHECK-NEXT:    br i1 [[_MSOR4]], label %[[BB11:.*]], label %[[BB12:.*]], !prof [[PROF1]]
; CHECK:       [[BB11]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB12]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.vcvtpd2ph.256(<4 x double> [[X0]], <8 x half> [[X1]], i8 [[X2]])
; CHECK-NEXT:    store <8 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %x0 = load <4 x double>, ptr %px0, align 32
  %res = call <8 x half> @llvm.x86.avx512fp16.mask.vcvtpd2ph.256(<4 x double> %x0, <8 x half> %x1, i8 %x2)
  ret <8 x half> %res
}

declare <8 x half> @llvm.x86.avx512fp16.mask.vcvtpd2ph.128(<2 x double>, <8 x half>, i8)

define <8 x half> @test_int_x86_avx512_mask_vcvt_pd2ph_128(<2 x double> %x0, <8 x half> %x1, i8 %x2) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512_mask_vcvt_pd2ph_128(
; CHECK-SAME: <2 x double> [[X0:%.*]], <8 x half> [[X1:%.*]], i8 [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <2 x i64> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP4]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP5]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i8 [[TMP3]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR3]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.vcvtpd2ph.128(<2 x double> [[X0]], <8 x half> [[X1]], i8 [[X2]])
; CHECK-NEXT:    store <8 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %res = call <8 x half> @llvm.x86.avx512fp16.mask.vcvtpd2ph.128(<2 x double> %x0, <8 x half> %x1, i8 %x2)
  ret <8 x half> %res
}

define <8 x half> @test_int_x86_avx512_mask_vcvt_pd2ph_128_load(ptr %px0, <8 x half> %x1, i8 %x2) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512_mask_vcvt_pd2ph_128_load(
; CHECK-SAME: ptr [[PX0:%.*]], <8 x half> [[X1:%.*]], i8 [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 8) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 24) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP1]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB4:.*]], label %[[BB5:.*]], !prof [[PROF1]]
; CHECK:       [[BB4]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB5]]:
; CHECK-NEXT:    [[X0:%.*]] = load <2 x double>, ptr [[PX0]], align 16
; CHECK-NEXT:    [[TMP6:%.*]] = ptrtoint ptr [[PX0]] to i64
; CHECK-NEXT:    [[TMP7:%.*]] = xor i64 [[TMP6]], 87960930222080
; CHECK-NEXT:    [[TMP8:%.*]] = inttoptr i64 [[TMP7]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load <2 x i64>, ptr [[TMP8]], align 16
; CHECK-NEXT:    [[TMP9:%.*]] = bitcast <2 x i64> [[_MSLD]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP9]], 0
; CHECK-NEXT:    [[TMP10:%.*]] = bitcast <8 x i16> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i128 [[TMP10]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP1]], [[_MSCMP2]]
; CHECK-NEXT:    [[_MSCMP3:%.*]] = icmp ne i8 [[TMP3]], 0
; CHECK-NEXT:    [[_MSOR4:%.*]] = or i1 [[_MSOR]], [[_MSCMP3]]
; CHECK-NEXT:    br i1 [[_MSOR4]], label %[[BB11:.*]], label %[[BB12:.*]], !prof [[PROF1]]
; CHECK:       [[BB11]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB12]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.vcvtpd2ph.128(<2 x double> [[X0]], <8 x half> [[X1]], i8 [[X2]])
; CHECK-NEXT:    store <8 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %x0 = load <2 x double>, ptr %px0, align 16
  %res = call <8 x half> @llvm.x86.avx512fp16.mask.vcvtpd2ph.128(<2 x double> %x0, <8 x half> %x1, i8 %x2)
  ret <8 x half> %res
}

declare <4 x i32> @llvm.x86.avx512fp16.mask.vcvtph2udq.128(<8 x half>, <4 x i32>, i8)

define <4 x i32> @test_int_x86_avx512_cvt_ph2udq_128(<8 x half> %x0) #0 {
; CHECK-LABEL: define <4 x i32> @test_int_x86_avx512_cvt_ph2udq_128(
; CHECK-SAME: <8 x half> [[X0:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    [[RES:%.*]] = call <4 x i32> @llvm.x86.avx512fp16.mask.vcvtph2udq.128(<8 x half> [[X0]], <4 x i32> poison, i8 -1)
; CHECK-NEXT:    store <4 x i32> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x i32> [[RES]]
;
  %res = call <4 x i32> @llvm.x86.avx512fp16.mask.vcvtph2udq.128(<8 x half> %x0, <4 x i32> poison, i8 -1)
  ret <4 x i32> %res
}

define <4 x i32> @test_int_x86_avx512_mask_cvt_ph2udq_128(<8 x half> %x0, <4 x i32> %x1, i8 %x2) #0 {
; CHECK-LABEL: define <4 x i32> @test_int_x86_avx512_mask_cvt_ph2udq_128(
; CHECK-SAME: <8 x half> [[X0:%.*]], <4 x i32> [[X1:%.*]], i8 [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <4 x i32>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP4]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <4 x i32> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP5]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i8 [[TMP3]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR3]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES:%.*]] = call <4 x i32> @llvm.x86.avx512fp16.mask.vcvtph2udq.128(<8 x half> [[X0]], <4 x i32> [[X1]], i8 [[X2]])
; CHECK-NEXT:    store <4 x i32> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x i32> [[RES]]
;
  %res = call <4 x i32> @llvm.x86.avx512fp16.mask.vcvtph2udq.128(<8 x half> %x0, <4 x i32> %x1, i8 %x2)
  ret <4 x i32> %res
}

define <4 x i32> @test_int_x86_avx512_maskz_cvt_ph2udq_128(<8 x half> %x0, i8 %x2) #0 {
; CHECK-LABEL: define <4 x i32> @test_int_x86_avx512_maskz_cvt_ph2udq_128(
; CHECK-SAME: <8 x half> [[X0:%.*]], i8 [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP3]], 0
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i8 [[TMP2]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    br i1 [[_MSOR]], label %[[BB4:.*]], label %[[BB5:.*]], !prof [[PROF1]]
; CHECK:       [[BB4]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB5]]:
; CHECK-NEXT:    [[RES:%.*]] = call <4 x i32> @llvm.x86.avx512fp16.mask.vcvtph2udq.128(<8 x half> [[X0]], <4 x i32> zeroinitializer, i8 [[X2]])
; CHECK-NEXT:    store <4 x i32> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x i32> [[RES]]
;
  %res = call <4 x i32> @llvm.x86.avx512fp16.mask.vcvtph2udq.128(<8 x half> %x0, <4 x i32> zeroinitializer, i8 %x2)
  ret <4 x i32> %res
}

declare <8 x i32> @llvm.x86.avx512fp16.mask.vcvtph2udq.256(<8 x half>, <8 x i32>, i8)

define <8 x i32> @test_int_x86_avx512_cvt_ph2udq_256(<8 x half> %x0) #0 {
; CHECK-LABEL: define <8 x i32> @test_int_x86_avx512_cvt_ph2udq_256(
; CHECK-SAME: <8 x half> [[X0:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    [[RES:%.*]] = call <8 x i32> @llvm.x86.avx512fp16.mask.vcvtph2udq.256(<8 x half> [[X0]], <8 x i32> poison, i8 -1)
; CHECK-NEXT:    store <8 x i32> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x i32> [[RES]]
;
  %res = call <8 x i32> @llvm.x86.avx512fp16.mask.vcvtph2udq.256(<8 x half> %x0, <8 x i32> poison, i8 -1)
  ret <8 x i32> %res
}

define <8 x i32> @test_int_x86_avx512_mask_cvt_ph2udq_256(<8 x half> %x0, <8 x i32> %x1, i8 %x2) #0 {
; CHECK-LABEL: define <8 x i32> @test_int_x86_avx512_mask_cvt_ph2udq_256(
; CHECK-SAME: <8 x half> [[X0:%.*]], <8 x i32> [[X1:%.*]], i8 [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i32>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 48) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP4]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i32> [[TMP2]] to i256
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i256 [[TMP5]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i8 [[TMP3]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR3]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x i32> @llvm.x86.avx512fp16.mask.vcvtph2udq.256(<8 x half> [[X0]], <8 x i32> [[X1]], i8 [[X2]])
; CHECK-NEXT:    store <8 x i32> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x i32> [[RES]]
;
  %res = call <8 x i32> @llvm.x86.avx512fp16.mask.vcvtph2udq.256(<8 x half> %x0, <8 x i32> %x1, i8 %x2)
  ret <8 x i32> %res
}

define <8 x i32> @test_int_x86_avx512_maskz_cvt_ph2udq_256(<8 x half> %x0, i8 %x2) #0 {
; CHECK-LABEL: define <8 x i32> @test_int_x86_avx512_maskz_cvt_ph2udq_256(
; CHECK-SAME: <8 x half> [[X0:%.*]], i8 [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP3]], 0
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i8 [[TMP2]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    br i1 [[_MSOR]], label %[[BB4:.*]], label %[[BB5:.*]], !prof [[PROF1]]
; CHECK:       [[BB4]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB5]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x i32> @llvm.x86.avx512fp16.mask.vcvtph2udq.256(<8 x half> [[X0]], <8 x i32> zeroinitializer, i8 [[X2]])
; CHECK-NEXT:    store <8 x i32> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x i32> [[RES]]
;
  %res = call <8 x i32> @llvm.x86.avx512fp16.mask.vcvtph2udq.256(<8 x half> %x0, <8 x i32> zeroinitializer, i8 %x2)
  ret <8 x i32> %res
}

declare <4 x i32> @llvm.x86.avx512fp16.mask.vcvttph2dq.128(<8 x half>, <4 x i32>, i8)

define <4 x i32> @test_int_x86_avx512_cvtt_ph2dq_128(<8 x half> %x0) #0 {
; CHECK-LABEL: define <4 x i32> @test_int_x86_avx512_cvtt_ph2dq_128(
; CHECK-SAME: <8 x half> [[X0:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    [[RES:%.*]] = call <4 x i32> @llvm.x86.avx512fp16.mask.vcvttph2dq.128(<8 x half> [[X0]], <4 x i32> poison, i8 -1)
; CHECK-NEXT:    store <4 x i32> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x i32> [[RES]]
;
  %res = call <4 x i32> @llvm.x86.avx512fp16.mask.vcvttph2dq.128(<8 x half> %x0, <4 x i32> poison, i8 -1)
  ret <4 x i32> %res
}

define <4 x i32> @test_int_x86_avx512_mask_cvtt_ph2dq_128(<8 x half> %x0, <4 x i32> %x1, i8 %x2) #0 {
; CHECK-LABEL: define <4 x i32> @test_int_x86_avx512_mask_cvtt_ph2dq_128(
; CHECK-SAME: <8 x half> [[X0:%.*]], <4 x i32> [[X1:%.*]], i8 [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <4 x i32>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP4]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <4 x i32> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP5]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i8 [[TMP3]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR3]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES:%.*]] = call <4 x i32> @llvm.x86.avx512fp16.mask.vcvttph2dq.128(<8 x half> [[X0]], <4 x i32> [[X1]], i8 [[X2]])
; CHECK-NEXT:    store <4 x i32> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x i32> [[RES]]
;
  %res = call <4 x i32> @llvm.x86.avx512fp16.mask.vcvttph2dq.128(<8 x half> %x0, <4 x i32> %x1, i8 %x2)
  ret <4 x i32> %res
}

define <4 x i32> @test_int_x86_avx512_maskz_cvtt_ph2dq_128(<8 x half> %x0, i8 %x2) #0 {
; CHECK-LABEL: define <4 x i32> @test_int_x86_avx512_maskz_cvtt_ph2dq_128(
; CHECK-SAME: <8 x half> [[X0:%.*]], i8 [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP3]], 0
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i8 [[TMP2]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    br i1 [[_MSOR]], label %[[BB4:.*]], label %[[BB5:.*]], !prof [[PROF1]]
; CHECK:       [[BB4]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB5]]:
; CHECK-NEXT:    [[RES:%.*]] = call <4 x i32> @llvm.x86.avx512fp16.mask.vcvttph2dq.128(<8 x half> [[X0]], <4 x i32> zeroinitializer, i8 [[X2]])
; CHECK-NEXT:    store <4 x i32> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x i32> [[RES]]
;
  %res = call <4 x i32> @llvm.x86.avx512fp16.mask.vcvttph2dq.128(<8 x half> %x0, <4 x i32> zeroinitializer, i8 %x2)
  ret <4 x i32> %res
}

declare <8 x i32> @llvm.x86.avx512fp16.mask.vcvttph2dq.256(<8 x half>, <8 x i32>, i8)

define <8 x i32> @test_int_x86_avx512_cvtt_ph2dq_256(<8 x half> %x0) #0 {
; CHECK-LABEL: define <8 x i32> @test_int_x86_avx512_cvtt_ph2dq_256(
; CHECK-SAME: <8 x half> [[X0:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    [[RES:%.*]] = call <8 x i32> @llvm.x86.avx512fp16.mask.vcvttph2dq.256(<8 x half> [[X0]], <8 x i32> poison, i8 -1)
; CHECK-NEXT:    store <8 x i32> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x i32> [[RES]]
;
  %res = call <8 x i32> @llvm.x86.avx512fp16.mask.vcvttph2dq.256(<8 x half> %x0, <8 x i32> poison, i8 -1)
  ret <8 x i32> %res
}

define <8 x i32> @test_int_x86_avx512_mask_cvtt_ph2dq_256(<8 x half> %x0, <8 x i32> %x1, i8 %x2) #0 {
; CHECK-LABEL: define <8 x i32> @test_int_x86_avx512_mask_cvtt_ph2dq_256(
; CHECK-SAME: <8 x half> [[X0:%.*]], <8 x i32> [[X1:%.*]], i8 [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i32>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 48) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP4]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i32> [[TMP2]] to i256
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i256 [[TMP5]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i8 [[TMP3]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR3]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x i32> @llvm.x86.avx512fp16.mask.vcvttph2dq.256(<8 x half> [[X0]], <8 x i32> [[X1]], i8 [[X2]])
; CHECK-NEXT:    store <8 x i32> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x i32> [[RES]]
;
  %res = call <8 x i32> @llvm.x86.avx512fp16.mask.vcvttph2dq.256(<8 x half> %x0, <8 x i32> %x1, i8 %x2)
  ret <8 x i32> %res
}

define <8 x i32> @test_int_x86_avx512_maskz_cvtt_ph2dq_256(<8 x half> %x0, i8 %x2) #0 {
; CHECK-LABEL: define <8 x i32> @test_int_x86_avx512_maskz_cvtt_ph2dq_256(
; CHECK-SAME: <8 x half> [[X0:%.*]], i8 [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP3]], 0
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i8 [[TMP2]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    br i1 [[_MSOR]], label %[[BB4:.*]], label %[[BB5:.*]], !prof [[PROF1]]
; CHECK:       [[BB4]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB5]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x i32> @llvm.x86.avx512fp16.mask.vcvttph2dq.256(<8 x half> [[X0]], <8 x i32> zeroinitializer, i8 [[X2]])
; CHECK-NEXT:    store <8 x i32> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x i32> [[RES]]
;
  %res = call <8 x i32> @llvm.x86.avx512fp16.mask.vcvttph2dq.256(<8 x half> %x0, <8 x i32> zeroinitializer, i8 %x2)
  ret <8 x i32> %res
}

declare <4 x i32> @llvm.x86.avx512fp16.mask.vcvttph2udq.128(<8 x half>, <4 x i32>, i8)

define <4 x i32> @test_int_x86_avx512_cvtt_ph2udq_128(<8 x half> %x0) #0 {
; CHECK-LABEL: define <4 x i32> @test_int_x86_avx512_cvtt_ph2udq_128(
; CHECK-SAME: <8 x half> [[X0:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    [[RES:%.*]] = call <4 x i32> @llvm.x86.avx512fp16.mask.vcvttph2udq.128(<8 x half> [[X0]], <4 x i32> poison, i8 -1)
; CHECK-NEXT:    store <4 x i32> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x i32> [[RES]]
;
  %res = call <4 x i32> @llvm.x86.avx512fp16.mask.vcvttph2udq.128(<8 x half> %x0, <4 x i32> poison, i8 -1)
  ret <4 x i32> %res
}

define <4 x i32> @test_int_x86_avx512_mask_cvtt_ph2udq_128(<8 x half> %x0, <4 x i32> %x1, i8 %x2) #0 {
; CHECK-LABEL: define <4 x i32> @test_int_x86_avx512_mask_cvtt_ph2udq_128(
; CHECK-SAME: <8 x half> [[X0:%.*]], <4 x i32> [[X1:%.*]], i8 [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <4 x i32>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP4]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <4 x i32> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP5]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i8 [[TMP3]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR3]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES:%.*]] = call <4 x i32> @llvm.x86.avx512fp16.mask.vcvttph2udq.128(<8 x half> [[X0]], <4 x i32> [[X1]], i8 [[X2]])
; CHECK-NEXT:    store <4 x i32> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x i32> [[RES]]
;
  %res = call <4 x i32> @llvm.x86.avx512fp16.mask.vcvttph2udq.128(<8 x half> %x0, <4 x i32> %x1, i8 %x2)
  ret <4 x i32> %res
}

define <4 x i32> @test_int_x86_avx512_maskz_cvtt_ph2udq_128(<8 x half> %x0, i8 %x2) #0 {
; CHECK-LABEL: define <4 x i32> @test_int_x86_avx512_maskz_cvtt_ph2udq_128(
; CHECK-SAME: <8 x half> [[X0:%.*]], i8 [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP3]], 0
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i8 [[TMP2]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    br i1 [[_MSOR]], label %[[BB4:.*]], label %[[BB5:.*]], !prof [[PROF1]]
; CHECK:       [[BB4]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB5]]:
; CHECK-NEXT:    [[RES:%.*]] = call <4 x i32> @llvm.x86.avx512fp16.mask.vcvttph2udq.128(<8 x half> [[X0]], <4 x i32> zeroinitializer, i8 [[X2]])
; CHECK-NEXT:    store <4 x i32> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x i32> [[RES]]
;
  %res = call <4 x i32> @llvm.x86.avx512fp16.mask.vcvttph2udq.128(<8 x half> %x0, <4 x i32> zeroinitializer, i8 %x2)
  ret <4 x i32> %res
}

declare <8 x i32> @llvm.x86.avx512fp16.mask.vcvttph2udq.256(<8 x half>, <8 x i32>, i8)

define <8 x i32> @test_int_x86_avx512_cvtt_ph2udq_256(<8 x half> %x0) #0 {
; CHECK-LABEL: define <8 x i32> @test_int_x86_avx512_cvtt_ph2udq_256(
; CHECK-SAME: <8 x half> [[X0:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    [[RES:%.*]] = call <8 x i32> @llvm.x86.avx512fp16.mask.vcvttph2udq.256(<8 x half> [[X0]], <8 x i32> poison, i8 -1)
; CHECK-NEXT:    store <8 x i32> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x i32> [[RES]]
;
  %res = call <8 x i32> @llvm.x86.avx512fp16.mask.vcvttph2udq.256(<8 x half> %x0, <8 x i32> poison, i8 -1)
  ret <8 x i32> %res
}

define <8 x i32> @test_int_x86_avx512_mask_cvtt_ph2udq_256(<8 x half> %x0, <8 x i32> %x1, i8 %x2) #0 {
; CHECK-LABEL: define <8 x i32> @test_int_x86_avx512_mask_cvtt_ph2udq_256(
; CHECK-SAME: <8 x half> [[X0:%.*]], <8 x i32> [[X1:%.*]], i8 [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i32>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 48) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP4]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i32> [[TMP2]] to i256
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i256 [[TMP5]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i8 [[TMP3]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR3]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x i32> @llvm.x86.avx512fp16.mask.vcvttph2udq.256(<8 x half> [[X0]], <8 x i32> [[X1]], i8 [[X2]])
; CHECK-NEXT:    store <8 x i32> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x i32> [[RES]]
;
  %res = call <8 x i32> @llvm.x86.avx512fp16.mask.vcvttph2udq.256(<8 x half> %x0, <8 x i32> %x1, i8 %x2)
  ret <8 x i32> %res
}

define <8 x i32> @test_int_x86_avx512_maskz_cvtt_ph2udq_256(<8 x half> %x0, i8 %x2) #0 {
; CHECK-LABEL: define <8 x i32> @test_int_x86_avx512_maskz_cvtt_ph2udq_256(
; CHECK-SAME: <8 x half> [[X0:%.*]], i8 [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP3]], 0
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i8 [[TMP2]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    br i1 [[_MSOR]], label %[[BB4:.*]], label %[[BB5:.*]], !prof [[PROF1]]
; CHECK:       [[BB4]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB5]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x i32> @llvm.x86.avx512fp16.mask.vcvttph2udq.256(<8 x half> [[X0]], <8 x i32> zeroinitializer, i8 [[X2]])
; CHECK-NEXT:    store <8 x i32> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x i32> [[RES]]
;
  %res = call <8 x i32> @llvm.x86.avx512fp16.mask.vcvttph2udq.256(<8 x half> %x0, <8 x i32> zeroinitializer, i8 %x2)
  ret <8 x i32> %res
}

declare <4 x float> @llvm.x86.avx512fp16.mask.vcvtph2psx.128(<8 x half>, <4 x float>, i8)

define <4 x float> @test_int_x86_avx512_cvt_ph2psx_128(<8 x half> %x0) #0 {
; CHECK-LABEL: define <4 x float> @test_int_x86_avx512_cvt_ph2psx_128(
; CHECK-SAME: <8 x half> [[X0:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    [[RES:%.*]] = call <4 x float> @llvm.x86.avx512fp16.mask.vcvtph2psx.128(<8 x half> [[X0]], <4 x float> poison, i8 -1)
; CHECK-NEXT:    store <4 x i32> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x float> [[RES]]
;
  %res = call <4 x float> @llvm.x86.avx512fp16.mask.vcvtph2psx.128(<8 x half> %x0, <4 x float> poison, i8 -1)
  ret <4 x float> %res
}

define <4 x float> @test_int_x86_avx512_mask_cvt_ph2psx_128(<8 x half> %x0, <4 x float> %x1, i8 %x2) #0 {
; CHECK-LABEL: define <4 x float> @test_int_x86_avx512_mask_cvt_ph2psx_128(
; CHECK-SAME: <8 x half> [[X0:%.*]], <4 x float> [[X1:%.*]], i8 [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <4 x i32>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP4]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <4 x i32> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP5]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i8 [[TMP3]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR3]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES:%.*]] = call <4 x float> @llvm.x86.avx512fp16.mask.vcvtph2psx.128(<8 x half> [[X0]], <4 x float> [[X1]], i8 [[X2]])
; CHECK-NEXT:    store <4 x i32> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x float> [[RES]]
;
  %res = call <4 x float> @llvm.x86.avx512fp16.mask.vcvtph2psx.128(<8 x half> %x0, <4 x float> %x1, i8 %x2)
  ret <4 x float> %res
}

define <4 x float> @test_int_x86_avx512_maskz_cvt_ph2psx_128(<8 x half> %x0, i8 %x2) #0 {
; CHECK-LABEL: define <4 x float> @test_int_x86_avx512_maskz_cvt_ph2psx_128(
; CHECK-SAME: <8 x half> [[X0:%.*]], i8 [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP3]], 0
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i8 [[TMP2]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    br i1 [[_MSOR]], label %[[BB4:.*]], label %[[BB5:.*]], !prof [[PROF1]]
; CHECK:       [[BB4]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB5]]:
; CHECK-NEXT:    [[RES:%.*]] = call <4 x float> @llvm.x86.avx512fp16.mask.vcvtph2psx.128(<8 x half> [[X0]], <4 x float> zeroinitializer, i8 [[X2]])
; CHECK-NEXT:    store <4 x i32> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x float> [[RES]]
;
  %res = call <4 x float> @llvm.x86.avx512fp16.mask.vcvtph2psx.128(<8 x half> %x0, <4 x float> zeroinitializer, i8 %x2)
  ret <4 x float> %res
}

declare <8 x float> @llvm.x86.avx512fp16.mask.vcvtph2psx.256(<8 x half>, <8 x float>, i8)

define <8 x float> @test_int_x86_avx512_cvt_ph2psx_256(<8 x half> %x0) #0 {
; CHECK-LABEL: define <8 x float> @test_int_x86_avx512_cvt_ph2psx_256(
; CHECK-SAME: <8 x half> [[X0:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    [[RES:%.*]] = call <8 x float> @llvm.x86.avx512fp16.mask.vcvtph2psx.256(<8 x half> [[X0]], <8 x float> poison, i8 -1)
; CHECK-NEXT:    store <8 x i32> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x float> [[RES]]
;
  %res = call <8 x float> @llvm.x86.avx512fp16.mask.vcvtph2psx.256(<8 x half> %x0, <8 x float> poison, i8 -1)
  ret <8 x float> %res
}

define <8 x float> @test_int_x86_avx512_mask_cvt_ph2psx_256(<8 x half> %x0, <8 x float> %x1, i8 %x2) #0 {
; CHECK-LABEL: define <8 x float> @test_int_x86_avx512_mask_cvt_ph2psx_256(
; CHECK-SAME: <8 x half> [[X0:%.*]], <8 x float> [[X1:%.*]], i8 [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i32>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 48) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP4]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i32> [[TMP2]] to i256
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i256 [[TMP5]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i8 [[TMP3]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR3]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x float> @llvm.x86.avx512fp16.mask.vcvtph2psx.256(<8 x half> [[X0]], <8 x float> [[X1]], i8 [[X2]])
; CHECK-NEXT:    store <8 x i32> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x float> [[RES]]
;
  %res = call <8 x float> @llvm.x86.avx512fp16.mask.vcvtph2psx.256(<8 x half> %x0, <8 x float> %x1, i8 %x2)
  ret <8 x float> %res
}

define <8 x float> @test_int_x86_avx512_maskz_cvt_ph2psx_256(<8 x half> %x0, i8 %x2) #0 {
; CHECK-LABEL: define <8 x float> @test_int_x86_avx512_maskz_cvt_ph2psx_256(
; CHECK-SAME: <8 x half> [[X0:%.*]], i8 [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP3]], 0
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i8 [[TMP2]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    br i1 [[_MSOR]], label %[[BB4:.*]], label %[[BB5:.*]], !prof [[PROF1]]
; CHECK:       [[BB4]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB5]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x float> @llvm.x86.avx512fp16.mask.vcvtph2psx.256(<8 x half> [[X0]], <8 x float> zeroinitializer, i8 [[X2]])
; CHECK-NEXT:    store <8 x i32> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x float> [[RES]]
;
  %res = call <8 x float> @llvm.x86.avx512fp16.mask.vcvtph2psx.256(<8 x half> %x0, <8 x float> zeroinitializer, i8 %x2)
  ret <8 x float> %res
}

declare <8 x half> @llvm.x86.avx512fp16.mask.vcvtps2phx.128(<4 x float>, <8 x half>, i8)

define <8 x half> @test_int_x86_avx512_mask_cvt_ps2phx_128(<4 x float> %x0, <8 x half> %x1, i8 %x2) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512_mask_cvt_ps2phx_128(
; CHECK-SAME: <4 x float> [[X0:%.*]], <8 x half> [[X1:%.*]], i8 [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <4 x i32> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP4]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP5]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i8 [[TMP3]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR3]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.vcvtps2phx.128(<4 x float> [[X0]], <8 x half> [[X1]], i8 [[X2]])
; CHECK-NEXT:    [[TMP8:%.*]] = bitcast <4 x i32> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP4:%.*]] = icmp ne i128 [[TMP8]], 0
; CHECK-NEXT:    [[TMP9:%.*]] = bitcast <8 x i16> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP5:%.*]] = icmp ne i128 [[TMP9]], 0
; CHECK-NEXT:    [[_MSOR6:%.*]] = or i1 [[_MSCMP4]], [[_MSCMP5]]
; CHECK-NEXT:    br i1 [[_MSOR6]], label %[[BB10:.*]], label %[[BB11:.*]], !prof [[PROF1]]
; CHECK:       [[BB10]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB11]]:
; CHECK-NEXT:    [[RES1:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.vcvtps2phx.128(<4 x float> [[X0]], <8 x half> [[X1]], i8 -1)
; CHECK-NEXT:    [[RES2:%.*]] = fadd <8 x half> [[RES]], [[RES1]]
; CHECK-NEXT:    store <8 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES2]]
;
  %res = call <8 x half> @llvm.x86.avx512fp16.mask.vcvtps2phx.128(<4 x float> %x0, <8 x half> %x1, i8 %x2)
  %res1 = call <8 x half> @llvm.x86.avx512fp16.mask.vcvtps2phx.128(<4 x float> %x0, <8 x half> %x1, i8 -1)
  %res2 = fadd <8 x half> %res, %res1
  ret <8 x half> %res2
}

declare <8 x half> @llvm.x86.avx512fp16.mask.vcvtps2phx.256(<8 x float>, <8 x half>, i8)

define <8 x half> @test_int_x86_avx512_cvt_ps2phx_256(<8 x float> %x0) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512_cvt_ps2phx_256(
; CHECK-SAME: <8 x float> [[X0:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    [[RES:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.vcvtps2phx.256(<8 x float> [[X0]], <8 x half> poison, i8 -1)
; CHECK-NEXT:    store <8 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %res = call <8 x half> @llvm.x86.avx512fp16.mask.vcvtps2phx.256(<8 x float> %x0, <8 x half> poison, i8 -1)
  ret <8 x half> %res
}

define <8 x half> @test_int_x86_avx512_mask_cvt_ps2phx_256(<8 x float> %x0, <8 x half> %x1, i8 %x2) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512_mask_cvt_ps2phx_256(
; CHECK-SAME: <8 x float> [[X0:%.*]], <8 x half> [[X1:%.*]], i8 [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 48) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x i32> [[TMP1]] to i256
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i256 [[TMP4]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP5]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i8 [[TMP3]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR3]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.vcvtps2phx.256(<8 x float> [[X0]], <8 x half> [[X1]], i8 [[X2]])
; CHECK-NEXT:    store <8 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %res = call <8 x half> @llvm.x86.avx512fp16.mask.vcvtps2phx.256(<8 x float> %x0, <8 x half> %x1, i8 %x2)
  ret <8 x half> %res
}

define <8 x half> @test_int_x86_avx512_maskz_cvt_ps2phx_256(<8 x float> %x0, i8 %x2) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512_maskz_cvt_ps2phx_256(
; CHECK-SAME: <8 x float> [[X0:%.*]], i8 [[X2:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast <8 x i32> [[TMP1]] to i256
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i256 [[TMP3]], 0
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i8 [[TMP2]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    br i1 [[_MSOR]], label %[[BB4:.*]], label %[[BB5:.*]], !prof [[PROF1]]
; CHECK:       [[BB4]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR4]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB5]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.vcvtps2phx.256(<8 x float> [[X0]], <8 x half> zeroinitializer, i8 [[X2]])
; CHECK-NEXT:    store <8 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %res = call <8 x half> @llvm.x86.avx512fp16.mask.vcvtps2phx.256(<8 x float> %x0, <8 x half> zeroinitializer, i8 %x2)
  ret <8 x half> %res
}

attributes #0 = { sanitize_memory }
