/* PR c/102989 */
/* { dg-require-effective-target bitint } */
/* { dg-options "-O2 -std=c23 -pedantic-errors" } */

#if __BITINT_MAXWIDTH__ >= 192
__attribute__((noipa)) _BitInt(192)
tests192 (_Decimal64 d)
{
  return d;
}

__attribute__((noipa)) unsigned _BitInt(192)
testu192 (_Decimal64 d)
{
  return d;
}
#endif

#if __BITINT_MAXWIDTH__ >= 575
__attribute__((noipa)) _BitInt(575)
tests575 (_Decimal64 d)
{
  return d;
}

__attribute__((noipa)) unsigned _BitInt(575)
testu575 (_Decimal64 d)
{
  return d;
}
#endif

int
main ()
{
#if __BITINT_MAXWIDTH__ >= 192
  if (tests192 (0.DD) != 0wb
      || tests192 (0.9999999999999999DD) != 0wb
      || tests192 (7.999999999999999DD) != 7wb
      || tests192 (-0.DD) != 0wb
      || tests192 (-0.9999999999999999DD) != 0wb
      || tests192 (-42.5DD) != -42wb
      || tests192 (-34242319854.45429e+27DD) != -34242319854454290000000000000000000000wb
      || tests192 (-213855087769445.9e+43DD) != -2138550877694459000000000000000000000000000000000000000000wb
      || tests192 (313855086769334.0e+43DD) != 3138550867693340000000000000000000000000000000000000000000wb
      || tests192 (-313855086769334.0e+43DD) != -3138550867693340000000000000000000000000000000000000000000wb)
    __builtin_abort ();
  if (tests192 (313855086769334.1e+43DD) != 3138550867693340381917894711603833208051177722232017256447wb
      || tests192 (9999999999999999e+369DD) != 3138550867693340381917894711603833208051177722232017256447wb
      || tests192 (-313855086769334.1e+43DD) != -3138550867693340381917894711603833208051177722232017256447wb - 1wb
      || tests192 (-9999999999999999e+369DD) != -3138550867693340381917894711603833208051177722232017256447wb - 1wb)
    __builtin_abort ();
  if (testu192 (0.DD) != 0uwb
      || testu192 (0.9999999999999999DD) != 0uwb
      || testu192 (-0.9999999999999999DD) != 0uwb
      || testu192 (-0.0DD) != 0uwb
      || testu192 (-0.5DD) != 0uwb
      || testu192 (42.99999999999999DD) != 42uwb
      || testu192 (42.e+21DD) != 42000000000000000000000uwb
      || testu192 (34272319854.45429e+27DD) != 34272319854454290000000000000000000000uwb
      || testu192 (627710173538668.0e+43DD) != 6277101735386680000000000000000000000000000000000000000000uwb)
    __builtin_abort ();
  if (testu192 (-1.DD) != 0uwb
      || testu192 (-42.5e+15DD) != 0uwb
      || testu192 (-9999999999999999e+369DD) != 0uwb
      || testu192 (627710173538668.1e+43DD) != 6277101735386680763835789423207666416102355444464034512895uwb
      || testu192 (9999999999999999e+369DD) != 6277101735386680763835789423207666416102355444464034512895uwb)
    __builtin_abort ();
#endif
#if __BITINT_MAXWIDTH__ >= 575
  if (tests575 (0.DD) != 0wb
      || tests575 (0.999999DD) != 0wb
      || tests575 (12.9999999999999DD) != 12wb
      || tests575 (-0.DD) != 0wb
      || tests575 (-0.9999999999999999DD) != 0wb
      || tests575 (-1.DD) != -1wb
      || tests575 (-89.5DD) != -89wb
      || tests575 (-34242319854.45429e+37DD) != -342423198544542900000000000000000000000000000000wb
      || tests575 (-518326003682761.2e+158DD) != -51832600368276120000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000wb
      || tests575 (6183260036827613.0e+157DD) != 61832600368276130000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000wb
      || tests575 (-6183260036827613.0e+157DD) != -61832600368276130000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000wb)
    __builtin_abort ();
  if (tests575 (6183260036827614.0e+157DD) != 61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb
      || tests575 (9999999999999999e+369DD) != 61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb
      || tests575 (-6183260036827614.0e+157DD) != -61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb - 1wb
      || tests575 (-9999999999999999e+369DD) != -61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb - 1wb)
    __builtin_abort ();
  if (testu575 (0.DD) != 0uwb
      || testu575 (0.5555555555555555DD) != 0uwb
      || testu575 (-0.7777777777777777DD) != 0uwb
      || testu575 (-0.99DD) != 0uwb
      || testu575 (-0.000DD) != 0uwb
      || testu575 (-0.99999999DD) != 0uwb
      || testu575 (42.99999999999999DD) != 42uwb
      || testu575 (42.e+21DD) != 42000000000000000000000uwb
      || testu575 (94272319854.45429e+27DD) != 94272319854454290000000000000000000000uwb
      || testu575 (1236652007365522.0e+158DD) != 123665200736552200000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000uwb)
    __builtin_abort ();
  if (testu575 (-1.DD) != 0uwb
      || testu575 (-42.5e+15DD) != 0uwb
      || testu575 (-9999999999999999e+369DD) != 0uwb
      || testu575 (1236652007365523.0e+158DD) != 123665200736552267030251260509823595017565674550605919957031528046448612553265933585158200530621522494798835713008069669675682517153375604983773077550946583958303386074349567uwb
      || testu575 (9999999999999999e+369DD) != 123665200736552267030251260509823595017565674550605919957031528046448612553265933585158200530621522494798835713008069669675682517153375604983773077550946583958303386074349567uwb)
    __builtin_abort ();
#endif
}
