; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple riscv32 | FileCheck %s -check-prefixes=CHECK-32
; RUN: llc < %s -mtriple riscv64 | FileCheck %s -check-prefixes=CHECK-64

declare dso_local void @main()

define dso_local void @naked() naked "frame-pointer"="all" {
; CHECK-32-LABEL: naked:
; CHECK-32:       # %bb.0:
; CHECK-32-NEXT:    call main
;
; CHECK-64-LABEL: naked:
; CHECK-64:       # %bb.0:
; CHECK-64-NEXT:    call main
  call void @main()
  unreachable
}

define dso_local void @normal() "frame-pointer"="all" {
; CHECK-32-LABEL: normal:
; CHECK-32:       # %bb.0:
; CHECK-32-NEXT:    addi sp, sp, -16
; CHECK-32-NEXT:    .cfi_def_cfa_offset 16
; CHECK-32-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK-32-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; CHECK-32-NEXT:    .cfi_offset ra, -4
; CHECK-32-NEXT:    .cfi_offset s0, -8
; CHECK-32-NEXT:    addi s0, sp, 16
; CHECK-32-NEXT:    .cfi_def_cfa s0, 0
; CHECK-32-NEXT:    call main
;
; CHECK-64-LABEL: normal:
; CHECK-64:       # %bb.0:
; CHECK-64-NEXT:    addi sp, sp, -16
; CHECK-64-NEXT:    .cfi_def_cfa_offset 16
; CHECK-64-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-64-NEXT:    sd s0, 0(sp) # 8-byte Folded Spill
; CHECK-64-NEXT:    .cfi_offset ra, -8
; CHECK-64-NEXT:    .cfi_offset s0, -16
; CHECK-64-NEXT:    addi s0, sp, 16
; CHECK-64-NEXT:    .cfi_def_cfa s0, 0
; CHECK-64-NEXT:    call main
  call void @main()
  unreachable
}
