; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; Test widening vector multiply-and-add.
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z13 | FileCheck %s

; Test a v16i8 (even) -> v8i16 unsigned widening multiply-and-add.
define <8 x i16> @f1(<16 x i8> %val1, <16 x i8> %val2, <8 x i16> %val3) {
; CHECK-LABEL: f1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmaleb %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %shuf1 = shufflevector <16 x i8> %val1, <16 x i8> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %zext1 = zext <8 x i8> %shuf1 to <8 x i16>
  %shuf2 = shufflevector <16 x i8> %val2, <16 x i8> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %zext2 = zext <8 x i8> %shuf2 to <8 x i16>
  %mul = mul <8 x i16> %zext1, %zext2
  %ret = add <8 x i16> %mul, %val3
  ret <8 x i16> %ret
}

; Test a v16i8 (odd) -> v8i16 unsigned widening multiply-and-add.
define <8 x i16> @f2(<16 x i8> %val1, <16 x i8> %val2, <8 x i16> %val3) {
; CHECK-LABEL: f2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmalob %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %shuf1 = shufflevector <16 x i8> %val1, <16 x i8> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %zext1 = zext <8 x i8> %shuf1 to <8 x i16>
  %shuf2 = shufflevector <16 x i8> %val2, <16 x i8> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %zext2 = zext <8 x i8> %shuf2 to <8 x i16>
  %mul = mul <8 x i16> %zext1, %zext2
  %ret = add <8 x i16> %mul, %val3
  ret <8 x i16> %ret
}

; Test a v16i8 (even) -> v8i16 signed widening multiply-and-add.
define <8 x i16> @f3(<16 x i8> %val1, <16 x i8> %val2, <8 x i16> %val3) {
; CHECK-LABEL: f3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmaeb %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %shuf1 = shufflevector <16 x i8> %val1, <16 x i8> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %sext1 = sext <8 x i8> %shuf1 to <8 x i16>
  %shuf2 = shufflevector <16 x i8> %val2, <16 x i8> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %sext2 = sext <8 x i8> %shuf2 to <8 x i16>
  %mul = mul <8 x i16> %sext1, %sext2
  %ret = add <8 x i16> %mul, %val3
  ret <8 x i16> %ret
}

; Test a v16i8 (odd) -> v8i16 signed widening multiply-and-add.
define <8 x i16> @f4(<16 x i8> %val1, <16 x i8> %val2, <8 x i16> %val3) {
; CHECK-LABEL: f4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmaob %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %shuf1 = shufflevector <16 x i8> %val1, <16 x i8> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %sext1 = sext <8 x i8> %shuf1 to <8 x i16>
  %shuf2 = shufflevector <16 x i8> %val2, <16 x i8> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %sext2 = sext <8 x i8> %shuf2 to <8 x i16>
  %mul = mul <8 x i16> %sext1, %sext2
  %ret = add <8 x i16> %mul, %val3
  ret <8 x i16> %ret
}

; Test a v8i16 (even) -> v4i32 unsigned widening multiply-and-add.
define <4 x i32> @f5(<8 x i16> %val1, <8 x i16> %val2, <4 x i32> %val3) {
; CHECK-LABEL: f5:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmaleh %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %shuf1 = shufflevector <8 x i16> %val1, <8 x i16> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %zext1 = zext <4 x i16> %shuf1 to <4 x i32>
  %shuf2 = shufflevector <8 x i16> %val2, <8 x i16> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %zext2 = zext <4 x i16> %shuf2 to <4 x i32>
  %mul = mul <4 x i32> %zext1, %zext2
  %ret = add <4 x i32> %mul, %val3
  ret <4 x i32> %ret
}

; Test a v8i16 (odd) -> v4i32 unsigned widening multiply-and-add.
define <4 x i32> @f6(<8 x i16> %val1, <8 x i16> %val2, <4 x i32> %val3) {
; CHECK-LABEL: f6:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmaloh %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %shuf1 = shufflevector <8 x i16> %val1, <8 x i16> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %zext1 = zext <4 x i16> %shuf1 to <4 x i32>
  %shuf2 = shufflevector <8 x i16> %val2, <8 x i16> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %zext2 = zext <4 x i16> %shuf2 to <4 x i32>
  %mul = mul <4 x i32> %zext1, %zext2
  %ret = add <4 x i32> %mul, %val3
  ret <4 x i32> %ret
}

; Test a v8i16 (even) -> v4i32 signed widening multiply-and-add.
define <4 x i32> @f7(<8 x i16> %val1, <8 x i16> %val2, <4 x i32> %val3) {
; CHECK-LABEL: f7:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmaeh %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %shuf1 = shufflevector <8 x i16> %val1, <8 x i16> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %sext1 = sext <4 x i16> %shuf1 to <4 x i32>
  %shuf2 = shufflevector <8 x i16> %val2, <8 x i16> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %sext2 = sext <4 x i16> %shuf2 to <4 x i32>
  %mul = mul <4 x i32> %sext1, %sext2
  %ret = add <4 x i32> %mul, %val3
  ret <4 x i32> %ret
}

; Test a v8i16 (odd) -> v4i32 signed widening multiply-and-add.
define <4 x i32> @f8(<8 x i16> %val1, <8 x i16> %val2, <4 x i32> %val3) {
; CHECK-LABEL: f8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmaoh %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %shuf1 = shufflevector <8 x i16> %val1, <8 x i16> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %sext1 = sext <4 x i16> %shuf1 to <4 x i32>
  %shuf2 = shufflevector <8 x i16> %val2, <8 x i16> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %sext2 = sext <4 x i16> %shuf2 to <4 x i32>
  %mul = mul <4 x i32> %sext1, %sext2
  %ret = add <4 x i32> %mul, %val3
  ret <4 x i32> %ret
}

; Test a v4i32 (even) -> v2i64 unsigned widening multiply-and-add.
define <2 x i64> @f9(<4 x i32> %val1, <4 x i32> %val2, <2 x i64> %val3) {
; CHECK-LABEL: f9:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmalef %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %shuf1 = shufflevector <4 x i32> %val1, <4 x i32> poison, <2 x i32> <i32 0, i32 2>
  %zext1 = zext <2 x i32> %shuf1 to <2 x i64>
  %shuf2 = shufflevector <4 x i32> %val2, <4 x i32> poison, <2 x i32> <i32 0, i32 2>
  %zext2 = zext <2 x i32> %shuf2 to <2 x i64>
  %mul = mul <2 x i64> %zext1, %zext2
  %ret = add <2 x i64> %mul, %val3
  ret <2 x i64> %ret
}

; Test a v4i32 (odd) -> v2i64 unsigned widening multiply-and-add.
define <2 x i64> @f10(<4 x i32> %val1, <4 x i32> %val2, <2 x i64> %val3) {
; CHECK-LABEL: f10:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmalof %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %shuf1 = shufflevector <4 x i32> %val1, <4 x i32> poison, <2 x i32> <i32 1, i32 3>
  %zext1 = zext <2 x i32> %shuf1 to <2 x i64>
  %shuf2 = shufflevector <4 x i32> %val2, <4 x i32> poison, <2 x i32> <i32 1, i32 3>
  %zext2 = zext <2 x i32> %shuf2 to <2 x i64>
  %mul = mul <2 x i64> %zext1, %zext2
  %ret = add <2 x i64> %mul, %val3
  ret <2 x i64> %ret
}

; Test a v4i32 (even) -> v2i64 signed widening multiply-and-add.
define <2 x i64> @f11(<4 x i32> %val1, <4 x i32> %val2, <2 x i64> %val3) {
; CHECK-LABEL: f11:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmaef %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %shuf1 = shufflevector <4 x i32> %val1, <4 x i32> poison, <2 x i32> <i32 0, i32 2>
  %sext1 = sext <2 x i32> %shuf1 to <2 x i64>
  %shuf2 = shufflevector <4 x i32> %val2, <4 x i32> poison, <2 x i32> <i32 0, i32 2>
  %sext2 = sext <2 x i32> %shuf2 to <2 x i64>
  %mul = mul <2 x i64> %sext1, %sext2
  %ret = add <2 x i64> %mul, %val3
  ret <2 x i64> %ret
}

; Test a v4i32 (odd) -> v2i64 signed widening multiply-and-add.
define <2 x i64> @f12(<4 x i32> %val1, <4 x i32> %val2, <2 x i64> %val3) {
; CHECK-LABEL: f12:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmaof %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %shuf1 = shufflevector <4 x i32> %val1, <4 x i32> poison, <2 x i32> <i32 1, i32 3>
  %sext1 = sext <2 x i32> %shuf1 to <2 x i64>
  %shuf2 = shufflevector <4 x i32> %val2, <4 x i32> poison, <2 x i32> <i32 1, i32 3>
  %sext2 = sext <2 x i32> %shuf2 to <2 x i64>
  %mul = mul <2 x i64> %sext1, %sext2
  %ret = add <2 x i64> %mul, %val3
  ret <2 x i64> %ret
}
