; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 < %s | FileCheck -check-prefixes=GFX9,GFX900 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx90a < %s | FileCheck -check-prefixes=GFX9,GFX90APLUS,GFX90A %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx942 < %s | FileCheck -check-prefixes=GFX9,GFX90APLUS,GFX942 %s


define void @v_shuffle_v4i32_v3i32__u_u_u_u(ptr addrspace(1) inreg %ptr) {
; GFX9-LABEL: v_shuffle_v4i32_v3i32__u_u_u_u:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> poison
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__0_u_u_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__0_u_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v3, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__0_u_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v3, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v3, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__0_u_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v3, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v3, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 0, i32 poison, i32 poison, i32 poison>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__1_u_u_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__1_u_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v1
; GFX900-NEXT:    global_store_dwordx4 v3, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__1_u_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v3, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    global_store_dwordx4 v3, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__1_u_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v3, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v1
; GFX942-NEXT:    global_store_dwordx4 v3, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 1, i32 poison, i32 poison, i32 poison>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__2_u_u_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__2_u_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    global_store_dwordx4 v3, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__2_u_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v3, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    global_store_dwordx4 v3, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__2_u_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v3, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    global_store_dwordx4 v3, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 2, i32 poison, i32 poison, i32 poison>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__3_u_u_u(ptr addrspace(1) inreg %ptr) {
; GFX9-LABEL: v_shuffle_v4i32_v3i32__3_u_u_u:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 3, i32 poison, i32 poison, i32 poison>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__4_u_u_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__4_u_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v1
; GFX900-NEXT:    global_store_dwordx4 v3, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__4_u_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v3, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    global_store_dwordx4 v3, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__4_u_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v3, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v1
; GFX942-NEXT:    global_store_dwordx4 v3, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 4, i32 poison, i32 poison, i32 poison>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_u_u_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_u_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    global_store_dwordx4 v3, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_u_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v3, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    global_store_dwordx4 v3, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_u_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v3, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    global_store_dwordx4 v3, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 poison, i32 poison, i32 poison>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_0_u_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_0_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v5, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v4
; GFX900-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_0_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_0_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    v_mov_b32_e32 v0, v6
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 0, i32 poison, i32 poison>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_1_u_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_1_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v5, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v4
; GFX900-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_1_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v4
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_1_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v4
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 1, i32 poison, i32 poison>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_2_u_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_2_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v5
; GFX900-NEXT:    v_mov_b32_e32 v1, v2
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_2_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v3, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    global_store_dwordx4 v3, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_2_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v3, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    v_mov_b32_e32 v0, v6
; GFX942-NEXT:    global_store_dwordx4 v3, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 2, i32 poison, i32 poison>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_3_u_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_3_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_3_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v4
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_3_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v4
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 3, i32 poison, i32 poison>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_4_u_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_4_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    global_store_dwordx4 v3, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_4_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v3, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    global_store_dwordx4 v3, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_4_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v3, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    global_store_dwordx4 v3, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 4, i32 poison, i32 poison>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_u_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    v_mov_b32_e32 v1, v2
; GFX900-NEXT:    global_store_dwordx4 v3, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v3, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    global_store_dwordx4 v3, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v3, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    global_store_dwordx4 v3, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 poison, i32 poison>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_0_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_0_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v5
; GFX900-NEXT:    v_mov_b32_e32 v1, v5
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_0_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v6
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_0_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v6
; GFX942-NEXT:    v_mov_b32_e32 v1, v6
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 0, i32 poison>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_1_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_1_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v5
; GFX900-NEXT:    v_mov_b32_e32 v1, v5
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_1_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    v_mov_b32_e32 v2, v3
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_1_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    v_mov_b32_e32 v2, v3
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 1, i32 poison>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_2_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_2_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v5
; GFX900-NEXT:    v_mov_b32_e32 v1, v5
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_2_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v3, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v6
; GFX90A-NEXT:    global_store_dwordx4 v3, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_2_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v3, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v6
; GFX942-NEXT:    v_mov_b32_e32 v1, v6
; GFX942-NEXT:    global_store_dwordx4 v3, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 2, i32 poison>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_3_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_3_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v5, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v4
; GFX900-NEXT:    v_mov_b32_e32 v1, v4
; GFX900-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_3_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v4
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_3_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v4
; GFX942-NEXT:    v_mov_b32_e32 v1, v4
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 3, i32 poison>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_4_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_4_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    v_mov_b32_e32 v1, v3
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_4_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v4
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    v_mov_b32_e32 v2, v3
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_4_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v4
; GFX942-NEXT:    v_mov_b32_e32 v1, v4
; GFX942-NEXT:    v_mov_b32_e32 v2, v3
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 4, i32 poison>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_5_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_5_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    v_mov_b32_e32 v1, v2
; GFX900-NEXT:    global_store_dwordx4 v3, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_5_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v3, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    global_store_dwordx4 v3, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_5_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v3, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    global_store_dwordx4 v3, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 5, i32 poison>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_5_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_5_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    v_mov_b32_e32 v1, v2
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_5_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_5_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    v_mov_b32_e32 v3, v4
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 5, i32 0>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_5_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_5_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v5, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    v_mov_b32_e32 v1, v2
; GFX900-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_5_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_5_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 5, i32 1>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_5_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_5_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    v_mov_b32_e32 v1, v2
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_5_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_5_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v3, v4
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 5, i32 2>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_5_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_5_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v5
; GFX900-NEXT:    v_mov_b32_e32 v1, v5
; GFX900-NEXT:    v_mov_b32_e32 v2, v5
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_5_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v6
; GFX90A-NEXT:    v_mov_b32_e32 v2, v6
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_5_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v6
; GFX942-NEXT:    v_mov_b32_e32 v1, v6
; GFX942-NEXT:    v_mov_b32_e32 v2, v6
; GFX942-NEXT:    v_mov_b32_e32 v3, v4
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 5, i32 3>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_5_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_5_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v5, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v4
; GFX900-NEXT:    v_mov_b32_e32 v1, v4
; GFX900-NEXT:    v_mov_b32_e32 v2, v4
; GFX900-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_5_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v4
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    v_mov_b32_e32 v2, v4
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_5_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v4
; GFX942-NEXT:    v_mov_b32_e32 v1, v4
; GFX942-NEXT:    v_mov_b32_e32 v2, v4
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 5, i32 4>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_5_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    v_mov_b32_e32 v1, v2
; GFX900-NEXT:    v_mov_b32_e32 v3, v2
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    v_mov_b32_e32 v3, v2
; GFX942-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 5, i32 5>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__u_0_0_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__u_0_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    v_mov_b32_e32 v3, v1
; GFX900-NEXT:    global_store_dwordx4 v0, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__u_0_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v0
; GFX90A-NEXT:    v_mov_b32_e32 v3, v0
; GFX90A-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__u_0_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v0
; GFX942-NEXT:    v_mov_b32_e32 v2, v0
; GFX942-NEXT:    v_mov_b32_e32 v3, v0
; GFX942-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 poison, i32 0, i32 0, i32 0>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__0_0_0_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__0_0_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v0
; GFX900-NEXT:    v_mov_b32_e32 v2, v0
; GFX900-NEXT:    v_mov_b32_e32 v3, v0
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__0_0_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v0
; GFX90A-NEXT:    v_mov_b32_e32 v3, v0
; GFX90A-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__0_0_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v0
; GFX942-NEXT:    v_mov_b32_e32 v2, v0
; GFX942-NEXT:    v_mov_b32_e32 v3, v0
; GFX942-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> zeroinitializer
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__1_0_0_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__1_0_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    v_mov_b32_e32 v3, v1
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__1_0_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[4:5], v[4:5] op_sel:[1,0]
; GFX90A-NEXT:    v_mov_b32_e32 v2, v4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__1_0_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[4:5], v[4:5] op_sel:[1,0]
; GFX942-NEXT:    v_mov_b32_e32 v2, v4
; GFX942-NEXT:    v_mov_b32_e32 v3, v4
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 1, i32 0, i32 0, i32 0>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__2_0_0_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__2_0_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    v_mov_b32_e32 v3, v1
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__2_0_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    v_mov_b32_e32 v2, v4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__2_0_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v6
; GFX942-NEXT:    v_mov_b32_e32 v1, v4
; GFX942-NEXT:    v_mov_b32_e32 v2, v4
; GFX942-NEXT:    v_mov_b32_e32 v3, v4
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 2, i32 0, i32 0, i32 0>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__3_0_0_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__3_0_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    v_mov_b32_e32 v3, v1
; GFX900-NEXT:    global_store_dwordx4 v0, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__3_0_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v0
; GFX90A-NEXT:    v_mov_b32_e32 v3, v0
; GFX90A-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__3_0_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v0
; GFX942-NEXT:    v_mov_b32_e32 v2, v0
; GFX942-NEXT:    v_mov_b32_e32 v3, v0
; GFX942-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 3, i32 0, i32 0, i32 0>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__4_0_0_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__4_0_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v5, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    v_mov_b32_e32 v3, v1
; GFX900-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__4_0_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[0:1], v[4:5] op_sel:[1,0]
; GFX90A-NEXT:    v_mov_b32_e32 v2, v4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__4_0_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[0:1], v[4:5] op_sel:[1,0]
; GFX942-NEXT:    v_mov_b32_e32 v2, v4
; GFX942-NEXT:    v_mov_b32_e32 v3, v4
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 4, i32 0, i32 0, i32 0>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_0_0_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_0_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v5, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v4
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    v_mov_b32_e32 v3, v1
; GFX900-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_0_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    v_mov_b32_e32 v2, v4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_0_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    v_mov_b32_e32 v1, v4
; GFX942-NEXT:    v_mov_b32_e32 v2, v4
; GFX942-NEXT:    v_mov_b32_e32 v3, v4
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 0, i32 0, i32 0>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_u_0_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_u_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v5, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v4
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    v_mov_b32_e32 v3, v1
; GFX900-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_u_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    v_mov_b32_e32 v2, v4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_u_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    v_mov_b32_e32 v2, v4
; GFX942-NEXT:    v_mov_b32_e32 v3, v4
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 poison, i32 0, i32 0>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_1_0_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_1_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    v_mov_b32_e32 v1, v4
; GFX900-NEXT:    v_mov_b32_e32 v2, v3
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_1_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    v_mov_b32_e32 v1, v5
; GFX90A-NEXT:    v_mov_b32_e32 v2, v4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_1_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    v_mov_b32_e32 v1, v5
; GFX942-NEXT:    v_mov_b32_e32 v2, v4
; GFX942-NEXT:    v_mov_b32_e32 v3, v4
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 1, i32 0, i32 0>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_2_0_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_2_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    v_mov_b32_e32 v1, v5
; GFX900-NEXT:    v_mov_b32_e32 v2, v3
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_2_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    v_mov_b32_e32 v1, v6
; GFX90A-NEXT:    v_mov_b32_e32 v2, v4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_2_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    v_mov_b32_e32 v1, v6
; GFX942-NEXT:    v_mov_b32_e32 v2, v4
; GFX942-NEXT:    v_mov_b32_e32 v3, v4
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 2, i32 0, i32 0>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_3_0_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_3_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v7, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    v_mov_b32_e32 v2, v4
; GFX900-NEXT:    v_mov_b32_e32 v3, v4
; GFX900-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_3_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v9, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:8]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v8
; GFX90A-NEXT:    v_mov_b32_e32 v1, v6
; GFX90A-NEXT:    v_mov_b32_e32 v2, v4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    global_store_dwordx4 v9, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_3_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v9, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:8]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v2, v4
; GFX942-NEXT:    v_mov_b32_e32 v0, v8
; GFX942-NEXT:    v_mov_b32_e32 v1, v6
; GFX942-NEXT:    v_mov_b32_e32 v3, v4
; GFX942-NEXT:    global_store_dwordx4 v9, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 3, i32 0, i32 0>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_4_0_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_4_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    v_mov_b32_e32 v2, v3
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_4_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    v_mov_b32_e32 v2, v4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_4_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    v_mov_b32_e32 v2, v4
; GFX942-NEXT:    v_mov_b32_e32 v3, v4
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 4, i32 0, i32 0>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_0_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    v_mov_b32_e32 v1, v2
; GFX900-NEXT:    v_mov_b32_e32 v2, v3
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    v_mov_b32_e32 v2, v4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    v_mov_b32_e32 v2, v4
; GFX942-NEXT:    v_mov_b32_e32 v3, v4
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 0, i32 0>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_u_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_u_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v5
; GFX900-NEXT:    v_mov_b32_e32 v1, v5
; GFX900-NEXT:    v_mov_b32_e32 v3, v2
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_u_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v6
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_u_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v3, v2
; GFX942-NEXT:    v_mov_b32_e32 v0, v6
; GFX942-NEXT:    v_mov_b32_e32 v1, v6
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 poison, i32 0>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_1_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_1_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    v_mov_b32_e32 v1, v2
; GFX900-NEXT:    v_mov_b32_e32 v2, v4
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_1_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    v_pk_mov_b32 v[2:3], v[0:1], v[0:1] op_sel:[1,0]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v4
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_1_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_pk_mov_b32 v[2:3], v[0:1], v[0:1] op_sel:[1,0]
; GFX942-NEXT:    v_mov_b32_e32 v0, v4
; GFX942-NEXT:    v_mov_b32_e32 v1, v4
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 1, i32 0>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_2_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_2_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    v_mov_b32_e32 v1, v2
; GFX900-NEXT:    v_mov_b32_e32 v2, v5
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_2_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    v_mov_b32_e32 v2, v6
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_2_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    v_mov_b32_e32 v2, v6
; GFX942-NEXT:    v_mov_b32_e32 v3, v4
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 2, i32 0>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_3_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_3_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v7, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v6
; GFX900-NEXT:    v_mov_b32_e32 v1, v6
; GFX900-NEXT:    v_mov_b32_e32 v2, v4
; GFX900-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_3_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v9, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:8]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v8
; GFX90A-NEXT:    v_mov_b32_e32 v1, v8
; GFX90A-NEXT:    v_mov_b32_e32 v2, v6
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    global_store_dwordx4 v9, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_3_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v9, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:8]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v3, v4
; GFX942-NEXT:    v_mov_b32_e32 v0, v8
; GFX942-NEXT:    v_mov_b32_e32 v1, v8
; GFX942-NEXT:    v_mov_b32_e32 v2, v6
; GFX942-NEXT:    global_store_dwordx4 v9, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 3, i32 0>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_4_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_4_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v7, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    v_mov_b32_e32 v1, v3
; GFX900-NEXT:    v_mov_b32_e32 v3, v4
; GFX900-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_4_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    v_pk_mov_b32 v[2:3], v[2:3], v[0:1] op_sel:[1,0]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v4
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_4_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_pk_mov_b32 v[2:3], v[2:3], v[0:1] op_sel:[1,0]
; GFX942-NEXT:    v_mov_b32_e32 v0, v4
; GFX942-NEXT:    v_mov_b32_e32 v1, v4
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 4, i32 0>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__u_1_1_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__u_1_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    v_mov_b32_e32 v3, v1
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__u_1_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v1
; GFX90A-NEXT:    v_mov_b32_e32 v3, v1
; GFX90A-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__u_1_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v1
; GFX942-NEXT:    v_mov_b32_e32 v3, v1
; GFX942-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 poison, i32 1, i32 1, i32 1>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__0_1_1_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__0_1_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    v_mov_b32_e32 v3, v1
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__0_1_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v1
; GFX90A-NEXT:    v_mov_b32_e32 v3, v1
; GFX90A-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__0_1_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v1
; GFX942-NEXT:    v_mov_b32_e32 v3, v1
; GFX942-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 0, i32 1, i32 1, i32 1>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__1_1_1_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__1_1_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v1
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    v_mov_b32_e32 v3, v1
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__1_1_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    v_mov_b32_e32 v2, v1
; GFX90A-NEXT:    v_mov_b32_e32 v3, v1
; GFX90A-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__1_1_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v1
; GFX942-NEXT:    v_mov_b32_e32 v2, v1
; GFX942-NEXT:    v_mov_b32_e32 v3, v1
; GFX942-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 1, i32 1, i32 1, i32 1>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__2_1_1_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__2_1_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    v_mov_b32_e32 v3, v1
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__2_1_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    v_mov_b32_e32 v2, v1
; GFX90A-NEXT:    v_mov_b32_e32 v3, v1
; GFX90A-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__2_1_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    v_mov_b32_e32 v2, v1
; GFX942-NEXT:    v_mov_b32_e32 v3, v1
; GFX942-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 2, i32 1, i32 1, i32 1>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__3_1_1_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__3_1_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    v_mov_b32_e32 v3, v1
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__3_1_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v1
; GFX90A-NEXT:    v_mov_b32_e32 v3, v1
; GFX90A-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__3_1_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v1
; GFX942-NEXT:    v_mov_b32_e32 v3, v1
; GFX942-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 3, i32 1, i32 1, i32 1>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__4_1_1_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__4_1_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v5, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    v_mov_b32_e32 v3, v1
; GFX900-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__4_1_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    v_mov_b32_e32 v2, v1
; GFX90A-NEXT:    v_mov_b32_e32 v3, v1
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__4_1_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v3
; GFX942-NEXT:    v_mov_b32_e32 v2, v1
; GFX942-NEXT:    v_mov_b32_e32 v3, v1
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 4, i32 1, i32 1, i32 1>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_1_1_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_1_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v5, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v4
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    v_mov_b32_e32 v3, v1
; GFX900-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_1_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v4
; GFX90A-NEXT:    v_mov_b32_e32 v2, v1
; GFX90A-NEXT:    v_mov_b32_e32 v3, v1
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_1_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v4
; GFX942-NEXT:    v_mov_b32_e32 v2, v1
; GFX942-NEXT:    v_mov_b32_e32 v3, v1
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 1, i32 1, i32 1>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_u_1_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_u_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v5
; GFX900-NEXT:    v_mov_b32_e32 v3, v2
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_u_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v4
; GFX90A-NEXT:    v_mov_b32_e32 v2, v1
; GFX90A-NEXT:    v_mov_b32_e32 v3, v1
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_u_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v4
; GFX942-NEXT:    v_mov_b32_e32 v2, v1
; GFX942-NEXT:    v_mov_b32_e32 v3, v1
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 poison, i32 1, i32 1>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_0_1_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_0_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v5
; GFX900-NEXT:    v_mov_b32_e32 v3, v2
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_0_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    v_mov_b32_e32 v2, v3
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_0_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    v_mov_b32_e32 v0, v6
; GFX942-NEXT:    v_mov_b32_e32 v2, v3
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 0, i32 1, i32 1>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_2_1_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_2_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v7, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v6
; GFX900-NEXT:    v_mov_b32_e32 v1, v3
; GFX900-NEXT:    v_mov_b32_e32 v3, v2
; GFX900-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_2_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    v_mov_b32_e32 v2, v3
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_2_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    v_mov_b32_e32 v1, v4
; GFX942-NEXT:    v_mov_b32_e32 v2, v3
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 2, i32 1, i32 1>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_3_1_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_3_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    v_mov_b32_e32 v2, v4
; GFX900-NEXT:    v_mov_b32_e32 v3, v4
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_3_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    v_mov_b32_e32 v2, v3
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_3_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v2, v3
; GFX942-NEXT:    v_mov_b32_e32 v0, v6
; GFX942-NEXT:    v_mov_b32_e32 v1, v4
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 3, i32 1, i32 1>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_4_1_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_4_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v5, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    v_mov_b32_e32 v2, v3
; GFX900-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_4_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    v_mov_b32_e32 v2, v3
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_4_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    v_mov_b32_e32 v2, v3
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 4, i32 1, i32 1>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_1_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v5
; GFX900-NEXT:    v_mov_b32_e32 v1, v5
; GFX900-NEXT:    v_mov_b32_e32 v3, v2
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    v_mov_b32_e32 v2, v3
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    v_mov_b32_e32 v2, v3
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 1, i32 1>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_u_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_u_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v5
; GFX900-NEXT:    v_mov_b32_e32 v1, v5
; GFX900-NEXT:    v_mov_b32_e32 v3, v2
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_u_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_u_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 poison, i32 1>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_0_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_0_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v7, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v6
; GFX900-NEXT:    v_mov_b32_e32 v1, v6
; GFX900-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_0_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v6
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_0_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v6
; GFX942-NEXT:    v_mov_b32_e32 v1, v6
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 0, i32 1>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_2_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_2_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v5, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    v_mov_b32_e32 v1, v2
; GFX900-NEXT:    v_mov_b32_e32 v2, v4
; GFX900-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_2_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    v_mov_b32_e32 v2, v4
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_2_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    v_mov_b32_e32 v2, v4
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 2, i32 1>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_3_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_3_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v7, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v6
; GFX900-NEXT:    v_mov_b32_e32 v1, v6
; GFX900-NEXT:    v_mov_b32_e32 v2, v4
; GFX900-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_3_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v6
; GFX90A-NEXT:    v_mov_b32_e32 v2, v4
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_3_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v6
; GFX942-NEXT:    v_mov_b32_e32 v1, v6
; GFX942-NEXT:    v_mov_b32_e32 v2, v4
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 3, i32 1>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_4_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_4_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    v_mov_b32_e32 v1, v3
; GFX900-NEXT:    v_mov_b32_e32 v3, v4
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_4_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v6
; GFX90A-NEXT:    v_mov_b32_e32 v2, v5
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_4_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v6
; GFX942-NEXT:    v_mov_b32_e32 v1, v6
; GFX942-NEXT:    v_mov_b32_e32 v2, v5
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 4, i32 1>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__u_2_2_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__u_2_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v2
; GFX900-NEXT:    v_mov_b32_e32 v3, v2
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__u_2_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__u_2_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    v_mov_b32_e32 v3, v2
; GFX942-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 poison, i32 2, i32 2, i32 2>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__0_2_2_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__0_2_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v2
; GFX900-NEXT:    v_mov_b32_e32 v3, v2
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__0_2_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__0_2_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    v_mov_b32_e32 v3, v2
; GFX942-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 0, i32 2, i32 2, i32 2>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__1_2_2_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__1_2_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v1
; GFX900-NEXT:    v_mov_b32_e32 v1, v2
; GFX900-NEXT:    v_mov_b32_e32 v3, v2
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__1_2_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[0:1], v[0:1] op_sel:[1,0]
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__1_2_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[0:1], v[0:1] op_sel:[1,0]
; GFX942-NEXT:    v_mov_b32_e32 v3, v2
; GFX942-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 1, i32 2, i32 2, i32 2>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__2_2_2_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__2_2_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    v_mov_b32_e32 v1, v2
; GFX900-NEXT:    v_mov_b32_e32 v3, v2
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__2_2_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__2_2_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    v_mov_b32_e32 v3, v2
; GFX942-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 2, i32 2, i32 2, i32 2>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__3_2_2_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__3_2_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v2
; GFX900-NEXT:    v_mov_b32_e32 v3, v2
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__3_2_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__3_2_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    v_mov_b32_e32 v3, v2
; GFX942-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 3, i32 2, i32 2, i32 2>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__4_2_2_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__4_2_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v4
; GFX900-NEXT:    v_mov_b32_e32 v1, v2
; GFX900-NEXT:    v_mov_b32_e32 v3, v2
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__4_2_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[4:5], v[0:1] op_sel:[1,0]
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__4_2_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v3, v2
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[4:5], v[0:1] op_sel:[1,0]
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 4, i32 2, i32 2, i32 2>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_2_2_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_2_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v5
; GFX900-NEXT:    v_mov_b32_e32 v1, v2
; GFX900-NEXT:    v_mov_b32_e32 v3, v2
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_2_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_2_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    v_mov_b32_e32 v0, v6
; GFX942-NEXT:    v_mov_b32_e32 v3, v2
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 2, i32 2, i32 2>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_u_2_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_u_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v5
; GFX900-NEXT:    v_mov_b32_e32 v3, v2
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_u_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_u_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v3, v2
; GFX942-NEXT:    v_mov_b32_e32 v0, v6
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 poison, i32 2, i32 2>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_0_2_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_0_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v7, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v6
; GFX900-NEXT:    v_mov_b32_e32 v2, v3
; GFX900-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_0_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:8]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v8
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    v_mov_b32_e32 v2, v4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_0_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:8]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    v_mov_b32_e32 v0, v8
; GFX942-NEXT:    v_mov_b32_e32 v2, v4
; GFX942-NEXT:    v_mov_b32_e32 v3, v4
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 0, i32 2, i32 2>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_1_2_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_1_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v5
; GFX900-NEXT:    v_mov_b32_e32 v3, v2
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_1_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_1_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v3, v2
; GFX942-NEXT:    v_mov_b32_e32 v0, v6
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 1, i32 2, i32 2>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_3_2_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_3_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v5, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    v_mov_b32_e32 v2, v4
; GFX900-NEXT:    v_mov_b32_e32 v3, v4
; GFX900-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_3_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_3_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v3, v2
; GFX942-NEXT:    v_mov_b32_e32 v0, v6
; GFX942-NEXT:    v_mov_b32_e32 v1, v4
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 3, i32 2, i32 2>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_4_2_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_4_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    v_mov_b32_e32 v2, v3
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_4_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    v_mov_b32_e32 v2, v4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_4_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v3, v4
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    v_mov_b32_e32 v2, v4
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 4, i32 2, i32 2>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_2_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v5
; GFX900-NEXT:    v_mov_b32_e32 v1, v5
; GFX900-NEXT:    v_mov_b32_e32 v3, v2
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v6
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v3, v2
; GFX942-NEXT:    v_mov_b32_e32 v0, v6
; GFX942-NEXT:    v_mov_b32_e32 v1, v6
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 2, i32 2>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_u_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_u_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    v_mov_b32_e32 v1, v2
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_u_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v6
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_u_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v3, v2
; GFX942-NEXT:    v_mov_b32_e32 v0, v6
; GFX942-NEXT:    v_mov_b32_e32 v1, v6
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 poison, i32 2>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_0_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_0_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[5:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v7
; GFX900-NEXT:    v_mov_b32_e32 v1, v7
; GFX900-NEXT:    v_mov_b32_e32 v3, v4
; GFX900-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_0_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:8]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v8
; GFX90A-NEXT:    v_mov_b32_e32 v1, v8
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_0_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:8]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v3, v4
; GFX942-NEXT:    v_mov_b32_e32 v0, v8
; GFX942-NEXT:    v_mov_b32_e32 v1, v8
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 0, i32 2>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_1_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_1_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v7, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v6
; GFX900-NEXT:    v_mov_b32_e32 v1, v6
; GFX900-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_1_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[2:3], v[0:1], v[0:1] op_sel:[1,0]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v6
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_1_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_pk_mov_b32 v[2:3], v[0:1], v[0:1] op_sel:[1,0]
; GFX942-NEXT:    v_mov_b32_e32 v0, v6
; GFX942-NEXT:    v_mov_b32_e32 v1, v6
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 1, i32 2>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_3_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_3_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v7, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v6
; GFX900-NEXT:    v_mov_b32_e32 v1, v6
; GFX900-NEXT:    v_mov_b32_e32 v2, v4
; GFX900-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_3_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:8]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v8
; GFX90A-NEXT:    v_mov_b32_e32 v1, v8
; GFX90A-NEXT:    v_mov_b32_e32 v2, v6
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_3_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[6:8]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v3, v4
; GFX942-NEXT:    v_mov_b32_e32 v0, v8
; GFX942-NEXT:    v_mov_b32_e32 v1, v8
; GFX942-NEXT:    v_mov_b32_e32 v2, v6
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 3, i32 2>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_4_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_4_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v5, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    v_mov_b32_e32 v1, v3
; GFX900-NEXT:    v_mov_b32_e32 v3, v4
; GFX900-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_4_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[2:3], v[4:5], v[0:1] op_sel:[1,0]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v6
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_4_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_pk_mov_b32 v[2:3], v[4:5], v[0:1] op_sel:[1,0]
; GFX942-NEXT:    v_mov_b32_e32 v0, v6
; GFX942-NEXT:    v_mov_b32_e32 v1, v6
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 4, i32 2>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__u_3_3_3(ptr addrspace(1) inreg %ptr) {
; GFX9-LABEL: v_shuffle_v4i32_v3i32__u_3_3_3:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 poison, i32 3, i32 3, i32 3>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__0_3_3_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__0_3_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v3, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__0_3_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v3, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v3, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__0_3_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v3, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx4 v3, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 0, i32 3, i32 3, i32 3>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__1_3_3_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__1_3_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v1
; GFX900-NEXT:    global_store_dwordx4 v3, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__1_3_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v3, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    global_store_dwordx4 v3, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__1_3_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v3, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v1
; GFX942-NEXT:    global_store_dwordx4 v3, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 1, i32 3, i32 3, i32 3>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__2_3_3_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__2_3_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    global_store_dwordx4 v3, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__2_3_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v3, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    global_store_dwordx4 v3, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__2_3_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v3, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    global_store_dwordx4 v3, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 2, i32 3, i32 3, i32 3>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__3_3_3_3(ptr addrspace(1) inreg %ptr) {
; GFX9-LABEL: v_shuffle_v4i32_v3i32__3_3_3_3:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__4_3_3_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__4_3_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    v_mov_b32_e32 v3, v1
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__4_3_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[4:5], v[4:5] op_sel:[1,0]
; GFX90A-NEXT:    v_mov_b32_e32 v2, v4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__4_3_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[4:5], v[4:5] op_sel:[1,0]
; GFX942-NEXT:    v_mov_b32_e32 v2, v4
; GFX942-NEXT:    v_mov_b32_e32 v3, v4
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 4, i32 3, i32 3, i32 3>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_3_3_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_3_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    v_mov_b32_e32 v3, v1
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_3_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    v_mov_b32_e32 v2, v4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_3_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v6
; GFX942-NEXT:    v_mov_b32_e32 v1, v4
; GFX942-NEXT:    v_mov_b32_e32 v2, v4
; GFX942-NEXT:    v_mov_b32_e32 v3, v4
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 3, i32 3, i32 3>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_u_3_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_u_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    v_mov_b32_e32 v3, v1
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_u_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v1, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v2, v4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    global_store_dwordx4 v1, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_u_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v1, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v6
; GFX942-NEXT:    v_mov_b32_e32 v2, v4
; GFX942-NEXT:    v_mov_b32_e32 v3, v4
; GFX942-NEXT:    global_store_dwordx4 v1, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 poison, i32 3, i32 3>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_0_3_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_0_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v5
; GFX900-NEXT:    v_mov_b32_e32 v2, v3
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_0_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    v_mov_b32_e32 v2, v4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_0_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    v_mov_b32_e32 v0, v6
; GFX942-NEXT:    v_mov_b32_e32 v2, v4
; GFX942-NEXT:    v_mov_b32_e32 v3, v4
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 0, i32 3, i32 3>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_1_3_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_1_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v5
; GFX900-NEXT:    v_mov_b32_e32 v2, v3
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_1_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v2, v4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_1_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v6
; GFX942-NEXT:    v_mov_b32_e32 v2, v4
; GFX942-NEXT:    v_mov_b32_e32 v3, v4
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 1, i32 3, i32 3>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_2_3_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_2_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v5
; GFX900-NEXT:    v_mov_b32_e32 v1, v2
; GFX900-NEXT:    v_mov_b32_e32 v2, v3
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_2_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    v_mov_b32_e32 v2, v4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_2_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    v_mov_b32_e32 v0, v6
; GFX942-NEXT:    v_mov_b32_e32 v2, v4
; GFX942-NEXT:    v_mov_b32_e32 v3, v4
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 2, i32 3, i32 3>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_4_3_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_4_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v5
; GFX900-NEXT:    v_mov_b32_e32 v1, v4
; GFX900-NEXT:    v_mov_b32_e32 v2, v3
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_4_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v5
; GFX90A-NEXT:    v_mov_b32_e32 v2, v4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_4_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v6
; GFX942-NEXT:    v_mov_b32_e32 v1, v5
; GFX942-NEXT:    v_mov_b32_e32 v2, v4
; GFX942-NEXT:    v_mov_b32_e32 v3, v4
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 4, i32 3, i32 3>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_3_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v5
; GFX900-NEXT:    v_mov_b32_e32 v1, v5
; GFX900-NEXT:    v_mov_b32_e32 v2, v3
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v6
; GFX90A-NEXT:    v_mov_b32_e32 v2, v4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v6
; GFX942-NEXT:    v_mov_b32_e32 v1, v6
; GFX942-NEXT:    v_mov_b32_e32 v2, v4
; GFX942-NEXT:    v_mov_b32_e32 v3, v4
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 3, i32 3>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_u_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_u_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v5, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v4
; GFX900-NEXT:    v_mov_b32_e32 v1, v4
; GFX900-NEXT:    v_mov_b32_e32 v3, v2
; GFX900-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_u_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v4
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_u_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v4
; GFX942-NEXT:    v_mov_b32_e32 v1, v4
; GFX942-NEXT:    v_mov_b32_e32 v3, v2
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 poison, i32 3>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_0_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_0_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v5
; GFX900-NEXT:    v_mov_b32_e32 v1, v5
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_0_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v6
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_0_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v6
; GFX942-NEXT:    v_mov_b32_e32 v1, v6
; GFX942-NEXT:    v_mov_b32_e32 v3, v4
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 0, i32 3>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_1_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_1_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v5
; GFX900-NEXT:    v_mov_b32_e32 v1, v5
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_1_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    v_pk_mov_b32 v[2:3], v[0:1], v[2:3] op_sel:[1,0]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v4
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_1_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_pk_mov_b32 v[2:3], v[0:1], v[2:3] op_sel:[1,0]
; GFX942-NEXT:    v_mov_b32_e32 v0, v4
; GFX942-NEXT:    v_mov_b32_e32 v1, v4
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 1, i32 3>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_2_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_2_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v5
; GFX900-NEXT:    v_mov_b32_e32 v1, v5
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_2_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v6
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_2_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v6
; GFX942-NEXT:    v_mov_b32_e32 v1, v6
; GFX942-NEXT:    v_mov_b32_e32 v3, v4
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 2, i32 3>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_4_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_4_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v5
; GFX900-NEXT:    v_mov_b32_e32 v1, v5
; GFX900-NEXT:    v_mov_b32_e32 v2, v4
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_4_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    v_pk_mov_b32 v[2:3], v[2:3], v[2:3] op_sel:[1,0]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v4
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_4_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    v_pk_mov_b32 v[2:3], v[2:3], v[2:3] op_sel:[1,0]
; GFX942-NEXT:    v_mov_b32_e32 v0, v4
; GFX942-NEXT:    v_mov_b32_e32 v1, v4
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 4, i32 3>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__u_4_4_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__u_4_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    v_mov_b32_e32 v3, v1
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__u_4_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v1
; GFX90A-NEXT:    v_mov_b32_e32 v3, v1
; GFX90A-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__u_4_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v1
; GFX942-NEXT:    v_mov_b32_e32 v3, v1
; GFX942-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 poison, i32 4, i32 4, i32 4>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__0_4_4_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__0_4_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v2
; GFX900-NEXT:    v_mov_b32_e32 v3, v2
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__0_4_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v3
; GFX90A-NEXT:    v_mov_b32_e32 v2, v3
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__0_4_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v3
; GFX942-NEXT:    v_mov_b32_e32 v2, v3
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 0, i32 4, i32 4, i32 4>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__1_4_4_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__1_4_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v5, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    v_mov_b32_e32 v3, v1
; GFX900-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__1_4_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    v_mov_b32_e32 v2, v1
; GFX90A-NEXT:    v_mov_b32_e32 v3, v1
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__1_4_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v3
; GFX942-NEXT:    v_mov_b32_e32 v2, v1
; GFX942-NEXT:    v_mov_b32_e32 v3, v1
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 1, i32 4, i32 4, i32 4>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__2_4_4_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__2_4_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    v_mov_b32_e32 v3, v1
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__2_4_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v4
; GFX90A-NEXT:    v_mov_b32_e32 v2, v1
; GFX90A-NEXT:    v_mov_b32_e32 v3, v1
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__2_4_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v4
; GFX942-NEXT:    v_mov_b32_e32 v2, v1
; GFX942-NEXT:    v_mov_b32_e32 v3, v1
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 2, i32 4, i32 4, i32 4>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__3_4_4_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__3_4_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    v_mov_b32_e32 v3, v1
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__3_4_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v1
; GFX90A-NEXT:    v_mov_b32_e32 v3, v1
; GFX90A-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__3_4_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_mov_b32_e32 v2, v1
; GFX942-NEXT:    v_mov_b32_e32 v3, v1
; GFX942-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 3, i32 4, i32 4, i32 4>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__4_4_4_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__4_4_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v1
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    v_mov_b32_e32 v3, v1
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__4_4_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    v_mov_b32_e32 v2, v1
; GFX90A-NEXT:    v_mov_b32_e32 v3, v1
; GFX90A-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__4_4_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v1
; GFX942-NEXT:    v_mov_b32_e32 v2, v1
; GFX942-NEXT:    v_mov_b32_e32 v3, v1
; GFX942-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 4, i32 4, i32 4, i32 4>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_4_4_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_4_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    v_mov_b32_e32 v2, v1
; GFX900-NEXT:    v_mov_b32_e32 v3, v1
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_4_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    v_mov_b32_e32 v2, v1
; GFX90A-NEXT:    v_mov_b32_e32 v3, v1
; GFX90A-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_4_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    v_mov_b32_e32 v2, v1
; GFX942-NEXT:    v_mov_b32_e32 v3, v1
; GFX942-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 4, i32 4, i32 4>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_u_4_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_u_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    v_mov_b32_e32 v3, v2
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_u_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    v_mov_b32_e32 v2, v1
; GFX90A-NEXT:    v_mov_b32_e32 v3, v1
; GFX90A-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_u_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    v_mov_b32_e32 v2, v1
; GFX942-NEXT:    v_mov_b32_e32 v3, v1
; GFX942-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 poison, i32 4, i32 4>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_0_4_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_0_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v5, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v4
; GFX900-NEXT:    v_mov_b32_e32 v2, v3
; GFX900-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_0_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    v_mov_b32_e32 v2, v5
; GFX90A-NEXT:    v_mov_b32_e32 v3, v5
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_0_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    v_mov_b32_e32 v0, v6
; GFX942-NEXT:    v_mov_b32_e32 v2, v5
; GFX942-NEXT:    v_mov_b32_e32 v3, v5
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 0, i32 4, i32 4>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_1_4_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_1_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v5, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v4
; GFX900-NEXT:    v_mov_b32_e32 v2, v3
; GFX900-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_1_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v4
; GFX90A-NEXT:    v_mov_b32_e32 v2, v3
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_1_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v4
; GFX942-NEXT:    v_mov_b32_e32 v2, v3
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 1, i32 4, i32 4>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_2_4_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_2_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v5, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    v_mov_b32_e32 v1, v4
; GFX900-NEXT:    v_mov_b32_e32 v3, v2
; GFX900-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_2_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    v_mov_b32_e32 v2, v5
; GFX90A-NEXT:    v_mov_b32_e32 v3, v5
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_2_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    v_mov_b32_e32 v0, v6
; GFX942-NEXT:    v_mov_b32_e32 v2, v5
; GFX942-NEXT:    v_mov_b32_e32 v3, v5
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 2, i32 4, i32 4>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_3_4_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_3_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    v_mov_b32_e32 v3, v2
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_3_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v4
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    v_mov_b32_e32 v2, v3
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_3_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v4
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    v_mov_b32_e32 v2, v3
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 3, i32 4, i32 4>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_4_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    v_mov_b32_e32 v1, v3
; GFX900-NEXT:    v_mov_b32_e32 v3, v2
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v4
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    v_mov_b32_e32 v2, v3
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v4
; GFX942-NEXT:    v_mov_b32_e32 v1, v4
; GFX942-NEXT:    v_mov_b32_e32 v2, v3
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 4, i32 4>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_u_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_u_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    v_mov_b32_e32 v1, v3
; GFX900-NEXT:    v_mov_b32_e32 v3, v2
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_u_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v4
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_u_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v4
; GFX942-NEXT:    v_mov_b32_e32 v1, v4
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 poison, i32 4>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_0_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_0_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v5
; GFX900-NEXT:    v_mov_b32_e32 v1, v5
; GFX900-NEXT:    v_mov_b32_e32 v3, v4
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_0_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v6
; GFX90A-NEXT:    v_mov_b32_e32 v3, v5
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_0_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v6
; GFX942-NEXT:    v_mov_b32_e32 v1, v6
; GFX942-NEXT:    v_mov_b32_e32 v3, v5
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 0, i32 4>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_1_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_1_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v5
; GFX900-NEXT:    v_mov_b32_e32 v1, v5
; GFX900-NEXT:    v_mov_b32_e32 v3, v4
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_1_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v6
; GFX90A-NEXT:    v_mov_b32_e32 v2, v3
; GFX90A-NEXT:    v_mov_b32_e32 v3, v5
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_1_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v2, v3
; GFX942-NEXT:    v_mov_b32_e32 v0, v6
; GFX942-NEXT:    v_mov_b32_e32 v1, v6
; GFX942-NEXT:    v_mov_b32_e32 v3, v5
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 1, i32 4>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_2_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_2_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v5
; GFX900-NEXT:    v_mov_b32_e32 v1, v5
; GFX900-NEXT:    v_mov_b32_e32 v3, v4
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_2_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v6
; GFX90A-NEXT:    v_mov_b32_e32 v3, v5
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_2_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v6
; GFX942-NEXT:    v_mov_b32_e32 v1, v6
; GFX942-NEXT:    v_mov_b32_e32 v3, v5
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 2, i32 4>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_3_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_3_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v5, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v4
; GFX900-NEXT:    v_mov_b32_e32 v1, v4
; GFX900-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_3_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v4
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_3_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v4
; GFX942-NEXT:    v_mov_b32_e32 v1, v4
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 3, i32 4>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__u_5_5_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__u_5_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v2
; GFX900-NEXT:    v_mov_b32_e32 v3, v2
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__u_5_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__u_5_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    v_mov_b32_e32 v3, v2
; GFX942-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 poison, i32 5, i32 5, i32 5>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__0_5_5_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__0_5_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v3
; GFX900-NEXT:    v_mov_b32_e32 v2, v3
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__0_5_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    v_mov_b32_e32 v2, v4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__0_5_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v4
; GFX942-NEXT:    v_mov_b32_e32 v2, v4
; GFX942-NEXT:    v_mov_b32_e32 v3, v4
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 0, i32 5, i32 5, i32 5>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__1_5_5_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__1_5_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v5, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    v_mov_b32_e32 v1, v2
; GFX900-NEXT:    v_mov_b32_e32 v3, v2
; GFX900-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__1_5_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[2:3], v[0:1] op_sel:[1,0]
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__1_5_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[2:3], v[0:1] op_sel:[1,0]
; GFX942-NEXT:    v_mov_b32_e32 v3, v2
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 1, i32 5, i32 5, i32 5>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__2_5_5_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__2_5_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    v_mov_b32_e32 v1, v2
; GFX900-NEXT:    v_mov_b32_e32 v3, v2
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__2_5_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v4
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__2_5_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v4
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    v_mov_b32_e32 v3, v2
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 2, i32 5, i32 5, i32 5>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__3_5_5_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__3_5_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v2
; GFX900-NEXT:    v_mov_b32_e32 v3, v2
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__3_5_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__3_5_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    v_mov_b32_e32 v3, v2
; GFX942-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 3, i32 5, i32 5, i32 5>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__4_5_5_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__4_5_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v1
; GFX900-NEXT:    v_mov_b32_e32 v1, v2
; GFX900-NEXT:    v_mov_b32_e32 v3, v2
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__4_5_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_pk_mov_b32 v[0:1], v[0:1], v[0:1] op_sel:[1,0]
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__4_5_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    v_pk_mov_b32 v[0:1], v[0:1], v[0:1] op_sel:[1,0]
; GFX942-NEXT:    v_mov_b32_e32 v3, v2
; GFX942-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 4, i32 5, i32 5, i32 5>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_u_5_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_u_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    v_mov_b32_e32 v3, v2
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_u_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_u_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    v_mov_b32_e32 v3, v2
; GFX942-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 poison, i32 5, i32 5>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_0_5_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_0_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v5, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v4
; GFX900-NEXT:    v_mov_b32_e32 v2, v4
; GFX900-NEXT:    v_mov_b32_e32 v3, v4
; GFX900-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_0_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_0_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    v_mov_b32_e32 v1, v4
; GFX942-NEXT:    v_mov_b32_e32 v3, v2
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 0, i32 5, i32 5>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_1_5_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_1_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v5, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v4
; GFX900-NEXT:    v_mov_b32_e32 v2, v4
; GFX900-NEXT:    v_mov_b32_e32 v3, v4
; GFX900-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_1_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v4
; GFX90A-NEXT:    v_mov_b32_e32 v2, v4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_1_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v4
; GFX942-NEXT:    v_mov_b32_e32 v2, v4
; GFX942-NEXT:    v_mov_b32_e32 v3, v4
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 1, i32 5, i32 5>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_2_5_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_2_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    v_mov_b32_e32 v1, v3
; GFX900-NEXT:    v_mov_b32_e32 v3, v2
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_2_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_2_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    v_mov_b32_e32 v1, v4
; GFX942-NEXT:    v_mov_b32_e32 v3, v2
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 2, i32 5, i32 5>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_3_5_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_3_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    v_mov_b32_e32 v2, v3
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_3_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v4
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    v_mov_b32_e32 v2, v4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_3_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v4
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    v_mov_b32_e32 v2, v4
; GFX942-NEXT:    v_mov_b32_e32 v3, v4
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 3, i32 5, i32 5>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_4_5_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_4_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    v_mov_b32_e32 v3, v2
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_4_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_4_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    v_mov_b32_e32 v3, v2
; GFX942-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 4, i32 5, i32 5>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_u_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_u_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    v_mov_b32_e32 v1, v3
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_u_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v2
; GFX90A-NEXT:    v_mov_b32_e32 v1, v2
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_u_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v2
; GFX942-NEXT:    v_mov_b32_e32 v1, v2
; GFX942-NEXT:    v_mov_b32_e32 v3, v2
; GFX942-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 poison, i32 5>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_0_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_0_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v7, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    v_mov_b32_e32 v1, v3
; GFX900-NEXT:    v_mov_b32_e32 v2, v4
; GFX900-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_0_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v6
; GFX90A-NEXT:    v_mov_b32_e32 v3, v6
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_0_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v6
; GFX942-NEXT:    v_mov_b32_e32 v1, v6
; GFX942-NEXT:    v_mov_b32_e32 v3, v6
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 0, i32 5>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_1_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_1_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v5
; GFX900-NEXT:    v_mov_b32_e32 v1, v5
; GFX900-NEXT:    v_mov_b32_e32 v3, v5
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_1_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v4
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    v_pk_mov_b32 v[2:3], v[0:1], v[0:1] op_sel:[1,0]
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_1_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v4
; GFX942-NEXT:    v_pk_mov_b32 v[2:3], v[0:1], v[0:1] op_sel:[1,0]
; GFX942-NEXT:    v_mov_b32_e32 v1, v4
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 1, i32 5>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_2_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_2_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[3:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v6, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v5
; GFX900-NEXT:    v_mov_b32_e32 v1, v5
; GFX900-NEXT:    v_mov_b32_e32 v3, v5
; GFX900-NEXT:    global_store_dwordx4 v6, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_2_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:2]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v7, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v6
; GFX90A-NEXT:    v_mov_b32_e32 v3, v6
; GFX90A-NEXT:    global_store_dwordx4 v7, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_2_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v7, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v6
; GFX942-NEXT:    v_mov_b32_e32 v1, v6
; GFX942-NEXT:    v_mov_b32_e32 v3, v6
; GFX942-NEXT:    global_store_dwordx4 v7, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 2, i32 5>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_3_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_3_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:4]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v5, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v4
; GFX900-NEXT:    v_mov_b32_e32 v1, v4
; GFX900-NEXT:    v_mov_b32_e32 v3, v4
; GFX900-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_3_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v4
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v4
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_3_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v4
; GFX942-NEXT:    v_mov_b32_e32 v1, v4
; GFX942-NEXT:    v_mov_b32_e32 v3, v4
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 3, i32 5>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v4i32_v3i32__5_5_4_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4i32_v3i32__5_5_4_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    v_mov_b32_e32 v1, v3
; GFX900-NEXT:    global_store_dwordx4 v4, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4i32_v3i32__5_5_4_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:4]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v4
; GFX90A-NEXT:    v_mov_b32_e32 v5, 0
; GFX90A-NEXT:    v_pk_mov_b32 v[2:3], v[2:3], v[0:1] op_sel:[1,0]
; GFX90A-NEXT:    v_mov_b32_e32 v1, v4
; GFX90A-NEXT:    global_store_dwordx4 v5, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4i32_v3i32__5_5_4_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:4]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v5, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v4
; GFX942-NEXT:    v_pk_mov_b32 v[2:3], v[2:3], v[0:1] op_sel:[1,0]
; GFX942-NEXT:    v_mov_b32_e32 v1, v4
; GFX942-NEXT:    global_store_dwordx4 v5, v[0:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=v"()
  %vec1 = call <3 x i32> asm "; def $0", "=v"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 4, i32 5>
  store <4 x i32> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @s_shuffle_v4i32_v3i32__u_u_u_u() {
; GFX9-LABEL: s_shuffle_v4i32_v3i32__u_u_u_u:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> poison
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__0_u_u_u() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__0_u_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__0_u_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__0_u_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 0, i32 poison, i32 poison, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__1_u_u_u() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__1_u_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__1_u_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__1_u_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 1, i32 poison, i32 poison, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__2_u_u_u() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__2_u_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__2_u_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__2_u_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 2, i32 poison, i32 poison, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__3_u_u_u() {
; GFX9-LABEL: s_shuffle_v4i32_v3i32__3_u_u_u:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 3, i32 poison, i32 poison, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__4_u_u_u() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__4_u_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__4_u_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__4_u_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 4, i32 poison, i32 poison, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_u_u_u() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_u_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_u_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_u_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 poison, i32 poison, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_0_u_u() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_0_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_0_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_0_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 0, i32 poison, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_1_u_u() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_1_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_1_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_1_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 1, i32 poison, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_2_u_u() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_2_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_2_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_2_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 2, i32 poison, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_3_u_u() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_3_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_3_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_3_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 3, i32 poison, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_4_u_u() {
; GFX9-LABEL: s_shuffle_v4i32_v3i32__5_4_u_u:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:10]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s10
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 4, i32 poison, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_u_u() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 poison, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_0_u() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_0_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_0_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_0_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 0, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_1_u() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_1_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    s_mov_b32 s10, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_1_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    s_mov_b32 s10, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_1_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    s_mov_b32 s10, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 1, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_2_u() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_2_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_2_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_2_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 2, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_3_u() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_3_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_3_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_3_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 3, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_4_u() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_4_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    s_mov_b32 s10, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_4_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    s_mov_b32 s10, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_4_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    s_mov_b32 s10, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 4, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_5_u() {
; GFX9-LABEL: s_shuffle_v4i32_v3i32__5_5_5_u:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:10]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s10
; GFX9-NEXT:    s_mov_b32 s9, s10
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 5, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_5_0() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_5_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    s_mov_b32 s11, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_5_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    s_mov_b32 s11, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_5_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s10
; GFX942-NEXT:    s_mov_b32 s9, s10
; GFX942-NEXT:    s_mov_b32 s11, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 5, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_5_1() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_5_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_5_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_5_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s10
; GFX942-NEXT:    s_mov_b32 s9, s10
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 5, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_5_2() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_5_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    s_mov_b32 s11, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_5_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    s_mov_b32 s11, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_5_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s10
; GFX942-NEXT:    s_mov_b32 s9, s10
; GFX942-NEXT:    s_mov_b32 s11, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 5, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_5_3() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_5_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    s_mov_b32 s10, s6
; GFX900-NEXT:    s_mov_b32 s11, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_5_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    s_mov_b32 s10, s6
; GFX90A-NEXT:    s_mov_b32 s11, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_5_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    s_mov_b32 s10, s2
; GFX942-NEXT:    s_mov_b32 s11, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 5, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_5_4() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_5_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    s_mov_b32 s10, s6
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_5_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    s_mov_b32 s10, s6
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_5_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    s_mov_b32 s10, s2
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 5, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_5_5() {
; GFX9-LABEL: s_shuffle_v4i32_v3i32__5_5_5_5:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:10]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s10
; GFX9-NEXT:    s_mov_b32 s9, s10
; GFX9-NEXT:    s_mov_b32 s11, s10
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 5, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__u_0_0_0() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__u_0_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__u_0_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__u_0_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 poison, i32 0, i32 0, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__0_0_0_0() {
; GFX9-LABEL: s_shuffle_v4i32_v3i32__0_0_0_0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:10]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s8
; GFX9-NEXT:    s_mov_b32 s10, s8
; GFX9-NEXT:    s_mov_b32 s11, s8
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> zeroinitializer
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__1_0_0_0() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__1_0_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__1_0_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__1_0_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 1, i32 0, i32 0, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__2_0_0_0() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__2_0_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__2_0_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__2_0_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 2, i32 0, i32 0, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__3_0_0_0() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__3_0_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__3_0_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__3_0_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 3, i32 0, i32 0, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__4_0_0_0() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__4_0_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s9
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__4_0_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s9
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__4_0_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s5
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 4, i32 0, i32 0, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_0_0_0() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_0_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_0_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_0_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 0, i32 0, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_u_0_0() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_u_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_u_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_u_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 poison, i32 0, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_1_0_0() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_1_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s5
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_1_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s5
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_1_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s1
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 1, i32 0, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_2_0_0() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_2_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_2_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_2_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 2, i32 0, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_3_0_0() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_3_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:14]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s12
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_3_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:14]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s12
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_3_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s4
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 3, i32 0, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_4_0_0() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_4_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_4_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_4_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s10
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 4, i32 0, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_0_0() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 0, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_u_0() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_u_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    s_mov_b32 s11, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_u_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    s_mov_b32 s11, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_u_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    s_mov_b32 s11, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 poison, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_1_0() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_1_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    s_mov_b32 s10, s5
; GFX900-NEXT:    s_mov_b32 s11, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_1_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    s_mov_b32 s10, s5
; GFX90A-NEXT:    s_mov_b32 s11, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_1_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    s_mov_b32 s10, s1
; GFX942-NEXT:    s_mov_b32 s11, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 1, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_2_0() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_2_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    s_mov_b32 s10, s6
; GFX900-NEXT:    s_mov_b32 s11, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_2_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    s_mov_b32 s10, s6
; GFX90A-NEXT:    s_mov_b32 s11, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_2_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    s_mov_b32 s10, s2
; GFX942-NEXT:    s_mov_b32 s11, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 2, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_3_0() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_3_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:14]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s14
; GFX900-NEXT:    s_mov_b32 s10, s12
; GFX900-NEXT:    s_mov_b32 s11, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_3_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:14]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s14
; GFX90A-NEXT:    s_mov_b32 s10, s12
; GFX90A-NEXT:    s_mov_b32 s11, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_3_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    s_mov_b32 s10, s4
; GFX942-NEXT:    s_mov_b32 s11, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 3, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_4_0() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_4_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:14]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s14
; GFX900-NEXT:    s_mov_b32 s10, s13
; GFX900-NEXT:    s_mov_b32 s11, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_4_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:14]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s14
; GFX90A-NEXT:    s_mov_b32 s10, s13
; GFX90A-NEXT:    s_mov_b32 s11, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_4_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    s_mov_b32 s10, s5
; GFX942-NEXT:    s_mov_b32 s11, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 4, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__u_1_1_1() {
; GFX9-LABEL: s_shuffle_v4i32_v3i32__u_1_1_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:10]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s9
; GFX9-NEXT:    s_mov_b32 s11, s9
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 poison, i32 1, i32 1, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__0_1_1_1() {
; GFX9-LABEL: s_shuffle_v4i32_v3i32__0_1_1_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:10]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s9
; GFX9-NEXT:    s_mov_b32 s11, s9
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 0, i32 1, i32 1, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__1_1_1_1() {
; GFX9-LABEL: s_shuffle_v4i32_v3i32__1_1_1_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:10]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s9
; GFX9-NEXT:    s_mov_b32 s10, s9
; GFX9-NEXT:    s_mov_b32 s11, s9
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 1, i32 1, i32 1, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__2_1_1_1() {
; GFX9-LABEL: s_shuffle_v4i32_v3i32__2_1_1_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:10]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s10
; GFX9-NEXT:    s_mov_b32 s10, s9
; GFX9-NEXT:    s_mov_b32 s11, s9
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 2, i32 1, i32 1, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__3_1_1_1() {
; GFX9-LABEL: s_shuffle_v4i32_v3i32__3_1_1_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:10]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s9
; GFX9-NEXT:    s_mov_b32 s11, s9
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 3, i32 1, i32 1, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__4_1_1_1() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__4_1_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    s_mov_b32 s10, s9
; GFX900-NEXT:    s_mov_b32 s11, s9
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__4_1_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    s_mov_b32 s10, s9
; GFX90A-NEXT:    s_mov_b32 s11, s9
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__4_1_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    s_mov_b32 s10, s9
; GFX942-NEXT:    s_mov_b32 s11, s9
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 4, i32 1, i32 1, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_1_1_1() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_1_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s10, s9
; GFX900-NEXT:    s_mov_b32 s11, s9
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_1_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s10, s9
; GFX90A-NEXT:    s_mov_b32 s11, s9
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_1_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s10, s9
; GFX942-NEXT:    s_mov_b32 s11, s9
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 1, i32 1, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_u_1_1() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_u_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s10, s5
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_u_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s10, s5
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_u_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s10, s1
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 poison, i32 1, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_0_1_1() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_0_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    s_mov_b32 s10, s5
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_0_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    s_mov_b32 s10, s5
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_0_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    s_mov_b32 s10, s1
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 0, i32 1, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_2_1_1() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_2_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    s_mov_b32 s10, s5
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_2_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    s_mov_b32 s10, s5
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_2_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    s_mov_b32 s10, s1
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 2, i32 1, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_3_1_1() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_3_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:14]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s12
; GFX900-NEXT:    s_mov_b32 s10, s5
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_3_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:14]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s12
; GFX90A-NEXT:    s_mov_b32 s10, s5
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_3_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s4
; GFX942-NEXT:    s_mov_b32 s10, s1
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 3, i32 1, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_4_1_1() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_4_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s10, s5
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_4_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s10, s5
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_4_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s10
; GFX942-NEXT:    s_mov_b32 s10, s1
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 4, i32 1, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_1_1() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    s_mov_b32 s10, s5
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    s_mov_b32 s10, s5
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    s_mov_b32 s10, s1
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 1, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_u_1() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_u_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_u_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_u_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 poison, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_0_1() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_0_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_0_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_0_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 0, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_2_1() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_2_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    s_mov_b32 s10, s6
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_2_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    s_mov_b32 s10, s6
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_2_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    s_mov_b32 s10, s2
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 2, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_3_1() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_3_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:14]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s14
; GFX900-NEXT:    s_mov_b32 s10, s12
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_3_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:14]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s14
; GFX90A-NEXT:    s_mov_b32 s10, s12
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_3_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    s_mov_b32 s10, s4
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 3, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_4_1() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_4_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:14]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s14
; GFX900-NEXT:    s_mov_b32 s10, s13
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_4_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:14]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s14
; GFX90A-NEXT:    s_mov_b32 s10, s13
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_4_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    s_mov_b32 s10, s5
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 4, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__u_2_2_2() {
; GFX9-LABEL: s_shuffle_v4i32_v3i32__u_2_2_2:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:10]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s10
; GFX9-NEXT:    s_mov_b32 s11, s10
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 poison, i32 2, i32 2, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__0_2_2_2() {
; GFX9-LABEL: s_shuffle_v4i32_v3i32__0_2_2_2:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:10]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s10
; GFX9-NEXT:    s_mov_b32 s11, s10
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 0, i32 2, i32 2, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__1_2_2_2() {
; GFX9-LABEL: s_shuffle_v4i32_v3i32__1_2_2_2:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:10]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s9
; GFX9-NEXT:    s_mov_b32 s9, s10
; GFX9-NEXT:    s_mov_b32 s11, s10
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 1, i32 2, i32 2, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__2_2_2_2() {
; GFX9-LABEL: s_shuffle_v4i32_v3i32__2_2_2_2:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:10]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s10
; GFX9-NEXT:    s_mov_b32 s9, s10
; GFX9-NEXT:    s_mov_b32 s11, s10
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 2, i32 2, i32 2, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__3_2_2_2() {
; GFX9-LABEL: s_shuffle_v4i32_v3i32__3_2_2_2:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:10]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s10
; GFX9-NEXT:    s_mov_b32 s11, s10
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 3, i32 2, i32 2, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__4_2_2_2() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__4_2_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    s_mov_b32 s11, s10
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__4_2_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    s_mov_b32 s11, s10
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__4_2_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    s_mov_b32 s9, s10
; GFX942-NEXT:    s_mov_b32 s11, s10
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 4, i32 2, i32 2, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_2_2_2() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_2_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    s_mov_b32 s11, s10
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_2_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    s_mov_b32 s11, s10
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_2_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s10
; GFX942-NEXT:    s_mov_b32 s11, s10
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 2, i32 2, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_u_2_2() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_u_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s11, s10
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_u_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s11, s10
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_u_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s11, s10
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 poison, i32 2, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_0_2_2() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_0_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    s_mov_b32 s10, s6
; GFX900-NEXT:    s_mov_b32 s11, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_0_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    s_mov_b32 s10, s6
; GFX90A-NEXT:    s_mov_b32 s11, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_0_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    s_mov_b32 s10, s2
; GFX942-NEXT:    s_mov_b32 s11, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 0, i32 2, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_1_2_2() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_1_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s11, s10
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_1_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s11, s10
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_1_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s11, s10
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 1, i32 2, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_3_2_2() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_3_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    s_mov_b32 s11, s10
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_3_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    s_mov_b32 s11, s10
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_3_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    s_mov_b32 s11, s10
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 3, i32 2, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_4_2_2() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_4_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s10, s6
; GFX900-NEXT:    s_mov_b32 s11, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_4_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s10, s6
; GFX90A-NEXT:    s_mov_b32 s11, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_4_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s10
; GFX942-NEXT:    s_mov_b32 s10, s2
; GFX942-NEXT:    s_mov_b32 s11, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 4, i32 2, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_2_2() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    s_mov_b32 s11, s10
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    s_mov_b32 s11, s10
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    s_mov_b32 s11, s10
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 2, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_u_2() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_u_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    s_mov_b32 s11, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_u_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    s_mov_b32 s11, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_u_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    s_mov_b32 s11, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 poison, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_0_2() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_0_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_0_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_0_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 0, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_1_2() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_1_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    s_mov_b32 s10, s5
; GFX900-NEXT:    s_mov_b32 s11, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_1_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    s_mov_b32 s10, s5
; GFX90A-NEXT:    s_mov_b32 s11, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_1_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    s_mov_b32 s10, s1
; GFX942-NEXT:    s_mov_b32 s11, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 1, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_3_2() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_3_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:14]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s14
; GFX900-NEXT:    s_mov_b32 s10, s12
; GFX900-NEXT:    s_mov_b32 s11, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_3_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:14]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s14
; GFX90A-NEXT:    s_mov_b32 s10, s12
; GFX90A-NEXT:    s_mov_b32 s11, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_3_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    s_mov_b32 s10, s4
; GFX942-NEXT:    s_mov_b32 s11, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 3, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_4_2() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_4_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:14]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s14
; GFX900-NEXT:    s_mov_b32 s10, s13
; GFX900-NEXT:    s_mov_b32 s11, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_4_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:14]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s14
; GFX90A-NEXT:    s_mov_b32 s10, s13
; GFX90A-NEXT:    s_mov_b32 s11, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_4_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    s_mov_b32 s10, s5
; GFX942-NEXT:    s_mov_b32 s11, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 4, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__u_3_3_3() {
; GFX9-LABEL: s_shuffle_v4i32_v3i32__u_3_3_3:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 poison, i32 3, i32 3, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__0_3_3_3() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__0_3_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__0_3_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__0_3_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 0, i32 3, i32 3, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__1_3_3_3() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__1_3_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__1_3_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__1_3_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 1, i32 3, i32 3, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__2_3_3_3() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__2_3_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__2_3_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__2_3_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 2, i32 3, i32 3, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__3_3_3_3() {
; GFX9-LABEL: s_shuffle_v4i32_v3i32__3_3_3_3:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> poison, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__4_3_3_3() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__4_3_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__4_3_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__4_3_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 4, i32 3, i32 3, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_3_3_3() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_3_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_3_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_3_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 3, i32 3, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_u_3_3() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_u_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_u_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_u_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 poison, i32 3, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_0_3_3() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_0_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:14]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    s_mov_b32 s10, s12
; GFX900-NEXT:    s_mov_b32 s11, s12
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_0_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:14]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    s_mov_b32 s10, s12
; GFX90A-NEXT:    s_mov_b32 s11, s12
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_0_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    s_mov_b32 s10, s4
; GFX942-NEXT:    s_mov_b32 s11, s4
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 0, i32 3, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_1_3_3() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_1_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_1_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_1_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 1, i32 3, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_2_3_3() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_2_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:14]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    s_mov_b32 s10, s12
; GFX900-NEXT:    s_mov_b32 s11, s12
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_2_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:14]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    s_mov_b32 s10, s12
; GFX90A-NEXT:    s_mov_b32 s11, s12
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_2_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    s_mov_b32 s10, s4
; GFX942-NEXT:    s_mov_b32 s11, s4
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 2, i32 3, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_4_3_3() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_4_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s5
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_4_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s5
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_4_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s1
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 4, i32 3, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_3_3() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 3, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_u_3() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_u_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    s_mov_b32 s11, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_u_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    s_mov_b32 s11, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_u_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    s_mov_b32 s11, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 poison, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_0_3() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_0_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:14]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s14
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s12
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_0_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:14]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s14
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s12
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_0_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s4
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 0, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_1_3() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_1_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:14]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s14
; GFX900-NEXT:    s_mov_b32 s10, s5
; GFX900-NEXT:    s_mov_b32 s11, s12
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_1_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:14]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s14
; GFX90A-NEXT:    s_mov_b32 s10, s5
; GFX90A-NEXT:    s_mov_b32 s11, s12
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_1_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    s_mov_b32 s10, s1
; GFX942-NEXT:    s_mov_b32 s11, s4
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 1, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_2_3() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_2_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    s_mov_b32 s11, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_2_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    s_mov_b32 s11, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_2_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    s_mov_b32 s11, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 2, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_4_3() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_4_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    s_mov_b32 s10, s5
; GFX900-NEXT:    s_mov_b32 s11, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_4_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    s_mov_b32 s10, s5
; GFX90A-NEXT:    s_mov_b32 s11, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_4_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    s_mov_b32 s10, s1
; GFX942-NEXT:    s_mov_b32 s11, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 4, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__u_4_4_4() {
; GFX9-LABEL: s_shuffle_v4i32_v3i32__u_4_4_4:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:10]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s9
; GFX9-NEXT:    s_mov_b32 s11, s9
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 poison, i32 4, i32 4, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__0_4_4_4() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__0_4_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s5
; GFX900-NEXT:    s_mov_b32 s10, s5
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__0_4_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s5
; GFX90A-NEXT:    s_mov_b32 s10, s5
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__0_4_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s1
; GFX942-NEXT:    s_mov_b32 s10, s1
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 0, i32 4, i32 4, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__1_4_4_4() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__1_4_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    s_mov_b32 s10, s9
; GFX900-NEXT:    s_mov_b32 s11, s9
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__1_4_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    s_mov_b32 s10, s9
; GFX90A-NEXT:    s_mov_b32 s11, s9
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__1_4_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    s_mov_b32 s10, s9
; GFX942-NEXT:    s_mov_b32 s11, s9
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 1, i32 4, i32 4, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__2_4_4_4() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__2_4_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s10, s9
; GFX900-NEXT:    s_mov_b32 s11, s9
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__2_4_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s10, s9
; GFX90A-NEXT:    s_mov_b32 s11, s9
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__2_4_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s10, s9
; GFX942-NEXT:    s_mov_b32 s11, s9
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 2, i32 4, i32 4, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__3_4_4_4() {
; GFX9-LABEL: s_shuffle_v4i32_v3i32__3_4_4_4:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:10]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s9
; GFX9-NEXT:    s_mov_b32 s11, s9
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 3, i32 4, i32 4, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__4_4_4_4() {
; GFX9-LABEL: s_shuffle_v4i32_v3i32__4_4_4_4:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:10]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s9
; GFX9-NEXT:    s_mov_b32 s10, s9
; GFX9-NEXT:    s_mov_b32 s11, s9
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 4, i32 4, i32 4, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_4_4_4() {
; GFX9-LABEL: s_shuffle_v4i32_v3i32__5_4_4_4:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:10]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s10
; GFX9-NEXT:    s_mov_b32 s10, s9
; GFX9-NEXT:    s_mov_b32 s11, s9
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 4, i32 4, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_u_4_4() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_u_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s10, s5
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_u_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s10, s5
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_u_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s10, s1
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 poison, i32 4, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_0_4_4() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_0_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:14]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    s_mov_b32 s10, s13
; GFX900-NEXT:    s_mov_b32 s11, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_0_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:14]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    s_mov_b32 s10, s13
; GFX90A-NEXT:    s_mov_b32 s11, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_0_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    s_mov_b32 s10, s5
; GFX942-NEXT:    s_mov_b32 s11, s5
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 0, i32 4, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_1_4_4() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_1_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s10, s5
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_1_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s10, s5
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_1_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s10, s1
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 1, i32 4, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_2_4_4() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_2_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:14]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    s_mov_b32 s10, s13
; GFX900-NEXT:    s_mov_b32 s11, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_2_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:14]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    s_mov_b32 s10, s13
; GFX90A-NEXT:    s_mov_b32 s11, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_2_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    s_mov_b32 s10, s5
; GFX942-NEXT:    s_mov_b32 s11, s5
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 2, i32 4, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_3_4_4() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_3_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    s_mov_b32 s10, s5
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_3_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    s_mov_b32 s10, s5
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_3_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    s_mov_b32 s10, s1
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 3, i32 4, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_4_4() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    s_mov_b32 s10, s5
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    s_mov_b32 s10, s5
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    s_mov_b32 s10, s1
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 4, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_u_4() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_u_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_u_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_u_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 poison, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_0_4() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_0_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:14]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s14
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_0_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:14]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s14
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_0_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s5
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 0, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_1_4() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_1_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:14]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s14
; GFX900-NEXT:    s_mov_b32 s10, s5
; GFX900-NEXT:    s_mov_b32 s11, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_1_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:14]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s14
; GFX90A-NEXT:    s_mov_b32 s10, s5
; GFX90A-NEXT:    s_mov_b32 s11, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_1_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    s_mov_b32 s10, s1
; GFX942-NEXT:    s_mov_b32 s11, s5
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 1, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_2_4() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_2_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_2_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_2_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 2, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_3_4() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_3_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_3_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_3_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 3, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__u_5_5_5() {
; GFX9-LABEL: s_shuffle_v4i32_v3i32__u_5_5_5:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:10]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s10
; GFX9-NEXT:    s_mov_b32 s11, s10
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 poison, i32 5, i32 5, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__0_5_5_5() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__0_5_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    s_mov_b32 s10, s6
; GFX900-NEXT:    s_mov_b32 s11, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__0_5_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    s_mov_b32 s10, s6
; GFX90A-NEXT:    s_mov_b32 s11, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__0_5_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    s_mov_b32 s10, s2
; GFX942-NEXT:    s_mov_b32 s11, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 0, i32 5, i32 5, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__1_5_5_5() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__1_5_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    s_mov_b32 s11, s10
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__1_5_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    s_mov_b32 s11, s10
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__1_5_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    s_mov_b32 s9, s10
; GFX942-NEXT:    s_mov_b32 s11, s10
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 1, i32 5, i32 5, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__2_5_5_5() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__2_5_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s10
; GFX900-NEXT:    s_mov_b32 s11, s10
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__2_5_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s10
; GFX90A-NEXT:    s_mov_b32 s11, s10
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__2_5_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s10
; GFX942-NEXT:    s_mov_b32 s11, s10
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 2, i32 5, i32 5, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__3_5_5_5() {
; GFX9-LABEL: s_shuffle_v4i32_v3i32__3_5_5_5:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:10]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s9, s10
; GFX9-NEXT:    s_mov_b32 s11, s10
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 3, i32 5, i32 5, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__4_5_5_5() {
; GFX9-LABEL: s_shuffle_v4i32_v3i32__4_5_5_5:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:10]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s9
; GFX9-NEXT:    s_mov_b32 s9, s10
; GFX9-NEXT:    s_mov_b32 s11, s10
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 4, i32 5, i32 5, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_u_5_5() {
; GFX9-LABEL: s_shuffle_v4i32_v3i32__5_u_5_5:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:10]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s10
; GFX9-NEXT:    s_mov_b32 s11, s10
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 poison, i32 5, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_0_5_5() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_0_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    s_mov_b32 s11, s10
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_0_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    s_mov_b32 s11, s10
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_0_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s10
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    s_mov_b32 s11, s10
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 0, i32 5, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_1_5_5() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_1_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s10, s6
; GFX900-NEXT:    s_mov_b32 s11, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_1_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s10, s6
; GFX90A-NEXT:    s_mov_b32 s11, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_1_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s10, s2
; GFX942-NEXT:    s_mov_b32 s11, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 1, i32 5, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_2_5_5() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_2_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    s_mov_b32 s11, s10
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_2_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    s_mov_b32 s11, s10
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_2_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s10
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    s_mov_b32 s11, s10
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 2, i32 5, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_3_5_5() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_3_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    s_mov_b32 s10, s6
; GFX900-NEXT:    s_mov_b32 s11, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_3_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    s_mov_b32 s10, s6
; GFX90A-NEXT:    s_mov_b32 s11, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_3_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    s_mov_b32 s10, s2
; GFX942-NEXT:    s_mov_b32 s11, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 3, i32 5, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_4_5_5() {
; GFX9-LABEL: s_shuffle_v4i32_v3i32__5_4_5_5:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:10]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s10
; GFX9-NEXT:    s_mov_b32 s11, s10
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 4, i32 5, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_u_5() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_u_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    s_mov_b32 s11, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_u_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    s_mov_b32 s11, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_u_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    s_mov_b32 s11, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 poison, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_0_5() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_0_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:14]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s14
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s14
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_0_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:14]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s14
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s14
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_0_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s6
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 0, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_1_5() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_1_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:14]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s14
; GFX900-NEXT:    s_mov_b32 s10, s5
; GFX900-NEXT:    s_mov_b32 s11, s14
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_1_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:14]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s14
; GFX90A-NEXT:    s_mov_b32 s10, s5
; GFX90A-NEXT:    s_mov_b32 s11, s14
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_1_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[4:6]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s6
; GFX942-NEXT:    s_mov_b32 s9, s6
; GFX942-NEXT:    s_mov_b32 s10, s1
; GFX942-NEXT:    s_mov_b32 s11, s6
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 1, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_2_5() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_2_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:10]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    s_mov_b32 s11, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_2_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:10]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    s_mov_b32 s11, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_2_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:10]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    s_mov_b32 s11, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 2, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_3_5() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_3_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_3_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_3_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    s_mov_b32 s10, s0
; GFX942-NEXT:    s_mov_b32 s11, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 3, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}

define void @s_shuffle_v4i32_v3i32__5_5_4_5() {
; GFX900-LABEL: s_shuffle_v4i32_v3i32__5_5_4_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:6]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s6
; GFX900-NEXT:    s_mov_b32 s10, s5
; GFX900-NEXT:    s_mov_b32 s11, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4i32_v3i32__5_5_4_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:6]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s6
; GFX90A-NEXT:    s_mov_b32 s10, s5
; GFX90A-NEXT:    s_mov_b32 s11, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4i32_v3i32__5_5_4_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:2]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s2
; GFX942-NEXT:    s_mov_b32 s9, s2
; GFX942-NEXT:    s_mov_b32 s10, s1
; GFX942-NEXT:    s_mov_b32 s11, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:11]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <3 x i32> asm "; def $0", "=s"()
  %vec1 = call <3 x i32> asm "; def $0", "=s"()
  %shuf = shufflevector <3 x i32> %vec0, <3 x i32> %vec1, <4 x i32> <i32 5, i32 5, i32 4, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<4 x i32> %shuf)
  ret void
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GFX90APLUS: {{.*}}
