; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+v,+zvfh,+zvfbfmin -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,NOZFMIN,ZVFH
; RUN: llc -mtriple=riscv64 -mattr=+v,+zvfh,+zvfbfmin -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,NOZFMIN,ZVFH
; RUN: llc -mtriple=riscv32 -mattr=+v,+zvfhmin,+zvfbfmin -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,NOZFMIN,ZVFHMIN
; RUN: llc -mtriple=riscv64 -mattr=+v,+zvfhmin,+zvfbfmin -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,NOZFMIN,ZVFHMIN
; RUN: llc -mtriple=riscv32 -mattr=+v,+zfhmin,+zfbfmin,+zvfhmin,+zvfbfmin -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,ZFMIN
; RUN: llc -mtriple=riscv64 -mattr=+v,+zfhmin,+zfbfmin,+zvfhmin,+zvfbfmin -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,ZFMIN

define <vscale x 8 x bfloat> @vsplat_nxv8bf16(bfloat %f) {
; NOZFMIN-LABEL: vsplat_nxv8bf16:
; NOZFMIN:       # %bb.0:
; NOZFMIN-NEXT:    fmv.x.w a0, fa0
; NOZFMIN-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; NOZFMIN-NEXT:    vmv.v.x v8, a0
; NOZFMIN-NEXT:    ret
;
; ZFMIN-LABEL: vsplat_nxv8bf16:
; ZFMIN:       # %bb.0:
; ZFMIN-NEXT:    fmv.x.h a0, fa0
; ZFMIN-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; ZFMIN-NEXT:    vmv.v.x v8, a0
; ZFMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x bfloat> poison, bfloat %f, i32 0
  %splat = shufflevector <vscale x 8 x bfloat> %head, <vscale x 8 x bfloat> poison, <vscale x 8 x i32> zeroinitializer
  ret <vscale x 8 x bfloat> %splat
}

define <vscale x 8 x bfloat> @vsplat_zero_nxv8bf16() {
; CHECK-LABEL: vsplat_zero_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    ret
  ret <vscale x 8 x bfloat> splat (bfloat zeroinitializer)
}

define <vscale x 8 x half> @vsplat_nxv8f16(half %f) {
; ZVFH-LABEL: vsplat_nxv8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfmv.v.f v8, fa0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vsplat_nxv8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fmv.x.w a0, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vmv.v.x v8, a0
; ZVFHMIN-NEXT:    ret
;
; ZFMIN-LABEL: vsplat_nxv8f16:
; ZFMIN:       # %bb.0:
; ZFMIN-NEXT:    fmv.x.h a0, fa0
; ZFMIN-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; ZFMIN-NEXT:    vmv.v.x v8, a0
; ZFMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %f, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  ret <vscale x 8 x half> %splat
}

define <vscale x 8 x half> @vsplat_zero_nxv8f16() {
; CHECK-LABEL: vsplat_zero_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    ret
  ret <vscale x 8 x half> splat (half zeroinitializer)
}

define <vscale x 8 x float> @vsplat_nxv8f32(float %f) {
; CHECK-LABEL: vsplat_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %f, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  ret <vscale x 8 x float> %splat
}

define <vscale x 8 x float> @vsplat_zero_nxv8f32() {
; CHECK-LABEL: vsplat_zero_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    ret
  ret <vscale x 8 x float> splat (float zeroinitializer)
}

define <vscale x 8 x double> @vsplat_nxv8f64(double %f) {
; CHECK-LABEL: vsplat_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfmv.v.f v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %f, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  ret <vscale x 8 x double> %splat
}

define <vscale x 8 x double> @vsplat_zero_nxv8f64() {
; CHECK-LABEL: vsplat_zero_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    ret
  ret <vscale x 8 x double> splat (double zeroinitializer)
}

define <vscale x 8 x float> @vsplat_load_nxv8f32(ptr %ptr) {
; CHECK-LABEL: vsplat_load_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    flw fa5, 0(a0)
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v8, fa5
; CHECK-NEXT:    ret
  %f = load float, ptr %ptr
  %head = insertelement <vscale x 8 x float> poison, float %f, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  ret <vscale x 8 x float> %splat
}

; Test that we fold this to a vlse with 0 stride.
define <vscale x 8 x float> @vsplat_load_nxv8f32_optimized(ptr %ptr) "target-features"="+optimized-zero-stride-load" {
; CHECK-LABEL: vsplat_load_nxv8f32_optimized:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vlse32.v v8, (a0), zero
; CHECK-NEXT:    ret
  %f = load float, ptr %ptr
  %head = insertelement <vscale x 8 x float> poison, float %f, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  ret <vscale x 8 x float> %splat
}
