; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple amdgcn-amd-amdhsa -mcpu=gfx803 -O0 -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefix=GCN %s

define void @child_function() #0 {
; GCN-LABEL: child_function:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    ;;#ASMSTART
; GCN-NEXT:    ;;#ASMEND
; GCN-NEXT:    s_setpc_b64 s[30:31]
  call void asm sideeffect "", "~{vcc}" () #0
  ret void
}

define void @spill_sgpr_with_no_lower_vgpr_available() #0 {
; GCN-LABEL: spill_sgpr_with_no_lower_vgpr_available:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_mov_b32 s18, s33
; GCN-NEXT:    s_mov_b32 s33, s32
; GCN-NEXT:    s_or_saveexec_b64 s[16:17], -1
; GCN-NEXT:    buffer_store_dword v255, off, s[0:3], s33 offset:452 ; 4-byte Folded Spill
; GCN-NEXT:    s_mov_b64 exec, s[16:17]
; GCN-NEXT:    s_add_i32 s32, s32, 0x7400
; GCN-NEXT:    buffer_store_dword v40, off, s[0:3], s33 offset:440 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v41, off, s[0:3], s33 offset:436 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v42, off, s[0:3], s33 offset:432 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v43, off, s[0:3], s33 offset:428 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v44, off, s[0:3], s33 offset:424 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v45, off, s[0:3], s33 offset:420 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v46, off, s[0:3], s33 offset:416 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v47, off, s[0:3], s33 offset:412 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v56, off, s[0:3], s33 offset:408 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v57, off, s[0:3], s33 offset:404 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v58, off, s[0:3], s33 offset:400 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v59, off, s[0:3], s33 offset:396 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v60, off, s[0:3], s33 offset:392 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v61, off, s[0:3], s33 offset:388 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v62, off, s[0:3], s33 offset:384 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v63, off, s[0:3], s33 offset:380 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v72, off, s[0:3], s33 offset:376 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v73, off, s[0:3], s33 offset:372 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v74, off, s[0:3], s33 offset:368 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v75, off, s[0:3], s33 offset:364 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v76, off, s[0:3], s33 offset:360 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v77, off, s[0:3], s33 offset:356 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v78, off, s[0:3], s33 offset:352 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v79, off, s[0:3], s33 offset:348 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v88, off, s[0:3], s33 offset:344 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v89, off, s[0:3], s33 offset:340 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v90, off, s[0:3], s33 offset:336 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v91, off, s[0:3], s33 offset:332 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v92, off, s[0:3], s33 offset:328 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v93, off, s[0:3], s33 offset:324 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v94, off, s[0:3], s33 offset:320 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v95, off, s[0:3], s33 offset:316 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v104, off, s[0:3], s33 offset:312 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v105, off, s[0:3], s33 offset:308 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v106, off, s[0:3], s33 offset:304 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v107, off, s[0:3], s33 offset:300 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v108, off, s[0:3], s33 offset:296 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v109, off, s[0:3], s33 offset:292 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v110, off, s[0:3], s33 offset:288 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v111, off, s[0:3], s33 offset:284 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v120, off, s[0:3], s33 offset:280 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v121, off, s[0:3], s33 offset:276 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v122, off, s[0:3], s33 offset:272 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v123, off, s[0:3], s33 offset:268 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v124, off, s[0:3], s33 offset:264 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v125, off, s[0:3], s33 offset:260 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v126, off, s[0:3], s33 offset:256 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v127, off, s[0:3], s33 offset:252 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v136, off, s[0:3], s33 offset:248 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v137, off, s[0:3], s33 offset:244 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v138, off, s[0:3], s33 offset:240 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v139, off, s[0:3], s33 offset:236 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v140, off, s[0:3], s33 offset:232 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v141, off, s[0:3], s33 offset:228 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v142, off, s[0:3], s33 offset:224 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v143, off, s[0:3], s33 offset:220 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v152, off, s[0:3], s33 offset:216 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v153, off, s[0:3], s33 offset:212 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v154, off, s[0:3], s33 offset:208 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v155, off, s[0:3], s33 offset:204 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v156, off, s[0:3], s33 offset:200 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v157, off, s[0:3], s33 offset:196 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v158, off, s[0:3], s33 offset:192 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v159, off, s[0:3], s33 offset:188 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v168, off, s[0:3], s33 offset:184 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v169, off, s[0:3], s33 offset:180 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v170, off, s[0:3], s33 offset:176 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v171, off, s[0:3], s33 offset:172 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v172, off, s[0:3], s33 offset:168 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v173, off, s[0:3], s33 offset:164 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v174, off, s[0:3], s33 offset:160 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v175, off, s[0:3], s33 offset:156 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v184, off, s[0:3], s33 offset:152 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v185, off, s[0:3], s33 offset:148 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v186, off, s[0:3], s33 offset:144 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v187, off, s[0:3], s33 offset:140 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v188, off, s[0:3], s33 offset:136 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v189, off, s[0:3], s33 offset:132 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v190, off, s[0:3], s33 offset:128 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v191, off, s[0:3], s33 offset:124 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v200, off, s[0:3], s33 offset:120 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v201, off, s[0:3], s33 offset:116 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v202, off, s[0:3], s33 offset:112 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v203, off, s[0:3], s33 offset:108 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v204, off, s[0:3], s33 offset:104 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v205, off, s[0:3], s33 offset:100 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v206, off, s[0:3], s33 offset:96 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v207, off, s[0:3], s33 offset:92 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v216, off, s[0:3], s33 offset:88 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v217, off, s[0:3], s33 offset:84 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v218, off, s[0:3], s33 offset:80 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v219, off, s[0:3], s33 offset:76 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v220, off, s[0:3], s33 offset:72 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v221, off, s[0:3], s33 offset:68 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v222, off, s[0:3], s33 offset:64 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v223, off, s[0:3], s33 offset:60 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v232, off, s[0:3], s33 offset:56 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v233, off, s[0:3], s33 offset:52 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v234, off, s[0:3], s33 offset:48 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v235, off, s[0:3], s33 offset:44 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v236, off, s[0:3], s33 offset:40 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v237, off, s[0:3], s33 offset:36 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v238, off, s[0:3], s33 offset:32 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v239, off, s[0:3], s33 offset:28 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v248, off, s[0:3], s33 offset:24 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v249, off, s[0:3], s33 offset:20 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v250, off, s[0:3], s33 offset:16 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v251, off, s[0:3], s33 offset:12 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v252, off, s[0:3], s33 offset:8 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v253, off, s[0:3], s33 offset:4 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v254, off, s[0:3], s33 ; 4-byte Folded Spill
; GCN-NEXT:    v_writelane_b32 v255, s30, 0
; GCN-NEXT:    v_writelane_b32 v255, s31, 1
; GCN-NEXT:    buffer_store_dword v31, off, s[0:3], s33 offset:448 ; 4-byte Folded Spill
; GCN-NEXT:    v_mov_b32_e32 v0, 0
; GCN-NEXT:    buffer_store_dword v0, off, s[0:3], s33 offset:444
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    ;;#ASMSTART
; GCN-NEXT:    ;;#ASMEND
; GCN-NEXT:    buffer_load_dword v31, off, s[0:3], s33 offset:448 ; 4-byte Folded Reload
; GCN-NEXT:    s_getpc_b64 s[16:17]
; GCN-NEXT:    s_add_u32 s16, s16, child_function@gotpcrel32@lo+4
; GCN-NEXT:    s_addc_u32 s17, s17, child_function@gotpcrel32@hi+12
; GCN-NEXT:    s_load_dwordx2 s[16:17], s[16:17], 0x0
; GCN-NEXT:    s_mov_b64 s[22:23], s[2:3]
; GCN-NEXT:    s_mov_b64 s[20:21], s[0:1]
; GCN-NEXT:    s_mov_b64 s[0:1], s[20:21]
; GCN-NEXT:    s_mov_b64 s[2:3], s[22:23]
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GCN-NEXT:    v_readlane_b32 s31, v255, 1
; GCN-NEXT:    v_readlane_b32 s30, v255, 0
; GCN-NEXT:    buffer_load_dword v254, off, s[0:3], s33 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v253, off, s[0:3], s33 offset:4 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v252, off, s[0:3], s33 offset:8 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v251, off, s[0:3], s33 offset:12 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v250, off, s[0:3], s33 offset:16 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v249, off, s[0:3], s33 offset:20 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v248, off, s[0:3], s33 offset:24 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v239, off, s[0:3], s33 offset:28 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v238, off, s[0:3], s33 offset:32 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v237, off, s[0:3], s33 offset:36 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v236, off, s[0:3], s33 offset:40 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v235, off, s[0:3], s33 offset:44 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v234, off, s[0:3], s33 offset:48 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v233, off, s[0:3], s33 offset:52 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v232, off, s[0:3], s33 offset:56 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v223, off, s[0:3], s33 offset:60 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v222, off, s[0:3], s33 offset:64 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v221, off, s[0:3], s33 offset:68 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v220, off, s[0:3], s33 offset:72 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v219, off, s[0:3], s33 offset:76 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v218, off, s[0:3], s33 offset:80 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v217, off, s[0:3], s33 offset:84 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v216, off, s[0:3], s33 offset:88 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v207, off, s[0:3], s33 offset:92 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v206, off, s[0:3], s33 offset:96 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v205, off, s[0:3], s33 offset:100 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v204, off, s[0:3], s33 offset:104 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v203, off, s[0:3], s33 offset:108 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v202, off, s[0:3], s33 offset:112 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v201, off, s[0:3], s33 offset:116 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v200, off, s[0:3], s33 offset:120 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v191, off, s[0:3], s33 offset:124 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v190, off, s[0:3], s33 offset:128 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v189, off, s[0:3], s33 offset:132 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v188, off, s[0:3], s33 offset:136 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v187, off, s[0:3], s33 offset:140 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v186, off, s[0:3], s33 offset:144 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v185, off, s[0:3], s33 offset:148 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v184, off, s[0:3], s33 offset:152 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v175, off, s[0:3], s33 offset:156 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v174, off, s[0:3], s33 offset:160 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v173, off, s[0:3], s33 offset:164 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v172, off, s[0:3], s33 offset:168 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v171, off, s[0:3], s33 offset:172 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v170, off, s[0:3], s33 offset:176 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v169, off, s[0:3], s33 offset:180 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v168, off, s[0:3], s33 offset:184 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v159, off, s[0:3], s33 offset:188 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v158, off, s[0:3], s33 offset:192 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v157, off, s[0:3], s33 offset:196 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v156, off, s[0:3], s33 offset:200 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v155, off, s[0:3], s33 offset:204 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v154, off, s[0:3], s33 offset:208 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v153, off, s[0:3], s33 offset:212 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v152, off, s[0:3], s33 offset:216 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v143, off, s[0:3], s33 offset:220 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v142, off, s[0:3], s33 offset:224 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v141, off, s[0:3], s33 offset:228 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v140, off, s[0:3], s33 offset:232 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v139, off, s[0:3], s33 offset:236 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v138, off, s[0:3], s33 offset:240 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v137, off, s[0:3], s33 offset:244 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v136, off, s[0:3], s33 offset:248 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v127, off, s[0:3], s33 offset:252 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v126, off, s[0:3], s33 offset:256 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v125, off, s[0:3], s33 offset:260 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v124, off, s[0:3], s33 offset:264 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v123, off, s[0:3], s33 offset:268 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v122, off, s[0:3], s33 offset:272 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v121, off, s[0:3], s33 offset:276 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v120, off, s[0:3], s33 offset:280 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v111, off, s[0:3], s33 offset:284 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v110, off, s[0:3], s33 offset:288 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v109, off, s[0:3], s33 offset:292 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v108, off, s[0:3], s33 offset:296 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v107, off, s[0:3], s33 offset:300 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v106, off, s[0:3], s33 offset:304 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v105, off, s[0:3], s33 offset:308 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v104, off, s[0:3], s33 offset:312 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v95, off, s[0:3], s33 offset:316 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v94, off, s[0:3], s33 offset:320 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v93, off, s[0:3], s33 offset:324 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v92, off, s[0:3], s33 offset:328 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v91, off, s[0:3], s33 offset:332 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v90, off, s[0:3], s33 offset:336 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v89, off, s[0:3], s33 offset:340 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v88, off, s[0:3], s33 offset:344 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v79, off, s[0:3], s33 offset:348 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v78, off, s[0:3], s33 offset:352 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v77, off, s[0:3], s33 offset:356 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v76, off, s[0:3], s33 offset:360 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v75, off, s[0:3], s33 offset:364 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v74, off, s[0:3], s33 offset:368 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v73, off, s[0:3], s33 offset:372 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v72, off, s[0:3], s33 offset:376 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v63, off, s[0:3], s33 offset:380 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v62, off, s[0:3], s33 offset:384 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v61, off, s[0:3], s33 offset:388 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v60, off, s[0:3], s33 offset:392 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v59, off, s[0:3], s33 offset:396 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v58, off, s[0:3], s33 offset:400 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v57, off, s[0:3], s33 offset:404 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v56, off, s[0:3], s33 offset:408 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v47, off, s[0:3], s33 offset:412 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v46, off, s[0:3], s33 offset:416 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v45, off, s[0:3], s33 offset:420 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v44, off, s[0:3], s33 offset:424 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v43, off, s[0:3], s33 offset:428 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v42, off, s[0:3], s33 offset:432 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v41, off, s[0:3], s33 offset:436 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v40, off, s[0:3], s33 offset:440 ; 4-byte Folded Reload
; GCN-NEXT:    s_mov_b32 s32, s33
; GCN-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GCN-NEXT:    buffer_load_dword v255, off, s[0:3], s33 offset:452 ; 4-byte Folded Reload
; GCN-NEXT:    s_mov_b64 exec, s[4:5]
; GCN-NEXT:    s_mov_b32 s33, s18
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %alloca = alloca i32, align 4, addrspace(5)
  store volatile i32 0, ptr addrspace(5) %alloca

  call void asm sideeffect "",
  "~{v0},~{v1},~{v2},~{v3},~{v4},~{v5},~{v6},~{v7},~{v8},~{v9}
  ,~{v10},~{v11},~{v12},~{v13},~{v14},~{v15},~{v16},~{v17},~{v18},~{v19}
  ,~{v20},~{v21},~{v22},~{v23},~{v24},~{v25},~{v26},~{v27},~{v28},~{v29}
  ,~{v30},~{v31},~{v32},~{v33},~{v34},~{v35},~{v36},~{v37},~{v38},~{v39}
  ,~{v40},~{v41},~{v42},~{v43},~{v44},~{v45},~{v46},~{v47},~{v48},~{v49}
  ,~{v50},~{v51},~{v52},~{v53},~{v54},~{v55},~{v56},~{v57},~{v58},~{v59}
  ,~{v60},~{v61},~{v62},~{v63},~{v64},~{v65},~{v66},~{v67},~{v68},~{v69}
  ,~{v70},~{v71},~{v72},~{v73},~{v74},~{v75},~{v76},~{v77},~{v78},~{v79}
  ,~{v80},~{v81},~{v82},~{v83},~{v84},~{v85},~{v86},~{v87},~{v88},~{v89}
  ,~{v90},~{v91},~{v92},~{v93},~{v94},~{v95},~{v96},~{v97},~{v98},~{v99}
  ,~{v100},~{v101},~{v102},~{v103},~{v104},~{v105},~{v106},~{v107},~{v108},~{v109}
  ,~{v110},~{v111},~{v112},~{v113},~{v114},~{v115},~{v116},~{v117},~{v118},~{v119}
  ,~{v120},~{v121},~{v122},~{v123},~{v124},~{v125},~{v126},~{v127},~{v128},~{v129}
  ,~{v130},~{v131},~{v132},~{v133},~{v134},~{v135},~{v136},~{v137},~{v138},~{v139}
  ,~{v140},~{v141},~{v142},~{v143},~{v144},~{v145},~{v146},~{v147},~{v148},~{v149}
  ,~{v150},~{v151},~{v152},~{v153},~{v154},~{v155},~{v156},~{v157},~{v158},~{v159}
  ,~{v160},~{v161},~{v162},~{v163},~{v164},~{v165},~{v166},~{v167},~{v168},~{v169}
  ,~{v170},~{v171},~{v172},~{v173},~{v174},~{v175},~{v176},~{v177},~{v178},~{v179}
  ,~{v180},~{v181},~{v182},~{v183},~{v184},~{v185},~{v186},~{v187},~{v188},~{v189}
  ,~{v190},~{v191},~{v192},~{v193},~{v194},~{v195},~{v196},~{v197},~{v198},~{v199}
  ,~{v200},~{v201},~{v202},~{v203},~{v204},~{v205},~{v206},~{v207},~{v208},~{v209}
  ,~{v210},~{v211},~{v212},~{v213},~{v214},~{v215},~{v216},~{v217},~{v218},~{v219}
  ,~{v220},~{v221},~{v222},~{v223},~{v224},~{v225},~{v226},~{v227},~{v228},~{v229}
  ,~{v230},~{v231},~{v232},~{v233},~{v234},~{v235},~{v236},~{v237},~{v238},~{v239}
  ,~{v240},~{v241},~{v242},~{v243},~{v244},~{v245},~{v246},~{v247},~{v248},~{v249}
  ,~{v250},~{v251},~{v252},~{v253},~{v254}" () #0
  call void @child_function()
  ret void
}

define void @spill_to_lowest_available_vgpr() #0 {
; GCN-LABEL: spill_to_lowest_available_vgpr:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_mov_b32 s18, s33
; GCN-NEXT:    s_mov_b32 s33, s32
; GCN-NEXT:    s_or_saveexec_b64 s[16:17], -1
; GCN-NEXT:    buffer_store_dword v254, off, s[0:3], s33 offset:448 ; 4-byte Folded Spill
; GCN-NEXT:    s_mov_b64 exec, s[16:17]
; GCN-NEXT:    s_add_i32 s32, s32, 0x7400
; GCN-NEXT:    buffer_store_dword v40, off, s[0:3], s33 offset:436 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v41, off, s[0:3], s33 offset:432 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v42, off, s[0:3], s33 offset:428 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v43, off, s[0:3], s33 offset:424 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v44, off, s[0:3], s33 offset:420 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v45, off, s[0:3], s33 offset:416 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v46, off, s[0:3], s33 offset:412 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v47, off, s[0:3], s33 offset:408 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v56, off, s[0:3], s33 offset:404 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v57, off, s[0:3], s33 offset:400 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v58, off, s[0:3], s33 offset:396 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v59, off, s[0:3], s33 offset:392 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v60, off, s[0:3], s33 offset:388 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v61, off, s[0:3], s33 offset:384 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v62, off, s[0:3], s33 offset:380 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v63, off, s[0:3], s33 offset:376 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v72, off, s[0:3], s33 offset:372 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v73, off, s[0:3], s33 offset:368 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v74, off, s[0:3], s33 offset:364 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v75, off, s[0:3], s33 offset:360 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v76, off, s[0:3], s33 offset:356 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v77, off, s[0:3], s33 offset:352 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v78, off, s[0:3], s33 offset:348 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v79, off, s[0:3], s33 offset:344 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v88, off, s[0:3], s33 offset:340 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v89, off, s[0:3], s33 offset:336 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v90, off, s[0:3], s33 offset:332 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v91, off, s[0:3], s33 offset:328 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v92, off, s[0:3], s33 offset:324 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v93, off, s[0:3], s33 offset:320 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v94, off, s[0:3], s33 offset:316 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v95, off, s[0:3], s33 offset:312 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v104, off, s[0:3], s33 offset:308 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v105, off, s[0:3], s33 offset:304 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v106, off, s[0:3], s33 offset:300 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v107, off, s[0:3], s33 offset:296 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v108, off, s[0:3], s33 offset:292 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v109, off, s[0:3], s33 offset:288 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v110, off, s[0:3], s33 offset:284 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v111, off, s[0:3], s33 offset:280 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v120, off, s[0:3], s33 offset:276 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v121, off, s[0:3], s33 offset:272 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v122, off, s[0:3], s33 offset:268 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v123, off, s[0:3], s33 offset:264 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v124, off, s[0:3], s33 offset:260 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v125, off, s[0:3], s33 offset:256 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v126, off, s[0:3], s33 offset:252 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v127, off, s[0:3], s33 offset:248 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v136, off, s[0:3], s33 offset:244 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v137, off, s[0:3], s33 offset:240 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v138, off, s[0:3], s33 offset:236 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v139, off, s[0:3], s33 offset:232 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v140, off, s[0:3], s33 offset:228 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v141, off, s[0:3], s33 offset:224 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v142, off, s[0:3], s33 offset:220 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v143, off, s[0:3], s33 offset:216 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v152, off, s[0:3], s33 offset:212 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v153, off, s[0:3], s33 offset:208 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v154, off, s[0:3], s33 offset:204 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v155, off, s[0:3], s33 offset:200 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v156, off, s[0:3], s33 offset:196 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v157, off, s[0:3], s33 offset:192 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v158, off, s[0:3], s33 offset:188 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v159, off, s[0:3], s33 offset:184 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v168, off, s[0:3], s33 offset:180 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v169, off, s[0:3], s33 offset:176 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v170, off, s[0:3], s33 offset:172 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v171, off, s[0:3], s33 offset:168 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v172, off, s[0:3], s33 offset:164 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v173, off, s[0:3], s33 offset:160 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v174, off, s[0:3], s33 offset:156 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v175, off, s[0:3], s33 offset:152 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v184, off, s[0:3], s33 offset:148 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v185, off, s[0:3], s33 offset:144 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v186, off, s[0:3], s33 offset:140 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v187, off, s[0:3], s33 offset:136 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v188, off, s[0:3], s33 offset:132 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v189, off, s[0:3], s33 offset:128 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v190, off, s[0:3], s33 offset:124 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v191, off, s[0:3], s33 offset:120 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v200, off, s[0:3], s33 offset:116 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v201, off, s[0:3], s33 offset:112 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v202, off, s[0:3], s33 offset:108 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v203, off, s[0:3], s33 offset:104 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v204, off, s[0:3], s33 offset:100 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v205, off, s[0:3], s33 offset:96 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v206, off, s[0:3], s33 offset:92 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v207, off, s[0:3], s33 offset:88 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v216, off, s[0:3], s33 offset:84 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v217, off, s[0:3], s33 offset:80 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v218, off, s[0:3], s33 offset:76 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v219, off, s[0:3], s33 offset:72 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v220, off, s[0:3], s33 offset:68 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v221, off, s[0:3], s33 offset:64 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v222, off, s[0:3], s33 offset:60 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v223, off, s[0:3], s33 offset:56 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v232, off, s[0:3], s33 offset:52 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v233, off, s[0:3], s33 offset:48 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v234, off, s[0:3], s33 offset:44 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v235, off, s[0:3], s33 offset:40 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v236, off, s[0:3], s33 offset:36 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v237, off, s[0:3], s33 offset:32 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v238, off, s[0:3], s33 offset:28 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v239, off, s[0:3], s33 offset:24 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v248, off, s[0:3], s33 offset:20 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v249, off, s[0:3], s33 offset:16 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v250, off, s[0:3], s33 offset:12 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v251, off, s[0:3], s33 offset:8 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v252, off, s[0:3], s33 offset:4 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v253, off, s[0:3], s33 ; 4-byte Folded Spill
; GCN-NEXT:    v_writelane_b32 v254, s30, 0
; GCN-NEXT:    v_writelane_b32 v254, s31, 1
; GCN-NEXT:    buffer_store_dword v31, off, s[0:3], s33 offset:444 ; 4-byte Folded Spill
; GCN-NEXT:    v_mov_b32_e32 v0, 0
; GCN-NEXT:    buffer_store_dword v0, off, s[0:3], s33 offset:440
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    ;;#ASMSTART
; GCN-NEXT:    ;;#ASMEND
; GCN-NEXT:    buffer_load_dword v31, off, s[0:3], s33 offset:444 ; 4-byte Folded Reload
; GCN-NEXT:    s_getpc_b64 s[16:17]
; GCN-NEXT:    s_add_u32 s16, s16, child_function@gotpcrel32@lo+4
; GCN-NEXT:    s_addc_u32 s17, s17, child_function@gotpcrel32@hi+12
; GCN-NEXT:    s_load_dwordx2 s[16:17], s[16:17], 0x0
; GCN-NEXT:    s_mov_b64 s[22:23], s[2:3]
; GCN-NEXT:    s_mov_b64 s[20:21], s[0:1]
; GCN-NEXT:    s_mov_b64 s[0:1], s[20:21]
; GCN-NEXT:    s_mov_b64 s[2:3], s[22:23]
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GCN-NEXT:    v_readlane_b32 s31, v254, 1
; GCN-NEXT:    v_readlane_b32 s30, v254, 0
; GCN-NEXT:    buffer_load_dword v253, off, s[0:3], s33 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v252, off, s[0:3], s33 offset:4 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v251, off, s[0:3], s33 offset:8 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v250, off, s[0:3], s33 offset:12 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v249, off, s[0:3], s33 offset:16 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v248, off, s[0:3], s33 offset:20 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v239, off, s[0:3], s33 offset:24 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v238, off, s[0:3], s33 offset:28 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v237, off, s[0:3], s33 offset:32 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v236, off, s[0:3], s33 offset:36 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v235, off, s[0:3], s33 offset:40 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v234, off, s[0:3], s33 offset:44 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v233, off, s[0:3], s33 offset:48 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v232, off, s[0:3], s33 offset:52 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v223, off, s[0:3], s33 offset:56 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v222, off, s[0:3], s33 offset:60 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v221, off, s[0:3], s33 offset:64 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v220, off, s[0:3], s33 offset:68 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v219, off, s[0:3], s33 offset:72 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v218, off, s[0:3], s33 offset:76 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v217, off, s[0:3], s33 offset:80 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v216, off, s[0:3], s33 offset:84 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v207, off, s[0:3], s33 offset:88 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v206, off, s[0:3], s33 offset:92 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v205, off, s[0:3], s33 offset:96 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v204, off, s[0:3], s33 offset:100 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v203, off, s[0:3], s33 offset:104 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v202, off, s[0:3], s33 offset:108 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v201, off, s[0:3], s33 offset:112 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v200, off, s[0:3], s33 offset:116 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v191, off, s[0:3], s33 offset:120 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v190, off, s[0:3], s33 offset:124 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v189, off, s[0:3], s33 offset:128 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v188, off, s[0:3], s33 offset:132 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v187, off, s[0:3], s33 offset:136 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v186, off, s[0:3], s33 offset:140 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v185, off, s[0:3], s33 offset:144 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v184, off, s[0:3], s33 offset:148 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v175, off, s[0:3], s33 offset:152 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v174, off, s[0:3], s33 offset:156 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v173, off, s[0:3], s33 offset:160 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v172, off, s[0:3], s33 offset:164 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v171, off, s[0:3], s33 offset:168 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v170, off, s[0:3], s33 offset:172 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v169, off, s[0:3], s33 offset:176 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v168, off, s[0:3], s33 offset:180 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v159, off, s[0:3], s33 offset:184 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v158, off, s[0:3], s33 offset:188 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v157, off, s[0:3], s33 offset:192 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v156, off, s[0:3], s33 offset:196 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v155, off, s[0:3], s33 offset:200 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v154, off, s[0:3], s33 offset:204 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v153, off, s[0:3], s33 offset:208 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v152, off, s[0:3], s33 offset:212 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v143, off, s[0:3], s33 offset:216 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v142, off, s[0:3], s33 offset:220 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v141, off, s[0:3], s33 offset:224 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v140, off, s[0:3], s33 offset:228 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v139, off, s[0:3], s33 offset:232 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v138, off, s[0:3], s33 offset:236 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v137, off, s[0:3], s33 offset:240 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v136, off, s[0:3], s33 offset:244 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v127, off, s[0:3], s33 offset:248 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v126, off, s[0:3], s33 offset:252 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v125, off, s[0:3], s33 offset:256 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v124, off, s[0:3], s33 offset:260 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v123, off, s[0:3], s33 offset:264 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v122, off, s[0:3], s33 offset:268 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v121, off, s[0:3], s33 offset:272 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v120, off, s[0:3], s33 offset:276 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v111, off, s[0:3], s33 offset:280 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v110, off, s[0:3], s33 offset:284 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v109, off, s[0:3], s33 offset:288 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v108, off, s[0:3], s33 offset:292 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v107, off, s[0:3], s33 offset:296 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v106, off, s[0:3], s33 offset:300 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v105, off, s[0:3], s33 offset:304 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v104, off, s[0:3], s33 offset:308 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v95, off, s[0:3], s33 offset:312 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v94, off, s[0:3], s33 offset:316 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v93, off, s[0:3], s33 offset:320 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v92, off, s[0:3], s33 offset:324 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v91, off, s[0:3], s33 offset:328 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v90, off, s[0:3], s33 offset:332 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v89, off, s[0:3], s33 offset:336 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v88, off, s[0:3], s33 offset:340 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v79, off, s[0:3], s33 offset:344 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v78, off, s[0:3], s33 offset:348 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v77, off, s[0:3], s33 offset:352 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v76, off, s[0:3], s33 offset:356 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v75, off, s[0:3], s33 offset:360 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v74, off, s[0:3], s33 offset:364 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v73, off, s[0:3], s33 offset:368 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v72, off, s[0:3], s33 offset:372 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v63, off, s[0:3], s33 offset:376 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v62, off, s[0:3], s33 offset:380 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v61, off, s[0:3], s33 offset:384 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v60, off, s[0:3], s33 offset:388 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v59, off, s[0:3], s33 offset:392 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v58, off, s[0:3], s33 offset:396 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v57, off, s[0:3], s33 offset:400 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v56, off, s[0:3], s33 offset:404 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v47, off, s[0:3], s33 offset:408 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v46, off, s[0:3], s33 offset:412 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v45, off, s[0:3], s33 offset:416 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v44, off, s[0:3], s33 offset:420 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v43, off, s[0:3], s33 offset:424 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v42, off, s[0:3], s33 offset:428 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v41, off, s[0:3], s33 offset:432 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v40, off, s[0:3], s33 offset:436 ; 4-byte Folded Reload
; GCN-NEXT:    s_mov_b32 s32, s33
; GCN-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GCN-NEXT:    buffer_load_dword v254, off, s[0:3], s33 offset:448 ; 4-byte Folded Reload
; GCN-NEXT:    s_mov_b64 exec, s[4:5]
; GCN-NEXT:    s_mov_b32 s33, s18
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %alloca = alloca i32, align 4, addrspace(5)
  store volatile i32 0, ptr addrspace(5) %alloca

  call void asm sideeffect "",
  "~{v0},~{v1},~{v2},~{v3},~{v4},~{v5},~{v6},~{v7},~{v8},~{v9}
  ,~{v10},~{v11},~{v12},~{v13},~{v14},~{v15},~{v16},~{v17},~{v18},~{v19}
  ,~{v20},~{v21},~{v22},~{v23},~{v24},~{v25},~{v26},~{v27},~{v28},~{v29}
  ,~{v30},~{v31},~{v32},~{v33},~{v34},~{v35},~{v36},~{v37},~{v38},~{v39}
  ,~{v40},~{v41},~{v42},~{v43},~{v44},~{v45},~{v46},~{v47},~{v48},~{v49}
  ,~{v50},~{v51},~{v52},~{v53},~{v54},~{v55},~{v56},~{v57},~{v58},~{v59}
  ,~{v60},~{v61},~{v62},~{v63},~{v64},~{v65},~{v66},~{v67},~{v68},~{v69}
  ,~{v70},~{v71},~{v72},~{v73},~{v74},~{v75},~{v76},~{v77},~{v78},~{v79}
  ,~{v80},~{v81},~{v82},~{v83},~{v84},~{v85},~{v86},~{v87},~{v88},~{v89}
  ,~{v90},~{v91},~{v92},~{v93},~{v94},~{v95},~{v96},~{v97},~{v98},~{v99}
  ,~{v100},~{v101},~{v102},~{v103},~{v104},~{v105},~{v106},~{v107},~{v108},~{v109}
  ,~{v110},~{v111},~{v112},~{v113},~{v114},~{v115},~{v116},~{v117},~{v118},~{v119}
  ,~{v120},~{v121},~{v122},~{v123},~{v124},~{v125},~{v126},~{v127},~{v128},~{v129}
  ,~{v130},~{v131},~{v132},~{v133},~{v134},~{v135},~{v136},~{v137},~{v138},~{v139}
  ,~{v140},~{v141},~{v142},~{v143},~{v144},~{v145},~{v146},~{v147},~{v148},~{v149}
  ,~{v150},~{v151},~{v152},~{v153},~{v154},~{v155},~{v156},~{v157},~{v158},~{v159}
  ,~{v160},~{v161},~{v162},~{v163},~{v164},~{v165},~{v166},~{v167},~{v168},~{v169}
  ,~{v170},~{v171},~{v172},~{v173},~{v174},~{v175},~{v176},~{v177},~{v178},~{v179}
  ,~{v180},~{v181},~{v182},~{v183},~{v184},~{v185},~{v186},~{v187},~{v188},~{v189}
  ,~{v190},~{v191},~{v192},~{v193},~{v194},~{v195},~{v196},~{v197},~{v198},~{v199}
  ,~{v200},~{v201},~{v202},~{v203},~{v204},~{v205},~{v206},~{v207},~{v208},~{v209}
  ,~{v210},~{v211},~{v212},~{v213},~{v214},~{v215},~{v216},~{v217},~{v218},~{v219}
  ,~{v220},~{v221},~{v222},~{v223},~{v224},~{v225},~{v226},~{v227},~{v228},~{v229}
  ,~{v230},~{v231},~{v232},~{v233},~{v234},~{v235},~{v236},~{v237},~{v238},~{v239}
  ,~{v240},~{v241},~{v242},~{v243},~{v244},~{v245},~{v246},~{v247},~{v248},~{v249}
  ,~{v250},~{v251},~{v252},~{v253}" () #0
  call void @child_function()
  ret void
}

define void @spill_sgpr_with_sgpr_uses() #0 {
; GCN-LABEL: spill_sgpr_with_sgpr_uses:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GCN-NEXT:    buffer_store_dword v254, off, s[0:3], s32 offset:448 ; 4-byte Folded Spill
; GCN-NEXT:    s_mov_b64 exec, s[4:5]
; GCN-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:436 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:432 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:428 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:424 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:420 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:416 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:412 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:408 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:404 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:400 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:396 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:392 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:388 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:384 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:380 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v63, off, s[0:3], s32 offset:376 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v72, off, s[0:3], s32 offset:372 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v73, off, s[0:3], s32 offset:368 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v74, off, s[0:3], s32 offset:364 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v75, off, s[0:3], s32 offset:360 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v76, off, s[0:3], s32 offset:356 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v77, off, s[0:3], s32 offset:352 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v78, off, s[0:3], s32 offset:348 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v79, off, s[0:3], s32 offset:344 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v88, off, s[0:3], s32 offset:340 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v89, off, s[0:3], s32 offset:336 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v90, off, s[0:3], s32 offset:332 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v91, off, s[0:3], s32 offset:328 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v92, off, s[0:3], s32 offset:324 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v93, off, s[0:3], s32 offset:320 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v94, off, s[0:3], s32 offset:316 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v95, off, s[0:3], s32 offset:312 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v104, off, s[0:3], s32 offset:308 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v105, off, s[0:3], s32 offset:304 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v106, off, s[0:3], s32 offset:300 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v107, off, s[0:3], s32 offset:296 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v108, off, s[0:3], s32 offset:292 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v109, off, s[0:3], s32 offset:288 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v110, off, s[0:3], s32 offset:284 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v111, off, s[0:3], s32 offset:280 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v120, off, s[0:3], s32 offset:276 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v121, off, s[0:3], s32 offset:272 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v122, off, s[0:3], s32 offset:268 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v123, off, s[0:3], s32 offset:264 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v124, off, s[0:3], s32 offset:260 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v125, off, s[0:3], s32 offset:256 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v126, off, s[0:3], s32 offset:252 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v127, off, s[0:3], s32 offset:248 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v136, off, s[0:3], s32 offset:244 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v137, off, s[0:3], s32 offset:240 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v138, off, s[0:3], s32 offset:236 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v139, off, s[0:3], s32 offset:232 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v140, off, s[0:3], s32 offset:228 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v141, off, s[0:3], s32 offset:224 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v142, off, s[0:3], s32 offset:220 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v143, off, s[0:3], s32 offset:216 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v152, off, s[0:3], s32 offset:212 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v153, off, s[0:3], s32 offset:208 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v154, off, s[0:3], s32 offset:204 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v155, off, s[0:3], s32 offset:200 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v156, off, s[0:3], s32 offset:196 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v157, off, s[0:3], s32 offset:192 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v158, off, s[0:3], s32 offset:188 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v159, off, s[0:3], s32 offset:184 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v168, off, s[0:3], s32 offset:180 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v169, off, s[0:3], s32 offset:176 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v170, off, s[0:3], s32 offset:172 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v171, off, s[0:3], s32 offset:168 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v172, off, s[0:3], s32 offset:164 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v173, off, s[0:3], s32 offset:160 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v174, off, s[0:3], s32 offset:156 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v175, off, s[0:3], s32 offset:152 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v184, off, s[0:3], s32 offset:148 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v185, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v186, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v187, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v188, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v189, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v190, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v191, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v200, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v201, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v202, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v203, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v204, off, s[0:3], s32 offset:100 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v205, off, s[0:3], s32 offset:96 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v206, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v207, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v216, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v217, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v218, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v219, off, s[0:3], s32 offset:72 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v220, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v221, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v222, off, s[0:3], s32 offset:60 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v223, off, s[0:3], s32 offset:56 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v232, off, s[0:3], s32 offset:52 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v233, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v234, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v235, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v236, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v237, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v238, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v239, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v248, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v249, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v250, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v251, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v252, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v253, off, s[0:3], s32 ; 4-byte Folded Spill
; GCN-NEXT:    v_mov_b32_e32 v0, 0
; GCN-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:440
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    ;;#ASMSTART
; GCN-NEXT:    ;;#ASMEND
; GCN-NEXT:    ;;#ASMSTART
; GCN-NEXT:    ; def s4
; GCN-NEXT:    ;;#ASMEND
; GCN-NEXT:    s_mov_b32 s5, s4
; GCN-NEXT:    ; implicit-def: $vgpr254 : SGPR spill to VGPR lane
; GCN-NEXT:    v_writelane_b32 v254, s5, 0
; GCN-NEXT:    s_or_saveexec_b64 s[8:9], -1
; GCN-NEXT:    buffer_store_dword v254, off, s[0:3], s32 offset:444 ; 4-byte Folded Spill
; GCN-NEXT:    s_mov_b64 exec, s[8:9]
; GCN-NEXT:    s_mov_b32 s5, 0
; GCN-NEXT:    s_cmp_lg_u32 s4, s5
; GCN-NEXT:    s_cbranch_scc1 .LBB3_2
; GCN-NEXT:  ; %bb.1: ; %bb0
; GCN-NEXT:    s_or_saveexec_b64 s[8:9], -1
; GCN-NEXT:    buffer_load_dword v254, off, s[0:3], s32 offset:444 ; 4-byte Folded Reload
; GCN-NEXT:    s_mov_b64 exec, s[8:9]
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_readlane_b32 s4, v254, 0
; GCN-NEXT:    ;;#ASMSTART
; GCN-NEXT:    ; use s4
; GCN-NEXT:    ;;#ASMEND
; GCN-NEXT:  .LBB3_2: ; %ret
; GCN-NEXT:    buffer_load_dword v253, off, s[0:3], s32 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v252, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v251, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v250, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v249, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v248, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v239, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v238, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v237, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v236, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v235, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v234, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v233, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v232, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v223, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v222, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v221, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v220, off, s[0:3], s32 offset:68 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v219, off, s[0:3], s32 offset:72 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v218, off, s[0:3], s32 offset:76 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v217, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v216, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v207, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v206, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v205, off, s[0:3], s32 offset:96 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v204, off, s[0:3], s32 offset:100 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v203, off, s[0:3], s32 offset:104 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v202, off, s[0:3], s32 offset:108 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v201, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v200, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v191, off, s[0:3], s32 offset:120 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v190, off, s[0:3], s32 offset:124 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v189, off, s[0:3], s32 offset:128 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v188, off, s[0:3], s32 offset:132 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v187, off, s[0:3], s32 offset:136 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v186, off, s[0:3], s32 offset:140 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v185, off, s[0:3], s32 offset:144 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v184, off, s[0:3], s32 offset:148 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v175, off, s[0:3], s32 offset:152 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v174, off, s[0:3], s32 offset:156 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v173, off, s[0:3], s32 offset:160 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v172, off, s[0:3], s32 offset:164 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v171, off, s[0:3], s32 offset:168 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v170, off, s[0:3], s32 offset:172 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v169, off, s[0:3], s32 offset:176 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v168, off, s[0:3], s32 offset:180 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v159, off, s[0:3], s32 offset:184 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v158, off, s[0:3], s32 offset:188 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v157, off, s[0:3], s32 offset:192 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v156, off, s[0:3], s32 offset:196 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v155, off, s[0:3], s32 offset:200 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v154, off, s[0:3], s32 offset:204 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v153, off, s[0:3], s32 offset:208 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v152, off, s[0:3], s32 offset:212 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v143, off, s[0:3], s32 offset:216 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v142, off, s[0:3], s32 offset:220 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v141, off, s[0:3], s32 offset:224 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v140, off, s[0:3], s32 offset:228 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v139, off, s[0:3], s32 offset:232 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v138, off, s[0:3], s32 offset:236 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v137, off, s[0:3], s32 offset:240 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v136, off, s[0:3], s32 offset:244 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v127, off, s[0:3], s32 offset:248 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v126, off, s[0:3], s32 offset:252 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v125, off, s[0:3], s32 offset:256 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v124, off, s[0:3], s32 offset:260 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v123, off, s[0:3], s32 offset:264 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v122, off, s[0:3], s32 offset:268 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v121, off, s[0:3], s32 offset:272 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v120, off, s[0:3], s32 offset:276 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v111, off, s[0:3], s32 offset:280 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v110, off, s[0:3], s32 offset:284 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v109, off, s[0:3], s32 offset:288 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v108, off, s[0:3], s32 offset:292 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v107, off, s[0:3], s32 offset:296 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v106, off, s[0:3], s32 offset:300 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v105, off, s[0:3], s32 offset:304 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v104, off, s[0:3], s32 offset:308 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v95, off, s[0:3], s32 offset:312 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v94, off, s[0:3], s32 offset:316 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v93, off, s[0:3], s32 offset:320 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v92, off, s[0:3], s32 offset:324 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v91, off, s[0:3], s32 offset:328 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v90, off, s[0:3], s32 offset:332 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v89, off, s[0:3], s32 offset:336 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v88, off, s[0:3], s32 offset:340 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v79, off, s[0:3], s32 offset:344 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v78, off, s[0:3], s32 offset:348 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v77, off, s[0:3], s32 offset:352 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v76, off, s[0:3], s32 offset:356 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v75, off, s[0:3], s32 offset:360 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v74, off, s[0:3], s32 offset:364 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v73, off, s[0:3], s32 offset:368 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v72, off, s[0:3], s32 offset:372 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v63, off, s[0:3], s32 offset:376 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:380 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:384 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:388 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:392 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:396 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:400 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:404 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:408 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:412 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:416 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:420 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:424 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:428 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:432 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:436 ; 4-byte Folded Reload
; GCN-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GCN-NEXT:    buffer_load_dword v254, off, s[0:3], s32 offset:448 ; 4-byte Folded Reload
; GCN-NEXT:    s_mov_b64 exec, s[4:5]
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %alloca = alloca i32, align 4, addrspace(5)
  store volatile i32 0, ptr addrspace(5) %alloca

  call void asm sideeffect "",
  "~{v0},~{v1},~{v2},~{v3},~{v4},~{v5},~{v6},~{v7},~{v8},~{v9}
  ,~{v10},~{v11},~{v12},~{v13},~{v14},~{v15},~{v16},~{v17},~{v18},~{v19}
  ,~{v20},~{v21},~{v22},~{v23},~{v24},~{v25},~{v26},~{v27},~{v28},~{v29}
  ,~{v30},~{v31},~{v32},~{v33},~{v34},~{v35},~{v36},~{v37},~{v38},~{v39}
  ,~{v40},~{v41},~{v42},~{v43},~{v44},~{v45},~{v46},~{v47},~{v48},~{v49}
  ,~{v50},~{v51},~{v52},~{v53},~{v54},~{v55},~{v56},~{v57},~{v58},~{v59}
  ,~{v60},~{v61},~{v62},~{v63},~{v64},~{v65},~{v66},~{v67},~{v68},~{v69}
  ,~{v70},~{v71},~{v72},~{v73},~{v74},~{v75},~{v76},~{v77},~{v78},~{v79}
  ,~{v80},~{v81},~{v82},~{v83},~{v84},~{v85},~{v86},~{v87},~{v88},~{v89}
  ,~{v90},~{v91},~{v92},~{v93},~{v94},~{v95},~{v96},~{v97},~{v98},~{v99}
  ,~{v100},~{v101},~{v102},~{v103},~{v104},~{v105},~{v106},~{v107},~{v108},~{v109}
  ,~{v110},~{v111},~{v112},~{v113},~{v114},~{v115},~{v116},~{v117},~{v118},~{v119}
  ,~{v120},~{v121},~{v122},~{v123},~{v124},~{v125},~{v126},~{v127},~{v128},~{v129}
  ,~{v130},~{v131},~{v132},~{v133},~{v134},~{v135},~{v136},~{v137},~{v138},~{v139}
  ,~{v140},~{v141},~{v142},~{v143},~{v144},~{v145},~{v146},~{v147},~{v148},~{v149}
  ,~{v150},~{v151},~{v152},~{v153},~{v154},~{v155},~{v156},~{v157},~{v158},~{v159}
  ,~{v160},~{v161},~{v162},~{v163},~{v164},~{v165},~{v166},~{v167},~{v168},~{v169}
  ,~{v170},~{v171},~{v172},~{v173},~{v174},~{v175},~{v176},~{v177},~{v178},~{v179}
  ,~{v180},~{v181},~{v182},~{v183},~{v184},~{v185},~{v186},~{v187},~{v188},~{v189}
  ,~{v190},~{v191},~{v192},~{v193},~{v194},~{v195},~{v196},~{v197},~{v198},~{v199}
  ,~{v200},~{v201},~{v202},~{v203},~{v204},~{v205},~{v206},~{v207},~{v208},~{v209}
  ,~{v210},~{v211},~{v212},~{v213},~{v214},~{v215},~{v216},~{v217},~{v218},~{v219}
  ,~{v220},~{v221},~{v222},~{v223},~{v224},~{v225},~{v226},~{v227},~{v228},~{v229}
  ,~{v230},~{v231},~{v232},~{v233},~{v234},~{v235},~{v236},~{v237},~{v238},~{v239}
  ,~{v240},~{v241},~{v242},~{v243},~{v244},~{v245},~{v246},~{v247},~{v248},~{v249}
  ,~{v250},~{v251},~{v252},~{v253}" () #0

  %sgpr = call i32 asm sideeffect "; def $0", "=s" () #0
  %cmp = icmp eq i32 %sgpr, 0
  br i1 %cmp, label %bb0, label %ret

bb0:
  call void asm sideeffect "; use $0", "s"(i32 %sgpr) #0
  br label %ret

ret:
  ret void
}

define void @spill_sgpr_with_tail_call() #0 {
; GCN-LABEL: spill_sgpr_with_tail_call:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:440 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:436 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:432 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:428 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:424 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:420 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:416 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:412 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:408 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:404 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:400 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:396 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:392 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:388 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:384 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v63, off, s[0:3], s32 offset:380 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v72, off, s[0:3], s32 offset:376 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v73, off, s[0:3], s32 offset:372 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v74, off, s[0:3], s32 offset:368 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v75, off, s[0:3], s32 offset:364 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v76, off, s[0:3], s32 offset:360 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v77, off, s[0:3], s32 offset:356 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v78, off, s[0:3], s32 offset:352 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v79, off, s[0:3], s32 offset:348 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v88, off, s[0:3], s32 offset:344 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v89, off, s[0:3], s32 offset:340 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v90, off, s[0:3], s32 offset:336 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v91, off, s[0:3], s32 offset:332 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v92, off, s[0:3], s32 offset:328 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v93, off, s[0:3], s32 offset:324 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v94, off, s[0:3], s32 offset:320 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v95, off, s[0:3], s32 offset:316 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v104, off, s[0:3], s32 offset:312 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v105, off, s[0:3], s32 offset:308 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v106, off, s[0:3], s32 offset:304 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v107, off, s[0:3], s32 offset:300 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v108, off, s[0:3], s32 offset:296 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v109, off, s[0:3], s32 offset:292 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v110, off, s[0:3], s32 offset:288 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v111, off, s[0:3], s32 offset:284 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v120, off, s[0:3], s32 offset:280 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v121, off, s[0:3], s32 offset:276 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v122, off, s[0:3], s32 offset:272 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v123, off, s[0:3], s32 offset:268 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v124, off, s[0:3], s32 offset:264 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v125, off, s[0:3], s32 offset:260 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v126, off, s[0:3], s32 offset:256 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v127, off, s[0:3], s32 offset:252 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v136, off, s[0:3], s32 offset:248 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v137, off, s[0:3], s32 offset:244 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v138, off, s[0:3], s32 offset:240 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v139, off, s[0:3], s32 offset:236 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v140, off, s[0:3], s32 offset:232 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v141, off, s[0:3], s32 offset:228 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v142, off, s[0:3], s32 offset:224 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v143, off, s[0:3], s32 offset:220 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v152, off, s[0:3], s32 offset:216 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v153, off, s[0:3], s32 offset:212 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v154, off, s[0:3], s32 offset:208 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v155, off, s[0:3], s32 offset:204 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v156, off, s[0:3], s32 offset:200 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v157, off, s[0:3], s32 offset:196 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v158, off, s[0:3], s32 offset:192 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v159, off, s[0:3], s32 offset:188 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v168, off, s[0:3], s32 offset:184 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v169, off, s[0:3], s32 offset:180 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v170, off, s[0:3], s32 offset:176 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v171, off, s[0:3], s32 offset:172 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v172, off, s[0:3], s32 offset:168 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v173, off, s[0:3], s32 offset:164 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v174, off, s[0:3], s32 offset:160 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v175, off, s[0:3], s32 offset:156 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v184, off, s[0:3], s32 offset:152 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v185, off, s[0:3], s32 offset:148 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v186, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v187, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v188, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v189, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v190, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v191, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v200, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v201, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v202, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v203, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v204, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v205, off, s[0:3], s32 offset:100 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v206, off, s[0:3], s32 offset:96 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v207, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v216, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v217, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v218, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v219, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v220, off, s[0:3], s32 offset:72 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v221, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v222, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v223, off, s[0:3], s32 offset:60 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v232, off, s[0:3], s32 offset:56 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v233, off, s[0:3], s32 offset:52 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v234, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v235, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v236, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v237, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v238, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v239, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v248, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v249, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v250, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v251, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v252, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v253, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v254, off, s[0:3], s32 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v31, off, s[0:3], s32 offset:448 ; 4-byte Folded Spill
; GCN-NEXT:    v_mov_b32_e32 v0, 0
; GCN-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:444
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    ;;#ASMSTART
; GCN-NEXT:    ;;#ASMEND
; GCN-NEXT:    buffer_load_dword v31, off, s[0:3], s32 offset:448 ; 4-byte Folded Reload
; GCN-NEXT:    s_getpc_b64 s[16:17]
; GCN-NEXT:    s_add_u32 s16, s16, child_function@gotpcrel32@lo+4
; GCN-NEXT:    s_addc_u32 s17, s17, child_function@gotpcrel32@hi+12
; GCN-NEXT:    s_load_dwordx2 s[16:17], s[16:17], 0x0
; GCN-NEXT:    buffer_load_dword v254, off, s[0:3], s32 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v253, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v252, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v251, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v250, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v249, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v248, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v239, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v238, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v237, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v236, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v235, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v234, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v233, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v232, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v223, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v222, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v221, off, s[0:3], s32 offset:68 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v220, off, s[0:3], s32 offset:72 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v219, off, s[0:3], s32 offset:76 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v218, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v217, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v216, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v207, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v206, off, s[0:3], s32 offset:96 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v205, off, s[0:3], s32 offset:100 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v204, off, s[0:3], s32 offset:104 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v203, off, s[0:3], s32 offset:108 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v202, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v201, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v200, off, s[0:3], s32 offset:120 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v191, off, s[0:3], s32 offset:124 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v190, off, s[0:3], s32 offset:128 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v189, off, s[0:3], s32 offset:132 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v188, off, s[0:3], s32 offset:136 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v187, off, s[0:3], s32 offset:140 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v186, off, s[0:3], s32 offset:144 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v185, off, s[0:3], s32 offset:148 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v184, off, s[0:3], s32 offset:152 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v175, off, s[0:3], s32 offset:156 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v174, off, s[0:3], s32 offset:160 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v173, off, s[0:3], s32 offset:164 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v172, off, s[0:3], s32 offset:168 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v171, off, s[0:3], s32 offset:172 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v170, off, s[0:3], s32 offset:176 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v169, off, s[0:3], s32 offset:180 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v168, off, s[0:3], s32 offset:184 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v159, off, s[0:3], s32 offset:188 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v158, off, s[0:3], s32 offset:192 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v157, off, s[0:3], s32 offset:196 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v156, off, s[0:3], s32 offset:200 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v155, off, s[0:3], s32 offset:204 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v154, off, s[0:3], s32 offset:208 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v153, off, s[0:3], s32 offset:212 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v152, off, s[0:3], s32 offset:216 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v143, off, s[0:3], s32 offset:220 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v142, off, s[0:3], s32 offset:224 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v141, off, s[0:3], s32 offset:228 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v140, off, s[0:3], s32 offset:232 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v139, off, s[0:3], s32 offset:236 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v138, off, s[0:3], s32 offset:240 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v137, off, s[0:3], s32 offset:244 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v136, off, s[0:3], s32 offset:248 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v127, off, s[0:3], s32 offset:252 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v126, off, s[0:3], s32 offset:256 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v125, off, s[0:3], s32 offset:260 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v124, off, s[0:3], s32 offset:264 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v123, off, s[0:3], s32 offset:268 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v122, off, s[0:3], s32 offset:272 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v121, off, s[0:3], s32 offset:276 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v120, off, s[0:3], s32 offset:280 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v111, off, s[0:3], s32 offset:284 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v110, off, s[0:3], s32 offset:288 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v109, off, s[0:3], s32 offset:292 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v108, off, s[0:3], s32 offset:296 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v107, off, s[0:3], s32 offset:300 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v106, off, s[0:3], s32 offset:304 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v105, off, s[0:3], s32 offset:308 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v104, off, s[0:3], s32 offset:312 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v95, off, s[0:3], s32 offset:316 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v94, off, s[0:3], s32 offset:320 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v93, off, s[0:3], s32 offset:324 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v92, off, s[0:3], s32 offset:328 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v91, off, s[0:3], s32 offset:332 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v90, off, s[0:3], s32 offset:336 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v89, off, s[0:3], s32 offset:340 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v88, off, s[0:3], s32 offset:344 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v79, off, s[0:3], s32 offset:348 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v78, off, s[0:3], s32 offset:352 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v77, off, s[0:3], s32 offset:356 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v76, off, s[0:3], s32 offset:360 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v75, off, s[0:3], s32 offset:364 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v74, off, s[0:3], s32 offset:368 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v73, off, s[0:3], s32 offset:372 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v72, off, s[0:3], s32 offset:376 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v63, off, s[0:3], s32 offset:380 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:384 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:388 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:392 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:396 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:400 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:404 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:408 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:412 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:416 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:420 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:424 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:428 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:432 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:436 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:440 ; 4-byte Folded Reload
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_setpc_b64 s[16:17]
  %alloca = alloca i32, align 4, addrspace(5)
  store volatile i32 0, ptr addrspace(5) %alloca

  call void asm sideeffect "",
  "~{v0},~{v1},~{v2},~{v3},~{v4},~{v5},~{v6},~{v7},~{v8},~{v9}
  ,~{v10},~{v11},~{v12},~{v13},~{v14},~{v15},~{v16},~{v17},~{v18},~{v19}
  ,~{v20},~{v21},~{v22},~{v23},~{v24},~{v25},~{v26},~{v27},~{v28},~{v29}
  ,~{v30},~{v31},~{v32},~{v33},~{v34},~{v35},~{v36},~{v37},~{v38},~{v39}
  ,~{v40},~{v41},~{v42},~{v43},~{v44},~{v45},~{v46},~{v47},~{v48},~{v49}
  ,~{v50},~{v51},~{v52},~{v53},~{v54},~{v55},~{v56},~{v57},~{v58},~{v59}
  ,~{v60},~{v61},~{v62},~{v63},~{v64},~{v65},~{v66},~{v67},~{v68},~{v69}
  ,~{v70},~{v71},~{v72},~{v73},~{v74},~{v75},~{v76},~{v77},~{v78},~{v79}
  ,~{v80},~{v81},~{v82},~{v83},~{v84},~{v85},~{v86},~{v87},~{v88},~{v89}
  ,~{v90},~{v91},~{v92},~{v93},~{v94},~{v95},~{v96},~{v97},~{v98},~{v99}
  ,~{v100},~{v101},~{v102},~{v103},~{v104},~{v105},~{v106},~{v107},~{v108},~{v109}
  ,~{v110},~{v111},~{v112},~{v113},~{v114},~{v115},~{v116},~{v117},~{v118},~{v119}
  ,~{v120},~{v121},~{v122},~{v123},~{v124},~{v125},~{v126},~{v127},~{v128},~{v129}
  ,~{v130},~{v131},~{v132},~{v133},~{v134},~{v135},~{v136},~{v137},~{v138},~{v139}
  ,~{v140},~{v141},~{v142},~{v143},~{v144},~{v145},~{v146},~{v147},~{v148},~{v149}
  ,~{v150},~{v151},~{v152},~{v153},~{v154},~{v155},~{v156},~{v157},~{v158},~{v159}
  ,~{v160},~{v161},~{v162},~{v163},~{v164},~{v165},~{v166},~{v167},~{v168},~{v169}
  ,~{v170},~{v171},~{v172},~{v173},~{v174},~{v175},~{v176},~{v177},~{v178},~{v179}
  ,~{v180},~{v181},~{v182},~{v183},~{v184},~{v185},~{v186},~{v187},~{v188},~{v189}
  ,~{v190},~{v191},~{v192},~{v193},~{v194},~{v195},~{v196},~{v197},~{v198},~{v199}
  ,~{v200},~{v201},~{v202},~{v203},~{v204},~{v205},~{v206},~{v207},~{v208},~{v209}
  ,~{v210},~{v211},~{v212},~{v213},~{v214},~{v215},~{v216},~{v217},~{v218},~{v219}
  ,~{v220},~{v221},~{v222},~{v223},~{v224},~{v225},~{v226},~{v227},~{v228},~{v229}
  ,~{v230},~{v231},~{v232},~{v233},~{v234},~{v235},~{v236},~{v237},~{v238},~{v239}
  ,~{v240},~{v241},~{v242},~{v243},~{v244},~{v245},~{v246},~{v247},~{v248},~{v249}
  ,~{v250},~{v251},~{v252},~{v253},~{v254}" () #0
  musttail call void @child_function()
  ret void
}

define void @spill_sgpr_no_free_vgpr(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; GCN-LABEL: spill_sgpr_no_free_vgpr:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GCN-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:464 ; 4-byte Folded Spill
; GCN-NEXT:    s_mov_b64 exec, s[4:5]
; GCN-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:444 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:440 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:436 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:432 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:428 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:424 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:420 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:416 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:412 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:408 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:404 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:400 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:396 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:392 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:388 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v63, off, s[0:3], s32 offset:384 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v72, off, s[0:3], s32 offset:380 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v73, off, s[0:3], s32 offset:376 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v74, off, s[0:3], s32 offset:372 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v75, off, s[0:3], s32 offset:368 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v76, off, s[0:3], s32 offset:364 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v77, off, s[0:3], s32 offset:360 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v78, off, s[0:3], s32 offset:356 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v79, off, s[0:3], s32 offset:352 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v88, off, s[0:3], s32 offset:348 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v89, off, s[0:3], s32 offset:344 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v90, off, s[0:3], s32 offset:340 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v91, off, s[0:3], s32 offset:336 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v92, off, s[0:3], s32 offset:332 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v93, off, s[0:3], s32 offset:328 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v94, off, s[0:3], s32 offset:324 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v95, off, s[0:3], s32 offset:320 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v104, off, s[0:3], s32 offset:316 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v105, off, s[0:3], s32 offset:312 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v106, off, s[0:3], s32 offset:308 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v107, off, s[0:3], s32 offset:304 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v108, off, s[0:3], s32 offset:300 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v109, off, s[0:3], s32 offset:296 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v110, off, s[0:3], s32 offset:292 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v111, off, s[0:3], s32 offset:288 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v120, off, s[0:3], s32 offset:284 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v121, off, s[0:3], s32 offset:280 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v122, off, s[0:3], s32 offset:276 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v123, off, s[0:3], s32 offset:272 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v124, off, s[0:3], s32 offset:268 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v125, off, s[0:3], s32 offset:264 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v126, off, s[0:3], s32 offset:260 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v127, off, s[0:3], s32 offset:256 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v136, off, s[0:3], s32 offset:252 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v137, off, s[0:3], s32 offset:248 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v138, off, s[0:3], s32 offset:244 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v139, off, s[0:3], s32 offset:240 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v140, off, s[0:3], s32 offset:236 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v141, off, s[0:3], s32 offset:232 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v142, off, s[0:3], s32 offset:228 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v143, off, s[0:3], s32 offset:224 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v152, off, s[0:3], s32 offset:220 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v153, off, s[0:3], s32 offset:216 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v154, off, s[0:3], s32 offset:212 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v155, off, s[0:3], s32 offset:208 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v156, off, s[0:3], s32 offset:204 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v157, off, s[0:3], s32 offset:200 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v158, off, s[0:3], s32 offset:196 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v159, off, s[0:3], s32 offset:192 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v168, off, s[0:3], s32 offset:188 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v169, off, s[0:3], s32 offset:184 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v170, off, s[0:3], s32 offset:180 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v171, off, s[0:3], s32 offset:176 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v172, off, s[0:3], s32 offset:172 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v173, off, s[0:3], s32 offset:168 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v174, off, s[0:3], s32 offset:164 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v175, off, s[0:3], s32 offset:160 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v184, off, s[0:3], s32 offset:156 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v185, off, s[0:3], s32 offset:152 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v186, off, s[0:3], s32 offset:148 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v187, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v188, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v189, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v190, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v191, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v200, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v201, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v202, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v203, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v204, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v205, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v206, off, s[0:3], s32 offset:100 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v207, off, s[0:3], s32 offset:96 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v216, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v217, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v218, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v219, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v220, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v221, off, s[0:3], s32 offset:72 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v222, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v223, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v232, off, s[0:3], s32 offset:60 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v233, off, s[0:3], s32 offset:56 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v234, off, s[0:3], s32 offset:52 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v235, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v236, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v237, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v238, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v239, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v248, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v249, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v250, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v251, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v252, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v253, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v254, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v255, off, s[0:3], s32 ; 4-byte Folded Spill
; GCN-NEXT:    v_writelane_b32 v5, s34, 0
; GCN-NEXT:    v_writelane_b32 v5, s35, 1
; GCN-NEXT:    v_writelane_b32 v5, s36, 2
; GCN-NEXT:    v_writelane_b32 v5, s37, 3
; GCN-NEXT:    v_mov_b32_e32 v4, v3
; GCN-NEXT:    v_mov_b32_e32 v3, v1
; GCN-NEXT:    ; implicit-def: $sgpr4
; GCN-NEXT:    ; implicit-def: $sgpr4
; GCN-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; GCN-NEXT:    v_mov_b32_e32 v1, v3
; GCN-NEXT:    ; implicit-def: $sgpr4
; GCN-NEXT:    ; implicit-def: $sgpr4
; GCN-NEXT:    ; kill: def $vgpr2 killed $vgpr2 def $vgpr2_vgpr3 killed $exec
; GCN-NEXT:    v_mov_b32_e32 v3, v4
; GCN-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GCN-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GCN-NEXT:    flat_load_dwordx4 v[6:9], v[2:3]
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:448 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v7, off, s[0:3], s32 offset:452 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:456 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v9, off, s[0:3], s32 offset:460 ; 4-byte Folded Spill
; GCN-NEXT:    ;;#ASMSTART
; GCN-NEXT:    ;;#ASMEND
; GCN-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:448 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:452 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:456 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v9, off, s[0:3], s32 offset:460 ; 4-byte Folded Reload
; GCN-NEXT:    ;;#ASMSTART
; GCN-NEXT:    ;;#ASMEND
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    flat_store_dwordx4 v[0:1], v[6:9]
; GCN-NEXT:    v_readlane_b32 s37, v5, 3
; GCN-NEXT:    v_readlane_b32 s36, v5, 2
; GCN-NEXT:    v_readlane_b32 s35, v5, 1
; GCN-NEXT:    v_readlane_b32 s34, v5, 0
; GCN-NEXT:    buffer_load_dword v255, off, s[0:3], s32 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v254, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v253, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v252, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v251, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v250, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v249, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v248, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v239, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v238, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v237, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v236, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v235, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v234, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v233, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v232, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v223, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v222, off, s[0:3], s32 offset:68 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v221, off, s[0:3], s32 offset:72 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v220, off, s[0:3], s32 offset:76 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v219, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v218, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v217, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v216, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v207, off, s[0:3], s32 offset:96 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v206, off, s[0:3], s32 offset:100 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v205, off, s[0:3], s32 offset:104 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v204, off, s[0:3], s32 offset:108 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v203, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v202, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v201, off, s[0:3], s32 offset:120 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v200, off, s[0:3], s32 offset:124 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v191, off, s[0:3], s32 offset:128 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v190, off, s[0:3], s32 offset:132 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v189, off, s[0:3], s32 offset:136 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v188, off, s[0:3], s32 offset:140 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v187, off, s[0:3], s32 offset:144 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v186, off, s[0:3], s32 offset:148 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v185, off, s[0:3], s32 offset:152 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v184, off, s[0:3], s32 offset:156 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v175, off, s[0:3], s32 offset:160 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v174, off, s[0:3], s32 offset:164 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v173, off, s[0:3], s32 offset:168 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v172, off, s[0:3], s32 offset:172 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v171, off, s[0:3], s32 offset:176 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v170, off, s[0:3], s32 offset:180 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v169, off, s[0:3], s32 offset:184 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v168, off, s[0:3], s32 offset:188 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v159, off, s[0:3], s32 offset:192 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v158, off, s[0:3], s32 offset:196 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v157, off, s[0:3], s32 offset:200 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v156, off, s[0:3], s32 offset:204 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v155, off, s[0:3], s32 offset:208 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v154, off, s[0:3], s32 offset:212 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v153, off, s[0:3], s32 offset:216 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v152, off, s[0:3], s32 offset:220 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v143, off, s[0:3], s32 offset:224 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v142, off, s[0:3], s32 offset:228 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v141, off, s[0:3], s32 offset:232 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v140, off, s[0:3], s32 offset:236 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v139, off, s[0:3], s32 offset:240 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v138, off, s[0:3], s32 offset:244 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v137, off, s[0:3], s32 offset:248 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v136, off, s[0:3], s32 offset:252 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v127, off, s[0:3], s32 offset:256 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v126, off, s[0:3], s32 offset:260 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v125, off, s[0:3], s32 offset:264 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v124, off, s[0:3], s32 offset:268 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v123, off, s[0:3], s32 offset:272 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v122, off, s[0:3], s32 offset:276 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v121, off, s[0:3], s32 offset:280 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v120, off, s[0:3], s32 offset:284 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v111, off, s[0:3], s32 offset:288 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v110, off, s[0:3], s32 offset:292 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v109, off, s[0:3], s32 offset:296 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v108, off, s[0:3], s32 offset:300 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v107, off, s[0:3], s32 offset:304 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v106, off, s[0:3], s32 offset:308 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v105, off, s[0:3], s32 offset:312 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v104, off, s[0:3], s32 offset:316 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v95, off, s[0:3], s32 offset:320 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v94, off, s[0:3], s32 offset:324 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v93, off, s[0:3], s32 offset:328 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v92, off, s[0:3], s32 offset:332 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v91, off, s[0:3], s32 offset:336 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v90, off, s[0:3], s32 offset:340 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v89, off, s[0:3], s32 offset:344 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v88, off, s[0:3], s32 offset:348 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v79, off, s[0:3], s32 offset:352 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v78, off, s[0:3], s32 offset:356 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v77, off, s[0:3], s32 offset:360 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v76, off, s[0:3], s32 offset:364 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v75, off, s[0:3], s32 offset:368 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v74, off, s[0:3], s32 offset:372 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v73, off, s[0:3], s32 offset:376 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v72, off, s[0:3], s32 offset:380 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v63, off, s[0:3], s32 offset:384 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:388 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:392 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:396 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:400 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:404 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:408 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:412 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:416 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:420 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:424 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:428 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:432 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:436 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:440 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:444 ; 4-byte Folded Reload
; GCN-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GCN-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:464 ; 4-byte Folded Reload
; GCN-NEXT:    s_mov_b64 exec, s[4:5]
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %a = load <4 x i32>, ptr addrspace(1) %in
  call void asm sideeffect "",
  "~{v6},~{v7},~{v8},~{v9}
  ,~{v10},~{v11},~{v12},~{v13},~{v14},~{v15},~{v16},~{v17},~{v18},~{v19}
  ,~{v20},~{v21},~{v22},~{v23},~{v24},~{v25},~{v26},~{v27},~{v28},~{v29}
  ,~{v30},~{v31},~{v32},~{v33},~{v34},~{v35},~{v36},~{v37},~{v38},~{v39}
  ,~{v40},~{v41},~{v42},~{v43},~{v44},~{v45},~{v46},~{v47},~{v48},~{v49}
  ,~{v50},~{v51},~{v52},~{v53},~{v54},~{v55},~{v56},~{v57},~{v58},~{v59}
  ,~{v60},~{v61},~{v62},~{v63},~{v64},~{v65},~{v66},~{v67},~{v68},~{v69}
  ,~{v70},~{v71},~{v72},~{v73},~{v74},~{v75},~{v76},~{v77},~{v78},~{v79}
  ,~{v80},~{v81},~{v82},~{v83},~{v84},~{v85},~{v86},~{v87},~{v88},~{v89}
  ,~{v90},~{v91},~{v92},~{v93},~{v94},~{v95},~{v96},~{v97},~{v98},~{v99}
  ,~{v100},~{v101},~{v102},~{v103},~{v104},~{v105},~{v106},~{v107},~{v108},~{v109}
  ,~{v110},~{v111},~{v112},~{v113},~{v114},~{v115},~{v116},~{v117},~{v118},~{v119}
  ,~{v120},~{v121},~{v122},~{v123},~{v124},~{v125},~{v126},~{v127},~{v128},~{v129}
  ,~{v130},~{v131},~{v132},~{v133},~{v134},~{v135},~{v136},~{v137},~{v138},~{v139}
  ,~{v140},~{v141},~{v142},~{v143},~{v144},~{v145},~{v146},~{v147},~{v148},~{v149}
  ,~{v150},~{v151},~{v152},~{v153},~{v154},~{v155},~{v156},~{v157},~{v158},~{v159}
  ,~{v160},~{v161},~{v162},~{v163},~{v164},~{v165},~{v166},~{v167},~{v168},~{v169}
  ,~{v170},~{v171},~{v172},~{v173},~{v174},~{v175},~{v176},~{v177},~{v178},~{v179}
  ,~{v180},~{v181},~{v182},~{v183},~{v184},~{v185},~{v186},~{v187},~{v188},~{v189}
  ,~{v190},~{v191},~{v192},~{v193},~{v194},~{v195},~{v196},~{v197},~{v198},~{v199}
  ,~{v200},~{v201},~{v202},~{v203},~{v204},~{v205},~{v206},~{v207},~{v208},~{v209}
  ,~{v210},~{v211},~{v212},~{v213},~{v214},~{v215},~{v216},~{v217},~{v218},~{v219}
  ,~{v220},~{v221},~{v222},~{v223},~{v224},~{v225},~{v226},~{v227},~{v228},~{v229}
  ,~{v230},~{v231},~{v232},~{v233},~{v234},~{v235},~{v236},~{v237},~{v238},~{v239}
  ,~{v240},~{v241},~{v242},~{v243},~{v244},~{v245},~{v246},~{v247},~{v248},~{v249}
  ,~{v250},~{v251},~{v252},~{v253},~{v254},~{v255}" () #0

  call void asm sideeffect "",
  "~{s34},~{s35},~{s36},~{s37}" () #0

  store <4 x i32> %a, ptr addrspace(1) %out
  ret void
}

define internal void @child_function_ipra() #0 {
; GCN-LABEL: child_function_ipra:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    ;;#ASMSTART
; GCN-NEXT:    ;;#ASMEND
; GCN-NEXT:    s_setpc_b64 s[30:31]
  call void asm sideeffect "",
  "~{v0},~{v1},~{v2},~{v3},~{v4},~{v5},~{v6},~{v7},~{v8},~{v9}
  ,~{v10},~{v11},~{v12},~{v13},~{v14},~{v15},~{v16},~{v17},~{v18},~{v19}
  ,~{v20},~{v21},~{v22},~{v23},~{v24},~{v25},~{v26},~{v27},~{v28},~{v29}
  ,~{v30},~{v31},~{v32},~{v33},~{v34},~{v35},~{v36},~{v37},~{v38},~{v39}
  ,~{v40},~{v41},~{v42},~{v43},~{v44},~{v45},~{v46},~{v47},~{v48},~{v49}
  ,~{v50},~{v51},~{v52},~{v53},~{v54},~{v55},~{v56},~{v57},~{v58},~{v59}
  ,~{v60},~{v61},~{v62},~{v63},~{v64},~{v65},~{v66},~{v67},~{v68},~{v69}
  ,~{v70},~{v71},~{v72},~{v73},~{v74},~{v75},~{v76},~{v77},~{v78},~{v79}
  ,~{v80},~{v81},~{v82},~{v83},~{v84},~{v85},~{v86},~{v87},~{v88},~{v89}
  ,~{v90},~{v91},~{v92},~{v93},~{v94},~{v95},~{v96},~{v97},~{v98},~{v99}
  ,~{v100},~{v101},~{v102},~{v103},~{v104},~{v105},~{v106},~{v107},~{v108},~{v109}
  ,~{v110},~{v111},~{v112},~{v113},~{v114},~{v115},~{v116},~{v117},~{v118},~{v119}
  ,~{v120},~{v121},~{v122},~{v123},~{v124},~{v125},~{v126},~{v127},~{v128},~{v129}
  ,~{v130},~{v131},~{v132},~{v133},~{v134},~{v135},~{v136},~{v137},~{v138},~{v139}
  ,~{v140},~{v141},~{v142},~{v143},~{v144},~{v145},~{v146},~{v147},~{v148},~{v149}
  ,~{v150},~{v151},~{v152},~{v153},~{v154},~{v155},~{v156},~{v157},~{v158},~{v159}
  ,~{v160},~{v161},~{v162},~{v163},~{v164},~{v165},~{v166},~{v167},~{v168},~{v169}
  ,~{v170},~{v171},~{v172},~{v173},~{v174},~{v175},~{v176},~{v177},~{v178},~{v179}
  ,~{v180},~{v181},~{v182},~{v183},~{v184},~{v185},~{v186},~{v187},~{v188},~{v189}
  ,~{v190},~{v191},~{v192},~{v193},~{v194},~{v195},~{v196},~{v197},~{v198},~{v199}
  ,~{v200},~{v201},~{v202},~{v203},~{v204},~{v205},~{v206},~{v207},~{v208},~{v209}
  ,~{v210},~{v211},~{v212},~{v213},~{v214},~{v215},~{v216},~{v217},~{v218},~{v219}
  ,~{v220},~{v221},~{v222},~{v223},~{v224},~{v225},~{v226},~{v227},~{v228},~{v229}
  ,~{v230},~{v231},~{v232},~{v233},~{v234},~{v235},~{v236},~{v237},~{v238},~{v239}
  ,~{v240},~{v241},~{v242},~{v243},~{v244},~{v245},~{v246},~{v247},~{v248},~{v249}
  ,~{v250},~{v251},~{v252},~{v253},~{v254},~{v255}" () #0
  ret void
}

define void @spill_sgpr_no_free_vgpr_ipra() #0 {
; GCN-LABEL: spill_sgpr_no_free_vgpr_ipra:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_mov_b32 s18, s33
; GCN-NEXT:    s_mov_b32 s33, s32
; GCN-NEXT:    s_add_i32 s32, s32, 0x7400
; GCN-NEXT:    buffer_store_dword v40, off, s[0:3], s33 offset:444 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v41, off, s[0:3], s33 offset:440 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v42, off, s[0:3], s33 offset:436 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v43, off, s[0:3], s33 offset:432 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v44, off, s[0:3], s33 offset:428 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v45, off, s[0:3], s33 offset:424 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v46, off, s[0:3], s33 offset:420 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v47, off, s[0:3], s33 offset:416 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v56, off, s[0:3], s33 offset:412 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v57, off, s[0:3], s33 offset:408 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v58, off, s[0:3], s33 offset:404 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v59, off, s[0:3], s33 offset:400 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v60, off, s[0:3], s33 offset:396 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v61, off, s[0:3], s33 offset:392 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v62, off, s[0:3], s33 offset:388 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v63, off, s[0:3], s33 offset:384 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v72, off, s[0:3], s33 offset:380 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v73, off, s[0:3], s33 offset:376 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v74, off, s[0:3], s33 offset:372 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v75, off, s[0:3], s33 offset:368 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v76, off, s[0:3], s33 offset:364 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v77, off, s[0:3], s33 offset:360 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v78, off, s[0:3], s33 offset:356 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v79, off, s[0:3], s33 offset:352 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v88, off, s[0:3], s33 offset:348 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v89, off, s[0:3], s33 offset:344 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v90, off, s[0:3], s33 offset:340 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v91, off, s[0:3], s33 offset:336 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v92, off, s[0:3], s33 offset:332 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v93, off, s[0:3], s33 offset:328 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v94, off, s[0:3], s33 offset:324 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v95, off, s[0:3], s33 offset:320 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v104, off, s[0:3], s33 offset:316 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v105, off, s[0:3], s33 offset:312 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v106, off, s[0:3], s33 offset:308 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v107, off, s[0:3], s33 offset:304 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v108, off, s[0:3], s33 offset:300 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v109, off, s[0:3], s33 offset:296 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v110, off, s[0:3], s33 offset:292 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v111, off, s[0:3], s33 offset:288 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v120, off, s[0:3], s33 offset:284 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v121, off, s[0:3], s33 offset:280 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v122, off, s[0:3], s33 offset:276 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v123, off, s[0:3], s33 offset:272 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v124, off, s[0:3], s33 offset:268 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v125, off, s[0:3], s33 offset:264 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v126, off, s[0:3], s33 offset:260 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v127, off, s[0:3], s33 offset:256 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v136, off, s[0:3], s33 offset:252 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v137, off, s[0:3], s33 offset:248 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v138, off, s[0:3], s33 offset:244 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v139, off, s[0:3], s33 offset:240 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v140, off, s[0:3], s33 offset:236 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v141, off, s[0:3], s33 offset:232 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v142, off, s[0:3], s33 offset:228 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v143, off, s[0:3], s33 offset:224 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v152, off, s[0:3], s33 offset:220 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v153, off, s[0:3], s33 offset:216 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v154, off, s[0:3], s33 offset:212 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v155, off, s[0:3], s33 offset:208 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v156, off, s[0:3], s33 offset:204 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v157, off, s[0:3], s33 offset:200 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v158, off, s[0:3], s33 offset:196 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v159, off, s[0:3], s33 offset:192 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v168, off, s[0:3], s33 offset:188 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v169, off, s[0:3], s33 offset:184 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v170, off, s[0:3], s33 offset:180 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v171, off, s[0:3], s33 offset:176 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v172, off, s[0:3], s33 offset:172 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v173, off, s[0:3], s33 offset:168 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v174, off, s[0:3], s33 offset:164 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v175, off, s[0:3], s33 offset:160 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v184, off, s[0:3], s33 offset:156 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v185, off, s[0:3], s33 offset:152 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v186, off, s[0:3], s33 offset:148 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v187, off, s[0:3], s33 offset:144 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v188, off, s[0:3], s33 offset:140 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v189, off, s[0:3], s33 offset:136 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v190, off, s[0:3], s33 offset:132 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v191, off, s[0:3], s33 offset:128 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v200, off, s[0:3], s33 offset:124 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v201, off, s[0:3], s33 offset:120 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v202, off, s[0:3], s33 offset:116 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v203, off, s[0:3], s33 offset:112 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v204, off, s[0:3], s33 offset:108 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v205, off, s[0:3], s33 offset:104 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v206, off, s[0:3], s33 offset:100 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v207, off, s[0:3], s33 offset:96 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v216, off, s[0:3], s33 offset:92 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v217, off, s[0:3], s33 offset:88 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v218, off, s[0:3], s33 offset:84 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v219, off, s[0:3], s33 offset:80 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v220, off, s[0:3], s33 offset:76 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v221, off, s[0:3], s33 offset:72 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v222, off, s[0:3], s33 offset:68 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v223, off, s[0:3], s33 offset:64 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v232, off, s[0:3], s33 offset:60 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v233, off, s[0:3], s33 offset:56 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v234, off, s[0:3], s33 offset:52 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v235, off, s[0:3], s33 offset:48 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v236, off, s[0:3], s33 offset:44 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v237, off, s[0:3], s33 offset:40 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v238, off, s[0:3], s33 offset:36 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v239, off, s[0:3], s33 offset:32 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v248, off, s[0:3], s33 offset:28 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v249, off, s[0:3], s33 offset:24 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v250, off, s[0:3], s33 offset:20 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v251, off, s[0:3], s33 offset:16 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v252, off, s[0:3], s33 offset:12 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v253, off, s[0:3], s33 offset:8 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v254, off, s[0:3], s33 offset:4 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v255, off, s[0:3], s33 ; 4-byte Folded Spill
; GCN-NEXT:    s_mov_b64 s[16:17], exec
; GCN-NEXT:    s_mov_b64 exec, 1
; GCN-NEXT:    buffer_store_dword v0, off, s[0:3], s33 offset:456
; GCN-NEXT:    v_writelane_b32 v0, s30, 0
; GCN-NEXT:    buffer_store_dword v0, off, s[0:3], s33 offset:448 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_load_dword v0, off, s[0:3], s33 offset:456
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_mov_b64 exec, s[16:17]
; GCN-NEXT:    s_mov_b64 s[16:17], exec
; GCN-NEXT:    s_mov_b64 exec, 1
; GCN-NEXT:    buffer_store_dword v0, off, s[0:3], s33 offset:456
; GCN-NEXT:    v_writelane_b32 v0, s31, 0
; GCN-NEXT:    buffer_store_dword v0, off, s[0:3], s33 offset:452 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_load_dword v0, off, s[0:3], s33 offset:456
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_mov_b64 exec, s[16:17]
; GCN-NEXT:    s_getpc_b64 s[16:17]
; GCN-NEXT:    s_add_u32 s16, s16, child_function_ipra@rel32@lo+4
; GCN-NEXT:    s_addc_u32 s17, s17, child_function_ipra@rel32@hi+12
; GCN-NEXT:    s_mov_b64 s[22:23], s[2:3]
; GCN-NEXT:    s_mov_b64 s[20:21], s[0:1]
; GCN-NEXT:    s_mov_b64 s[0:1], s[20:21]
; GCN-NEXT:    s_mov_b64 s[2:3], s[22:23]
; GCN-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GCN-NEXT:    s_mov_b64 s[4:5], exec
; GCN-NEXT:    s_mov_b64 exec, 1
; GCN-NEXT:    buffer_store_dword v0, off, s[0:3], s33 offset:456
; GCN-NEXT:    buffer_load_dword v0, off, s[0:3], s33 offset:452 ; 4-byte Folded Reload
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_readlane_b32 s31, v0, 0
; GCN-NEXT:    buffer_load_dword v0, off, s[0:3], s33 offset:456
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_mov_b64 exec, s[4:5]
; GCN-NEXT:    s_mov_b64 s[4:5], exec
; GCN-NEXT:    s_mov_b64 exec, 1
; GCN-NEXT:    buffer_store_dword v0, off, s[0:3], s33 offset:456
; GCN-NEXT:    buffer_load_dword v0, off, s[0:3], s33 offset:448 ; 4-byte Folded Reload
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_readlane_b32 s30, v0, 0
; GCN-NEXT:    buffer_load_dword v0, off, s[0:3], s33 offset:456
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_mov_b64 exec, s[4:5]
; GCN-NEXT:    buffer_load_dword v255, off, s[0:3], s33 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v254, off, s[0:3], s33 offset:4 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v253, off, s[0:3], s33 offset:8 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v252, off, s[0:3], s33 offset:12 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v251, off, s[0:3], s33 offset:16 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v250, off, s[0:3], s33 offset:20 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v249, off, s[0:3], s33 offset:24 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v248, off, s[0:3], s33 offset:28 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v239, off, s[0:3], s33 offset:32 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v238, off, s[0:3], s33 offset:36 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v237, off, s[0:3], s33 offset:40 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v236, off, s[0:3], s33 offset:44 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v235, off, s[0:3], s33 offset:48 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v234, off, s[0:3], s33 offset:52 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v233, off, s[0:3], s33 offset:56 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v232, off, s[0:3], s33 offset:60 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v223, off, s[0:3], s33 offset:64 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v222, off, s[0:3], s33 offset:68 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v221, off, s[0:3], s33 offset:72 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v220, off, s[0:3], s33 offset:76 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v219, off, s[0:3], s33 offset:80 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v218, off, s[0:3], s33 offset:84 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v217, off, s[0:3], s33 offset:88 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v216, off, s[0:3], s33 offset:92 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v207, off, s[0:3], s33 offset:96 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v206, off, s[0:3], s33 offset:100 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v205, off, s[0:3], s33 offset:104 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v204, off, s[0:3], s33 offset:108 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v203, off, s[0:3], s33 offset:112 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v202, off, s[0:3], s33 offset:116 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v201, off, s[0:3], s33 offset:120 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v200, off, s[0:3], s33 offset:124 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v191, off, s[0:3], s33 offset:128 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v190, off, s[0:3], s33 offset:132 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v189, off, s[0:3], s33 offset:136 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v188, off, s[0:3], s33 offset:140 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v187, off, s[0:3], s33 offset:144 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v186, off, s[0:3], s33 offset:148 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v185, off, s[0:3], s33 offset:152 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v184, off, s[0:3], s33 offset:156 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v175, off, s[0:3], s33 offset:160 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v174, off, s[0:3], s33 offset:164 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v173, off, s[0:3], s33 offset:168 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v172, off, s[0:3], s33 offset:172 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v171, off, s[0:3], s33 offset:176 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v170, off, s[0:3], s33 offset:180 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v169, off, s[0:3], s33 offset:184 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v168, off, s[0:3], s33 offset:188 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v159, off, s[0:3], s33 offset:192 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v158, off, s[0:3], s33 offset:196 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v157, off, s[0:3], s33 offset:200 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v156, off, s[0:3], s33 offset:204 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v155, off, s[0:3], s33 offset:208 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v154, off, s[0:3], s33 offset:212 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v153, off, s[0:3], s33 offset:216 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v152, off, s[0:3], s33 offset:220 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v143, off, s[0:3], s33 offset:224 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v142, off, s[0:3], s33 offset:228 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v141, off, s[0:3], s33 offset:232 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v140, off, s[0:3], s33 offset:236 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v139, off, s[0:3], s33 offset:240 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v138, off, s[0:3], s33 offset:244 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v137, off, s[0:3], s33 offset:248 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v136, off, s[0:3], s33 offset:252 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v127, off, s[0:3], s33 offset:256 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v126, off, s[0:3], s33 offset:260 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v125, off, s[0:3], s33 offset:264 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v124, off, s[0:3], s33 offset:268 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v123, off, s[0:3], s33 offset:272 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v122, off, s[0:3], s33 offset:276 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v121, off, s[0:3], s33 offset:280 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v120, off, s[0:3], s33 offset:284 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v111, off, s[0:3], s33 offset:288 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v110, off, s[0:3], s33 offset:292 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v109, off, s[0:3], s33 offset:296 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v108, off, s[0:3], s33 offset:300 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v107, off, s[0:3], s33 offset:304 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v106, off, s[0:3], s33 offset:308 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v105, off, s[0:3], s33 offset:312 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v104, off, s[0:3], s33 offset:316 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v95, off, s[0:3], s33 offset:320 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v94, off, s[0:3], s33 offset:324 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v93, off, s[0:3], s33 offset:328 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v92, off, s[0:3], s33 offset:332 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v91, off, s[0:3], s33 offset:336 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v90, off, s[0:3], s33 offset:340 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v89, off, s[0:3], s33 offset:344 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v88, off, s[0:3], s33 offset:348 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v79, off, s[0:3], s33 offset:352 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v78, off, s[0:3], s33 offset:356 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v77, off, s[0:3], s33 offset:360 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v76, off, s[0:3], s33 offset:364 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v75, off, s[0:3], s33 offset:368 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v74, off, s[0:3], s33 offset:372 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v73, off, s[0:3], s33 offset:376 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v72, off, s[0:3], s33 offset:380 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v63, off, s[0:3], s33 offset:384 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v62, off, s[0:3], s33 offset:388 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v61, off, s[0:3], s33 offset:392 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v60, off, s[0:3], s33 offset:396 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v59, off, s[0:3], s33 offset:400 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v58, off, s[0:3], s33 offset:404 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v57, off, s[0:3], s33 offset:408 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v56, off, s[0:3], s33 offset:412 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v47, off, s[0:3], s33 offset:416 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v46, off, s[0:3], s33 offset:420 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v45, off, s[0:3], s33 offset:424 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v44, off, s[0:3], s33 offset:428 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v43, off, s[0:3], s33 offset:432 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v42, off, s[0:3], s33 offset:436 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v41, off, s[0:3], s33 offset:440 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v40, off, s[0:3], s33 offset:444 ; 4-byte Folded Reload
; GCN-NEXT:    s_mov_b32 s32, s33
; GCN-NEXT:    s_mov_b32 s33, s18
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_setpc_b64 s[30:31]
  call void @child_function_ipra()
  ret void
}

define internal void @child_function_ipra_tail_call() #0 {
; GCN-LABEL: child_function_ipra_tail_call:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:444 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:440 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:436 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:432 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:428 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:424 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:420 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:416 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:412 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:408 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:404 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:400 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:396 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:392 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:388 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v63, off, s[0:3], s32 offset:384 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v72, off, s[0:3], s32 offset:380 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v73, off, s[0:3], s32 offset:376 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v74, off, s[0:3], s32 offset:372 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v75, off, s[0:3], s32 offset:368 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v76, off, s[0:3], s32 offset:364 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v77, off, s[0:3], s32 offset:360 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v78, off, s[0:3], s32 offset:356 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v79, off, s[0:3], s32 offset:352 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v88, off, s[0:3], s32 offset:348 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v89, off, s[0:3], s32 offset:344 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v90, off, s[0:3], s32 offset:340 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v91, off, s[0:3], s32 offset:336 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v92, off, s[0:3], s32 offset:332 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v93, off, s[0:3], s32 offset:328 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v94, off, s[0:3], s32 offset:324 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v95, off, s[0:3], s32 offset:320 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v104, off, s[0:3], s32 offset:316 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v105, off, s[0:3], s32 offset:312 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v106, off, s[0:3], s32 offset:308 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v107, off, s[0:3], s32 offset:304 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v108, off, s[0:3], s32 offset:300 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v109, off, s[0:3], s32 offset:296 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v110, off, s[0:3], s32 offset:292 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v111, off, s[0:3], s32 offset:288 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v120, off, s[0:3], s32 offset:284 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v121, off, s[0:3], s32 offset:280 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v122, off, s[0:3], s32 offset:276 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v123, off, s[0:3], s32 offset:272 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v124, off, s[0:3], s32 offset:268 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v125, off, s[0:3], s32 offset:264 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v126, off, s[0:3], s32 offset:260 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v127, off, s[0:3], s32 offset:256 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v136, off, s[0:3], s32 offset:252 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v137, off, s[0:3], s32 offset:248 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v138, off, s[0:3], s32 offset:244 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v139, off, s[0:3], s32 offset:240 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v140, off, s[0:3], s32 offset:236 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v141, off, s[0:3], s32 offset:232 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v142, off, s[0:3], s32 offset:228 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v143, off, s[0:3], s32 offset:224 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v152, off, s[0:3], s32 offset:220 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v153, off, s[0:3], s32 offset:216 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v154, off, s[0:3], s32 offset:212 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v155, off, s[0:3], s32 offset:208 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v156, off, s[0:3], s32 offset:204 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v157, off, s[0:3], s32 offset:200 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v158, off, s[0:3], s32 offset:196 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v159, off, s[0:3], s32 offset:192 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v168, off, s[0:3], s32 offset:188 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v169, off, s[0:3], s32 offset:184 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v170, off, s[0:3], s32 offset:180 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v171, off, s[0:3], s32 offset:176 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v172, off, s[0:3], s32 offset:172 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v173, off, s[0:3], s32 offset:168 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v174, off, s[0:3], s32 offset:164 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v175, off, s[0:3], s32 offset:160 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v184, off, s[0:3], s32 offset:156 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v185, off, s[0:3], s32 offset:152 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v186, off, s[0:3], s32 offset:148 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v187, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v188, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v189, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v190, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v191, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v200, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v201, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v202, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v203, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v204, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v205, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v206, off, s[0:3], s32 offset:100 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v207, off, s[0:3], s32 offset:96 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v216, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v217, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v218, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v219, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v220, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v221, off, s[0:3], s32 offset:72 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v222, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v223, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v232, off, s[0:3], s32 offset:60 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v233, off, s[0:3], s32 offset:56 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v234, off, s[0:3], s32 offset:52 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v235, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v236, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v237, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v238, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v239, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v248, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v249, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v250, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v251, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v252, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v253, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v254, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GCN-NEXT:    buffer_store_dword v255, off, s[0:3], s32 ; 4-byte Folded Spill
; GCN-NEXT:    ;;#ASMSTART
; GCN-NEXT:    ;;#ASMEND
; GCN-NEXT:    buffer_load_dword v255, off, s[0:3], s32 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v254, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v253, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v252, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v251, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v250, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v249, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v248, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v239, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v238, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v237, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v236, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v235, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v234, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v233, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v232, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v223, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v222, off, s[0:3], s32 offset:68 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v221, off, s[0:3], s32 offset:72 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v220, off, s[0:3], s32 offset:76 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v219, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v218, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v217, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v216, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v207, off, s[0:3], s32 offset:96 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v206, off, s[0:3], s32 offset:100 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v205, off, s[0:3], s32 offset:104 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v204, off, s[0:3], s32 offset:108 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v203, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v202, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v201, off, s[0:3], s32 offset:120 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v200, off, s[0:3], s32 offset:124 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v191, off, s[0:3], s32 offset:128 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v190, off, s[0:3], s32 offset:132 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v189, off, s[0:3], s32 offset:136 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v188, off, s[0:3], s32 offset:140 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v187, off, s[0:3], s32 offset:144 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v186, off, s[0:3], s32 offset:148 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v185, off, s[0:3], s32 offset:152 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v184, off, s[0:3], s32 offset:156 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v175, off, s[0:3], s32 offset:160 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v174, off, s[0:3], s32 offset:164 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v173, off, s[0:3], s32 offset:168 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v172, off, s[0:3], s32 offset:172 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v171, off, s[0:3], s32 offset:176 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v170, off, s[0:3], s32 offset:180 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v169, off, s[0:3], s32 offset:184 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v168, off, s[0:3], s32 offset:188 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v159, off, s[0:3], s32 offset:192 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v158, off, s[0:3], s32 offset:196 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v157, off, s[0:3], s32 offset:200 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v156, off, s[0:3], s32 offset:204 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v155, off, s[0:3], s32 offset:208 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v154, off, s[0:3], s32 offset:212 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v153, off, s[0:3], s32 offset:216 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v152, off, s[0:3], s32 offset:220 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v143, off, s[0:3], s32 offset:224 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v142, off, s[0:3], s32 offset:228 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v141, off, s[0:3], s32 offset:232 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v140, off, s[0:3], s32 offset:236 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v139, off, s[0:3], s32 offset:240 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v138, off, s[0:3], s32 offset:244 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v137, off, s[0:3], s32 offset:248 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v136, off, s[0:3], s32 offset:252 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v127, off, s[0:3], s32 offset:256 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v126, off, s[0:3], s32 offset:260 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v125, off, s[0:3], s32 offset:264 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v124, off, s[0:3], s32 offset:268 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v123, off, s[0:3], s32 offset:272 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v122, off, s[0:3], s32 offset:276 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v121, off, s[0:3], s32 offset:280 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v120, off, s[0:3], s32 offset:284 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v111, off, s[0:3], s32 offset:288 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v110, off, s[0:3], s32 offset:292 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v109, off, s[0:3], s32 offset:296 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v108, off, s[0:3], s32 offset:300 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v107, off, s[0:3], s32 offset:304 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v106, off, s[0:3], s32 offset:308 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v105, off, s[0:3], s32 offset:312 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v104, off, s[0:3], s32 offset:316 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v95, off, s[0:3], s32 offset:320 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v94, off, s[0:3], s32 offset:324 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v93, off, s[0:3], s32 offset:328 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v92, off, s[0:3], s32 offset:332 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v91, off, s[0:3], s32 offset:336 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v90, off, s[0:3], s32 offset:340 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v89, off, s[0:3], s32 offset:344 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v88, off, s[0:3], s32 offset:348 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v79, off, s[0:3], s32 offset:352 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v78, off, s[0:3], s32 offset:356 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v77, off, s[0:3], s32 offset:360 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v76, off, s[0:3], s32 offset:364 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v75, off, s[0:3], s32 offset:368 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v74, off, s[0:3], s32 offset:372 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v73, off, s[0:3], s32 offset:376 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v72, off, s[0:3], s32 offset:380 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v63, off, s[0:3], s32 offset:384 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:388 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:392 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:396 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:400 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:404 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:408 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:412 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:416 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:420 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:424 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:428 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:432 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:436 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:440 ; 4-byte Folded Reload
; GCN-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:444 ; 4-byte Folded Reload
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_setpc_b64 s[30:31]
  call void asm sideeffect "",
  "~{v0},~{v1},~{v2},~{v3},~{v4},~{v5},~{v6},~{v7},~{v8},~{v9}
  ,~{v10},~{v11},~{v12},~{v13},~{v14},~{v15},~{v16},~{v17},~{v18},~{v19}
  ,~{v20},~{v21},~{v22},~{v23},~{v24},~{v25},~{v26},~{v27},~{v28},~{v29}
  ,~{v30},~{v31},~{v32},~{v33},~{v34},~{v35},~{v36},~{v37},~{v38},~{v39}
  ,~{v40},~{v41},~{v42},~{v43},~{v44},~{v45},~{v46},~{v47},~{v48},~{v49}
  ,~{v50},~{v51},~{v52},~{v53},~{v54},~{v55},~{v56},~{v57},~{v58},~{v59}
  ,~{v60},~{v61},~{v62},~{v63},~{v64},~{v65},~{v66},~{v67},~{v68},~{v69}
  ,~{v70},~{v71},~{v72},~{v73},~{v74},~{v75},~{v76},~{v77},~{v78},~{v79}
  ,~{v80},~{v81},~{v82},~{v83},~{v84},~{v85},~{v86},~{v87},~{v88},~{v89}
  ,~{v90},~{v91},~{v92},~{v93},~{v94},~{v95},~{v96},~{v97},~{v98},~{v99}
  ,~{v100},~{v101},~{v102},~{v103},~{v104},~{v105},~{v106},~{v107},~{v108},~{v109}
  ,~{v110},~{v111},~{v112},~{v113},~{v114},~{v115},~{v116},~{v117},~{v118},~{v119}
  ,~{v120},~{v121},~{v122},~{v123},~{v124},~{v125},~{v126},~{v127},~{v128},~{v129}
  ,~{v130},~{v131},~{v132},~{v133},~{v134},~{v135},~{v136},~{v137},~{v138},~{v139}
  ,~{v140},~{v141},~{v142},~{v143},~{v144},~{v145},~{v146},~{v147},~{v148},~{v149}
  ,~{v150},~{v151},~{v152},~{v153},~{v154},~{v155},~{v156},~{v157},~{v158},~{v159}
  ,~{v160},~{v161},~{v162},~{v163},~{v164},~{v165},~{v166},~{v167},~{v168},~{v169}
  ,~{v170},~{v171},~{v172},~{v173},~{v174},~{v175},~{v176},~{v177},~{v178},~{v179}
  ,~{v180},~{v181},~{v182},~{v183},~{v184},~{v185},~{v186},~{v187},~{v188},~{v189}
  ,~{v190},~{v191},~{v192},~{v193},~{v194},~{v195},~{v196},~{v197},~{v198},~{v199}
  ,~{v200},~{v201},~{v202},~{v203},~{v204},~{v205},~{v206},~{v207},~{v208},~{v209}
  ,~{v210},~{v211},~{v212},~{v213},~{v214},~{v215},~{v216},~{v217},~{v218},~{v219}
  ,~{v220},~{v221},~{v222},~{v223},~{v224},~{v225},~{v226},~{v227},~{v228},~{v229}
  ,~{v230},~{v231},~{v232},~{v233},~{v234},~{v235},~{v236},~{v237},~{v238},~{v239}
  ,~{v240},~{v241},~{v242},~{v243},~{v244},~{v245},~{v246},~{v247},~{v248},~{v249}
  ,~{v250},~{v251},~{v252},~{v253},~{v254},~{v255}" () #0
  ret void
}

define void @spill_sgpr_no_free_vgpr_ipra_tail_call() #0 {
; GCN-LABEL: spill_sgpr_no_free_vgpr_ipra_tail_call:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_getpc_b64 s[16:17]
; GCN-NEXT:    s_add_u32 s16, s16, child_function_ipra_tail_call@rel32@lo+4
; GCN-NEXT:    s_addc_u32 s17, s17, child_function_ipra_tail_call@rel32@hi+12
; GCN-NEXT:    s_setpc_b64 s[16:17]
  tail call void @child_function_ipra_tail_call()
  ret void
}


attributes #0 = { nounwind noinline norecurse "amdgpu-flat-work-group-size"="1,256" }
